/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.asn1.crmf;

import b.b;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Boolean;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Choice;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Encodable;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Object;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1OctetString;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Primitive;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1TaggedObject;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.DERTaggedObject;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.crmf.EncryptedKey;

public class PKIArchiveOptions
extends ASN1Object
implements ASN1Choice {
    public static final int encryptedPrivKey = 0;
    public static final int keyGenParameters = 1;
    public static final int archiveRemGenPrivKey = 2;
    private ASN1Encodable value;

    public static PKIArchiveOptions getInstance(Object object) {
        if (object != null && !(object instanceof PKIArchiveOptions)) {
            if (object instanceof ASN1TaggedObject) {
                return new PKIArchiveOptions((ASN1TaggedObject)object);
            }
            throw new IllegalArgumentException("unknown object: " + object);
        }
        return (PKIArchiveOptions)object;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private PKIArchiveOptions(ASN1TaggedObject aSN1TaggedObject) {
        int n3 = aSN1TaggedObject.getTagNo();
        if (n3 != 0) {
            if (n3 != 1) {
                if (n3 != 2) throw new IllegalArgumentException(com.fis.ekyc.nfc.build_in.bouncycastle.asn1.cmc.b.a(aSN1TaggedObject, b.a("unknown tag number: ")));
                this.value = ASN1Boolean.getInstance(aSN1TaggedObject, false);
                return;
            } else {
                this.value = ASN1OctetString.getInstance(aSN1TaggedObject, false);
            }
            return;
        } else {
            this.value = EncryptedKey.getInstance(aSN1TaggedObject.getObject());
        }
    }

    public PKIArchiveOptions(EncryptedKey encryptedKey) {
        this.value = encryptedKey;
    }

    public PKIArchiveOptions(ASN1OctetString aSN1OctetString) {
        this.value = aSN1OctetString;
    }

    public PKIArchiveOptions(boolean bl) {
        this.value = ASN1Boolean.getInstance(bl);
    }

    public int getType() {
        ASN1Encodable aSN1Encodable = aSN1Encodable.value;
        if (aSN1Encodable instanceof EncryptedKey) {
            return 0;
        }
        if (aSN1Encodable instanceof ASN1OctetString) {
            return 1;
        }
        return 2;
    }

    public ASN1Encodable getValue() {
        return this.value;
    }

    @Override
    public ASN1Primitive toASN1Primitive() {
        ASN1Encodable aSN1Encodable = aSN1Encodable.value;
        if (aSN1Encodable instanceof EncryptedKey) {
            return new DERTaggedObject(true, 0, aSN1Encodable);
        }
        if (aSN1Encodable instanceof ASN1OctetString) {
            return new DERTaggedObject(false, 1, aSN1Encodable);
        }
        return new DERTaggedObject(false, 2, aSN1Encodable);
    }
}

