/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.asn1.crmf;

import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Choice;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Encodable;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Integer;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Object;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Primitive;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1TaggedObject;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.DERBitString;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.DERTaggedObject;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.cms.EnvelopedData;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.crmf.PKMACValue;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.crmf.SubsequentMessage;

public class POPOPrivKey
extends ASN1Object
implements ASN1Choice {
    public static final int thisMessage = 0;
    public static final int subsequentMessage = 1;
    public static final int dhMAC = 2;
    public static final int agreeMAC = 3;
    public static final int encryptedKey = 4;
    private int tagNo;
    private ASN1Encodable obj;

    private POPOPrivKey(ASN1TaggedObject aSN1TaggedObject) {
        this.tagNo = aSN1TaggedObject.getTagNo();
        switch (this.tagNo) {
            default: {
                throw new IllegalArgumentException("unknown tag in POPOPrivKey");
            }
            case 4: {
                this.obj = EnvelopedData.getInstance(aSN1TaggedObject, false);
                break;
            }
            case 3: {
                this.obj = PKMACValue.getInstance(aSN1TaggedObject, false);
                break;
            }
            case 1: {
                this.obj = SubsequentMessage.valueOf(ASN1Integer.getInstance(aSN1TaggedObject, false).intValueExact());
                break;
            }
            case 0: 
            case 2: {
                this.obj = DERBitString.getInstance(aSN1TaggedObject, false);
            }
        }
    }

    public static POPOPrivKey getInstance(Object object) {
        if (object instanceof POPOPrivKey) {
            return (POPOPrivKey)object;
        }
        if (object != null) {
            return new POPOPrivKey(ASN1TaggedObject.getInstance(object));
        }
        return null;
    }

    public static POPOPrivKey getInstance(ASN1TaggedObject aSN1TaggedObject, boolean bl) {
        return POPOPrivKey.getInstance(ASN1TaggedObject.getInstance(aSN1TaggedObject, bl));
    }

    public POPOPrivKey(PKMACValue pKMACValue) {
        this.tagNo = 3;
        this.obj = pKMACValue;
    }

    public POPOPrivKey(SubsequentMessage subsequentMessage) {
        this.tagNo = 1;
        this.obj = subsequentMessage;
    }

    public int getType() {
        return this.tagNo;
    }

    public ASN1Encodable getValue() {
        return this.obj;
    }

    @Override
    public ASN1Primitive toASN1Primitive() {
        POPOPrivKey pOPOPrivKey = this;
        int n3 = pOPOPrivKey.tagNo;
        ASN1Encodable aSN1Encodable = pOPOPrivKey.obj;
        return new DERTaggedObject(false, n3, aSN1Encodable);
    }
}

