/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.asn1.dvcs;

import b.b;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1EncodableVector;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Object;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Primitive;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Sequence;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1TaggedObject;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.DERSequence;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.dvcs.DVCSRequestInformation;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.dvcs.Data;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.x509.GeneralName;
import d.a;

public class DVCSRequest
extends ASN1Object {
    private DVCSRequestInformation requestInformation;
    private Data data;
    private GeneralName transactionIdentifier;

    public DVCSRequest(DVCSRequestInformation dVCSRequestInformation, Data data) {
        this(dVCSRequestInformation, data, null);
    }

    public DVCSRequest(DVCSRequestInformation dVCSRequestInformation, Data data, GeneralName generalName) {
        this.requestInformation = dVCSRequestInformation;
        this.data = data;
        this.transactionIdentifier = generalName;
    }

    private DVCSRequest(ASN1Sequence aSN1Sequence) {
        this.requestInformation = DVCSRequestInformation.getInstance(aSN1Sequence.getObjectAt(0));
        this.data = Data.getInstance(aSN1Sequence.getObjectAt(1));
        if (aSN1Sequence.size() > 2) {
            this.transactionIdentifier = GeneralName.getInstance(aSN1Sequence.getObjectAt(2));
        }
    }

    public static DVCSRequest getInstance(Object object) {
        if (object instanceof DVCSRequest) {
            return (DVCSRequest)object;
        }
        if (object != null) {
            return new DVCSRequest(ASN1Sequence.getInstance(object));
        }
        return null;
    }

    public static DVCSRequest getInstance(ASN1TaggedObject aSN1TaggedObject, boolean bl) {
        return DVCSRequest.getInstance(ASN1Sequence.getInstance(aSN1TaggedObject, bl));
    }

    @Override
    public ASN1Primitive toASN1Primitive() {
        ASN1EncodableVector aSN1EncodableVector;
        ASN1EncodableVector aSN1EncodableVector2 = aSN1EncodableVector;
        aSN1EncodableVector2(3);
        aSN1EncodableVector2.add(aSN1Object.requestInformation);
        aSN1EncodableVector.add(aSN1Object.data);
        ASN1Object aSN1Object = aSN1Object.transactionIdentifier;
        if (aSN1Object != null) {
            aSN1EncodableVector2.add(aSN1Object);
        }
        return new DERSequence(aSN1EncodableVector2);
    }

    public String toString() {
        StringBuilder stringBuilder = b.a("DVCSRequest {\nrequestInformation: ").append(((DVCSRequest)((Object)string2)).requestInformation).append("\ndata: ").append(((DVCSRequest)((Object)string2)).data).append("\n");
        String string2 = ((DVCSRequest)((Object)string2)).transactionIdentifier != null ? b.a("transactionIdentifier: ").append(((DVCSRequest)((Object)string2)).transactionIdentifier).append("\n").toString() : "";
        return a.a(stringBuilder, string2, "}\n");
    }

    public Data getData() {
        return this.data;
    }

    public DVCSRequestInformation getRequestInformation() {
        return this.requestInformation;
    }

    public GeneralName getTransactionIdentifier() {
        return this.transactionIdentifier;
    }
}

