/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.asn1.dvcs;

import b.b;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Encodable;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1EncodableVector;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1GeneralizedTime;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Integer;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Object;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Primitive;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Sequence;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1TaggedObject;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.DERSequence;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.DERTaggedObject;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.a;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.dvcs.DVCSTime;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.dvcs.ServiceType;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.x509.Extensions;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.x509.GeneralNames;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.x509.PolicyInformation;
import java.math.BigInteger;

public class DVCSRequestInformation
extends ASN1Object {
    private static final int DEFAULT_VERSION = 1;
    private static final int TAG_REQUESTER = 0;
    private static final int TAG_REQUEST_POLICY = 1;
    private static final int TAG_DVCS = 2;
    private static final int TAG_DATA_LOCATIONS = 3;
    private static final int TAG_EXTENSIONS = 4;
    private int version = 1;
    private ServiceType service;
    private BigInteger nonce;
    private DVCSTime requestTime;
    private GeneralNames requester;
    private PolicyInformation requestPolicy;
    private GeneralNames dvcs;
    private GeneralNames dataLocations;
    private Extensions extensions;

    private DVCSRequestInformation(ASN1Sequence aSN1Sequence) {
        int n3 = 0;
        if (aSN1Sequence.getObjectAt(0) instanceof ASN1Integer) {
            int n4 = n3;
            n3 = 1;
            this.version = ASN1Integer.getInstance(aSN1Sequence.getObjectAt(n4)).intValueExact();
        } else {
            this.version = 1;
        }
        this.service = ServiceType.getInstance(aSN1Sequence.getObjectAt(n3++));
        while (n3 < aSN1Sequence.size()) {
            ASN1Encodable aSN1Encodable = aSN1Sequence.getObjectAt(n3);
            if (aSN1Encodable instanceof ASN1Integer) {
                this.nonce = ASN1Integer.getInstance(aSN1Encodable).getValue();
            } else if (!(aSN1Encodable instanceof ASN1GeneralizedTime) && aSN1Encodable instanceof ASN1TaggedObject) {
                aSN1Encodable = ASN1TaggedObject.getInstance(aSN1Encodable);
                int n5 = ((ASN1TaggedObject)aSN1Encodable).getTagNo();
                switch (n5) {
                    default: {
                        throw new IllegalArgumentException(a.a("unknown tag number encountered: ", n5));
                    }
                    case 4: {
                        this.extensions = Extensions.getInstance((ASN1TaggedObject)aSN1Encodable, false);
                        break;
                    }
                    case 3: {
                        this.dataLocations = GeneralNames.getInstance((ASN1TaggedObject)aSN1Encodable, false);
                        break;
                    }
                    case 2: {
                        this.dvcs = GeneralNames.getInstance((ASN1TaggedObject)aSN1Encodable, false);
                        break;
                    }
                    case 1: {
                        this.requestPolicy = PolicyInformation.getInstance(ASN1Sequence.getInstance((ASN1TaggedObject)aSN1Encodable, false));
                        break;
                    }
                    case 0: {
                        this.requester = GeneralNames.getInstance((ASN1TaggedObject)aSN1Encodable, false);
                        break;
                    }
                }
            } else {
                this.requestTime = DVCSTime.getInstance(aSN1Encodable);
            }
            ++n3;
        }
    }

    public static DVCSRequestInformation getInstance(Object object) {
        if (object instanceof DVCSRequestInformation) {
            return (DVCSRequestInformation)object;
        }
        if (object != null) {
            return new DVCSRequestInformation(ASN1Sequence.getInstance(object));
        }
        return null;
    }

    public static DVCSRequestInformation getInstance(ASN1TaggedObject aSN1TaggedObject, boolean bl) {
        return DVCSRequestInformation.getInstance(ASN1Sequence.getInstance(aSN1TaggedObject, bl));
    }

    @Override
    public ASN1Primitive toASN1Primitive() {
        Object object;
        ASN1EncodableVector aSN1EncodableVector;
        ASN1EncodableVector aSN1EncodableVector2 = aSN1EncodableVector;
        aSN1EncodableVector = new ASN1EncodableVector(9);
        int n3 = this.version;
        if (n3 != 1) {
            aSN1EncodableVector2.add(new ASN1Integer(n3));
        }
        aSN1EncodableVector2.add(this.service);
        Object object2 = this.nonce;
        if (object2 != null) {
            ASN1Integer aSN1Integer;
            object = aSN1Integer;
            aSN1Integer = new ASN1Integer((BigInteger)object2);
            aSN1EncodableVector2.add((ASN1Encodable)object);
        }
        if ((object2 = this.requestTime) != null) {
            aSN1EncodableVector2.add((ASN1Encodable)object2);
        }
        int n4 = 5;
        int[] nArray = new int[5];
        object = nArray;
        nArray[0] = 0;
        nArray[1] = 1;
        nArray[2] = 2;
        nArray[3] = 3;
        nArray[4] = 4;
        ASN1Encodable[] aSN1EncodableArray = new ASN1Encodable[5];
        ASN1Encodable[] aSN1EncodableArray2 = aSN1EncodableArray;
        aSN1EncodableArray2[0] = this.requester;
        aSN1EncodableArray2[1] = this.requestPolicy;
        aSN1EncodableArray2[2] = this.dvcs;
        aSN1EncodableArray2[3] = this.dataLocations;
        aSN1EncodableArray[4] = this.extensions;
        for (int i3 = 0; i3 < n4; ++i3) {
            DERTaggedObject dERTaggedObject;
            Object object3 = object[i3];
            ASN1Encodable aSN1Encodable = aSN1EncodableArray2[i3];
            if (aSN1Encodable == null) continue;
            DERTaggedObject dERTaggedObject2 = dERTaggedObject;
            dERTaggedObject = new DERTaggedObject(false, (int)object3, aSN1Encodable);
            aSN1EncodableVector2.add(dERTaggedObject2);
        }
        return new DERSequence(aSN1EncodableVector2);
    }

    public String toString() {
        StringBuffer stringBuffer;
        StringBuffer stringBuffer2 = stringBuffer;
        new StringBuffer().append("DVCSRequestInformation {\n");
        if (this.version != 1) {
            stringBuffer2.append(b.a("version: ").append(this.version).append("\n").toString());
        }
        stringBuffer2.append(b.a("service: ").append(this.service).append("\n").toString());
        if (this.nonce != null) {
            stringBuffer2.append(b.a("nonce: ").append(this.nonce).append("\n").toString());
        }
        if (this.requestTime != null) {
            stringBuffer2.append(b.a("requestTime: ").append(this.requestTime).append("\n").toString());
        }
        if (this.requester != null) {
            stringBuffer2.append(b.a("requester: ").append(this.requester).append("\n").toString());
        }
        if (this.requestPolicy != null) {
            stringBuffer2.append(b.a("requestPolicy: ").append(this.requestPolicy).append("\n").toString());
        }
        if (this.dvcs != null) {
            stringBuffer2.append(b.a("dvcs: ").append(this.dvcs).append("\n").toString());
        }
        if (this.dataLocations != null) {
            stringBuffer2.append(b.a("dataLocations: ").append(this.dataLocations).append("\n").toString());
        }
        if (this.extensions != null) {
            stringBuffer2.append(b.a("extensions: ").append(this.extensions).append("\n").toString());
        }
        StringBuffer stringBuffer3 = stringBuffer2;
        stringBuffer3.append("}\n");
        return stringBuffer3.toString();
    }

    public int getVersion() {
        return this.version;
    }

    public ServiceType getService() {
        return this.service;
    }

    public BigInteger getNonce() {
        return this.nonce;
    }

    public DVCSTime getRequestTime() {
        return this.requestTime;
    }

    public GeneralNames getRequester() {
        return this.requester;
    }

    public PolicyInformation getRequestPolicy() {
        return this.requestPolicy;
    }

    public GeneralNames getDVCS() {
        return this.dvcs;
    }

    public GeneralNames getDataLocations() {
        return this.dataLocations;
    }

    public Extensions getExtensions() {
        return this.extensions;
    }
}

