/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.asn1.dvcs;

import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Encodable;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1EncodableVector;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Integer;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.DERSequence;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.DERTaggedObject;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.dvcs.DVCSRequestInformation;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.dvcs.DVCSTime;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.dvcs.ServiceType;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.x509.Extensions;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.x509.GeneralName;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.x509.GeneralNames;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.x509.PolicyInformation;
import com.fis.ekyc.nfc.build_in.bouncycastle.util.BigIntegers;
import java.math.BigInteger;

public class DVCSRequestInformationBuilder {
    private static final int DEFAULT_VERSION = 1;
    private static final int TAG_REQUESTER = 0;
    private static final int TAG_REQUEST_POLICY = 1;
    private static final int TAG_DVCS = 2;
    private static final int TAG_DATA_LOCATIONS = 3;
    private static final int TAG_EXTENSIONS = 4;
    private int version = 1;
    private final ServiceType service;
    private DVCSRequestInformation initialInfo;
    private BigInteger nonce;
    private DVCSTime requestTime;
    private GeneralNames requester;
    private PolicyInformation requestPolicy;
    private GeneralNames dvcs;
    private GeneralNames dataLocations;
    private Extensions extensions;

    public DVCSRequestInformationBuilder(ServiceType serviceType) {
        this.service = serviceType;
    }

    public DVCSRequestInformationBuilder(DVCSRequestInformation dVCSRequestInformation) {
        this.initialInfo = dVCSRequestInformation;
        this.service = dVCSRequestInformation.getService();
        this.version = dVCSRequestInformation.getVersion();
        this.nonce = dVCSRequestInformation.getNonce();
        this.requestTime = dVCSRequestInformation.getRequestTime();
        this.requestPolicy = dVCSRequestInformation.getRequestPolicy();
        this.dvcs = dVCSRequestInformation.getDVCS();
        this.dataLocations = dVCSRequestInformation.getDataLocations();
    }

    public DVCSRequestInformation build() {
        Object object;
        ASN1EncodableVector aSN1EncodableVector;
        ASN1EncodableVector aSN1EncodableVector2 = aSN1EncodableVector;
        aSN1EncodableVector = new ASN1EncodableVector(9);
        int n3 = this.version;
        if (n3 != 1) {
            aSN1EncodableVector2.add(new ASN1Integer(n3));
        }
        aSN1EncodableVector2.add(this.service);
        Object object2 = this.nonce;
        if (object2 != null) {
            ASN1Integer aSN1Integer;
            object = aSN1Integer;
            aSN1Integer = new ASN1Integer((BigInteger)object2);
            aSN1EncodableVector2.add((ASN1Encodable)object);
        }
        if ((object2 = this.requestTime) != null) {
            aSN1EncodableVector2.add((ASN1Encodable)object2);
        }
        int n4 = 5;
        int[] nArray = new int[5];
        object = nArray;
        nArray[0] = 0;
        nArray[1] = 1;
        nArray[2] = 2;
        nArray[3] = 3;
        nArray[4] = 4;
        ASN1Encodable[] aSN1EncodableArray = new ASN1Encodable[5];
        ASN1Encodable[] aSN1EncodableArray2 = aSN1EncodableArray;
        aSN1EncodableArray2[0] = this.requester;
        aSN1EncodableArray2[1] = this.requestPolicy;
        aSN1EncodableArray2[2] = this.dvcs;
        aSN1EncodableArray2[3] = this.dataLocations;
        aSN1EncodableArray[4] = this.extensions;
        for (int i3 = 0; i3 < n4; ++i3) {
            DERTaggedObject dERTaggedObject;
            Object object3 = object[i3];
            ASN1Encodable aSN1Encodable = aSN1EncodableArray2[i3];
            if (aSN1Encodable == null) continue;
            DERTaggedObject dERTaggedObject2 = dERTaggedObject;
            dERTaggedObject = new DERTaggedObject(false, (int)object3, aSN1Encodable);
            aSN1EncodableVector2.add(dERTaggedObject2);
        }
        return DVCSRequestInformation.getInstance(new DERSequence(aSN1EncodableVector2));
    }

    public void setVersion(int n3) {
        if (this.initialInfo == null) {
            this.version = n3;
            return;
        }
        throw new IllegalStateException("cannot change version in existing DVCSRequestInformation");
    }

    public void setNonce(BigInteger bigInteger) {
        Object object = this.initialInfo;
        if (object != null) {
            if (((DVCSRequestInformation)object).getNonce() == null) {
                this.nonce = bigInteger;
            } else {
                object = this.initialInfo.getNonce().toByteArray();
                byte[] byArray = BigIntegers.asUnsignedByteArray(bigInteger);
                Object object2 = object;
                object = new byte[((Object)object2).length + byArray.length];
                int n3 = ((Object)object2).length;
                System.arraycopy(object2, 0, object, 0, n3);
                n3 = ((Object)object2).length;
                int n4 = byArray.length;
                System.arraycopy(byArray, 0, object, n3, n4);
                this.nonce = new BigInteger((byte[])object);
            }
        }
        this.nonce = bigInteger;
    }

    public void setRequestTime(DVCSTime dVCSTime) {
        if (this.initialInfo == null) {
            this.requestTime = dVCSTime;
            return;
        }
        throw new IllegalStateException("cannot change request time in existing DVCSRequestInformation");
    }

    public void setRequester(GeneralName generalName) {
        GeneralNames generalNames;
        DVCSRequestInformationBuilder dVCSRequestInformationBuilder = generalNames2;
        GeneralNames generalNames2 = generalNames;
        generalNames = new GeneralNames(generalName);
        dVCSRequestInformationBuilder.setRequester(generalNames2);
    }

    public void setRequester(GeneralNames generalNames) {
        this.requester = generalNames;
    }

    public void setRequestPolicy(PolicyInformation policyInformation) {
        if (this.initialInfo == null) {
            this.requestPolicy = policyInformation;
            return;
        }
        throw new IllegalStateException("cannot change request policy in existing DVCSRequestInformation");
    }

    public void setDVCS(GeneralName generalName) {
        GeneralNames generalNames;
        DVCSRequestInformationBuilder dVCSRequestInformationBuilder = generalNames2;
        GeneralNames generalNames2 = generalNames;
        generalNames = new GeneralNames(generalName);
        dVCSRequestInformationBuilder.setDVCS(generalNames2);
    }

    public void setDVCS(GeneralNames generalNames) {
        this.dvcs = generalNames;
    }

    public void setDataLocations(GeneralName generalName) {
        GeneralNames generalNames;
        DVCSRequestInformationBuilder dVCSRequestInformationBuilder = generalNames2;
        GeneralNames generalNames2 = generalNames;
        generalNames = new GeneralNames(generalName);
        dVCSRequestInformationBuilder.setDataLocations(generalNames2);
    }

    public void setDataLocations(GeneralNames generalNames) {
        this.dataLocations = generalNames;
    }

    public void setExtensions(Extensions extensions) {
        if (this.initialInfo == null) {
            this.extensions = extensions;
            return;
        }
        throw new IllegalStateException("cannot change extensions in existing DVCSRequestInformation");
    }
}

