/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.asn1.eac;

import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1ApplicationSpecific;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1EncodableVector;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Object;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1ParsingException;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Primitive;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Sequence;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.DERApplicationSpecific;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.DEROctetString;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.b;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.eac.CertificateBody;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.eac.PublicKeyDataObject;
import com.fis.ekyc.nfc.build_in.bouncycastle.util.Arrays;
import java.io.IOException;
import java.util.Enumeration;

public class CVCertificateRequest
extends ASN1Object {
    private static final int bodyValid = 1;
    private static final int signValid = 2;
    private final ASN1ApplicationSpecific original;
    private CertificateBody certificateBody;
    private byte[] innerSignature = null;
    private byte[] outerSignature = null;

    private CVCertificateRequest(ASN1ApplicationSpecific aSN1ApplicationSpecific) {
        this.original = aSN1ApplicationSpecific;
        if (aSN1ApplicationSpecific.isConstructed() && aSN1ApplicationSpecific.getApplicationTag() == 7) {
            ASN1Sequence aSN1Sequence = ASN1Sequence.getInstance(aSN1ApplicationSpecific.getObject(16));
            this.initCertBody(ASN1ApplicationSpecific.getInstance(aSN1Sequence.getObjectAt(0)));
            this.outerSignature = ASN1ApplicationSpecific.getInstance(aSN1Sequence.getObjectAt(aSN1Sequence.size() - 1)).getContents();
        } else {
            this.initCertBody(aSN1ApplicationSpecific);
        }
    }

    private void initCertBody(ASN1ApplicationSpecific aSN1ApplicationSpecific) {
        if (aSN1ApplicationSpecific.getApplicationTag() == 33) {
            int n3 = 0;
            Enumeration enumeration = ASN1Sequence.getInstance(aSN1ApplicationSpecific.getObject(16)).getObjects();
            while (enumeration.hasMoreElements()) {
                ASN1ApplicationSpecific aSN1ApplicationSpecific2 = ASN1ApplicationSpecific.getInstance(enumeration.nextElement());
                int n4 = aSN1ApplicationSpecific2.getApplicationTag();
                if (n4 != 55) {
                    if (n4 == 78) {
                        this.certificateBody = CertificateBody.getInstance(aSN1ApplicationSpecific2);
                        n3 |= 1;
                        continue;
                    }
                    throw new IOException(b.b.a("Invalid tag, not an CV Certificate Request element:").append(aSN1ApplicationSpecific2.getApplicationTag()).toString());
                }
                this.innerSignature = aSN1ApplicationSpecific2.getContents();
                n3 |= 2;
            }
            if ((n3 & 3) != 0) {
                return;
            }
            throw new IOException(b.b.a("Invalid CARDHOLDER_CERTIFICATE in request:").append(aSN1ApplicationSpecific.getApplicationTag()).toString());
        }
        throw new IOException(b.b.a("not a CARDHOLDER_CERTIFICATE in request:").append(aSN1ApplicationSpecific.getApplicationTag()).toString());
    }

    public static CVCertificateRequest getInstance(Object object) {
        if (object instanceof CVCertificateRequest) {
            return (CVCertificateRequest)object;
        }
        if (object != null) {
            try {
                return new CVCertificateRequest(ASN1ApplicationSpecific.getInstance(object));
            }
            catch (IOException iOException) {
                throw new ASN1ParsingException(b.a(iOException, b.b.a("unable to parse data: ")), iOException);
            }
        }
        return null;
    }

    public CertificateBody getCertificateBody() {
        return this.certificateBody;
    }

    public PublicKeyDataObject getPublicKey() {
        return this.certificateBody.getPublicKey();
    }

    public byte[] getInnerSignature() {
        return Arrays.clone(this.innerSignature);
    }

    public byte[] getOuterSignature() {
        return Arrays.clone(this.outerSignature);
    }

    public boolean hasOuterSignature() {
        return this.outerSignature != null;
    }

    @Override
    public ASN1Primitive toASN1Primitive() {
        ASN1EncodableVector aSN1EncodableVector;
        Object object = this.original;
        if (object != null) {
            return object;
        }
        object = aSN1EncodableVector;
        ((ASN1EncodableVector)object)(2);
        aSN1EncodableVector.add(this.certificateBody);
        try {
            aSN1EncodableVector.add(new DERApplicationSpecific(false, 55, new DEROctetString(this.innerSignature)));
            return new DERApplicationSpecific(33, (ASN1EncodableVector)object);
        }
        catch (IOException iOException) {
            throw new IllegalStateException("unable to convert signature!");
        }
    }
}

