/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.asn1.eac;

import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1EncodableVector;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Object;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1ObjectIdentifier;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1OctetString;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Primitive;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Sequence;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1TaggedObject;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.DEROctetString;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.DERSequence;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.DERTaggedObject;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.eac.PublicKeyDataObject;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.eac.UnsignedInteger;
import com.fis.ekyc.nfc.build_in.bouncycastle.util.Arrays;
import java.math.BigInteger;

public class ECDSAPublicKey
extends PublicKeyDataObject {
    private static final int P = 1;
    private static final int A = 2;
    private static final int B = 4;
    private static final int G = 8;
    private static final int R = 16;
    private static final int Y = 32;
    private static final int F = 64;
    private ASN1ObjectIdentifier usage;
    private BigInteger primeModulusP;
    private BigInteger firstCoefA;
    private BigInteger secondCoefB;
    private byte[] basePointG;
    private BigInteger orderOfBasePointR;
    private byte[] publicPointY;
    private BigInteger cofactorF;
    private int options;

    public ECDSAPublicKey(ASN1Sequence object) {
        ECDSAPublicKey eCDSAPublicKey = this;
        object = ((ASN1Sequence)object).getObjects();
        eCDSAPublicKey.usage = ASN1ObjectIdentifier.getInstance(object.nextElement());
        eCDSAPublicKey.options = 0;
        block9: while (object.hasMoreElements()) {
            Object object2 = object.nextElement();
            if (object2 instanceof ASN1TaggedObject) {
                object2 = (ASN1TaggedObject)object2;
                switch (((ASN1TaggedObject)object2).getTagNo()) {
                    default: {
                        this.options = 0;
                        throw new IllegalArgumentException("Unknown Object Identifier!");
                    }
                    case 7: {
                        this.setCofactorF(UnsignedInteger.getInstance(object2).getValue());
                        continue block9;
                    }
                    case 6: {
                        this.setPublicPointY(ASN1OctetString.getInstance(object2, false));
                        continue block9;
                    }
                    case 5: {
                        this.setOrderOfBasePointR(UnsignedInteger.getInstance(object2).getValue());
                        continue block9;
                    }
                    case 4: {
                        this.setBasePointG(ASN1OctetString.getInstance(object2, false));
                        continue block9;
                    }
                    case 3: {
                        this.setSecondCoefB(UnsignedInteger.getInstance(object2).getValue());
                        continue block9;
                    }
                    case 2: {
                        this.setFirstCoefA(UnsignedInteger.getInstance(object2).getValue());
                        continue block9;
                    }
                    case 1: 
                }
                this.setPrimeModulusP(UnsignedInteger.getInstance(object2).getValue());
                continue;
            }
            throw new IllegalArgumentException("Unknown Object Identifier!");
        }
        int n3 = this.options;
        if (n3 != 32 && n3 != 127) {
            throw new IllegalArgumentException("All options must be either present or absent!");
        }
    }

    public ECDSAPublicKey(ASN1ObjectIdentifier aSN1ObjectIdentifier, byte[] byArray) {
        DEROctetString dEROctetString;
        ECDSAPublicKey eCDSAPublicKey = aSN1Object;
        eCDSAPublicKey.usage = aSN1ObjectIdentifier;
        ASN1Object aSN1Object = dEROctetString;
        dEROctetString = new DEROctetString(byArray);
        eCDSAPublicKey.setPublicPointY((ASN1OctetString)aSN1Object);
    }

    public ECDSAPublicKey(ASN1ObjectIdentifier aSN1ObjectIdentifier, BigInteger bigInteger, BigInteger bigInteger2, BigInteger bigInteger3, byte[] byArray, BigInteger bigInteger4, byte[] byArray2, int n3) {
        ECDSAPublicKey eCDSAPublicKey = this;
        ECDSAPublicKey eCDSAPublicKey2 = this;
        this.usage = aSN1ObjectIdentifier;
        this.setPrimeModulusP(bigInteger);
        this.setFirstCoefA(bigInteger2);
        eCDSAPublicKey2.setSecondCoefB(bigInteger3);
        eCDSAPublicKey2.setBasePointG(new DEROctetString(byArray));
        eCDSAPublicKey.setOrderOfBasePointR(bigInteger4);
        eCDSAPublicKey.setPublicPointY(new DEROctetString(byArray2));
        this.setCofactorF(BigInteger.valueOf(n3));
    }

    private void setBasePointG(ASN1OctetString aSN1OctetString) {
        int n3 = this.options;
        if ((n3 & 8) == 0) {
            this.options = n3 | 8;
            this.basePointG = aSN1OctetString.getOctets();
            return;
        }
        throw new IllegalArgumentException("Base Point G already set");
    }

    private void setCofactorF(BigInteger bigInteger) {
        int n3 = this.options;
        if ((n3 & 0x40) == 0) {
            this.options = n3 | 0x40;
            this.cofactorF = bigInteger;
            return;
        }
        throw new IllegalArgumentException("Cofactor F already set");
    }

    private void setFirstCoefA(BigInteger bigInteger) {
        int n3 = this.options;
        if ((n3 & 2) == 0) {
            this.options = n3 | 2;
            this.firstCoefA = bigInteger;
            return;
        }
        throw new IllegalArgumentException("First Coef A already set");
    }

    private void setOrderOfBasePointR(BigInteger bigInteger) {
        int n3 = this.options;
        if ((n3 & 0x10) == 0) {
            this.options = n3 | 0x10;
            this.orderOfBasePointR = bigInteger;
            return;
        }
        throw new IllegalArgumentException("Order of base point R already set");
    }

    private void setPrimeModulusP(BigInteger bigInteger) {
        int n3 = this.options;
        if ((n3 & 1) == 0) {
            this.options = n3 | 1;
            this.primeModulusP = bigInteger;
            return;
        }
        throw new IllegalArgumentException("Prime Modulus P already set");
    }

    private void setPublicPointY(ASN1OctetString aSN1OctetString) {
        int n3 = this.options;
        if ((n3 & 0x20) == 0) {
            this.options = n3 | 0x20;
            this.publicPointY = aSN1OctetString.getOctets();
            return;
        }
        throw new IllegalArgumentException("Public Point Y already set");
    }

    private void setSecondCoefB(BigInteger bigInteger) {
        int n3 = this.options;
        if ((n3 & 4) == 0) {
            this.options = n3 | 4;
            this.secondCoefB = bigInteger;
            return;
        }
        throw new IllegalArgumentException("Second Coef B already set");
    }

    @Override
    public ASN1ObjectIdentifier getUsage() {
        return this.usage;
    }

    public byte[] getBasePointG() {
        if ((this.options & 8) != 0) {
            return Arrays.clone(this.basePointG);
        }
        return null;
    }

    public BigInteger getCofactorF() {
        if ((this.options & 0x40) != 0) {
            return this.cofactorF;
        }
        return null;
    }

    public BigInteger getFirstCoefA() {
        if ((this.options & 2) != 0) {
            return this.firstCoefA;
        }
        return null;
    }

    public BigInteger getOrderOfBasePointR() {
        if ((this.options & 0x10) != 0) {
            return this.orderOfBasePointR;
        }
        return null;
    }

    public BigInteger getPrimeModulusP() {
        if ((this.options & 1) != 0) {
            return this.primeModulusP;
        }
        return null;
    }

    public byte[] getPublicPointY() {
        if ((this.options & 0x20) != 0) {
            return Arrays.clone(this.publicPointY);
        }
        return null;
    }

    public BigInteger getSecondCoefB() {
        if ((this.options & 4) != 0) {
            return this.secondCoefB;
        }
        return null;
    }

    public boolean hasParameters() {
        return this.primeModulusP != null;
    }

    public ASN1EncodableVector getASN1EncodableVector(ASN1ObjectIdentifier aSN1Object, boolean bl) {
        DEROctetString dEROctetString;
        ASN1EncodableVector aSN1EncodableVector;
        ASN1EncodableVector aSN1EncodableVector2 = aSN1EncodableVector;
        new ASN1EncodableVector(8).add(aSN1Object);
        if (!bl) {
            DEROctetString dEROctetString2;
            ASN1EncodableVector aSN1EncodableVector3 = aSN1EncodableVector2;
            aSN1EncodableVector3.add(new UnsignedInteger(1, this.getPrimeModulusP()));
            aSN1EncodableVector3.add(new UnsignedInteger(2, this.getFirstCoefA()));
            aSN1EncodableVector3.add(new UnsignedInteger(3, this.getSecondCoefB()));
            aSN1Object = dEROctetString2;
            dEROctetString2 = new DEROctetString(this.getBasePointG());
            aSN1EncodableVector3.add(new DERTaggedObject(false, 4, aSN1Object));
            aSN1EncodableVector3.add(new UnsignedInteger(5, this.getOrderOfBasePointR()));
        }
        aSN1Object = dEROctetString;
        dEROctetString = new DEROctetString(this.getPublicPointY());
        aSN1EncodableVector2.add(new DERTaggedObject(false, 6, aSN1Object));
        if (!bl) {
            UnsignedInteger unsignedInteger;
            aSN1Object = unsignedInteger;
            unsignedInteger = new UnsignedInteger(7, this.getCofactorF());
            aSN1EncodableVector2.add(aSN1Object);
        }
        return aSN1EncodableVector2;
    }

    @Override
    public ASN1Primitive toASN1Primitive() {
        ECDSAPublicKey eCDSAPublicKey = this;
        return new DERSequence(eCDSAPublicKey.getASN1EncodableVector(eCDSAPublicKey.usage, this.hasParameters() ^ true));
    }
}

