/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.asn1.esf;

import c.b;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Encodable;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1EncodableVector;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Object;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Primitive;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Sequence;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1TaggedObject;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.DERSequence;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.DERTaggedObject;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.esf.OtherRevVals;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ocsp.BasicOCSPResponse;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.x509.CertificateList;
import java.util.Enumeration;

public class RevocationValues
extends ASN1Object {
    private ASN1Sequence crlVals;
    private ASN1Sequence ocspVals;
    private OtherRevVals otherRevVals;

    public static RevocationValues getInstance(Object object) {
        if (object instanceof RevocationValues) {
            return (RevocationValues)object;
        }
        if (object != null) {
            return new RevocationValues(ASN1Sequence.getInstance(object));
        }
        return null;
    }

    private RevocationValues(ASN1Sequence object) {
        if (((ASN1Sequence)object).size() <= 3) {
            object = ((ASN1Sequence)object).getObjects();
            while (object.hasMoreElements()) {
                ASN1Primitive aSN1Primitive = (ASN1TaggedObject)object.nextElement();
                int n3 = aSN1Primitive.getTagNo();
                if (n3 != 0) {
                    if (n3 != 1) {
                        if (n3 == 2) {
                            this.otherRevVals = OtherRevVals.getInstance(aSN1Primitive.getObject());
                            continue;
                        }
                        throw new IllegalArgumentException(com.fis.ekyc.nfc.build_in.bouncycastle.asn1.cmc.b.a(aSN1Primitive, b.b.a("invalid tag: ")));
                    }
                    aSN1Primitive = (ASN1Sequence)aSN1Primitive.getObject();
                    Enumeration enumeration = ((ASN1Sequence)aSN1Primitive).getObjects();
                    while (enumeration.hasMoreElements()) {
                        BasicOCSPResponse.getInstance(enumeration.nextElement());
                    }
                    this.ocspVals = aSN1Primitive;
                    continue;
                }
                aSN1Primitive = (ASN1Sequence)aSN1Primitive.getObject();
                Enumeration enumeration = ((ASN1Sequence)aSN1Primitive).getObjects();
                while (enumeration.hasMoreElements()) {
                    CertificateList.getInstance(enumeration.nextElement());
                }
                this.crlVals = aSN1Primitive;
            }
            return;
        }
        throw new IllegalArgumentException(b.a((ASN1Sequence)object, b.b.a("Bad sequence size: ")));
    }

    public RevocationValues(CertificateList[] object, BasicOCSPResponse[] basicOCSPResponseArray, OtherRevVals otherRevVals) {
        if (object != null) {
            DERSequence dERSequence;
            DERSequence dERSequence2 = dERSequence;
            dERSequence = new DERSequence((ASN1Encodable[])object);
            this.crlVals = dERSequence2;
        }
        if (basicOCSPResponseArray != null) {
            DERSequence dERSequence;
            object = dERSequence;
            dERSequence = new DERSequence(basicOCSPResponseArray);
            this.ocspVals = object;
        }
        this.otherRevVals = otherRevVals;
    }

    public CertificateList[] getCrlVals() {
        ASN1Sequence aSN1Sequence = this.crlVals;
        if (aSN1Sequence == null) {
            return new CertificateList[0];
        }
        int n3 = aSN1Sequence.size();
        CertificateList[] certificateListArray = new CertificateList[n3];
        for (int i3 = 0; i3 < n3; ++i3) {
            certificateListArray[i3] = CertificateList.getInstance(this.crlVals.getObjectAt(i3));
        }
        return certificateListArray;
    }

    public BasicOCSPResponse[] getOcspVals() {
        ASN1Sequence aSN1Sequence = this.ocspVals;
        if (aSN1Sequence == null) {
            return new BasicOCSPResponse[0];
        }
        int n3 = aSN1Sequence.size();
        BasicOCSPResponse[] basicOCSPResponseArray = new BasicOCSPResponse[n3];
        for (int i3 = 0; i3 < n3; ++i3) {
            basicOCSPResponseArray[i3] = BasicOCSPResponse.getInstance(this.ocspVals.getObjectAt(i3));
        }
        return basicOCSPResponseArray;
    }

    public OtherRevVals getOtherRevVals() {
        return this.otherRevVals;
    }

    @Override
    public ASN1Primitive toASN1Primitive() {
        DERTaggedObject dERTaggedObject;
        ASN1EncodableVector aSN1EncodableVector;
        ASN1EncodableVector aSN1EncodableVector2 = aSN1EncodableVector;
        aSN1EncodableVector = new ASN1EncodableVector(3);
        ASN1Primitive aSN1Primitive = ((RevocationValues)aSN1Object).crlVals;
        if (aSN1Primitive != null) {
            DERTaggedObject dERTaggedObject2;
            dERTaggedObject = dERTaggedObject2;
            dERTaggedObject2 = new DERTaggedObject(true, 0, aSN1Primitive);
            aSN1EncodableVector2.add(dERTaggedObject);
        }
        if ((aSN1Primitive = ((RevocationValues)aSN1Object).ocspVals) != null) {
            DERTaggedObject dERTaggedObject3;
            dERTaggedObject = dERTaggedObject3;
            dERTaggedObject3 = new DERTaggedObject(true, 1, aSN1Primitive);
            aSN1EncodableVector2.add(dERTaggedObject);
        }
        if ((aSN1Object = ((RevocationValues)aSN1Object).otherRevVals) != null) {
            DERTaggedObject dERTaggedObject4;
            aSN1Primitive = dERTaggedObject4;
            ASN1Object aSN1Object = ((OtherRevVals)aSN1Object).toASN1Primitive();
            dERTaggedObject4 = new DERTaggedObject(true, 2, aSN1Object);
            aSN1EncodableVector2.add(aSN1Primitive);
        }
        return new DERSequence(aSN1EncodableVector2);
    }
}

