/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ess;

import c.b;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1EncodableVector;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Object;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1OctetString;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Primitive;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Sequence;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.DEROctetString;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.DERSequence;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.nist.NISTObjectIdentifiers;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.x509.AlgorithmIdentifier;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.x509.IssuerSerial;
import com.fis.ekyc.nfc.build_in.bouncycastle.util.Arrays;

public class ESSCertIDv2
extends ASN1Object {
    private static final AlgorithmIdentifier DEFAULT_ALG_ID = new AlgorithmIdentifier(NISTObjectIdentifiers.id_sha256);
    private AlgorithmIdentifier hashAlgorithm;
    private byte[] certHash;
    private IssuerSerial issuerSerial;

    public static ESSCertIDv2 getInstance(Object object) {
        if (object instanceof ESSCertIDv2) {
            return (ESSCertIDv2)object;
        }
        if (object != null) {
            return new ESSCertIDv2(ASN1Sequence.getInstance(object));
        }
        return null;
    }

    private ESSCertIDv2(ASN1Sequence aSN1Sequence) {
        if (aSN1Sequence.size() <= 3) {
            int n3 = 0;
            if (aSN1Sequence.getObjectAt(0) instanceof ASN1OctetString) {
                this.hashAlgorithm = DEFAULT_ALG_ID;
            } else {
                int n4 = n3;
                n3 = 1;
                this.hashAlgorithm = AlgorithmIdentifier.getInstance(aSN1Sequence.getObjectAt(n4).toASN1Primitive());
            }
            this.certHash = ASN1OctetString.getInstance(aSN1Sequence.getObjectAt(n3++).toASN1Primitive()).getOctets();
            if (aSN1Sequence.size() > n3) {
                this.issuerSerial = IssuerSerial.getInstance(aSN1Sequence.getObjectAt(n3));
            }
            return;
        }
        throw new IllegalArgumentException(b.a(aSN1Sequence, b.b.a("Bad sequence size: ")));
    }

    public ESSCertIDv2(byte[] byArray) {
        this(null, byArray, null);
    }

    public ESSCertIDv2(AlgorithmIdentifier algorithmIdentifier, byte[] byArray) {
        this(algorithmIdentifier, byArray, null);
    }

    public ESSCertIDv2(byte[] byArray, IssuerSerial issuerSerial) {
        this(null, byArray, issuerSerial);
    }

    public ESSCertIDv2(AlgorithmIdentifier algorithmIdentifier, byte[] byArray, IssuerSerial issuerSerial) {
        this.hashAlgorithm = algorithmIdentifier == null ? DEFAULT_ALG_ID : algorithmIdentifier;
        this.certHash = Arrays.clone(byArray);
        this.issuerSerial = issuerSerial;
    }

    public AlgorithmIdentifier getHashAlgorithm() {
        return this.hashAlgorithm;
    }

    public byte[] getCertHash() {
        return Arrays.clone(this.certHash);
    }

    public IssuerSerial getIssuerSerial() {
        return this.issuerSerial;
    }

    @Override
    public ASN1Primitive toASN1Primitive() {
        ASN1EncodableVector aSN1EncodableVector;
        ASN1EncodableVector aSN1EncodableVector2 = aSN1EncodableVector;
        aSN1EncodableVector = new ASN1EncodableVector(3);
        if (!aSN1Object.hashAlgorithm.equals(DEFAULT_ALG_ID)) {
            aSN1EncodableVector2.add(aSN1Object.hashAlgorithm);
        }
        aSN1EncodableVector2.add(new DEROctetString(aSN1Object.certHash).toASN1Primitive());
        ASN1Object aSN1Object = aSN1Object.issuerSerial;
        if (aSN1Object != null) {
            aSN1EncodableVector2.add(aSN1Object);
        }
        return new DERSequence(aSN1EncodableVector2);
    }
}

