/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.asn1.gm;

import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1ObjectIdentifier;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.gm.GMObjectIdentifiers;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.x9.X9ECParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.x9.X9ECParametersHolder;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.x9.X9ECPoint;
import com.fis.ekyc.nfc.build_in.bouncycastle.math.ec.ECCurve;
import com.fis.ekyc.nfc.build_in.bouncycastle.math.ec.WNafUtil;
import com.fis.ekyc.nfc.build_in.bouncycastle.util.Strings;
import com.fis.ekyc.nfc.build_in.bouncycastle.util.encoders.Hex;
import java.math.BigInteger;
import java.util.Enumeration;
import java.util.Hashtable;

public class GMNamedCurves {
    public static X9ECParametersHolder sm2p256v1 = new X9ECParametersHolder(){

        @Override
        public X9ECParameters createParameters() {
            Object object = GMNamedCurves.fromHex("FFFFFFFEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00000000FFFFFFFFFFFFFFFF");
            Object object2 = GMNamedCurves.fromHex("FFFFFFFEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00000000FFFFFFFFFFFFFFFC");
            BigInteger bigInteger = GMNamedCurves.fromHex("28E9FA9E9D9F5E344D5A9E4BCF6509A7F39789F515AB8F92DDBCBD414D940E93");
            BigInteger bigInteger2 = GMNamedCurves.fromHex("FFFFFFFEFFFFFFFFFFFFFFFFFFFFFFFF7203DF6B21C6052B53BBF40939D54123");
            BigInteger bigInteger3 = BigInteger.valueOf(1L);
            object = GMNamedCurves.configureCurve(new ECCurve.Fp((BigInteger)object, (BigInteger)object2, bigInteger, bigInteger2, bigInteger3));
            object2 = GMNamedCurves.configureBasepoint((ECCurve)object, "0432C4AE2C1F1981195F9904466A39C9948FE30BBFF2660BE1715A4589334C74C7BC3736A2F4F6779C59BDCEE36B692153D0A9877CC62A474002DF32E52139F0A0");
            return new X9ECParameters((ECCurve)object, (X9ECPoint)object2, bigInteger2, bigInteger3, null);
        }
    };
    public static X9ECParametersHolder wapip192v1 = new X9ECParametersHolder(){

        @Override
        public X9ECParameters createParameters() {
            Object object = GMNamedCurves.fromHex("BDB6F4FE3E8B1D9E0DA8C0D46F4C318CEFE4AFE3B6B8551F");
            Object object2 = GMNamedCurves.fromHex("BB8E5E8FBC115E139FE6A814FE48AAA6F0ADA1AA5DF91985");
            BigInteger bigInteger = GMNamedCurves.fromHex("1854BEBDC31B21B7AEFC80AB0ECD10D5B1B3308E6DBF11C1");
            BigInteger bigInteger2 = GMNamedCurves.fromHex("BDB6F4FE3E8B1D9E0DA8C0D40FC962195DFAE76F56564677");
            BigInteger bigInteger3 = BigInteger.valueOf(1L);
            object = GMNamedCurves.configureCurve(new ECCurve.Fp((BigInteger)object, (BigInteger)object2, bigInteger, bigInteger2, bigInteger3));
            object2 = GMNamedCurves.configureBasepoint((ECCurve)object, "044AD5F7048DE709AD51236DE65E4D4B482C836DC6E410664002BB3A02D4AAADACAE24817A4CA3A1B014B5270432DB27D2");
            return new X9ECParameters((ECCurve)object, (X9ECPoint)object2, bigInteger2, bigInteger3, null);
        }
    };
    public static final Hashtable objIds = new Hashtable();
    public static final Hashtable curves = new Hashtable();
    public static final Hashtable names = new Hashtable();

    private static X9ECPoint configureBasepoint(ECCurve eCCurve, String string2) {
        X9ECPoint x9ECPoint = new X9ECPoint(eCCurve, Hex.decodeStrict(string2));
        WNafUtil.configureBasepoint(x9ECPoint.getPoint());
        return x9ECPoint;
    }

    private static ECCurve configureCurve(ECCurve eCCurve) {
        return eCCurve;
    }

    private static BigInteger fromHex(String string2) {
        return new BigInteger(1, Hex.decodeStrict(string2));
    }

    public static void defineCurve(String string2, ASN1ObjectIdentifier aSN1ObjectIdentifier, X9ECParametersHolder x9ECParametersHolder) {
        objIds.put(Strings.toLowerCase(string2), aSN1ObjectIdentifier);
        names.put(aSN1ObjectIdentifier, string2);
        curves.put(aSN1ObjectIdentifier, x9ECParametersHolder);
    }

    public static X9ECParameters getByName(String object) {
        return (object = GMNamedCurves.getOID((String)object)) == null ? null : GMNamedCurves.getByOID((ASN1ObjectIdentifier)object);
    }

    public static X9ECParameters getByOID(ASN1ObjectIdentifier object) {
        return (object = (X9ECParametersHolder)curves.get(object)) == null ? null : ((X9ECParametersHolder)object).getParameters();
    }

    public static ASN1ObjectIdentifier getOID(String string2) {
        return (ASN1ObjectIdentifier)objIds.get(Strings.toLowerCase(string2));
    }

    public static String getName(ASN1ObjectIdentifier aSN1ObjectIdentifier) {
        return (String)names.get(aSN1ObjectIdentifier);
    }

    public static Enumeration getNames() {
        return names.elements();
    }

    static {
        X9ECParametersHolder x9ECParametersHolder = wapip192v1;
        GMNamedCurves.defineCurve("wapip192v1", GMObjectIdentifiers.wapip192v1, x9ECParametersHolder);
        x9ECParametersHolder = sm2p256v1;
        GMNamedCurves.defineCurve("sm2p256v1", GMObjectIdentifiers.sm2p256v1, x9ECParametersHolder);
    }
}

