/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.asn1.isismtt.x509;

import c.b;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Encodable;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1EncodableVector;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Object;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1ObjectIdentifier;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1OctetString;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Primitive;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Sequence;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1TaggedObject;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.DEROctetString;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.DERPrintableString;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.DERSequence;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.DERTaggedObject;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.c;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.isismtt.x509.NamingAuthority;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.x500.DirectoryString;
import java.util.Enumeration;

public class ProfessionInfo
extends ASN1Object {
    public static final ASN1ObjectIdentifier Rechtsanwltin;
    public static final ASN1ObjectIdentifier Rechtsanwalt;
    public static final ASN1ObjectIdentifier Rechtsbeistand;
    public static final ASN1ObjectIdentifier Steuerberaterin;
    public static final ASN1ObjectIdentifier Steuerberater;
    public static final ASN1ObjectIdentifier Steuerbevollmchtigte;
    public static final ASN1ObjectIdentifier Steuerbevollmchtigter;
    public static final ASN1ObjectIdentifier Notarin;
    public static final ASN1ObjectIdentifier Notar;
    public static final ASN1ObjectIdentifier Notarvertreterin;
    public static final ASN1ObjectIdentifier Notarvertreter;
    public static final ASN1ObjectIdentifier Notariatsverwalterin;
    public static final ASN1ObjectIdentifier Notariatsverwalter;
    public static final ASN1ObjectIdentifier Wirtschaftsprferin;
    public static final ASN1ObjectIdentifier Wirtschaftsprfer;
    public static final ASN1ObjectIdentifier VereidigteBuchprferin;
    public static final ASN1ObjectIdentifier VereidigterBuchprfer;
    public static final ASN1ObjectIdentifier Patentanwltin;
    public static final ASN1ObjectIdentifier Patentanwalt;
    private NamingAuthority namingAuthority;
    private ASN1Sequence professionItems;
    private ASN1Sequence professionOIDs;
    private String registrationNumber;
    private ASN1OctetString addProfessionInfo;

    public static ProfessionInfo getInstance(Object object) {
        if (object != null && !(object instanceof ProfessionInfo)) {
            if (object instanceof ASN1Sequence) {
                return new ProfessionInfo((ASN1Sequence)object);
            }
            throw new IllegalArgumentException(c.a(object, b.b.a("illegal object in getInstance: ")));
        }
        return (ProfessionInfo)object;
    }

    private ProfessionInfo(ASN1Sequence object) {
        if (((ASN1Sequence)object).size() <= 5) {
            ASN1Encodable aSN1Encodable = (ASN1Encodable)(object = ((ASN1Sequence)object).getObjects()).nextElement();
            if (aSN1Encodable instanceof ASN1TaggedObject) {
                if (((ASN1TaggedObject)(aSN1Encodable = (ASN1TaggedObject)aSN1Encodable)).getTagNo() == 0) {
                    this.namingAuthority = NamingAuthority.getInstance((ASN1TaggedObject)aSN1Encodable, true);
                    aSN1Encodable = (ASN1Encodable)object.nextElement();
                } else {
                    throw new IllegalArgumentException(com.fis.ekyc.nfc.build_in.bouncycastle.asn1.cmc.b.a((ASN1TaggedObject)aSN1Encodable, b.b.a("Bad tag number: ")));
                }
            }
            this.professionItems = ASN1Sequence.getInstance(aSN1Encodable);
            if (object.hasMoreElements()) {
                aSN1Encodable = (ASN1Encodable)object.nextElement();
                if (aSN1Encodable instanceof ASN1Sequence) {
                    this.professionOIDs = ASN1Sequence.getInstance(aSN1Encodable);
                } else if (aSN1Encodable instanceof DERPrintableString) {
                    this.registrationNumber = DERPrintableString.getInstance(aSN1Encodable).getString();
                } else if (aSN1Encodable instanceof ASN1OctetString) {
                    this.addProfessionInfo = ASN1OctetString.getInstance(aSN1Encodable);
                } else {
                    throw new IllegalArgumentException(b.b.a("Bad object encountered: ").append(aSN1Encodable.getClass()).toString());
                }
            }
            if (object.hasMoreElements()) {
                aSN1Encodable = (ASN1Encodable)object.nextElement();
                if (aSN1Encodable instanceof DERPrintableString) {
                    this.registrationNumber = DERPrintableString.getInstance(aSN1Encodable).getString();
                } else if (aSN1Encodable instanceof DEROctetString) {
                    this.addProfessionInfo = (DEROctetString)aSN1Encodable;
                } else {
                    throw new IllegalArgumentException(b.b.a("Bad object encountered: ").append(aSN1Encodable.getClass()).toString());
                }
            }
            if (object.hasMoreElements()) {
                if ((object = (ASN1Encodable)object.nextElement()) instanceof DEROctetString) {
                    this.addProfessionInfo = (DEROctetString)object;
                } else {
                    throw new IllegalArgumentException(b.b.a("Bad object encountered: ").append(object.getClass()).toString());
                }
            }
            return;
        }
        throw new IllegalArgumentException(b.a((ASN1Sequence)object, b.b.a("Bad sequence size: ")));
    }

    public ProfessionInfo(NamingAuthority aSN1Object, DirectoryString[] directoryStringArray, ASN1ObjectIdentifier[] aSN1ObjectIdentifierArray, String string2, ASN1OctetString aSN1OctetString) {
        DERSequence dERSequence;
        this.namingAuthority = aSN1Object;
        aSN1Object = dERSequence;
        dERSequence = new DERSequence(directoryStringArray);
        this.professionItems = aSN1Object;
        if (aSN1ObjectIdentifierArray != null) {
            DERSequence dERSequence2;
            aSN1Object = dERSequence2;
            dERSequence2 = new DERSequence(aSN1ObjectIdentifierArray);
            this.professionOIDs = aSN1Object;
        }
        ProfessionInfo professionInfo = this;
        professionInfo.registrationNumber = string2;
        professionInfo.addProfessionInfo = aSN1OctetString;
    }

    static {
        ASN1ObjectIdentifier aSN1ObjectIdentifier = NamingAuthority.id_isismtt_at_namingAuthorities_RechtWirtschaftSteuern;
        Rechtsanwltin = new ASN1ObjectIdentifier(aSN1ObjectIdentifier + ".1");
        Rechtsanwalt = new ASN1ObjectIdentifier(aSN1ObjectIdentifier + ".2");
        Rechtsbeistand = new ASN1ObjectIdentifier(aSN1ObjectIdentifier + ".3");
        Steuerberaterin = new ASN1ObjectIdentifier(aSN1ObjectIdentifier + ".4");
        Steuerberater = new ASN1ObjectIdentifier(aSN1ObjectIdentifier + ".5");
        Steuerbevollmchtigte = new ASN1ObjectIdentifier(aSN1ObjectIdentifier + ".6");
        Steuerbevollmchtigter = new ASN1ObjectIdentifier(aSN1ObjectIdentifier + ".7");
        Notarin = new ASN1ObjectIdentifier(aSN1ObjectIdentifier + ".8");
        Notar = new ASN1ObjectIdentifier(aSN1ObjectIdentifier + ".9");
        Notarvertreterin = new ASN1ObjectIdentifier(aSN1ObjectIdentifier + ".10");
        Notarvertreter = new ASN1ObjectIdentifier(aSN1ObjectIdentifier + ".11");
        Notariatsverwalterin = new ASN1ObjectIdentifier(aSN1ObjectIdentifier + ".12");
        Notariatsverwalter = new ASN1ObjectIdentifier(aSN1ObjectIdentifier + ".13");
        Wirtschaftsprferin = new ASN1ObjectIdentifier(aSN1ObjectIdentifier + ".14");
        Wirtschaftsprfer = new ASN1ObjectIdentifier(aSN1ObjectIdentifier + ".15");
        VereidigteBuchprferin = new ASN1ObjectIdentifier(aSN1ObjectIdentifier + ".16");
        VereidigterBuchprfer = new ASN1ObjectIdentifier(aSN1ObjectIdentifier + ".17");
        Patentanwltin = new ASN1ObjectIdentifier(aSN1ObjectIdentifier + ".18");
        Patentanwalt = new ASN1ObjectIdentifier(aSN1ObjectIdentifier + ".19");
    }

    @Override
    public ASN1Primitive toASN1Primitive() {
        ASN1OctetString aSN1OctetString;
        ASN1Primitive aSN1Primitive;
        ASN1EncodableVector aSN1EncodableVector;
        ASN1EncodableVector aSN1EncodableVector2 = aSN1EncodableVector;
        aSN1EncodableVector = new ASN1EncodableVector(5);
        Object object = this.namingAuthority;
        if (object != null) {
            DERTaggedObject dERTaggedObject;
            aSN1Primitive = dERTaggedObject;
            dERTaggedObject = new DERTaggedObject(true, 0, (ASN1Encodable)object);
            aSN1EncodableVector2.add(aSN1Primitive);
        }
        aSN1EncodableVector2.add(this.professionItems);
        object = this.professionOIDs;
        if (object != null) {
            aSN1EncodableVector2.add((ASN1Encodable)object);
        }
        if ((object = this.registrationNumber) != null) {
            DERPrintableString dERPrintableString;
            aSN1Primitive = dERPrintableString;
            dERPrintableString = new DERPrintableString((String)object, true);
            aSN1EncodableVector2.add(aSN1Primitive);
        }
        if ((aSN1OctetString = this.addProfessionInfo) != null) {
            aSN1EncodableVector2.add(aSN1OctetString);
        }
        return new DERSequence(aSN1EncodableVector2);
    }

    public ASN1OctetString getAddProfessionInfo() {
        return this.addProfessionInfo;
    }

    public NamingAuthority getNamingAuthority() {
        return this.namingAuthority;
    }

    public DirectoryString[] getProfessionItems() {
        DirectoryString[] directoryStringArray = new DirectoryString[directoryStringArray.professionItems.size()];
        int n3 = 0;
        Enumeration enumeration = directoryStringArray.professionItems.getObjects();
        while (enumeration.hasMoreElements()) {
            directoryStringArray[n3++] = DirectoryString.getInstance(enumeration.nextElement());
        }
        return directoryStringArray;
    }

    public ASN1ObjectIdentifier[] getProfessionOIDs() {
        ASN1Sequence aSN1Sequence = aSN1ObjectIdentifierArray2.professionOIDs;
        if (aSN1Sequence == null) {
            return new ASN1ObjectIdentifier[0];
        }
        ASN1ObjectIdentifier[] aSN1ObjectIdentifierArray = aSN1ObjectIdentifierArray2;
        ASN1ObjectIdentifier[] aSN1ObjectIdentifierArray2 = new ASN1ObjectIdentifier[aSN1Sequence.size()];
        int n3 = 0;
        Enumeration enumeration = aSN1ObjectIdentifierArray.professionOIDs.getObjects();
        while (enumeration.hasMoreElements()) {
            aSN1ObjectIdentifierArray2[n3++] = ASN1ObjectIdentifier.getInstance(enumeration.nextElement());
        }
        return aSN1ObjectIdentifierArray2;
    }

    public String getRegistrationNumber() {
        return this.registrationNumber;
    }
}

