/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.asn1.nist;

import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1EncodableVector;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Integer;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Object;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Primitive;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Sequence;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.DEROctetString;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.DERSequence;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.cmc.a;
import com.fis.ekyc.nfc.build_in.bouncycastle.util.Arrays;

public class KMACwithSHAKE128_params
extends ASN1Object {
    private static final byte[] EMPTY_STRING = new byte[0];
    private static final int DEF_LENGTH = 256;
    private final int outputLength;
    private final byte[] customizationString;

    public KMACwithSHAKE128_params(int n3) {
        KMACwithSHAKE128_params kMACwithSHAKE128_params = this;
        kMACwithSHAKE128_params.outputLength = n3;
        kMACwithSHAKE128_params.customizationString = EMPTY_STRING;
    }

    public KMACwithSHAKE128_params(int n3, byte[] byArray) {
        this.outputLength = n3;
        this.customizationString = Arrays.clone(byArray);
    }

    public static KMACwithSHAKE128_params getInstance(Object object) {
        if (object instanceof KMACwithSHAKE128_params) {
            return (KMACwithSHAKE128_params)object;
        }
        if (object != null) {
            return new KMACwithSHAKE128_params(ASN1Sequence.getInstance(object));
        }
        return null;
    }

    private KMACwithSHAKE128_params(ASN1Sequence aSN1Sequence) {
        if (aSN1Sequence.size() <= 2) {
            if (aSN1Sequence.size() == 2) {
                this.outputLength = ASN1Integer.getInstance(aSN1Sequence.getObjectAt(0)).intValueExact();
                this.customizationString = a.a(aSN1Sequence, 1);
            } else if (aSN1Sequence.size() == 1) {
                if (aSN1Sequence.getObjectAt(0) instanceof ASN1Integer) {
                    KMACwithSHAKE128_params kMACwithSHAKE128_params = this;
                    kMACwithSHAKE128_params.outputLength = ASN1Integer.getInstance(aSN1Sequence.getObjectAt(0)).intValueExact();
                    kMACwithSHAKE128_params.customizationString = EMPTY_STRING;
                } else {
                    this.outputLength = 256;
                    this.customizationString = a.a(aSN1Sequence, 0);
                }
            } else {
                KMACwithSHAKE128_params kMACwithSHAKE128_params = this;
                kMACwithSHAKE128_params.outputLength = 256;
                kMACwithSHAKE128_params.customizationString = EMPTY_STRING;
            }
            return;
        }
        throw new IllegalArgumentException("sequence size greater than 2");
    }

    public int getOutputLength() {
        return this.outputLength;
    }

    public byte[] getCustomizationString() {
        return Arrays.clone(this.customizationString);
    }

    @Override
    public ASN1Primitive toASN1Primitive() {
        ASN1EncodableVector aSN1EncodableVector;
        ASN1EncodableVector aSN1EncodableVector2 = aSN1EncodableVector;
        aSN1EncodableVector = new ASN1EncodableVector();
        int n3 = this.outputLength;
        if (n3 != 256) {
            aSN1EncodableVector2.add(new ASN1Integer(n3));
        }
        if (this.customizationString.length != 0) {
            aSN1EncodableVector2.add(new DEROctetString(this.getCustomizationString()));
        }
        return new DERSequence(aSN1EncodableVector2);
    }
}

