/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ocsp;

import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1EncodableVector;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Integer;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Object;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Primitive;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Sequence;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1TaggedObject;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.DERSequence;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.DERTaggedObject;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.x509.Extensions;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.x509.GeneralName;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.x509.X509Extensions;

public class TBSRequest
extends ASN1Object {
    private static final ASN1Integer V1 = new ASN1Integer(0L);
    public ASN1Integer version;
    public GeneralName requestorName;
    public ASN1Sequence requestList;
    public Extensions requestExtensions;
    public boolean versionSet;

    public TBSRequest(GeneralName generalName, ASN1Sequence aSN1Sequence, X509Extensions x509Extensions) {
        this.version = V1;
        this.requestorName = generalName;
        this.requestList = aSN1Sequence;
        this.requestExtensions = Extensions.getInstance(x509Extensions);
    }

    public TBSRequest(GeneralName generalName, ASN1Sequence aSN1Sequence, Extensions extensions) {
        this.version = V1;
        this.requestorName = generalName;
        this.requestList = aSN1Sequence;
        this.requestExtensions = extensions;
    }

    private TBSRequest(ASN1Sequence aSN1Sequence) {
        int n3 = 0;
        if (aSN1Sequence.getObjectAt(0) instanceof ASN1TaggedObject && ((ASN1TaggedObject)aSN1Sequence.getObjectAt(0)).getTagNo() == 0) {
            this.versionSet = true;
            this.version = ASN1Integer.getInstance((ASN1TaggedObject)aSN1Sequence.getObjectAt(0), true);
            n3 = 1;
        } else {
            this.version = V1;
        }
        if (aSN1Sequence.getObjectAt(n3) instanceof ASN1TaggedObject) {
            this.requestorName = GeneralName.getInstance((ASN1TaggedObject)aSN1Sequence.getObjectAt(n3++), true);
        }
        this.requestList = (ASN1Sequence)aSN1Sequence.getObjectAt(n3++);
        if (aSN1Sequence.size() == n3 + 1) {
            this.requestExtensions = Extensions.getInstance((ASN1TaggedObject)aSN1Sequence.getObjectAt(n3), true);
        }
    }

    public static TBSRequest getInstance(ASN1TaggedObject aSN1TaggedObject, boolean bl) {
        return TBSRequest.getInstance(ASN1Sequence.getInstance(aSN1TaggedObject, bl));
    }

    public static TBSRequest getInstance(Object object) {
        if (object instanceof TBSRequest) {
            return (TBSRequest)object;
        }
        if (object != null) {
            return new TBSRequest(ASN1Sequence.getInstance(object));
        }
        return null;
    }

    public ASN1Integer getVersion() {
        return this.version;
    }

    public GeneralName getRequestorName() {
        return this.requestorName;
    }

    public ASN1Sequence getRequestList() {
        return this.requestList;
    }

    public Extensions getRequestExtensions() {
        return this.requestExtensions;
    }

    @Override
    public ASN1Primitive toASN1Primitive() {
        ASN1Primitive aSN1Primitive;
        ASN1Object aSN1Object;
        ASN1EncodableVector aSN1EncodableVector;
        ASN1EncodableVector aSN1EncodableVector2 = aSN1EncodableVector;
        aSN1EncodableVector = new ASN1EncodableVector(4);
        if (!aSN1Object2.version.equals(V1) || aSN1Object2.versionSet) {
            DERTaggedObject dERTaggedObject;
            aSN1Object = dERTaggedObject;
            aSN1Primitive = aSN1Object2.version;
            dERTaggedObject = new DERTaggedObject(true, 0, aSN1Primitive);
            aSN1EncodableVector2.add(aSN1Object);
        }
        if ((aSN1Object = aSN1Object2.requestorName) != null) {
            DERTaggedObject dERTaggedObject;
            aSN1Primitive = dERTaggedObject;
            dERTaggedObject = new DERTaggedObject(true, 1, aSN1Object);
            aSN1EncodableVector2.add(aSN1Primitive);
        }
        aSN1EncodableVector2.add(aSN1Object2.requestList);
        ASN1Object aSN1Object2 = aSN1Object2.requestExtensions;
        if (aSN1Object2 != null) {
            DERTaggedObject dERTaggedObject;
            aSN1Object = dERTaggedObject;
            dERTaggedObject = new DERTaggedObject(true, 2, aSN1Object2);
            aSN1EncodableVector2.add(aSN1Object);
        }
        return new DERSequence(aSN1EncodableVector2);
    }
}

