/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.asn1.pkcs;

import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Object;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Primitive;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Sequence;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.BERSequence;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.DLSequence;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.pkcs.ContentInfo;

public class AuthenticatedSafe
extends ASN1Object {
    private ContentInfo[] info;
    private boolean isBer = true;

    private AuthenticatedSafe(ASN1Sequence aSN1Sequence) {
        this.info = new ContentInfo[aSN1Sequence.size()];
        int n3 = 0;
        while (true) {
            ContentInfo[] contentInfoArray = this.info;
            if (n3 == this.info.length) break;
            contentInfoArray[n3] = ContentInfo.getInstance(aSN1Sequence.getObjectAt(n3));
            ++n3;
        }
        this.isBer = aSN1Sequence instanceof BERSequence;
    }

    public static AuthenticatedSafe getInstance(Object object) {
        if (object instanceof AuthenticatedSafe) {
            return (AuthenticatedSafe)object;
        }
        if (object != null) {
            return new AuthenticatedSafe(ASN1Sequence.getInstance(object));
        }
        return null;
    }

    public AuthenticatedSafe(ContentInfo[] contentInfoArray) {
        this.info = this.copy(contentInfoArray);
    }

    private ContentInfo[] copy(ContentInfo[] contentInfoArray) {
        int n3 = contentInfoArray.length;
        ContentInfo[] contentInfoArray2 = new ContentInfo[n3];
        System.arraycopy(contentInfoArray, 0, contentInfoArray2, 0, n3);
        return contentInfoArray2;
    }

    public ContentInfo[] getContentInfo() {
        AuthenticatedSafe authenticatedSafe = this;
        return authenticatedSafe.copy(authenticatedSafe.info);
    }

    @Override
    public ASN1Primitive toASN1Primitive() {
        if (this.isBer) {
            return new BERSequence(this.info);
        }
        return new DLSequence(this.info);
    }
}

