/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.asn1.pkcs;

import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1EncodableVector;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Integer;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Object;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1OctetString;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Primitive;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Sequence;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.DERNull;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.DEROctetString;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.DERSequence;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.x509.AlgorithmIdentifier;
import com.fis.ekyc.nfc.build_in.bouncycastle.util.Arrays;
import java.math.BigInteger;

public class PBKDF2Params
extends ASN1Object {
    private static final AlgorithmIdentifier algid_hmacWithSHA1 = new AlgorithmIdentifier(PKCSObjectIdentifiers.id_hmacWithSHA1, DERNull.INSTANCE);
    private final ASN1OctetString octStr;
    private final ASN1Integer iterationCount;
    private final ASN1Integer keyLength;
    private final AlgorithmIdentifier prf;

    public static PBKDF2Params getInstance(Object object) {
        if (object instanceof PBKDF2Params) {
            return (PBKDF2Params)object;
        }
        if (object != null) {
            return new PBKDF2Params(ASN1Sequence.getInstance(object));
        }
        return null;
    }

    public PBKDF2Params(byte[] byArray, int n3) {
        this(byArray, n3, 0);
    }

    public PBKDF2Params(byte[] byArray, int n3, int n4) {
        this(byArray, n3, n4, null);
    }

    public PBKDF2Params(byte[] byArray, int n3, int n4, AlgorithmIdentifier algorithmIdentifier) {
        this.octStr = new DEROctetString(Arrays.clone(byArray));
        this.iterationCount = new ASN1Integer(n3);
        this.keyLength = n4 > 0 ? new ASN1Integer(n4) : null;
        this.prf = algorithmIdentifier;
    }

    public PBKDF2Params(byte[] byArray, int n3, AlgorithmIdentifier algorithmIdentifier) {
        this(byArray, n3, 0, algorithmIdentifier);
    }

    private PBKDF2Params(ASN1Sequence object) {
        PBKDF2Params pBKDF2Params = this;
        object = ((ASN1Sequence)object).getObjects();
        pBKDF2Params.octStr = (ASN1OctetString)object.nextElement();
        pBKDF2Params.iterationCount = (ASN1Integer)object.nextElement();
        if (object.hasMoreElements()) {
            Object object2 = object.nextElement();
            if (object2 instanceof ASN1Integer) {
                this.keyLength = ASN1Integer.getInstance(object2);
                object2 = object.hasMoreElements() ? object.nextElement() : null;
            } else {
                this.keyLength = null;
            }
            this.prf = object2 != null ? AlgorithmIdentifier.getInstance(object2) : null;
        } else {
            PBKDF2Params pBKDF2Params2 = this;
            pBKDF2Params2.keyLength = null;
            pBKDF2Params2.prf = null;
        }
    }

    public byte[] getSalt() {
        return this.octStr.getOctets();
    }

    public BigInteger getIterationCount() {
        return this.iterationCount.getValue();
    }

    public BigInteger getKeyLength() {
        ASN1Object aSN1Object = ((PBKDF2Params)aSN1Object).keyLength;
        if (aSN1Object != null) {
            return ((ASN1Integer)aSN1Object).getValue();
        }
        return null;
    }

    public boolean isDefaultPrf() {
        ASN1Object aSN1Object = ((PBKDF2Params)aSN1Object).prf;
        return aSN1Object == null || aSN1Object.equals(algid_hmacWithSHA1);
    }

    public AlgorithmIdentifier getPrf() {
        ASN1Object aSN1Object = aSN1Object.prf;
        if (aSN1Object != null) {
            return aSN1Object;
        }
        return algid_hmacWithSHA1;
    }

    @Override
    public ASN1Primitive toASN1Primitive() {
        ASN1EncodableVector aSN1EncodableVector;
        ASN1EncodableVector aSN1EncodableVector2 = aSN1EncodableVector;
        aSN1EncodableVector2(4);
        aSN1EncodableVector2.add(this.octStr);
        aSN1EncodableVector.add(this.iterationCount);
        ASN1Object aSN1Object = this.keyLength;
        if (aSN1Object != null) {
            aSN1EncodableVector2.add(aSN1Object);
        }
        if ((aSN1Object = this.prf) != null && !aSN1Object.equals(algid_hmacWithSHA1)) {
            aSN1EncodableVector2.add(this.prf);
        }
        return new DERSequence(aSN1EncodableVector2);
    }
}

