/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.asn1.pkcs;

import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1BitString;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Encodable;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1EncodableVector;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Integer;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Object;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1OctetString;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Primitive;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Sequence;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Set;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1TaggedObject;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.DERBitString;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.DEROctetString;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.DERSequence;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.DERTaggedObject;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.x509.AlgorithmIdentifier;
import com.fis.ekyc.nfc.build_in.bouncycastle.util.BigIntegers;
import java.math.BigInteger;

public class PrivateKeyInfo
extends ASN1Object {
    private ASN1Integer version;
    private AlgorithmIdentifier privateKeyAlgorithm;
    private ASN1OctetString privateKey;
    private ASN1Set attributes;
    private ASN1BitString publicKey;

    public static PrivateKeyInfo getInstance(ASN1TaggedObject aSN1TaggedObject, boolean bl) {
        return PrivateKeyInfo.getInstance(ASN1Sequence.getInstance(aSN1TaggedObject, bl));
    }

    public static PrivateKeyInfo getInstance(Object object) {
        if (object instanceof PrivateKeyInfo) {
            return (PrivateKeyInfo)object;
        }
        if (object != null) {
            return new PrivateKeyInfo(ASN1Sequence.getInstance(object));
        }
        return null;
    }

    private static int getVersionValue(ASN1Integer aSN1Integer) {
        int n3 = aSN1Integer.intValueExact();
        if (n3 >= 0 && n3 <= 1) {
            return n3;
        }
        throw new IllegalArgumentException("invalid version for private key info");
    }

    public PrivateKeyInfo(AlgorithmIdentifier algorithmIdentifier, ASN1Encodable aSN1Encodable) {
        this(algorithmIdentifier, aSN1Encodable, null, null);
    }

    public PrivateKeyInfo(AlgorithmIdentifier algorithmIdentifier, ASN1Encodable aSN1Encodable, ASN1Set aSN1Set) {
        this(algorithmIdentifier, aSN1Encodable, aSN1Set, null);
    }

    public PrivateKeyInfo(AlgorithmIdentifier aSN1Object, ASN1Encodable aSN1Encodable, ASN1Set aSN1Set, byte[] byArray) {
        DEROctetString dEROctetString;
        ASN1Integer aSN1Integer;
        BigInteger bigInteger = byArray != null ? BigIntegers.ONE : BigIntegers.ZERO;
        PrivateKeyInfo privateKeyInfo = this;
        privateKeyInfo.version = aSN1Integer = new ASN1Integer(bigInteger);
        privateKeyInfo.privateKeyAlgorithm = aSN1Object;
        aSN1Object = dEROctetString;
        dEROctetString = new DEROctetString(aSN1Encodable);
        privateKeyInfo.privateKey = aSN1Object;
        privateKeyInfo.attributes = aSN1Set;
        if (byArray == null) {
            aSN1Object = null;
        } else {
            DERBitString dERBitString;
            aSN1Object = dERBitString;
            dERBitString = new DERBitString(byArray);
        }
        this.publicKey = aSN1Object;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private PrivateKeyInfo(ASN1Sequence object) {
        PrivateKeyInfo privateKeyInfo = this;
        object = ((ASN1Sequence)object).getObjects();
        this.version = ASN1Integer.getInstance(object.nextElement());
        int n3 = PrivateKeyInfo.getVersionValue(this.version);
        privateKeyInfo.privateKeyAlgorithm = AlgorithmIdentifier.getInstance(object.nextElement());
        privateKeyInfo.privateKey = ASN1OctetString.getInstance(object.nextElement());
        int n4 = -1;
        while (object.hasMoreElements()) {
            ASN1TaggedObject aSN1TaggedObject = (ASN1TaggedObject)object.nextElement();
            int n5 = aSN1TaggedObject.getTagNo();
            if (n5 <= n4) throw new IllegalArgumentException("invalid optional field in private key info");
            if (n5 != 0) {
                if (n5 != 1) throw new IllegalArgumentException("unknown optional field in private key info");
                if (n3 < 1) throw new IllegalArgumentException("'publicKey' requires version v2(1) or later");
                this.publicKey = DERBitString.getInstance(aSN1TaggedObject, false);
            } else {
                this.attributes = ASN1Set.getInstance(aSN1TaggedObject, false);
            }
            n4 = n5;
        }
    }

    public ASN1Integer getVersion() {
        return this.version;
    }

    public ASN1Set getAttributes() {
        return this.attributes;
    }

    public AlgorithmIdentifier getPrivateKeyAlgorithm() {
        return this.privateKeyAlgorithm;
    }

    public ASN1OctetString getPrivateKey() {
        return new DEROctetString(this.privateKey.getOctets());
    }

    public ASN1Encodable parsePrivateKey() {
        return ASN1Primitive.fromByteArray(this.privateKey.getOctets());
    }

    public boolean hasPublicKey() {
        return this.publicKey != null;
    }

    public ASN1Encodable parsePublicKey() {
        ASN1Object aSN1Object = ((PrivateKeyInfo)aSN1Object).publicKey;
        return aSN1Object == null ? null : ASN1Primitive.fromByteArray(((ASN1BitString)aSN1Object).getOctets());
    }

    public ASN1BitString getPublicKeyData() {
        return this.publicKey;
    }

    @Override
    public ASN1Primitive toASN1Primitive() {
        ASN1BitString aSN1BitString;
        ASN1EncodableVector aSN1EncodableVector;
        ASN1EncodableVector aSN1EncodableVector2 = aSN1EncodableVector;
        aSN1EncodableVector2(5);
        aSN1EncodableVector2.add(this.version);
        aSN1EncodableVector2.add(this.privateKeyAlgorithm);
        aSN1EncodableVector.add(this.privateKey);
        ASN1Primitive aSN1Primitive = this.attributes;
        if (aSN1Primitive != null) {
            DERTaggedObject dERTaggedObject;
            DERTaggedObject dERTaggedObject2 = dERTaggedObject;
            dERTaggedObject = new DERTaggedObject(false, 0, aSN1Primitive);
            aSN1EncodableVector2.add(dERTaggedObject2);
        }
        if ((aSN1BitString = this.publicKey) != null) {
            DERTaggedObject dERTaggedObject;
            aSN1Primitive = dERTaggedObject;
            dERTaggedObject = new DERTaggedObject(false, 1, aSN1BitString);
            aSN1EncodableVector2.add(aSN1Primitive);
        }
        return new DERSequence(aSN1EncodableVector2);
    }
}

