/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.asn1.pkcs;

import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1EncodableVector;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Object;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Primitive;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Sequence;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1TaggedObject;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.DERNull;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.DEROctetString;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.DERSequence;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.DERTaggedObject;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.oiw.OIWObjectIdentifiers;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.x509.AlgorithmIdentifier;

public class RSAESOAEPparams
extends ASN1Object {
    public static final AlgorithmIdentifier DEFAULT_HASH_ALGORITHM;
    public static final AlgorithmIdentifier DEFAULT_MASK_GEN_FUNCTION;
    public static final AlgorithmIdentifier DEFAULT_P_SOURCE_ALGORITHM;
    private AlgorithmIdentifier hashAlgorithm;
    private AlgorithmIdentifier maskGenAlgorithm;
    private AlgorithmIdentifier pSourceAlgorithm;

    public static RSAESOAEPparams getInstance(Object object) {
        if (object instanceof RSAESOAEPparams) {
            return (RSAESOAEPparams)object;
        }
        if (object != null) {
            return new RSAESOAEPparams(ASN1Sequence.getInstance(object));
        }
        return null;
    }

    public RSAESOAEPparams() {
        this.hashAlgorithm = DEFAULT_HASH_ALGORITHM;
        this.maskGenAlgorithm = DEFAULT_MASK_GEN_FUNCTION;
        this.pSourceAlgorithm = DEFAULT_P_SOURCE_ALGORITHM;
    }

    public RSAESOAEPparams(AlgorithmIdentifier algorithmIdentifier, AlgorithmIdentifier algorithmIdentifier2, AlgorithmIdentifier algorithmIdentifier3) {
        this.hashAlgorithm = algorithmIdentifier;
        this.maskGenAlgorithm = algorithmIdentifier2;
        this.pSourceAlgorithm = algorithmIdentifier3;
    }

    public RSAESOAEPparams(ASN1Sequence aSN1Sequence) {
        this.hashAlgorithm = DEFAULT_HASH_ALGORITHM;
        this.maskGenAlgorithm = DEFAULT_MASK_GEN_FUNCTION;
        this.pSourceAlgorithm = DEFAULT_P_SOURCE_ALGORITHM;
        for (int i3 = 0; i3 != aSN1Sequence.size(); ++i3) {
            ASN1TaggedObject aSN1TaggedObject = (ASN1TaggedObject)aSN1Sequence.getObjectAt(i3);
            int n3 = aSN1TaggedObject.getTagNo();
            if (n3 != 0) {
                if (n3 != 1) {
                    if (n3 == 2) {
                        this.pSourceAlgorithm = AlgorithmIdentifier.getInstance(aSN1TaggedObject, true);
                        continue;
                    }
                    throw new IllegalArgumentException("unknown tag");
                }
                this.maskGenAlgorithm = AlgorithmIdentifier.getInstance(aSN1TaggedObject, true);
                continue;
            }
            this.hashAlgorithm = AlgorithmIdentifier.getInstance(aSN1TaggedObject, true);
        }
    }

    static {
        AlgorithmIdentifier algorithmIdentifier;
        AlgorithmIdentifier algorithmIdentifier2 = algorithmIdentifier;
        DEFAULT_HASH_ALGORITHM = new AlgorithmIdentifier(OIWObjectIdentifiers.idSHA1, DERNull.INSTANCE);
        DEFAULT_MASK_GEN_FUNCTION = new AlgorithmIdentifier(PKCSObjectIdentifiers.id_mgf1, algorithmIdentifier2);
        DEFAULT_P_SOURCE_ALGORITHM = new AlgorithmIdentifier(PKCSObjectIdentifiers.id_pSpecified, new DEROctetString(new byte[0]));
    }

    public AlgorithmIdentifier getHashAlgorithm() {
        return this.hashAlgorithm;
    }

    public AlgorithmIdentifier getMaskGenAlgorithm() {
        return this.maskGenAlgorithm;
    }

    public AlgorithmIdentifier getPSourceAlgorithm() {
        return this.pSourceAlgorithm;
    }

    @Override
    public ASN1Primitive toASN1Primitive() {
        AlgorithmIdentifier algorithmIdentifier;
        DERTaggedObject dERTaggedObject;
        ASN1EncodableVector aSN1EncodableVector;
        ASN1EncodableVector aSN1EncodableVector2 = aSN1EncodableVector;
        aSN1EncodableVector = new ASN1EncodableVector(3);
        if (!aSN1Object.hashAlgorithm.equals(DEFAULT_HASH_ALGORITHM)) {
            DERTaggedObject dERTaggedObject2;
            dERTaggedObject = dERTaggedObject2;
            algorithmIdentifier = aSN1Object.hashAlgorithm;
            dERTaggedObject2 = new DERTaggedObject(true, 0, algorithmIdentifier);
            aSN1EncodableVector2.add(dERTaggedObject);
        }
        if (!aSN1Object.maskGenAlgorithm.equals(DEFAULT_MASK_GEN_FUNCTION)) {
            DERTaggedObject dERTaggedObject3;
            dERTaggedObject = dERTaggedObject3;
            algorithmIdentifier = aSN1Object.maskGenAlgorithm;
            dERTaggedObject3 = new DERTaggedObject(true, 1, algorithmIdentifier);
            aSN1EncodableVector2.add(dERTaggedObject);
        }
        if (!aSN1Object.pSourceAlgorithm.equals(DEFAULT_P_SOURCE_ALGORITHM)) {
            DERTaggedObject dERTaggedObject4;
            dERTaggedObject = dERTaggedObject4;
            ASN1Object aSN1Object = aSN1Object.pSourceAlgorithm;
            dERTaggedObject4 = new DERTaggedObject(true, 2, aSN1Object);
            aSN1EncodableVector2.add(dERTaggedObject);
        }
        return new DERSequence(aSN1EncodableVector2);
    }
}

