/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.asn1.pkcs;

import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1EncodableVector;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Integer;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Object;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Primitive;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Sequence;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1TaggedObject;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.DERNull;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.DERSequence;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.DERTaggedObject;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.oiw.OIWObjectIdentifiers;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.x509.AlgorithmIdentifier;
import java.math.BigInteger;

public class RSASSAPSSparams
extends ASN1Object {
    public static final AlgorithmIdentifier DEFAULT_HASH_ALGORITHM;
    public static final AlgorithmIdentifier DEFAULT_MASK_GEN_FUNCTION;
    public static final ASN1Integer DEFAULT_SALT_LENGTH;
    public static final ASN1Integer DEFAULT_TRAILER_FIELD;
    private AlgorithmIdentifier hashAlgorithm;
    private AlgorithmIdentifier maskGenAlgorithm;
    private ASN1Integer saltLength;
    private ASN1Integer trailerField;

    public static RSASSAPSSparams getInstance(Object object) {
        if (object instanceof RSASSAPSSparams) {
            return (RSASSAPSSparams)object;
        }
        if (object != null) {
            return new RSASSAPSSparams(ASN1Sequence.getInstance(object));
        }
        return null;
    }

    public RSASSAPSSparams() {
        this.hashAlgorithm = DEFAULT_HASH_ALGORITHM;
        this.maskGenAlgorithm = DEFAULT_MASK_GEN_FUNCTION;
        this.saltLength = DEFAULT_SALT_LENGTH;
        this.trailerField = DEFAULT_TRAILER_FIELD;
    }

    public RSASSAPSSparams(AlgorithmIdentifier algorithmIdentifier, AlgorithmIdentifier algorithmIdentifier2, ASN1Integer aSN1Integer, ASN1Integer aSN1Integer2) {
        this.hashAlgorithm = algorithmIdentifier;
        this.maskGenAlgorithm = algorithmIdentifier2;
        this.saltLength = aSN1Integer;
        this.trailerField = aSN1Integer2;
    }

    private RSASSAPSSparams(ASN1Sequence aSN1Sequence) {
        this.hashAlgorithm = DEFAULT_HASH_ALGORITHM;
        this.maskGenAlgorithm = DEFAULT_MASK_GEN_FUNCTION;
        this.saltLength = DEFAULT_SALT_LENGTH;
        this.trailerField = DEFAULT_TRAILER_FIELD;
        block6: for (int i3 = 0; i3 != aSN1Sequence.size(); ++i3) {
            ASN1TaggedObject aSN1TaggedObject = (ASN1TaggedObject)aSN1Sequence.getObjectAt(i3);
            switch (aSN1TaggedObject.getTagNo()) {
                default: {
                    throw new IllegalArgumentException("unknown tag");
                }
                case 3: {
                    this.trailerField = ASN1Integer.getInstance(aSN1TaggedObject, true);
                    continue block6;
                }
                case 2: {
                    this.saltLength = ASN1Integer.getInstance(aSN1TaggedObject, true);
                    continue block6;
                }
                case 1: {
                    this.maskGenAlgorithm = AlgorithmIdentifier.getInstance(aSN1TaggedObject, true);
                    continue block6;
                }
                case 0: {
                    this.hashAlgorithm = AlgorithmIdentifier.getInstance(aSN1TaggedObject, true);
                }
            }
        }
    }

    static {
        AlgorithmIdentifier algorithmIdentifier;
        AlgorithmIdentifier algorithmIdentifier2 = algorithmIdentifier;
        DEFAULT_HASH_ALGORITHM = new AlgorithmIdentifier(OIWObjectIdentifiers.idSHA1, DERNull.INSTANCE);
        DEFAULT_MASK_GEN_FUNCTION = new AlgorithmIdentifier(PKCSObjectIdentifiers.id_mgf1, algorithmIdentifier2);
        DEFAULT_SALT_LENGTH = new ASN1Integer(20L);
        DEFAULT_TRAILER_FIELD = new ASN1Integer(1L);
    }

    public AlgorithmIdentifier getHashAlgorithm() {
        return this.hashAlgorithm;
    }

    public AlgorithmIdentifier getMaskGenAlgorithm() {
        return this.maskGenAlgorithm;
    }

    public BigInteger getSaltLength() {
        return this.saltLength.getValue();
    }

    public BigInteger getTrailerField() {
        return this.trailerField.getValue();
    }

    @Override
    public ASN1Primitive toASN1Primitive() {
        ASN1Object aSN1Object;
        DERTaggedObject dERTaggedObject;
        ASN1EncodableVector aSN1EncodableVector;
        ASN1EncodableVector aSN1EncodableVector2 = aSN1EncodableVector;
        aSN1EncodableVector = new ASN1EncodableVector(4);
        if (!aSN1Object2.hashAlgorithm.equals(DEFAULT_HASH_ALGORITHM)) {
            DERTaggedObject dERTaggedObject2;
            dERTaggedObject = dERTaggedObject2;
            aSN1Object = aSN1Object2.hashAlgorithm;
            dERTaggedObject2 = new DERTaggedObject(true, 0, aSN1Object);
            aSN1EncodableVector2.add(dERTaggedObject);
        }
        if (!aSN1Object2.maskGenAlgorithm.equals(DEFAULT_MASK_GEN_FUNCTION)) {
            DERTaggedObject dERTaggedObject3;
            dERTaggedObject = dERTaggedObject3;
            aSN1Object = aSN1Object2.maskGenAlgorithm;
            dERTaggedObject3 = new DERTaggedObject(true, 1, aSN1Object);
            aSN1EncodableVector2.add(dERTaggedObject);
        }
        if (!aSN1Object2.saltLength.equals(DEFAULT_SALT_LENGTH)) {
            DERTaggedObject dERTaggedObject4;
            dERTaggedObject = dERTaggedObject4;
            aSN1Object = aSN1Object2.saltLength;
            dERTaggedObject4 = new DERTaggedObject(true, 2, aSN1Object);
            aSN1EncodableVector2.add(dERTaggedObject);
        }
        if (!aSN1Object2.trailerField.equals(DEFAULT_TRAILER_FIELD)) {
            DERTaggedObject dERTaggedObject5;
            dERTaggedObject = dERTaggedObject5;
            ASN1Object aSN1Object2 = aSN1Object2.trailerField;
            dERTaggedObject5 = new DERTaggedObject(true, 3, aSN1Object2);
            aSN1EncodableVector2.add(dERTaggedObject);
        }
        return new DERSequence(aSN1EncodableVector2);
    }
}

