/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.asn1.tsp;

import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1EncodableVector;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Integer;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Object;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Primitive;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Sequence;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1TaggedObject;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.DERSequence;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.DERTaggedObject;

public class Accuracy
extends ASN1Object {
    public static final int MIN_MILLIS = 1;
    public static final int MAX_MILLIS = 999;
    public static final int MIN_MICROS = 1;
    public static final int MAX_MICROS = 999;
    public ASN1Integer seconds;
    public ASN1Integer millis;
    public ASN1Integer micros;

    public Accuracy() {
    }

    public Accuracy(ASN1Integer aSN1Integer, ASN1Integer aSN1Integer2, ASN1Integer aSN1Integer3) {
        int n3;
        if (aSN1Integer2 != null && ((n3 = aSN1Integer2.intValueExact()) < 1 || n3 > 999)) {
            throw new IllegalArgumentException("Invalid millis field : not in (1..999)");
        }
        if (aSN1Integer3 != null && ((n3 = aSN1Integer3.intValueExact()) < 1 || n3 > 999)) {
            throw new IllegalArgumentException("Invalid micros field : not in (1..999)");
        }
        Accuracy accuracy = this;
        accuracy.seconds = aSN1Integer;
        accuracy.millis = aSN1Integer2;
        accuracy.micros = aSN1Integer3;
    }

    private Accuracy(ASN1Sequence aSN1Sequence) {
        this.seconds = null;
        this.millis = null;
        this.micros = null;
        for (int i3 = 0; i3 < aSN1Sequence.size(); ++i3) {
            int n3;
            if (aSN1Sequence.getObjectAt(i3) instanceof ASN1Integer) {
                this.seconds = (ASN1Integer)aSN1Sequence.getObjectAt(i3);
                continue;
            }
            if (!(aSN1Sequence.getObjectAt(i3) instanceof ASN1TaggedObject)) continue;
            ASN1TaggedObject aSN1TaggedObject = (ASN1TaggedObject)aSN1Sequence.getObjectAt(i3);
            int n4 = aSN1TaggedObject.getTagNo();
            if (n4 != 0) {
                if (n4 == 1) {
                    this.micros = ASN1Integer.getInstance(aSN1TaggedObject, false);
                    n3 = this.micros.intValueExact();
                    if (n3 >= 1 && n3 <= 999) continue;
                    throw new IllegalArgumentException("Invalid micros field : not in (1..999)");
                }
                throw new IllegalArgumentException("Invalid tag number");
            }
            this.millis = ASN1Integer.getInstance(aSN1TaggedObject, false);
            n3 = this.millis.intValueExact();
            if (n3 >= 1 && n3 <= 999) continue;
            throw new IllegalArgumentException("Invalid millis field : not in (1..999)");
        }
    }

    public static Accuracy getInstance(Object object) {
        if (object instanceof Accuracy) {
            return (Accuracy)object;
        }
        if (object != null) {
            return new Accuracy(ASN1Sequence.getInstance(object));
        }
        return null;
    }

    public ASN1Integer getSeconds() {
        return this.seconds;
    }

    public ASN1Integer getMillis() {
        return this.millis;
    }

    public ASN1Integer getMicros() {
        return this.micros;
    }

    @Override
    public ASN1Primitive toASN1Primitive() {
        ASN1Integer aSN1Integer;
        ASN1EncodableVector aSN1EncodableVector;
        ASN1EncodableVector aSN1EncodableVector2 = aSN1EncodableVector;
        aSN1EncodableVector = new ASN1EncodableVector(3);
        ASN1Primitive aSN1Primitive = this.seconds;
        if (aSN1Primitive != null) {
            aSN1EncodableVector2.add(aSN1Primitive);
        }
        if ((aSN1Primitive = this.millis) != null) {
            DERTaggedObject dERTaggedObject;
            DERTaggedObject dERTaggedObject2 = dERTaggedObject;
            dERTaggedObject = new DERTaggedObject(false, 0, aSN1Primitive);
            aSN1EncodableVector2.add(dERTaggedObject2);
        }
        if ((aSN1Integer = this.micros) != null) {
            DERTaggedObject dERTaggedObject;
            aSN1Primitive = dERTaggedObject;
            dERTaggedObject = new DERTaggedObject(false, 1, aSN1Integer);
            aSN1EncodableVector2.add(aSN1Primitive);
        }
        return new DERSequence(aSN1EncodableVector2);
    }
}

