/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.asn1.x500;

import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Encodable;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1ObjectIdentifier;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.x500.AttributeTypeAndValue;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.x500.RDN;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.x500.X500Name;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.x500.X500NameStyle;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.x500.style.BCStyle;
import java.util.Vector;

public class X500NameBuilder {
    private X500NameStyle template;
    private Vector rdns;

    public X500NameBuilder() {
        this(BCStyle.INSTANCE);
    }

    public X500NameBuilder(X500NameStyle x500NameStyle) {
        Vector vector;
        Vector vector2 = vector;
        vector = new Vector();
        v1.rdns = vector2;
        v1.template = x500NameStyle;
    }

    public X500NameBuilder addRDN(ASN1ObjectIdentifier aSN1ObjectIdentifier, String string2) {
        X500NameBuilder x500NameBuilder = this;
        x500NameBuilder.addRDN(aSN1ObjectIdentifier, this.template.stringToValue(aSN1ObjectIdentifier, string2));
        return x500NameBuilder;
    }

    public X500NameBuilder addRDN(ASN1ObjectIdentifier aSN1ObjectIdentifier, ASN1Encodable aSN1Encodable) {
        X500NameBuilder x500NameBuilder = this;
        x500NameBuilder.rdns.addElement(new RDN(aSN1ObjectIdentifier, aSN1Encodable));
        return x500NameBuilder;
    }

    public X500NameBuilder addRDN(AttributeTypeAndValue attributeTypeAndValue) {
        X500NameBuilder x500NameBuilder = this;
        x500NameBuilder.rdns.addElement(new RDN(attributeTypeAndValue));
        return x500NameBuilder;
    }

    public X500NameBuilder addMultiValuedRDN(ASN1ObjectIdentifier[] aSN1ObjectIdentifierArray, String[] stringArray) {
        int n3 = stringArray.length;
        ASN1Encodable[] aSN1EncodableArray = new ASN1Encodable[n3];
        for (int i3 = 0; i3 != n3; ++i3) {
            ASN1ObjectIdentifier aSN1ObjectIdentifier = aSN1ObjectIdentifierArray[i3];
            aSN1EncodableArray[i3] = this.template.stringToValue(aSN1ObjectIdentifier, stringArray[i3]);
        }
        return this.addMultiValuedRDN(aSN1ObjectIdentifierArray, aSN1EncodableArray);
    }

    public X500NameBuilder addMultiValuedRDN(ASN1ObjectIdentifier[] aSN1ObjectIdentifierArray, ASN1Encodable[] aSN1EncodableArray) {
        AttributeTypeAndValue[] attributeTypeAndValueArray = new AttributeTypeAndValue[aSN1ObjectIdentifierArray.length];
        for (int i3 = 0; i3 != aSN1ObjectIdentifierArray.length; ++i3) {
            AttributeTypeAndValue attributeTypeAndValue;
            AttributeTypeAndValue attributeTypeAndValue2 = attributeTypeAndValue;
            ASN1ObjectIdentifier aSN1ObjectIdentifier = aSN1ObjectIdentifierArray[i3];
            attributeTypeAndValue = new AttributeTypeAndValue(aSN1ObjectIdentifier, aSN1EncodableArray[i3]);
            attributeTypeAndValueArray[i3] = attributeTypeAndValue2;
        }
        return this.addMultiValuedRDN(attributeTypeAndValueArray);
    }

    public X500NameBuilder addMultiValuedRDN(AttributeTypeAndValue[] attributeTypeAndValueArray) {
        X500NameBuilder x500NameBuilder = this;
        x500NameBuilder.rdns.addElement(new RDN(attributeTypeAndValueArray));
        return x500NameBuilder;
    }

    public X500Name build() {
        int n3 = this.rdns.size();
        RDN[] rDNArray = new RDN[n3];
        for (int i3 = 0; i3 != n3; ++i3) {
            rDNArray[i3] = (RDN)this.rdns.elementAt(i3);
        }
        return new X500Name(this.template, rDNArray);
    }
}

