/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.asn1.x500.style;

import b.b;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Encodable;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1ObjectIdentifier;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1ParsingException;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.DERUTF8String;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.x500.AttributeTypeAndValue;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.x500.RDN;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.x500.X500Name;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.x500.X500NameStyle;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.x500.style.IETFUtils;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;

public abstract class AbstractX500NameStyle
implements X500NameStyle {
    public static Hashtable copyHashTable(Hashtable hashtable) {
        Hashtable hashtable2;
        Hashtable hashtable3 = hashtable2;
        hashtable2 = new Hashtable();
        Enumeration enumeration = hashtable.keys();
        while (enumeration.hasMoreElements()) {
            Object k3 = enumeration.nextElement();
            hashtable3.put(k3, hashtable.get(k3));
        }
        return hashtable3;
    }

    private int calcHashCode(ASN1Encodable aSN1Encodable) {
        return IETFUtils.canonicalString(aSN1Encodable).hashCode();
    }

    private boolean foundMatch(boolean n3, RDN rDN, RDN[] rDNArray) {
        if (n3 != 0) {
            for (n3 = rDNArray.length - 1; n3 >= 0; --n3) {
                RDN rDN2 = rDNArray[n3];
                if (rDN2 == null || !this.rdnAreEqual(rDN, rDN2)) continue;
                rDNArray[n3] = null;
                return true;
            }
        } else {
            for (n3 = 0; n3 != rDNArray.length; ++n3) {
                RDN rDN3 = rDNArray[n3];
                if (rDN3 == null || !this.rdnAreEqual(rDN, rDN3)) continue;
                rDNArray[n3] = null;
                return true;
            }
        }
        return false;
    }

    @Override
    public int calculateHashCode(X500Name x500Name) {
        int n3 = 0;
        RDN[] rDNArray = x500Name.getRDNs();
        for (int i3 = 0; i3 != rDNArray.length; ++i3) {
            if (rDNArray[i3].isMultiValued()) {
                AttributeTypeAndValue[] attributeTypeAndValueArray = rDNArray[i3].getTypesAndValues();
                for (int i4 = 0; i4 != attributeTypeAndValueArray.length; ++i4) {
                    n3 = n3 ^ attributeTypeAndValueArray[i4].getType().hashCode() ^ this.calcHashCode(attributeTypeAndValueArray[i4].getValue());
                }
                continue;
            }
            n3 = n3 ^ rDNArray[i3].getFirst().getType().hashCode() ^ this.calcHashCode(rDNArray[i3].getFirst().getValue());
        }
        return n3;
    }

    @Override
    public ASN1Encodable stringToValue(ASN1ObjectIdentifier aSN1ObjectIdentifier, String string2) {
        if (string2.length() != 0 && string2.charAt(0) == '#') {
            try {
                return IETFUtils.valueFromHexString(string2, 1);
            }
            catch (IOException iOException) {
                throw new ASN1ParsingException(b.a("can't recode value for oid ").append(aSN1ObjectIdentifier.getId()).toString());
            }
        }
        if (string2.length() != 0 && string2.charAt(0) == '\\') {
            string2 = string2.substring(1);
        }
        return this.encodeStringValue(aSN1ObjectIdentifier, string2);
    }

    public ASN1Encodable encodeStringValue(ASN1ObjectIdentifier aSN1ObjectIdentifier, String string2) {
        return new DERUTF8String(string2);
    }

    @Override
    public boolean areEqual(X500Name rDNArray, X500Name rDNArray2) {
        if ((rDNArray = rDNArray.getRDNs()).length != (rDNArray2 = rDNArray2.getRDNs()).length) {
            return false;
        }
        boolean bl = false;
        if (rDNArray[0].getFirst() != null && rDNArray2[0].getFirst() != null) {
            bl = rDNArray[0].getFirst().getType().equals(rDNArray2[0].getFirst().getType()) ^ true;
        }
        for (int i3 = 0; i3 != rDNArray.length; ++i3) {
            if (this.foundMatch(bl, rDNArray[i3], rDNArray2)) continue;
            return false;
        }
        return true;
    }

    public boolean rdnAreEqual(RDN rDN, RDN rDN2) {
        return IETFUtils.rDNAreEqual(rDN, rDN2);
    }
}

