/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.asn1.x500.style;

import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Encodable;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1ObjectIdentifier;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Primitive;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1String;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.DERUniversalString;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.g;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.j;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.x500.AttributeTypeAndValue;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.x500.RDN;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.x500.X500NameBuilder;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.x500.X500NameStyle;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.x500.style.X500NameTokenizer;
import com.fis.ekyc.nfc.build_in.bouncycastle.util.Strings;
import com.fis.ekyc.nfc.build_in.bouncycastle.util.encoders.Hex;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class IETFUtils {
    private static String unescape(String string2) {
        if (string2.length() != 0 && (string2.indexOf(92) >= 0 || string2.indexOf(34) >= 0)) {
            StringBuffer stringBuffer;
            char[] cArray = string2.toCharArray();
            boolean bl = false;
            boolean bl2 = false;
            StringBuffer stringBuffer2 = stringBuffer;
            stringBuffer = new StringBuffer(string2.length());
            int n3 = 0;
            if (cArray[0] == '\\' && cArray[1] == '#') {
                n3 = 2;
                stringBuffer2.append("\\#");
            }
            boolean bl3 = false;
            int n4 = 0;
            char c3 = '\u0000';
            while (n3 != cArray.length) {
                char c4 = cArray[n3];
                if (c4 != ' ') {
                    bl3 = true;
                }
                if (c4 == '\"') {
                    if (!bl) {
                        bl2 ^= true;
                    } else {
                        stringBuffer2.append(c4);
                    }
                    bl = false;
                } else if (c4 == '\\' && !bl && !bl2) {
                    bl = true;
                    n4 = stringBuffer2.length();
                } else if (c4 != ' ' || bl || bl3) {
                    if (bl && IETFUtils.isHexDigit(c4)) {
                        if (c3 != '\u0000') {
                            stringBuffer2.append((char)(IETFUtils.convertHex(c3) * 16 + IETFUtils.convertHex(c4)));
                            bl = false;
                            c3 = '\u0000';
                        } else {
                            c3 = c4;
                        }
                    } else {
                        stringBuffer2.append(c4);
                        bl = false;
                    }
                }
                ++n3;
            }
            if (stringBuffer2.length() > 0) {
                while (true) {
                    StringBuffer stringBuffer3 = stringBuffer2;
                    if (stringBuffer3.charAt(stringBuffer3.length() - 1) != ' ' || n4 == stringBuffer2.length() - 1) break;
                    StringBuffer stringBuffer4 = stringBuffer2;
                    stringBuffer4.setLength(stringBuffer4.length() - 1);
                }
            }
            return stringBuffer2.toString();
        }
        return string2.trim();
    }

    private static boolean isHexDigit(char c3) {
        return '0' <= c3 && c3 <= '9' || 'a' <= c3 && c3 <= 'f' || 'A' <= c3 && c3 <= 'F';
    }

    private static int convertHex(char c3) {
        if ('0' <= c3 && c3 <= '9') {
            return c3 - 48;
        }
        if ('a' <= c3 && c3 <= 'f') {
            return c3 - 97 + 10;
        }
        return c3 - 65 + 10;
    }

    public static RDN[] rDNsFromString(String object, X500NameStyle x500NameStyle) {
        X500NameBuilder x500NameBuilder;
        X500NameTokenizer x500NameTokenizer;
        X500NameTokenizer x500NameTokenizer2 = x500NameTokenizer;
        x500NameTokenizer = new X500NameTokenizer((String)object);
        object = x500NameBuilder;
        x500NameBuilder = new X500NameBuilder(x500NameStyle);
        while (x500NameTokenizer2.hasMoreTokens()) {
            X500NameTokenizer x500NameTokenizer3;
            X500NameTokenizer x500NameTokenizer4;
            Object object2 = x500NameTokenizer2.nextToken();
            if (object2.indexOf(43) > 0) {
                X500NameTokenizer x500NameTokenizer5;
                X500NameTokenizer x500NameTokenizer6;
                x500NameTokenizer4 = x500NameTokenizer6;
                x500NameTokenizer6 = new X500NameTokenizer((String)object2, '+');
                object2 = x500NameTokenizer5;
                Object object3 = new X500NameTokenizer(x500NameTokenizer4.nextToken(), '=').nextToken();
                if (object2.hasMoreTokens()) {
                    object2 = object2.nextToken();
                    object3 = x500NameStyle.attrNameToOID(((String)object3).trim());
                    if (x500NameTokenizer4.hasMoreTokens()) {
                        Vector<String> vector;
                        Vector<Object> vector2;
                        Vector<Object> vector3 = vector2;
                        vector2 = new Vector<Object>();
                        Vector<String> vector4 = vector;
                        vector4();
                        vector3.addElement(object3);
                        vector.addElement(IETFUtils.unescape((String)object2));
                        while (x500NameTokenizer4.hasMoreTokens()) {
                            X500NameTokenizer x500NameTokenizer7;
                            object2 = x500NameTokenizer7;
                            object3 = new X500NameTokenizer(x500NameTokenizer4.nextToken(), '=').nextToken();
                            if (object2.hasMoreTokens()) {
                                object2 = object2.nextToken();
                                vector3.addElement(x500NameStyle.attrNameToOID(((String)object3).trim()));
                                vector4.addElement(IETFUtils.unescape((String)object2));
                                continue;
                            }
                            throw new IllegalArgumentException("badly formatted directory string");
                        }
                        object2 = IETFUtils.toOIDArray(vector3);
                        ((X500NameBuilder)object).addMultiValuedRDN((ASN1ObjectIdentifier[])object2, IETFUtils.toValueArray(vector4));
                        continue;
                    }
                    ((X500NameBuilder)object).addRDN((ASN1ObjectIdentifier)object3, IETFUtils.unescape((String)object2));
                    continue;
                }
                throw new IllegalArgumentException("badly formatted directory string");
            }
            x500NameTokenizer4 = x500NameTokenizer3;
            object2 = new X500NameTokenizer((String)object2, '=').nextToken();
            if (x500NameTokenizer4.hasMoreTokens()) {
                object2 = x500NameStyle.attrNameToOID(object2.trim());
                ((X500NameBuilder)object).addRDN((ASN1ObjectIdentifier)object2, IETFUtils.unescape(x500NameTokenizer4.nextToken()));
                continue;
            }
            throw new IllegalArgumentException("badly formatted directory string");
        }
        return ((X500NameBuilder)object).build().getRDNs();
    }

    private static String[] toValueArray(Vector vector) {
        int n3 = vector.size();
        String[] stringArray = new String[n3];
        for (int i3 = 0; i3 != n3; ++i3) {
            stringArray[i3] = (String)vector.elementAt(i3);
        }
        return stringArray;
    }

    private static ASN1ObjectIdentifier[] toOIDArray(Vector vector) {
        int n3 = vector.size();
        ASN1ObjectIdentifier[] aSN1ObjectIdentifierArray = new ASN1ObjectIdentifier[n3];
        for (int i3 = 0; i3 != n3; ++i3) {
            aSN1ObjectIdentifierArray[i3] = (ASN1ObjectIdentifier)vector.elementAt(i3);
        }
        return aSN1ObjectIdentifierArray;
    }

    public static String[] findAttrNamesForOID(ASN1ObjectIdentifier aSN1ObjectIdentifier, Hashtable hashtable) {
        int n3 = 0;
        Enumeration enumeration = hashtable.elements();
        while (enumeration.hasMoreElements()) {
            if (!aSN1ObjectIdentifier.equals(enumeration.nextElement())) continue;
            ++n3;
        }
        String[] stringArray = new String[n3];
        int n4 = 0;
        Enumeration enumeration2 = hashtable.keys();
        while (enumeration2.hasMoreElements()) {
            String string2 = (String)enumeration2.nextElement();
            if (!aSN1ObjectIdentifier.equals(hashtable.get(string2))) continue;
            int n5 = n4 + 1;
            stringArray[n4] = string2;
            n4 = n5;
        }
        return stringArray;
    }

    public static ASN1ObjectIdentifier decodeAttrName(String string2, Hashtable object) {
        if (Strings.toUpperCase(string2).startsWith("OID.")) {
            return new ASN1ObjectIdentifier(string2.substring(4));
        }
        if (string2.charAt(0) >= '0' && string2.charAt(0) <= '9') {
            return new ASN1ObjectIdentifier(string2);
        }
        if ((object = (ASN1ObjectIdentifier)((Hashtable)object).get(Strings.toLowerCase(string2))) != null) {
            return object;
        }
        throw new IllegalArgumentException(g.a("Unknown object id - ", string2, " - passed to distinguished name"));
    }

    public static ASN1Encodable valueFromHexString(String string2, int n3) {
        int n4 = (string2.length() - n3) / 2;
        byte[] byArray = new byte[n4];
        for (int i3 = 0; i3 != n4; ++i3) {
            int n5 = i3 * 2 + n3;
            char c3 = string2.charAt(n5);
            byArray[i3] = (byte)(IETFUtils.convertHex(c3) << 4 | IETFUtils.convertHex(string2.charAt(n5 + 1)));
        }
        return ASN1Primitive.fromByteArray(byArray);
    }

    public static void appendRDN(StringBuffer stringBuffer, RDN attributeTypeAndValueArray, Hashtable hashtable) {
        if (attributeTypeAndValueArray.isMultiValued()) {
            attributeTypeAndValueArray = attributeTypeAndValueArray.getTypesAndValues();
            boolean bl = true;
            for (int i3 = 0; i3 != attributeTypeAndValueArray.length; ++i3) {
                if (bl) {
                    bl = false;
                } else {
                    stringBuffer.append('+');
                }
                IETFUtils.appendTypeAndValue(stringBuffer, attributeTypeAndValueArray[i3], hashtable);
            }
        } else if (attributeTypeAndValueArray.getFirst() != null) {
            IETFUtils.appendTypeAndValue(stringBuffer, attributeTypeAndValueArray.getFirst(), hashtable);
        }
    }

    public static void appendTypeAndValue(StringBuffer stringBuffer, AttributeTypeAndValue attributeTypeAndValue, Hashtable object) {
        if ((object = (String)((Hashtable)object).get(attributeTypeAndValue.getType())) != null) {
            stringBuffer.append((String)object);
        } else {
            stringBuffer.append(attributeTypeAndValue.getType().getId());
        }
        stringBuffer.append('=');
        stringBuffer.append(IETFUtils.valueToString(attributeTypeAndValue.getValue()));
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String valueToString(ASN1Encodable object) {
        StringBuffer stringBuffer;
        StringBuffer stringBuffer2 = stringBuffer;
        stringBuffer = new StringBuffer();
        if (object instanceof ASN1String && !(object instanceof DERUniversalString)) {
            if (((String)(object = ((ASN1String)object).getString())).length() > 0 && ((String)object).charAt(0) == '#') {
                stringBuffer2.append('\\');
            }
            stringBuffer2.append((String)object);
        } else {
            Object object2;
            StringBuffer stringBuffer3;
            try {
                stringBuffer3 = stringBuffer2;
                object2 = object;
                stringBuffer2.append('#');
            }
            catch (IOException iOException) {
                throw new IllegalArgumentException("Other value has no encoded form");
            }
            {
                stringBuffer3.append(Hex.toHexString(object2.toASN1Primitive().getEncoded("DER")));
            }
        }
        StringBuffer stringBuffer4 = stringBuffer2;
        int n3 = stringBuffer4.length();
        int n4 = 0;
        if (stringBuffer4.length() >= 2 && stringBuffer2.charAt(0) == '\\' && stringBuffer2.charAt(1) == '#') {
            n4 = 2;
        }
        block6: while (n4 != n3) {
            char c3 = stringBuffer2.charAt(n4);
            if (c3 != '\"' && c3 != '\\' && c3 != '+' && c3 != ',') {
                switch (c3) {
                    default: {
                        ++n4;
                        continue block6;
                    }
                    case ';': 
                    case '<': 
                    case '=': 
                    case '>': 
                }
            }
            stringBuffer2.insert(n4, "\\");
            n4 += 2;
            ++n3;
        }
        if (stringBuffer2.length() > 0) {
            for (n3 = 0; stringBuffer2.length() > n3 && stringBuffer2.charAt(n3) == ' '; n3 += 2) {
                stringBuffer2.insert(n3, "\\");
            }
        }
        for (n3 = stringBuffer2.length() - 1; n3 >= 0 && stringBuffer2.charAt(n3) == ' '; --n3) {
            stringBuffer2.insert(n3, '\\');
        }
        return stringBuffer2.toString();
    }

    public static String canonicalize(String string2) {
        int n3;
        int n4;
        ASN1Primitive aSN1Primitive;
        if (string2.length() > 0 && string2.charAt(0) == '#' && (aSN1Primitive = IETFUtils.decodeObject(string2)) instanceof ASN1String) {
            string2 = ((ASN1String)((Object)aSN1Primitive)).getString();
        }
        if ((n4 = (string2 = Strings.toLowerCase(string2)).length()) < 2) {
            return string2;
        }
        int n5 = n4;
        int n6 = n5 - 1;
        for (n4 = 0; n4 < n6 && string2.charAt(n4) == '\\' && string2.charAt(n4 + 1) == ' '; n4 += 2) {
        }
        int n7 = n4 + 1;
        for (n3 = n6; n3 > n7 && string2.charAt(n3 - 1) == '\\' && string2.charAt(n3) == ' '; n3 -= 2) {
        }
        if (n4 > 0 || n3 < n6) {
            string2 = string2.substring(n4, n3 + 1);
        }
        return IETFUtils.stripInternalSpaces(string2);
    }

    public static String canonicalString(ASN1Encodable aSN1Encodable) {
        return IETFUtils.canonicalize(IETFUtils.valueToString(aSN1Encodable));
    }

    private static ASN1Primitive decodeObject(String string2) {
        int n3;
        try {
            n3 = string2.length();
        }
        catch (IOException iOException) {
            throw new IllegalStateException(j.a("unknown encoding in name: ", iOException));
        }
        return ASN1Primitive.fromByteArray(Hex.decodeStrict(string2, 1, n3 - 1));
    }

    public static String stripInternalSpaces(String string2) {
        StringBuffer stringBuffer;
        if (string2.indexOf("  ") < 0) {
            return string2;
        }
        StringBuffer stringBuffer2 = stringBuffer;
        stringBuffer2();
        char c3 = string2.charAt(0);
        stringBuffer.append(c3);
        for (int i3 = 1; i3 < string2.length(); ++i3) {
            char c4 = string2.charAt(i3);
            if (c3 == ' ' && c4 == ' ') continue;
            stringBuffer2.append(c4);
            c3 = c4;
        }
        return stringBuffer2.toString();
    }

    public static boolean rDNAreEqual(RDN attributeTypeAndValueArray, RDN attributeTypeAndValueArray2) {
        if (attributeTypeAndValueArray.size() != attributeTypeAndValueArray2.size()) {
            return false;
        }
        if ((attributeTypeAndValueArray = attributeTypeAndValueArray.getTypesAndValues()).length != (attributeTypeAndValueArray2 = attributeTypeAndValueArray2.getTypesAndValues()).length) {
            return false;
        }
        for (int i3 = 0; i3 != attributeTypeAndValueArray.length; ++i3) {
            if (IETFUtils.atvAreEqual(attributeTypeAndValueArray[i3], attributeTypeAndValueArray2[i3])) continue;
            return false;
        }
        return true;
    }

    private static boolean atvAreEqual(AttributeTypeAndValue attributeTypeAndValue, AttributeTypeAndValue attributeTypeAndValue2) {
        if (attributeTypeAndValue == attributeTypeAndValue2) {
            return true;
        }
        if (attributeTypeAndValue != null && attributeTypeAndValue2 != null) {
            if (!attributeTypeAndValue.getType().equals(attributeTypeAndValue2.getType())) {
                return false;
            }
            return IETFUtils.canonicalString(attributeTypeAndValue.getValue()).equals(IETFUtils.canonicalString(attributeTypeAndValue2.getValue()));
        }
        return false;
    }
}

