/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.asn1.x509;

import c.b;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Encodable;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1EncodableVector;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Integer;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Object;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Primitive;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Sequence;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1TaggedObject;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.DERBitString;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.DERSequence;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.x509.AlgorithmIdentifier;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.x509.AttCertIssuer;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.x509.AttCertValidityPeriod;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.x509.Extensions;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.x509.Holder;

public class AttributeCertificateInfo
extends ASN1Object {
    private ASN1Integer version;
    private Holder holder;
    private AttCertIssuer issuer;
    private AlgorithmIdentifier signature;
    private ASN1Integer serialNumber;
    private AttCertValidityPeriod attrCertValidityPeriod;
    private ASN1Sequence attributes;
    private DERBitString issuerUniqueID;
    private Extensions extensions;

    public static AttributeCertificateInfo getInstance(ASN1TaggedObject aSN1TaggedObject, boolean bl) {
        return AttributeCertificateInfo.getInstance(ASN1Sequence.getInstance(aSN1TaggedObject, bl));
    }

    public static AttributeCertificateInfo getInstance(Object object) {
        if (object instanceof AttributeCertificateInfo) {
            return (AttributeCertificateInfo)object;
        }
        if (object != null) {
            return new AttributeCertificateInfo(ASN1Sequence.getInstance(object));
        }
        return null;
    }

    private AttributeCertificateInfo(ASN1Sequence aSN1Sequence) {
        if (aSN1Sequence.size() >= 6 && aSN1Sequence.size() <= 9) {
            int n3;
            if (aSN1Sequence.getObjectAt(0) instanceof ASN1Integer) {
                this.version = ASN1Integer.getInstance(aSN1Sequence.getObjectAt(0));
                n3 = 1;
            } else {
                ASN1Integer aSN1Integer;
                ASN1Integer aSN1Integer2 = aSN1Integer;
                aSN1Integer = new ASN1Integer(0L);
                this.version = aSN1Integer2;
                n3 = 0;
            }
            this.holder = Holder.getInstance(aSN1Sequence.getObjectAt(n3));
            this.issuer = AttCertIssuer.getInstance(aSN1Sequence.getObjectAt(n3 + 1));
            this.signature = AlgorithmIdentifier.getInstance(aSN1Sequence.getObjectAt(n3 + 2));
            this.serialNumber = ASN1Integer.getInstance(aSN1Sequence.getObjectAt(n3 + 3));
            this.attrCertValidityPeriod = AttCertValidityPeriod.getInstance(aSN1Sequence.getObjectAt(n3 + 4));
            this.attributes = ASN1Sequence.getInstance(aSN1Sequence.getObjectAt(n3 + 5));
            n3 += 6;
            while (n3 < aSN1Sequence.size()) {
                ASN1Encodable aSN1Encodable = aSN1Sequence.getObjectAt(n3);
                if (aSN1Encodable instanceof DERBitString) {
                    this.issuerUniqueID = DERBitString.getInstance(aSN1Sequence.getObjectAt(n3));
                } else if (aSN1Encodable instanceof ASN1Sequence || aSN1Encodable instanceof Extensions) {
                    this.extensions = Extensions.getInstance(aSN1Sequence.getObjectAt(n3));
                }
                ++n3;
            }
            return;
        }
        throw new IllegalArgumentException(b.a(aSN1Sequence, b.b.a("Bad sequence size: ")));
    }

    public ASN1Integer getVersion() {
        return this.version;
    }

    public Holder getHolder() {
        return this.holder;
    }

    public AttCertIssuer getIssuer() {
        return this.issuer;
    }

    public AlgorithmIdentifier getSignature() {
        return this.signature;
    }

    public ASN1Integer getSerialNumber() {
        return this.serialNumber;
    }

    public AttCertValidityPeriod getAttrCertValidityPeriod() {
        return this.attrCertValidityPeriod;
    }

    public ASN1Sequence getAttributes() {
        return this.attributes;
    }

    public DERBitString getIssuerUniqueID() {
        return this.issuerUniqueID;
    }

    public Extensions getExtensions() {
        return this.extensions;
    }

    @Override
    public ASN1Primitive toASN1Primitive() {
        Extensions extensions;
        ASN1EncodableVector aSN1EncodableVector;
        ASN1EncodableVector aSN1EncodableVector2 = aSN1EncodableVector;
        aSN1EncodableVector = new ASN1EncodableVector(9);
        if (this.version.intValueExact() != 0) {
            aSN1EncodableVector2.add(this.version);
        }
        aSN1EncodableVector2.add(this.holder);
        aSN1EncodableVector2.add(this.issuer);
        aSN1EncodableVector2.add(this.signature);
        aSN1EncodableVector2.add(this.serialNumber);
        aSN1EncodableVector2.add(this.attrCertValidityPeriod);
        aSN1EncodableVector2.add(this.attributes);
        DERBitString dERBitString = this.issuerUniqueID;
        if (dERBitString != null) {
            aSN1EncodableVector2.add(dERBitString);
        }
        if ((extensions = this.extensions) != null) {
            aSN1EncodableVector2.add(extensions);
        }
        return new DERSequence(aSN1EncodableVector2);
    }
}

