/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.asn1.x509;

import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1EncodableVector;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Integer;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Object;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1OctetString;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Primitive;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Sequence;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1TaggedObject;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.DEROctetString;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.DERSequence;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.DERTaggedObject;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.g;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.x509.Extension;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.x509.Extensions;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.x509.GeneralNames;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.digests.SHA1Digest;
import com.fis.ekyc.nfc.build_in.bouncycastle.util.encoders.Hex;
import java.math.BigInteger;

public class AuthorityKeyIdentifier
extends ASN1Object {
    public ASN1OctetString keyidentifier = null;
    public GeneralNames certissuer = null;
    public ASN1Integer certserno = null;

    public static AuthorityKeyIdentifier getInstance(ASN1TaggedObject aSN1TaggedObject, boolean bl) {
        return AuthorityKeyIdentifier.getInstance(ASN1Sequence.getInstance(aSN1TaggedObject, bl));
    }

    public static AuthorityKeyIdentifier getInstance(Object object) {
        if (object instanceof AuthorityKeyIdentifier) {
            return (AuthorityKeyIdentifier)object;
        }
        if (object != null) {
            return new AuthorityKeyIdentifier(ASN1Sequence.getInstance(object));
        }
        return null;
    }

    public static AuthorityKeyIdentifier fromExtensions(Extensions extensions) {
        return AuthorityKeyIdentifier.getInstance(Extensions.getExtensionParsedValue(extensions, Extension.authorityKeyIdentifier));
    }

    public AuthorityKeyIdentifier(ASN1Sequence object) {
        object = ((ASN1Sequence)object).getObjects();
        while (object.hasMoreElements()) {
            ASN1TaggedObject aSN1TaggedObject = ASN1TaggedObject.getInstance(object.nextElement());
            int n3 = aSN1TaggedObject.getTagNo();
            if (n3 != 0) {
                if (n3 != 1) {
                    if (n3 == 2) {
                        this.certserno = ASN1Integer.getInstance(aSN1TaggedObject, false);
                        continue;
                    }
                    throw new IllegalArgumentException("illegal tag");
                }
                this.certissuer = GeneralNames.getInstance(aSN1TaggedObject, false);
                continue;
            }
            this.keyidentifier = ASN1OctetString.getInstance(aSN1TaggedObject, false);
        }
    }

    public AuthorityKeyIdentifier(SubjectPublicKeyInfo subjectPublicKeyInfo) {
        this(subjectPublicKeyInfo, null, null);
    }

    public AuthorityKeyIdentifier(SubjectPublicKeyInfo object, GeneralNames generalNames, BigInteger bigInteger) {
        SHA1Digest sHA1Digest = new SHA1Digest();
        object = new byte[sHA1Digest.getDigestSize()];
        byte[] byArray = ((SubjectPublicKeyInfo)object).getPublicKeyData().getBytes();
        sHA1Digest.update(byArray, 0, byArray.length);
        sHA1Digest.doFinal((byte[])object, 0);
        this.keyidentifier = new DEROctetString((byte[])object);
        this.certissuer = generalNames;
        if (bigInteger != null) {
            ASN1Integer aSN1Integer;
            object = aSN1Integer;
            aSN1Integer = new ASN1Integer(bigInteger);
        } else {
            object = null;
        }
        this.certserno = object;
    }

    public AuthorityKeyIdentifier(GeneralNames generalNames, BigInteger bigInteger) {
        this((byte[])null, generalNames, bigInteger);
    }

    public AuthorityKeyIdentifier(byte[] byArray) {
        this(byArray, null, null);
    }

    public AuthorityKeyIdentifier(byte[] object, GeneralNames generalNames, BigInteger bigInteger) {
        DEROctetString dEROctetString;
        if (object != null) {
            DEROctetString dEROctetString2;
            dEROctetString = dEROctetString2;
            dEROctetString2 = new DEROctetString((byte[])object);
        } else {
            dEROctetString = null;
        }
        AuthorityKeyIdentifier authorityKeyIdentifier = this;
        authorityKeyIdentifier.keyidentifier = dEROctetString;
        authorityKeyIdentifier.certissuer = generalNames;
        if (bigInteger != null) {
            ASN1Integer aSN1Integer;
            object = aSN1Integer;
            aSN1Integer = new ASN1Integer(bigInteger);
        } else {
            object = null;
        }
        this.certserno = object;
    }

    public byte[] getKeyIdentifier() {
        ASN1Object aSN1Object = ((AuthorityKeyIdentifier)aSN1Object).keyidentifier;
        if (aSN1Object != null) {
            return ((ASN1OctetString)aSN1Object).getOctets();
        }
        return null;
    }

    public GeneralNames getAuthorityCertIssuer() {
        return this.certissuer;
    }

    public BigInteger getAuthorityCertSerialNumber() {
        ASN1Object aSN1Object = ((AuthorityKeyIdentifier)aSN1Object).certserno;
        if (aSN1Object != null) {
            return ((ASN1Integer)aSN1Object).getValue();
        }
        return null;
    }

    @Override
    public ASN1Primitive toASN1Primitive() {
        ASN1Integer aSN1Integer;
        DERTaggedObject dERTaggedObject;
        ASN1EncodableVector aSN1EncodableVector;
        ASN1EncodableVector aSN1EncodableVector2 = aSN1EncodableVector;
        aSN1EncodableVector = new ASN1EncodableVector(3);
        ASN1Object aSN1Object = this.keyidentifier;
        if (aSN1Object != null) {
            DERTaggedObject dERTaggedObject2;
            dERTaggedObject = dERTaggedObject2;
            dERTaggedObject2 = new DERTaggedObject(false, 0, aSN1Object);
            aSN1EncodableVector2.add(dERTaggedObject);
        }
        if ((aSN1Object = this.certissuer) != null) {
            DERTaggedObject dERTaggedObject3;
            dERTaggedObject = dERTaggedObject3;
            dERTaggedObject3 = new DERTaggedObject(false, 1, aSN1Object);
            aSN1EncodableVector2.add(dERTaggedObject);
        }
        if ((aSN1Integer = this.certserno) != null) {
            DERTaggedObject dERTaggedObject4;
            aSN1Object = dERTaggedObject4;
            dERTaggedObject4 = new DERTaggedObject(false, 2, aSN1Integer);
            aSN1EncodableVector2.add(aSN1Object);
        }
        return new DERSequence(aSN1EncodableVector2);
    }

    public String toString() {
        Object object = ((AuthorityKeyIdentifier)object).keyidentifier;
        object = object != null ? Hex.toHexString(((ASN1OctetString)object).getOctets()) : "null";
        return g.a("AuthorityKeyIdentifier: KeyID(", (String)object, ")");
    }
}

