/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.asn1.x509;

import b.b;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Boolean;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1EncodableVector;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Integer;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Object;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Primitive;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Sequence;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1TaggedObject;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.DERSequence;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.x509.Extension;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.x509.Extensions;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.x509.X509Extension;
import java.math.BigInteger;

public class BasicConstraints
extends ASN1Object {
    public ASN1Boolean cA = ASN1Boolean.getInstance(false);
    public ASN1Integer pathLenConstraint = null;

    public static BasicConstraints getInstance(ASN1TaggedObject aSN1TaggedObject, boolean bl) {
        return BasicConstraints.getInstance(ASN1Sequence.getInstance(aSN1TaggedObject, bl));
    }

    public static BasicConstraints getInstance(Object object) {
        if (object instanceof BasicConstraints) {
            return (BasicConstraints)object;
        }
        if (object instanceof X509Extension) {
            return BasicConstraints.getInstance(X509Extension.convertValueToObject((X509Extension)object));
        }
        if (object != null) {
            return new BasicConstraints(ASN1Sequence.getInstance(object));
        }
        return null;
    }

    public static BasicConstraints fromExtensions(Extensions extensions) {
        return BasicConstraints.getInstance(Extensions.getExtensionParsedValue(extensions, Extension.basicConstraints));
    }

    private BasicConstraints(ASN1Sequence aSN1Sequence) {
        if (aSN1Sequence.size() == 0) {
            BasicConstraints basicConstraints = this;
            basicConstraints.cA = null;
            basicConstraints.pathLenConstraint = null;
        } else {
            if (aSN1Sequence.getObjectAt(0) instanceof ASN1Boolean) {
                this.cA = ASN1Boolean.getInstance(aSN1Sequence.getObjectAt(0));
            } else {
                this.cA = null;
                this.pathLenConstraint = ASN1Integer.getInstance(aSN1Sequence.getObjectAt(0));
            }
            if (aSN1Sequence.size() > 1) {
                if (this.cA != null) {
                    this.pathLenConstraint = ASN1Integer.getInstance(aSN1Sequence.getObjectAt(1));
                } else {
                    throw new IllegalArgumentException("wrong sequence in constructor");
                }
            }
        }
    }

    public BasicConstraints(boolean bl) {
        this.cA = bl ? ASN1Boolean.getInstance(true) : null;
        this.pathLenConstraint = null;
    }

    public BasicConstraints(int n3) {
        this.cA = ASN1Boolean.getInstance(true);
        this.pathLenConstraint = new ASN1Integer(n3);
    }

    public boolean isCA() {
        ASN1Object aSN1Object = ((BasicConstraints)aSN1Object).cA;
        return aSN1Object != null && ((ASN1Boolean)aSN1Object).isTrue();
    }

    public BigInteger getPathLenConstraint() {
        ASN1Object aSN1Object = ((BasicConstraints)aSN1Object).pathLenConstraint;
        if (aSN1Object != null) {
            return ((ASN1Integer)aSN1Object).getValue();
        }
        return null;
    }

    @Override
    public ASN1Primitive toASN1Primitive() {
        ASN1Integer aSN1Integer;
        ASN1EncodableVector aSN1EncodableVector;
        ASN1EncodableVector aSN1EncodableVector2 = aSN1EncodableVector;
        aSN1EncodableVector = new ASN1EncodableVector(2);
        ASN1Boolean aSN1Boolean = this.cA;
        if (aSN1Boolean != null) {
            aSN1EncodableVector2.add(aSN1Boolean);
        }
        if ((aSN1Integer = this.pathLenConstraint) != null) {
            aSN1EncodableVector2.add(aSN1Integer);
        }
        return new DERSequence(aSN1EncodableVector2);
    }

    public String toString() {
        if (this.pathLenConstraint == null) {
            return b.a("BasicConstraints: isCa(").append(this.isCA()).append(")").toString();
        }
        return b.a("BasicConstraints: isCa(").append(this.isCA()).append("), pathLenConstraint = ").append(this.pathLenConstraint.getValue()).toString();
    }
}

