/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.asn1.x509;

import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Object;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Primitive;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Sequence;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1TaggedObject;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.DERSequence;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.x509.DistributionPoint;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.x509.Extension;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.x509.Extensions;
import com.fis.ekyc.nfc.build_in.bouncycastle.util.Strings;

public class CRLDistPoint
extends ASN1Object {
    public ASN1Sequence seq;

    public static CRLDistPoint getInstance(ASN1TaggedObject aSN1TaggedObject, boolean bl) {
        return CRLDistPoint.getInstance(ASN1Sequence.getInstance(aSN1TaggedObject, bl));
    }

    public static CRLDistPoint getInstance(Object object) {
        if (object instanceof CRLDistPoint) {
            return (CRLDistPoint)object;
        }
        if (object != null) {
            return new CRLDistPoint(ASN1Sequence.getInstance(object));
        }
        return null;
    }

    public static CRLDistPoint fromExtensions(Extensions extensions) {
        return CRLDistPoint.getInstance(Extensions.getExtensionParsedValue(extensions, Extension.cRLDistributionPoints));
    }

    private CRLDistPoint(ASN1Sequence aSN1Sequence) {
        this.seq = aSN1Sequence;
    }

    public CRLDistPoint(DistributionPoint[] distributionPointArray) {
        DERSequence dERSequence;
        aSN1Object.seq = null;
        ASN1Object aSN1Object = dERSequence;
        dERSequence = new DERSequence(distributionPointArray);
        v1.seq = aSN1Object;
    }

    public DistributionPoint[] getDistributionPoints() {
        DistributionPoint[] distributionPointArray = new DistributionPoint[this.seq.size()];
        for (int i3 = 0; i3 != this.seq.size(); ++i3) {
            distributionPointArray[i3] = DistributionPoint.getInstance(this.seq.getObjectAt(i3));
        }
        return distributionPointArray;
    }

    @Override
    public ASN1Primitive toASN1Primitive() {
        return this.seq;
    }

    public String toString() {
        StringBuffer stringBuffer;
        CRLDistPoint cRLDistPoint = stringBuffer2;
        StringBuffer stringBuffer2 = stringBuffer;
        String string2 = Strings.lineSeparator();
        new StringBuffer().append("CRLDistPoint:");
        stringBuffer2.append(string2);
        DistributionPoint[] distributionPointArray = cRLDistPoint.getDistributionPoints();
        for (int i3 = 0; i3 != distributionPointArray.length; ++i3) {
            stringBuffer2.append("    ");
            stringBuffer2.append(distributionPointArray[i3]);
            stringBuffer2.append(string2);
        }
        return stringBuffer2.toString();
    }
}

