/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.asn1.x509;

import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Encodable;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1EncodableVector;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Object;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1ObjectIdentifier;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Primitive;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Sequence;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1TaggedObject;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.DERSequence;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.x509.Extension;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.x509.Extensions;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.x509.KeyPurposeId;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class ExtendedKeyUsage
extends ASN1Object {
    public Hashtable usageTable;
    public ASN1Sequence seq;

    public static ExtendedKeyUsage getInstance(ASN1TaggedObject aSN1TaggedObject, boolean bl) {
        return ExtendedKeyUsage.getInstance(ASN1Sequence.getInstance(aSN1TaggedObject, bl));
    }

    public static ExtendedKeyUsage getInstance(Object object) {
        if (object instanceof ExtendedKeyUsage) {
            return (ExtendedKeyUsage)object;
        }
        if (object != null) {
            return new ExtendedKeyUsage(ASN1Sequence.getInstance(object));
        }
        return null;
    }

    public static ExtendedKeyUsage fromExtensions(Extensions extensions) {
        return ExtendedKeyUsage.getInstance(Extensions.getExtensionParsedValue(extensions, Extension.extendedKeyUsage));
    }

    public ExtendedKeyUsage(KeyPurposeId keyPurposeId) {
        ExtendedKeyUsage extendedKeyUsage = this;
        extendedKeyUsage.usageTable = new Hashtable();
        extendedKeyUsage.seq = new DERSequence(keyPurposeId);
        KeyPurposeId keyPurposeId2 = keyPurposeId;
        extendedKeyUsage.usageTable.put(keyPurposeId2, keyPurposeId2);
    }

    private ExtendedKeyUsage(ASN1Sequence object) {
        Hashtable hashtable;
        Object object2 = hashtable;
        hashtable = new Hashtable();
        this.usageTable = object2;
        this.seq = object;
        object = ((ASN1Sequence)object).getObjects();
        while (object.hasMoreElements()) {
            object2 = (ASN1Encodable)object.nextElement();
            if (object2.toASN1Primitive() instanceof ASN1ObjectIdentifier) {
                Object object3 = object2;
                this.usageTable.put(object3, object3);
                continue;
            }
            throw new IllegalArgumentException("Only ASN1ObjectIdentifiers allowed in ExtendedKeyUsage.");
        }
    }

    public ExtendedKeyUsage(KeyPurposeId[] keyPurposeIdArray) {
        DERSequence dERSequence;
        ASN1EncodableVector aSN1EncodableVector;
        aSN1Object.usageTable = new Hashtable();
        ASN1EncodableVector aSN1EncodableVector2 = aSN1EncodableVector;
        aSN1EncodableVector = new ASN1EncodableVector(keyPurposeIdArray.length);
        for (int i3 = 0; i3 != keyPurposeIdArray.length; ++i3) {
            aSN1EncodableVector2.add(keyPurposeIdArray[i3]);
            KeyPurposeId keyPurposeId = keyPurposeIdArray[i3];
            aSN1Object.usageTable.put(keyPurposeId, keyPurposeId);
        }
        ExtendedKeyUsage extendedKeyUsage = aSN1Object;
        ASN1Object aSN1Object = dERSequence;
        dERSequence = new DERSequence(aSN1EncodableVector2);
        extendedKeyUsage.seq = aSN1Object;
    }

    public ExtendedKeyUsage(Vector object) {
        DERSequence dERSequence;
        ASN1EncodableVector aSN1EncodableVector;
        aSN1Object.usageTable = new Hashtable();
        ASN1EncodableVector aSN1EncodableVector2 = aSN1EncodableVector;
        aSN1EncodableVector = new ASN1EncodableVector(((Vector)object).size());
        object = ((Vector)object).elements();
        while (object.hasMoreElements()) {
            KeyPurposeId keyPurposeId = KeyPurposeId.getInstance(object.nextElement());
            aSN1EncodableVector2.add(keyPurposeId);
            KeyPurposeId keyPurposeId2 = keyPurposeId;
            aSN1Object.usageTable.put(keyPurposeId2, keyPurposeId2);
        }
        ExtendedKeyUsage extendedKeyUsage = aSN1Object;
        ASN1Object aSN1Object = dERSequence;
        dERSequence = new DERSequence(aSN1EncodableVector2);
        extendedKeyUsage.seq = aSN1Object;
    }

    public boolean hasKeyPurposeId(KeyPurposeId keyPurposeId) {
        return this.usageTable.get(keyPurposeId) != null;
    }

    public KeyPurposeId[] getUsages() {
        KeyPurposeId[] keyPurposeIdArray = new KeyPurposeId[keyPurposeIdArray.seq.size()];
        int n3 = 0;
        Enumeration enumeration = keyPurposeIdArray.seq.getObjects();
        while (enumeration.hasMoreElements()) {
            keyPurposeIdArray[n3++] = KeyPurposeId.getInstance(enumeration.nextElement());
        }
        return keyPurposeIdArray;
    }

    public int size() {
        return this.usageTable.size();
    }

    @Override
    public ASN1Primitive toASN1Primitive() {
        return this.seq;
    }
}

