/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.asn1.x509;

import b.b;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1OctetString;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Sequence;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.DERIA5String;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.a;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.x500.RDN;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.x500.X500Name;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.x500.style.IETFUtils;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.x500.style.RFC4519Style;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.x509.GeneralName;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.x509.GeneralSubtree;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.x509.NameConstraintValidator;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.x509.NameConstraintValidatorException;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.x509.OtherName;
import com.fis.ekyc.nfc.build_in.bouncycastle.util.Arrays;
import com.fis.ekyc.nfc.build_in.bouncycastle.util.Integers;
import com.fis.ekyc.nfc.build_in.bouncycastle.util.Strings;
import com.fis.ekyc.nfc.build_in.bouncycastle.util.encoders.Hex;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class PKIXNameConstraintValidator
implements NameConstraintValidator {
    private Set excludedSubtreesDN;
    private Set excludedSubtreesDNS;
    private Set excludedSubtreesEmail;
    private Set excludedSubtreesURI;
    private Set excludedSubtreesIP;
    private Set excludedSubtreesOtherName;
    private Set permittedSubtreesDN;
    private Set permittedSubtreesDNS;
    private Set permittedSubtreesEmail;
    private Set permittedSubtreesURI;
    private Set permittedSubtreesIP;
    private Set permittedSubtreesOtherName;

    public PKIXNameConstraintValidator() {
        HashSet hashSet;
        HashSet hashSet2;
        HashSet hashSet3;
        HashSet hashSet4;
        HashSet hashSet5;
        HashSet hashSet6;
        Object object = hashSet6;
        hashSet6 = new HashSet();
        v1.excludedSubtreesDN = object;
        object = hashSet5;
        hashSet5 = new HashSet();
        v1.excludedSubtreesDNS = object;
        object = hashSet4;
        hashSet4 = new HashSet();
        v1.excludedSubtreesEmail = object;
        object = hashSet3;
        hashSet3 = new HashSet();
        v1.excludedSubtreesURI = object;
        object = hashSet2;
        hashSet2 = new HashSet();
        v1.excludedSubtreesIP = object;
        object = hashSet;
        hashSet = new HashSet();
        v1.excludedSubtreesOtherName = object;
    }

    private static boolean withinDNSubtree(ASN1Sequence aSN1Sequence, ASN1Sequence aSN1Sequence2) {
        int n3;
        block8: {
            int n4;
            if (aSN1Sequence2.size() < 1) {
                return false;
            }
            if (aSN1Sequence2.size() > aSN1Sequence.size()) {
                return false;
            }
            n3 = 0;
            RDN rDN = RDN.getInstance(aSN1Sequence2.getObjectAt(0));
            int n5 = n4 = 0;
            n4 = n3;
            n3 = n5;
            while (n3 < aSN1Sequence.size()) {
                if (!IETFUtils.rDNAreEqual(rDN, RDN.getInstance(aSN1Sequence.getObjectAt(n3)))) {
                    int n6 = n4 = n3 + 1;
                    n4 = n3;
                    n3 = n6;
                    continue;
                }
                break block8;
            }
            n3 = n4;
        }
        if (aSN1Sequence2.size() > aSN1Sequence.size() - n3) {
            return false;
        }
        for (int i3 = 0; i3 < aSN1Sequence2.size(); ++i3) {
            RDN rDN = RDN.getInstance(aSN1Sequence2.getObjectAt(i3));
            RDN rDN2 = RDN.getInstance(aSN1Sequence.getObjectAt(n3 + i3));
            if (rDN.size() == rDN2.size()) {
                if (!rDN.getFirst().getType().equals(rDN2.getFirst().getType())) {
                    return false;
                }
                if (!(rDN.size() == 1 && rDN.getFirst().getType().equals(RFC4519Style.serialNumber) ? !rDN2.getFirst().getValue().toString().startsWith(rDN.getFirst().getValue().toString()) : !IETFUtils.rDNAreEqual(rDN, rDN2))) continue;
                return false;
            }
            return false;
        }
        return true;
    }

    private void checkPermittedDN(Set set, ASN1Sequence aSN1Sequence) {
        if (set == null) {
            return;
        }
        if (set.isEmpty() && aSN1Sequence.size() == 0) {
            return;
        }
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            if (!PKIXNameConstraintValidator.withinDNSubtree(aSN1Sequence, (ASN1Sequence)iterator.next())) continue;
            return;
        }
        throw new NameConstraintValidatorException("Subject distinguished name is not from a permitted subtree");
    }

    private void checkExcludedDN(Set set, ASN1Sequence aSN1Sequence) {
        if (set.isEmpty()) {
            return;
        }
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            if (!PKIXNameConstraintValidator.withinDNSubtree(aSN1Sequence, (ASN1Sequence)iterator.next())) continue;
            throw new NameConstraintValidatorException("Subject distinguished name is from an excluded subtree");
        }
    }

    private Set intersectDN(Set set, Set object) {
        HashSet hashSet;
        HashSet hashSet2 = hashSet;
        hashSet = new HashSet();
        object = object.iterator();
        while (object.hasNext()) {
            ASN1Sequence aSN1Sequence = ASN1Sequence.getInstance(((GeneralSubtree)object.next()).getBase().getName().toASN1Primitive());
            if (set == null) {
                if (aSN1Sequence == null) continue;
                hashSet2.add(aSN1Sequence);
                continue;
            }
            for (ASN1Sequence aSN1Sequence2 : set) {
                if (PKIXNameConstraintValidator.withinDNSubtree(aSN1Sequence, aSN1Sequence2)) {
                    hashSet2.add(aSN1Sequence);
                    continue;
                }
                if (!PKIXNameConstraintValidator.withinDNSubtree(aSN1Sequence2, aSN1Sequence)) continue;
                hashSet2.add(aSN1Sequence2);
            }
        }
        return hashSet2;
    }

    private Set unionDN(Set object, ASN1Sequence aSN1Sequence) {
        HashSet hashSet;
        if (object.isEmpty()) {
            if (aSN1Sequence == null) {
                return object;
            }
            Set set = object;
            set.add(aSN1Sequence);
            return set;
        }
        HashSet hashSet2 = hashSet;
        hashSet = new HashSet();
        object = object.iterator();
        while (object.hasNext()) {
            ASN1Sequence aSN1Sequence2 = ASN1Sequence.getInstance(object.next());
            if (PKIXNameConstraintValidator.withinDNSubtree(aSN1Sequence, aSN1Sequence2)) {
                hashSet2.add(aSN1Sequence2);
                continue;
            }
            if (PKIXNameConstraintValidator.withinDNSubtree(aSN1Sequence2, aSN1Sequence)) {
                hashSet2.add(aSN1Sequence);
                continue;
            }
            Object object2 = hashSet2;
            ((HashSet)object2).add(aSN1Sequence2);
            ((HashSet)object2).add(aSN1Sequence);
        }
        return hashSet2;
    }

    private Set intersectOtherName(Set set, Set set2) {
        HashSet hashSet;
        Set set3 = set2;
        set2 = hashSet;
        hashSet = new HashSet();
        Iterator iterator = set3.iterator();
        while (iterator.hasNext()) {
            OtherName otherName = OtherName.getInstance(((GeneralSubtree)iterator.next()).getBase().getName());
            if (set == null) {
                if (otherName == null) continue;
                ((HashSet)set2).add(otherName);
                continue;
            }
            Iterator iterator2 = set.iterator();
            while (iterator2.hasNext()) {
                this.intersectOtherName(otherName, OtherName.getInstance(iterator2.next()), set2);
            }
        }
        return set2;
    }

    private void intersectOtherName(OtherName otherName, OtherName otherName2, Set set) {
        if (otherName.equals(otherName2)) {
            set.add(otherName);
        }
    }

    private Set unionOtherName(Set set, OtherName otherName) {
        Object object;
        if (set != null) {
            HashSet hashSet;
            object = hashSet;
            hashSet = new HashSet(set);
        } else {
            HashSet hashSet;
            object = hashSet;
            hashSet = new HashSet();
        }
        Object object2 = object;
        object2.add(otherName);
        return object2;
    }

    private Set intersectEmail(Set set, Set set2) {
        HashSet hashSet;
        Set set3 = set2;
        set2 = hashSet;
        hashSet = new HashSet();
        Iterator iterator = set3.iterator();
        while (iterator.hasNext()) {
            String string2 = this.extractNameAsString(((GeneralSubtree)iterator.next()).getBase());
            if (set == null) {
                if (string2 == null) continue;
                ((HashSet)set2).add(string2);
                continue;
            }
            Iterator iterator2 = set.iterator();
            while (iterator2.hasNext()) {
                this.intersectEmail(string2, (String)iterator2.next(), set2);
            }
        }
        return set2;
    }

    private Set unionEmail(Set set, String string2) {
        HashSet hashSet;
        if (set.isEmpty()) {
            if (string2 == null) {
                return set;
            }
            Set set2 = set;
            set2.add(string2);
            return set2;
        }
        Set set3 = set;
        set = hashSet;
        hashSet = new HashSet();
        Iterator iterator = set3.iterator();
        while (iterator.hasNext()) {
            this.unionEmail((String)iterator.next(), string2, set);
        }
        return set;
    }

    private Set intersectIP(Set set, Set set2) {
        HashSet hashSet;
        Set set3 = set2;
        set2 = hashSet;
        hashSet = new HashSet();
        Iterator iterator = set3.iterator();
        while (iterator.hasNext()) {
            byte[] byArray = ASN1OctetString.getInstance(((GeneralSubtree)iterator.next()).getBase().getName()).getOctets();
            if (set == null) {
                if (byArray == null) continue;
                ((HashSet)set2).add(byArray);
                continue;
            }
            Iterator iterator2 = set.iterator();
            while (iterator2.hasNext()) {
                set2.addAll(this.intersectIPRange((byte[])iterator2.next(), byArray));
            }
        }
        return set2;
    }

    private Set unionIP(Set set, byte[] byArray) {
        HashSet hashSet;
        if (set.isEmpty()) {
            if (byArray == null) {
                return set;
            }
            Set set2 = set;
            set2.add(byArray);
            return set2;
        }
        Set set3 = set;
        set = hashSet;
        hashSet = new HashSet();
        Iterator iterator = set3.iterator();
        while (iterator.hasNext()) {
            set.addAll(this.unionIPRange((byte[])iterator.next(), byArray));
        }
        return set;
    }

    private Set unionIPRange(byte[] byArray, byte[] byArray2) {
        HashSet hashSet;
        HashSet hashSet2 = hashSet;
        hashSet = new HashSet();
        if (Arrays.areEqual(byArray, byArray2)) {
            hashSet2.add(byArray);
        } else {
            HashSet hashSet3 = hashSet2;
            hashSet3.add(byArray);
            hashSet3.add(byArray2);
        }
        return hashSet2;
    }

    private Set intersectIPRange(byte[] object, byte[] byArray) {
        if (((byte[])object).length != byArray.length) {
            return Collections.EMPTY_SET;
        }
        PKIXNameConstraintValidator pKIXNameConstraintValidator = object2;
        byte[][] byArray2 = pKIXNameConstraintValidator.extractIPsAndSubnetMasks((byte[])object, byArray);
        object = byArray2[0];
        byArray = byArray2[1];
        byte[] byArray3 = byArray2[2];
        byte[] byArray4 = byArray2[3];
        byte[][] byArray5 = pKIXNameConstraintValidator.minMaxIPs((byte[])object, byArray, byArray3, byArray4);
        object = byArray5;
        byArray3 = PKIXNameConstraintValidator.min(byArray5[1], (byte[])object[3]);
        if (PKIXNameConstraintValidator.compareTo(PKIXNameConstraintValidator.max(byArray5[0], (byte[])object[2]), byArray3) == 1) {
            return Collections.EMPTY_SET;
        }
        PKIXNameConstraintValidator pKIXNameConstraintValidator2 = object2;
        Object object2 = PKIXNameConstraintValidator.or((byte[])object[0], (byte[])object[2]);
        return Collections.singleton(pKIXNameConstraintValidator2.ipWithSubnetMask((byte[])object2, PKIXNameConstraintValidator.or(byArray, byArray4)));
    }

    private byte[] ipWithSubnetMask(byte[] byArray, byte[] byArray2) {
        int n3 = byArray.length;
        byte[] byArray3 = new byte[n3 * 2];
        System.arraycopy(byArray, 0, byArray3, 0, n3);
        int n4 = n3;
        System.arraycopy(byArray2, 0, byArray3, n4, n4);
        return byArray3;
    }

    private byte[][] extractIPsAndSubnetMasks(byte[] byArray, byte[] byArray2) {
        int n3 = byArray.length / 2;
        byte[] byArray3 = byArray;
        byte[] byArray4 = byArray;
        int n4 = n3;
        byArray = new byte[n4];
        byArray2 = new byte[n4];
        System.arraycopy(byArray4, 0, byArray, 0, n3);
        System.arraycopy(byArray3, n3, byArray2, 0, n3);
        byte[] byArray5 = new byte[n3];
        byte[] byArray6 = new byte[n3];
        System.arraycopy(byArray2, 0, byArray5, 0, n3);
        System.arraycopy(byArray2, n3, byArray6, 0, n3);
        return new byte[][]{byArray, byArray2, byArray5, byArray6};
    }

    private byte[][] minMaxIPs(byte[] byArray, byte[] byArray2, byte[] byArray3, byte[] byArray4) {
        int n3 = byArray.length;
        byte[] byArray5 = new byte[n3];
        byte[] byArray6 = new byte[n3];
        byte[] byArray7 = new byte[n3];
        byte[] byArray8 = new byte[n3];
        for (int i3 = 0; i3 < n3; ++i3) {
            byArray5[i3] = (byte)(byArray[i3] & byArray2[i3]);
            byte by = byArray2[i3];
            byArray6[i3] = (byte)(byArray[i3] & by | ~by);
            byArray7[i3] = (byte)(byArray3[i3] & byArray4[i3]);
            by = byArray4[i3];
            byArray8[i3] = (byte)(byArray3[i3] & by | ~by);
        }
        return new byte[][]{byArray5, byArray6, byArray7, byArray8};
    }

    private void checkPermittedEmail(Set set, String string2) {
        if (set == null) {
            return;
        }
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            if (!this.emailIsConstrained(string2, (String)iterator.next())) continue;
            return;
        }
        if (string2.length() == 0 && set.size() == 0) {
            return;
        }
        throw new NameConstraintValidatorException("Subject email address is not from a permitted subtree.");
    }

    private void checkPermittedOtherName(Set object, OtherName otherName) {
        if (object == null) {
            return;
        }
        object = object.iterator();
        while (object.hasNext()) {
            if (!this.otherNameIsConstrained(otherName, OtherName.getInstance(object.next()))) continue;
            return;
        }
        throw new NameConstraintValidatorException("Subject OtherName is not from a permitted subtree.");
    }

    private void checkExcludedOtherName(Set object, OtherName otherName) {
        if (object.isEmpty()) {
            return;
        }
        object = object.iterator();
        while (object.hasNext()) {
            if (!this.otherNameIsConstrained(otherName, OtherName.getInstance(object.next()))) continue;
            throw new NameConstraintValidatorException("OtherName is from an excluded subtree.");
        }
    }

    private void checkExcludedEmail(Set object, String string2) {
        if (object.isEmpty()) {
            return;
        }
        object = object.iterator();
        while (object.hasNext()) {
            if (!this.emailIsConstrained(string2, (String)object.next())) continue;
            throw new NameConstraintValidatorException("Email address is from an excluded subtree.");
        }
    }

    private void checkPermittedIP(Set set, byte[] byArray) {
        if (set == null) {
            return;
        }
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            if (!this.isIPConstrained(byArray, (byte[])iterator.next())) continue;
            return;
        }
        if (byArray.length == 0 && set.size() == 0) {
            return;
        }
        throw new NameConstraintValidatorException("IP is not from a permitted subtree.");
    }

    private void checkExcludedIP(Set object, byte[] byArray) {
        if (object.isEmpty()) {
            return;
        }
        object = object.iterator();
        while (object.hasNext()) {
            if (!this.isIPConstrained(byArray, (byte[])object.next())) continue;
            throw new NameConstraintValidatorException("IP is from an excluded subtree.");
        }
    }

    private boolean isIPConstrained(byte[] byArray, byte[] byArray2) {
        int n3 = byArray.length;
        if (n3 != byArray2.length / 2) {
            return false;
        }
        int n4 = n3;
        byte[] byArray3 = new byte[n3];
        System.arraycopy(byArray2, n3, byArray3, 0, n3);
        byte[] byArray4 = new byte[n4];
        byte[] byArray5 = new byte[n4];
        for (int i3 = 0; i3 < n3; ++i3) {
            byArray4[i3] = (byte)(byArray2[i3] & byArray3[i3]);
            byArray5[i3] = (byte)(byArray[i3] & byArray3[i3]);
        }
        return Arrays.areEqual(byArray4, byArray5);
    }

    private boolean otherNameIsConstrained(OtherName otherName, OtherName otherName2) {
        return otherName2.equals(otherName);
    }

    private boolean emailIsConstrained(String string2, String string3) {
        String string4 = string2;
        String string5 = string4.substring(string4.indexOf(64) + 1);
        if (string3.indexOf(64) != -1) {
            if (string2.equalsIgnoreCase(string3)) {
                return true;
            }
            if (string5.equalsIgnoreCase(string3.substring(1))) {
                return true;
            }
        } else if (string3.charAt(0) != '.' ? string5.equalsIgnoreCase(string3) : this.withinDomain(string5, string3)) {
            return true;
        }
        return false;
    }

    private boolean withinDomain(String stringArray, String string2) {
        if (string2.startsWith(".")) {
            string2 = string2.substring(1);
        }
        String[] stringArray2 = Strings.split(string2, '.');
        if ((stringArray = Strings.split((String)stringArray, '.')).length <= stringArray2.length) {
            return false;
        }
        int n3 = stringArray.length - stringArray2.length;
        for (int i3 = -1; i3 < stringArray2.length; ++i3) {
            if (!(i3 == -1 ? stringArray[i3 + n3].equals("") : !stringArray2[i3].equalsIgnoreCase(stringArray[i3 + n3]))) continue;
            return false;
        }
        return true;
    }

    private void checkPermittedDNS(Set set, String string2) {
        if (set == null) {
            return;
        }
        for (String string3 : set) {
            if (!this.withinDomain(string2, string3) && !string2.equalsIgnoreCase(string3)) continue;
            return;
        }
        if (string2.length() == 0 && set.size() == 0) {
            return;
        }
        throw new NameConstraintValidatorException("DNS is not from a permitted subtree.");
    }

    private void checkExcludedDNS(Set object, String string2) {
        if (object.isEmpty()) {
            return;
        }
        object = object.iterator();
        while (object.hasNext()) {
            String string3 = (String)object.next();
            if (!this.withinDomain(string2, string3) && !string2.equalsIgnoreCase(string3)) continue;
            throw new NameConstraintValidatorException("DNS is from an excluded subtree.");
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private void unionEmail(String string2, String string3, Set set) {
        block8: {
            block9: {
                block15: {
                    block10: {
                        block14: {
                            block11: {
                                block13: {
                                    block12: {
                                        block6: {
                                            String string4;
                                            block7: {
                                                if (string2.indexOf(64) == -1) break block6;
                                                String string5 = string2;
                                                string4 = string5.substring(string5.indexOf(64) + 1);
                                                if (string3.indexOf(64) == -1) break block7;
                                                if (!string2.equalsIgnoreCase(string3)) break block8;
                                                break block9;
                                            }
                                            if (!(string3.startsWith(".") ? this.withinDomain(string4, string3) : string4.equalsIgnoreCase(string3))) break block8;
                                            break block10;
                                        }
                                        if (!string2.startsWith(".")) break block11;
                                        if (string3.indexOf(64) == -1) break block12;
                                        if (!this.withinDomain(string3.substring(string2.indexOf(64) + 1), string2)) break block8;
                                        break block9;
                                    }
                                    if (!string3.startsWith(".")) break block13;
                                    if (this.withinDomain(string2, string3) || string2.equalsIgnoreCase(string3)) break block10;
                                    if (!this.withinDomain(string3, string2)) break block8;
                                    break block9;
                                }
                                if (!this.withinDomain(string3, string2)) break block8;
                                break block9;
                            }
                            if (string3.indexOf(64) == -1) break block14;
                            if (!string3.substring(string2.indexOf(64) + 1).equalsIgnoreCase(string2)) break block8;
                            break block9;
                        }
                        if (!string3.startsWith(".")) break block15;
                        if (!this.withinDomain(string2, string3)) break block8;
                    }
                    set.add(string3);
                    return;
                }
                if (!string2.equalsIgnoreCase(string3)) break block8;
            }
            set.add(string2);
            return;
        }
        Set set2 = set;
        set2.add(string2);
        set2.add(string3);
    }

    /*
     * Enabled aggressive block sorting
     */
    private void unionURI(String string2, String string3, Set set) {
        block8: {
            block9: {
                block15: {
                    block10: {
                        block14: {
                            block11: {
                                block13: {
                                    block12: {
                                        block6: {
                                            String string4;
                                            block7: {
                                                if (string2.indexOf(64) == -1) break block6;
                                                String string5 = string2;
                                                string4 = string5.substring(string5.indexOf(64) + 1);
                                                if (string3.indexOf(64) == -1) break block7;
                                                if (!string2.equalsIgnoreCase(string3)) break block8;
                                                break block9;
                                            }
                                            if (!(string3.startsWith(".") ? this.withinDomain(string4, string3) : string4.equalsIgnoreCase(string3))) break block8;
                                            break block10;
                                        }
                                        if (!string2.startsWith(".")) break block11;
                                        if (string3.indexOf(64) == -1) break block12;
                                        if (!this.withinDomain(string3.substring(string2.indexOf(64) + 1), string2)) break block8;
                                        break block9;
                                    }
                                    if (!string3.startsWith(".")) break block13;
                                    if (this.withinDomain(string2, string3) || string2.equalsIgnoreCase(string3)) break block10;
                                    if (!this.withinDomain(string3, string2)) break block8;
                                    break block9;
                                }
                                if (!this.withinDomain(string3, string2)) break block8;
                                break block9;
                            }
                            if (string3.indexOf(64) == -1) break block14;
                            if (!string3.substring(string2.indexOf(64) + 1).equalsIgnoreCase(string2)) break block8;
                            break block9;
                        }
                        if (!string3.startsWith(".")) break block15;
                        if (!this.withinDomain(string2, string3)) break block8;
                    }
                    set.add(string3);
                    return;
                }
                if (!string2.equalsIgnoreCase(string3)) break block8;
            }
            set.add(string2);
            return;
        }
        Set set2 = set;
        set2.add(string2);
        set2.add(string3);
    }

    private Set intersectDNS(Set set, Set set2) {
        HashSet hashSet;
        Set set3 = set2;
        set2 = hashSet;
        hashSet = new HashSet();
        Iterator iterator = set3.iterator();
        while (iterator.hasNext()) {
            String string2 = this.extractNameAsString(((GeneralSubtree)iterator.next()).getBase());
            if (set == null) {
                if (string2 == null) continue;
                ((HashSet)set2).add(string2);
                continue;
            }
            for (String string3 : set) {
                if (this.withinDomain(string3, string2)) {
                    ((HashSet)set2).add(string3);
                    continue;
                }
                if (!this.withinDomain(string2, string3)) continue;
                ((HashSet)set2).add(string2);
            }
        }
        return set2;
    }

    private Set unionDNS(Set set, String string2) {
        HashSet hashSet;
        if (set.isEmpty()) {
            if (string2 == null) {
                return set;
            }
            Set set2 = set;
            set2.add(string2);
            return set2;
        }
        Set set3 = set;
        set = hashSet;
        hashSet = new HashSet();
        for (String string3 : set3) {
            if (this.withinDomain(string3, string2)) {
                ((HashSet)set).add(string2);
                continue;
            }
            if (this.withinDomain(string2, string3)) {
                ((HashSet)set).add(string3);
                continue;
            }
            Set set4 = set;
            ((HashSet)set4).add(string3);
            ((HashSet)set4).add(string2);
        }
        return set;
    }

    /*
     * Enabled aggressive block sorting
     */
    private void intersectEmail(String string2, String string3, Set set) {
        block10: {
            block16: {
                block14: {
                    block12: {
                        block15: {
                            block13: {
                                block11: {
                                    if (string2.indexOf(64) == -1) break block11;
                                    String string4 = string2;
                                    String string5 = string4.substring(string4.indexOf(64) + 1);
                                    if (string3.indexOf(64) != -1) {
                                        if (!string2.equalsIgnoreCase(string3)) return;
                                        break block10;
                                    } else if (string3.startsWith(".")) {
                                        if (!this.withinDomain(string5, string3)) return;
                                        break block10;
                                    } else if (!string5.equalsIgnoreCase(string3)) return;
                                    break block10;
                                }
                                if (!string2.startsWith(".")) break block12;
                                if (string3.indexOf(64) == -1) break block13;
                                if (!this.withinDomain(string3.substring(string2.indexOf(64) + 1), string2)) return;
                                break block14;
                            }
                            if (!string3.startsWith(".")) break block15;
                            if (this.withinDomain(string2, string3) || string2.equalsIgnoreCase(string3)) break block10;
                            if (!this.withinDomain(string3, string2)) return;
                            break block14;
                        }
                        if (!this.withinDomain(string3, string2)) return;
                        break block14;
                    }
                    if (string3.indexOf(64) == -1) break block16;
                    String string6 = string3;
                    if (!string6.substring(string6.indexOf(64) + 1).equalsIgnoreCase(string2)) return;
                }
                set.add(string3);
                return;
            }
            if (string3.startsWith(".")) {
                if (!this.withinDomain(string2, string3)) return;
            } else if (!string2.equalsIgnoreCase(string3)) return;
        }
        set.add(string2);
    }

    private void checkExcludedURI(Set object, String string2) {
        if (object.isEmpty()) {
            return;
        }
        object = object.iterator();
        while (object.hasNext()) {
            if (!this.isUriConstrained(string2, (String)object.next())) continue;
            throw new NameConstraintValidatorException("URI is from an excluded subtree.");
        }
    }

    private Set intersectURI(Set set, Set set2) {
        HashSet hashSet;
        Set set3 = set2;
        set2 = hashSet;
        hashSet = new HashSet();
        Iterator iterator = set3.iterator();
        while (iterator.hasNext()) {
            String string2 = this.extractNameAsString(((GeneralSubtree)iterator.next()).getBase());
            if (set == null) {
                if (string2 == null) continue;
                ((HashSet)set2).add(string2);
                continue;
            }
            Iterator iterator2 = set.iterator();
            while (iterator2.hasNext()) {
                this.intersectURI((String)iterator2.next(), string2, set2);
            }
        }
        return set2;
    }

    private Set unionURI(Set set, String string2) {
        HashSet hashSet;
        if (set.isEmpty()) {
            if (string2 == null) {
                return set;
            }
            Set set2 = set;
            set2.add(string2);
            return set2;
        }
        Set set3 = set;
        set = hashSet;
        hashSet = new HashSet();
        Iterator iterator = set3.iterator();
        while (iterator.hasNext()) {
            this.unionURI((String)iterator.next(), string2, set);
        }
        return set;
    }

    /*
     * Enabled aggressive block sorting
     */
    private void intersectURI(String string2, String string3, Set set) {
        block10: {
            block16: {
                block14: {
                    block12: {
                        block15: {
                            block13: {
                                block11: {
                                    if (string2.indexOf(64) == -1) break block11;
                                    String string4 = string2;
                                    String string5 = string4.substring(string4.indexOf(64) + 1);
                                    if (string3.indexOf(64) != -1) {
                                        if (!string2.equalsIgnoreCase(string3)) return;
                                        break block10;
                                    } else if (string3.startsWith(".")) {
                                        if (!this.withinDomain(string5, string3)) return;
                                        break block10;
                                    } else if (!string5.equalsIgnoreCase(string3)) return;
                                    break block10;
                                }
                                if (!string2.startsWith(".")) break block12;
                                if (string3.indexOf(64) == -1) break block13;
                                if (!this.withinDomain(string3.substring(string2.indexOf(64) + 1), string2)) return;
                                break block14;
                            }
                            if (!string3.startsWith(".")) break block15;
                            if (this.withinDomain(string2, string3) || string2.equalsIgnoreCase(string3)) break block10;
                            if (!this.withinDomain(string3, string2)) return;
                            break block14;
                        }
                        if (!this.withinDomain(string3, string2)) return;
                        break block14;
                    }
                    if (string3.indexOf(64) == -1) break block16;
                    String string6 = string3;
                    if (!string6.substring(string6.indexOf(64) + 1).equalsIgnoreCase(string2)) return;
                }
                set.add(string3);
                return;
            }
            if (string3.startsWith(".")) {
                if (!this.withinDomain(string2, string3)) return;
            } else if (!string2.equalsIgnoreCase(string3)) return;
        }
        set.add(string2);
    }

    private void checkPermittedURI(Set set, String string2) {
        if (set == null) {
            return;
        }
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            if (!this.isUriConstrained(string2, (String)iterator.next())) continue;
            return;
        }
        if (string2.length() == 0 && set.size() == 0) {
            return;
        }
        throw new NameConstraintValidatorException("URI is not from a permitted subtree.");
    }

    private boolean isUriConstrained(String string2, String string3) {
        string2 = PKIXNameConstraintValidator.extractHostFromURL(string2);
        return !string3.startsWith(".") ? string2.equalsIgnoreCase(string3) : this.withinDomain(string2, string3);
    }

    private static String extractHostFromURL(String string2) {
        String string3 = string2;
        string2 = string3.substring(string3.indexOf(58) + 1);
        if (string2.indexOf("//") != -1) {
            String string4 = string2;
            string2 = string4.substring(string4.indexOf("//") + 2);
        }
        if (string2.lastIndexOf(58) != -1) {
            String string5 = string2;
            string2 = string5.substring(0, string5.lastIndexOf(58));
        }
        String string6 = string2;
        String string7 = string6.substring(string6.indexOf(58) + 1);
        string2 = string7.substring(string7.indexOf(64) + 1);
        if (string2.indexOf(47) != -1) {
            String string8 = string2;
            string2 = string8.substring(0, string8.indexOf(47));
        }
        return string2;
    }

    private String extractNameAsString(GeneralName generalName) {
        return DERIA5String.getInstance(generalName.getName()).getString();
    }

    private static byte[] max(byte[] byArray, byte[] byArray2) {
        for (int i3 = 0; i3 < byArray.length; ++i3) {
            if ((byArray[i3] & 0xFFFF) <= (byArray2[i3] & 0xFFFF)) continue;
            return byArray;
        }
        return byArray2;
    }

    private static byte[] min(byte[] byArray, byte[] byArray2) {
        for (int i3 = 0; i3 < byArray.length; ++i3) {
            if ((byArray[i3] & 0xFFFF) >= (byArray2[i3] & 0xFFFF)) continue;
            return byArray;
        }
        return byArray2;
    }

    private static int compareTo(byte[] byArray, byte[] byArray2) {
        if (Arrays.areEqual(byArray, byArray2)) {
            return 0;
        }
        if (Arrays.areEqual(PKIXNameConstraintValidator.max(byArray, byArray2), byArray)) {
            return 1;
        }
        return -1;
    }

    private static byte[] or(byte[] byArray, byte[] byArray2) {
        byte[] byArray3 = new byte[byArray.length];
        for (int i3 = 0; i3 < byArray.length; ++i3) {
            byArray3[i3] = (byte)(byArray[i3] | byArray2[i3]);
        }
        return byArray3;
    }

    private int hashCollection(Collection object) {
        if (object == null) {
            return 0;
        }
        int n3 = 0;
        object = object.iterator();
        while (object.hasNext()) {
            Object e3 = object.next();
            if (e3 instanceof byte[]) {
                n3 = Arrays.hashCode((byte[])e3) + n3;
                continue;
            }
            n3 = e3.hashCode() + n3;
        }
        return n3;
    }

    private boolean collectionsAreEqual(Collection object, Collection collection) {
        if (object == collection) {
            return true;
        }
        if (object != null && collection != null) {
            if (object.size() != collection.size()) {
                return false;
            }
            object = object.iterator();
            while (object.hasNext()) {
                Object e3 = object.next();
                Iterator iterator = collection.iterator();
                boolean bl = false;
                while (iterator.hasNext()) {
                    if (!this.equals(e3, iterator.next())) continue;
                    bl = true;
                    break;
                }
                if (bl) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    private boolean equals(Object object, Object object2) {
        if (object == object2) {
            return true;
        }
        if (object != null && object2 != null) {
            if (object instanceof byte[] && object2 instanceof byte[]) {
                return Arrays.areEqual((byte[])object, (byte[])object2);
            }
            return object.equals(object2);
        }
        return false;
    }

    private String stringifyIP(byte[] byArray) {
        int n3;
        StringBuilder stringBuilder;
        StringBuilder stringBuilder2 = stringBuilder;
        stringBuilder = new StringBuilder();
        for (n3 = 0; n3 < byArray.length / 2; ++n3) {
            if (stringBuilder2.length() > 0) {
                stringBuilder2.append(".");
            }
            stringBuilder2.append(Integer.toString(byArray[n3] & 0xFF));
        }
        stringBuilder2.append("/");
        n3 = 1;
        for (int i3 = byArray.length / 2; i3 < byArray.length; ++i3) {
            if (n3 != 0) {
                n3 = 0;
            } else {
                stringBuilder2.append(".");
            }
            stringBuilder2.append(Integer.toString(byArray[i3] & 0xFF));
        }
        return stringBuilder2.toString();
    }

    private String stringifyIPCollection(Set object) {
        StringBuilder stringBuilder;
        Set set = object;
        object = stringBuilder;
        new StringBuilder().append("[");
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            if (((StringBuilder)object).length() > 1) {
                ((StringBuilder)object).append(",");
            }
            ((StringBuilder)object).append(this.stringifyIP((byte[])iterator.next()));
        }
        Object object2 = object;
        ((StringBuilder)object2).append("]");
        return ((StringBuilder)object2).toString();
    }

    private String stringifyOtherNameCollection(Set object) {
        StringBuilder stringBuilder;
        StringBuilder stringBuilder2 = stringBuilder;
        new StringBuilder().append("[");
        object = object.iterator();
        while (object.hasNext()) {
            if (stringBuilder2.length() > 1) {
                stringBuilder2.append(",");
            }
            StringBuilder stringBuilder3 = stringBuilder2;
            OtherName otherName = OtherName.getInstance(object.next());
            stringBuilder3.append(otherName.getTypeID().getId());
            stringBuilder3.append(":");
            try {
                stringBuilder3.append(Hex.toHexString(otherName.getValue().toASN1Primitive().getEncoded()));
            }
            catch (IOException iOException) {
                stringBuilder2.append(((Object)iOException).toString());
            }
        }
        StringBuilder stringBuilder4 = stringBuilder2;
        stringBuilder4.append("]");
        return stringBuilder4.toString();
    }

    private final void addLine(StringBuilder stringBuilder, String string2) {
        stringBuilder.append(string2).append(Strings.lineSeparator());
    }

    @Override
    public void checkPermitted(GeneralName generalName) {
        switch (generalName.getTagNo()) {
            default: {
                break;
            }
            case 7: {
                PKIXNameConstraintValidator pKIXNameConstraintValidator = object;
                pKIXNameConstraintValidator.checkPermittedIP(pKIXNameConstraintValidator.permittedSubtreesIP, ASN1OctetString.getInstance(generalName.getName()).getOctets());
                break;
            }
            case 6: {
                PKIXNameConstraintValidator pKIXNameConstraintValidator = object;
                Object object = pKIXNameConstraintValidator.permittedSubtreesURI;
                pKIXNameConstraintValidator.checkPermittedURI((Set)object, pKIXNameConstraintValidator.extractNameAsString(generalName));
                break;
            }
            case 4: {
                ((PKIXNameConstraintValidator)object).checkPermittedDN(X500Name.getInstance(generalName.getName()));
                break;
            }
            case 2: {
                PKIXNameConstraintValidator pKIXNameConstraintValidator = object;
                Object object = pKIXNameConstraintValidator.permittedSubtreesDNS;
                pKIXNameConstraintValidator.checkPermittedDNS((Set)object, pKIXNameConstraintValidator.extractNameAsString(generalName));
                break;
            }
            case 1: {
                PKIXNameConstraintValidator pKIXNameConstraintValidator = object;
                Object object = pKIXNameConstraintValidator.permittedSubtreesEmail;
                pKIXNameConstraintValidator.checkPermittedEmail((Set)object, pKIXNameConstraintValidator.extractNameAsString(generalName));
                break;
            }
            case 0: {
                PKIXNameConstraintValidator pKIXNameConstraintValidator = object;
                pKIXNameConstraintValidator.checkPermittedOtherName(pKIXNameConstraintValidator.permittedSubtreesOtherName, OtherName.getInstance(generalName.getName()));
            }
        }
    }

    @Override
    public void checkExcluded(GeneralName generalName) {
        switch (generalName.getTagNo()) {
            default: {
                break;
            }
            case 7: {
                PKIXNameConstraintValidator pKIXNameConstraintValidator = object;
                pKIXNameConstraintValidator.checkExcludedIP(pKIXNameConstraintValidator.excludedSubtreesIP, ASN1OctetString.getInstance(generalName.getName()).getOctets());
                break;
            }
            case 6: {
                PKIXNameConstraintValidator pKIXNameConstraintValidator = object;
                Object object = pKIXNameConstraintValidator.excludedSubtreesURI;
                pKIXNameConstraintValidator.checkExcludedURI((Set)object, pKIXNameConstraintValidator.extractNameAsString(generalName));
                break;
            }
            case 4: {
                ((PKIXNameConstraintValidator)object).checkExcludedDN(X500Name.getInstance(generalName.getName()));
                break;
            }
            case 2: {
                PKIXNameConstraintValidator pKIXNameConstraintValidator = object;
                Object object = pKIXNameConstraintValidator.excludedSubtreesDNS;
                pKIXNameConstraintValidator.checkExcludedDNS((Set)object, pKIXNameConstraintValidator.extractNameAsString(generalName));
                break;
            }
            case 1: {
                PKIXNameConstraintValidator pKIXNameConstraintValidator = object;
                Object object = pKIXNameConstraintValidator.excludedSubtreesEmail;
                pKIXNameConstraintValidator.checkExcludedEmail((Set)object, pKIXNameConstraintValidator.extractNameAsString(generalName));
                break;
            }
            case 0: {
                PKIXNameConstraintValidator pKIXNameConstraintValidator = object;
                pKIXNameConstraintValidator.checkExcludedOtherName(pKIXNameConstraintValidator.excludedSubtreesOtherName, OtherName.getInstance(generalName.getName()));
            }
        }
    }

    @Override
    public void intersectPermittedSubtree(GeneralSubtree generalSubtree) {
        GeneralSubtree[] generalSubtreeArray = generalSubtreeArray3;
        GeneralSubtree[] generalSubtreeArray2 = new GeneralSubtree[1];
        GeneralSubtree[] generalSubtreeArray3 = generalSubtreeArray2;
        generalSubtreeArray2[0] = generalSubtree;
        generalSubtreeArray.intersectPermittedSubtree(generalSubtreeArray3);
    }

    @Override
    public void intersectPermittedSubtree(GeneralSubtree[] object) {
        int n3;
        HashMap hashMap;
        HashMap object22 = hashMap;
        hashMap = new HashMap();
        for (n3 = 0; n3 != ((Object)object).length; ++n3) {
            Object object2 = object[n3];
            Integer n4 = Integers.valueOf(((GeneralSubtree)object2).getBase().getTagNo());
            if (object22.get(n4) == null) {
                HashSet hashSet;
                HashSet hashSet2 = hashSet;
                hashSet = new HashSet();
                object22.put(n4, hashSet2);
            }
            ((Set)object22.get(n4)).add(object2);
        }
        block9: for (Map.Entry entry : object22.entrySet()) {
            n3 = (Integer)entry.getKey();
            switch (n3) {
                default: {
                    throw new IllegalStateException(a.a("Unknown tag encountered: ", n3));
                }
                case 7: {
                    PKIXNameConstraintValidator pKIXNameConstraintValidator = this;
                    pKIXNameConstraintValidator.permittedSubtreesIP = pKIXNameConstraintValidator.intersectIP(pKIXNameConstraintValidator.permittedSubtreesIP, (Set)entry.getValue());
                    continue block9;
                }
                case 6: {
                    PKIXNameConstraintValidator pKIXNameConstraintValidator = this;
                    pKIXNameConstraintValidator.permittedSubtreesURI = pKIXNameConstraintValidator.intersectURI(pKIXNameConstraintValidator.permittedSubtreesURI, (Set)entry.getValue());
                    continue block9;
                }
                case 4: {
                    PKIXNameConstraintValidator pKIXNameConstraintValidator = this;
                    pKIXNameConstraintValidator.permittedSubtreesDN = pKIXNameConstraintValidator.intersectDN(pKIXNameConstraintValidator.permittedSubtreesDN, (Set)entry.getValue());
                    continue block9;
                }
                case 2: {
                    PKIXNameConstraintValidator pKIXNameConstraintValidator = this;
                    pKIXNameConstraintValidator.permittedSubtreesDNS = pKIXNameConstraintValidator.intersectDNS(pKIXNameConstraintValidator.permittedSubtreesDNS, (Set)entry.getValue());
                    continue block9;
                }
                case 1: {
                    PKIXNameConstraintValidator pKIXNameConstraintValidator = this;
                    pKIXNameConstraintValidator.permittedSubtreesEmail = pKIXNameConstraintValidator.intersectEmail(pKIXNameConstraintValidator.permittedSubtreesEmail, (Set)entry.getValue());
                    continue block9;
                }
                case 0: 
            }
            PKIXNameConstraintValidator pKIXNameConstraintValidator = this;
            pKIXNameConstraintValidator.permittedSubtreesOtherName = pKIXNameConstraintValidator.intersectOtherName(pKIXNameConstraintValidator.permittedSubtreesOtherName, (Set)entry.getValue());
        }
    }

    @Override
    public void intersectEmptyPermittedSubtree(int n3) {
        switch (n3) {
            default: {
                throw new IllegalStateException(a.a("Unknown tag encountered: ", n3));
            }
            case 7: {
                HashSet hashSet;
                PKIXNameConstraintValidator pKIXNameConstraintValidator = object;
                Object object = hashSet;
                hashSet = new HashSet();
                pKIXNameConstraintValidator.permittedSubtreesIP = object;
                break;
            }
            case 6: {
                HashSet hashSet;
                PKIXNameConstraintValidator pKIXNameConstraintValidator = object;
                Object object = hashSet;
                hashSet = new HashSet();
                pKIXNameConstraintValidator.permittedSubtreesURI = object;
                break;
            }
            case 4: {
                HashSet hashSet;
                PKIXNameConstraintValidator pKIXNameConstraintValidator = object;
                Object object = hashSet;
                hashSet = new HashSet();
                pKIXNameConstraintValidator.permittedSubtreesDN = object;
                break;
            }
            case 2: {
                HashSet hashSet;
                PKIXNameConstraintValidator pKIXNameConstraintValidator = object;
                Object object = hashSet;
                hashSet = new HashSet();
                pKIXNameConstraintValidator.permittedSubtreesDNS = object;
                break;
            }
            case 1: {
                HashSet hashSet;
                PKIXNameConstraintValidator pKIXNameConstraintValidator = object;
                Object object = hashSet;
                hashSet = new HashSet();
                pKIXNameConstraintValidator.permittedSubtreesEmail = object;
                break;
            }
            case 0: {
                HashSet hashSet;
                PKIXNameConstraintValidator pKIXNameConstraintValidator = object;
                Object object = hashSet;
                hashSet = new HashSet();
                pKIXNameConstraintValidator.permittedSubtreesOtherName = object;
            }
        }
    }

    @Override
    public void addExcludedSubtree(GeneralSubtree aSN1Object) {
        aSN1Object = ((GeneralSubtree)aSN1Object).getBase();
        switch (((GeneralName)aSN1Object).getTagNo()) {
            default: {
                throw new IllegalStateException(b.a("Unknown tag encountered: ").append(((GeneralName)aSN1Object).getTagNo()).toString());
            }
            case 7: {
                PKIXNameConstraintValidator pKIXNameConstraintValidator = object;
                pKIXNameConstraintValidator.excludedSubtreesIP = pKIXNameConstraintValidator.unionIP(pKIXNameConstraintValidator.excludedSubtreesIP, ASN1OctetString.getInstance(((GeneralName)aSN1Object).getName()).getOctets());
                break;
            }
            case 6: {
                PKIXNameConstraintValidator pKIXNameConstraintValidator = object;
                Object object = ((PKIXNameConstraintValidator)object).excludedSubtreesURI;
                pKIXNameConstraintValidator.excludedSubtreesURI = pKIXNameConstraintValidator.unionURI((Set)object, pKIXNameConstraintValidator.extractNameAsString((GeneralName)aSN1Object));
                break;
            }
            case 4: {
                PKIXNameConstraintValidator pKIXNameConstraintValidator = object;
                pKIXNameConstraintValidator.excludedSubtreesDN = pKIXNameConstraintValidator.unionDN(pKIXNameConstraintValidator.excludedSubtreesDN, (ASN1Sequence)((GeneralName)aSN1Object).getName().toASN1Primitive());
                break;
            }
            case 2: {
                PKIXNameConstraintValidator pKIXNameConstraintValidator = object;
                Object object = ((PKIXNameConstraintValidator)object).excludedSubtreesDNS;
                pKIXNameConstraintValidator.excludedSubtreesDNS = pKIXNameConstraintValidator.unionDNS((Set)object, pKIXNameConstraintValidator.extractNameAsString((GeneralName)aSN1Object));
                break;
            }
            case 1: {
                PKIXNameConstraintValidator pKIXNameConstraintValidator = object;
                Object object = ((PKIXNameConstraintValidator)object).excludedSubtreesEmail;
                pKIXNameConstraintValidator.excludedSubtreesEmail = pKIXNameConstraintValidator.unionEmail((Set)object, pKIXNameConstraintValidator.extractNameAsString((GeneralName)aSN1Object));
                break;
            }
            case 0: {
                PKIXNameConstraintValidator pKIXNameConstraintValidator = object;
                pKIXNameConstraintValidator.excludedSubtreesOtherName = pKIXNameConstraintValidator.unionOtherName(pKIXNameConstraintValidator.excludedSubtreesOtherName, OtherName.getInstance(((GeneralName)aSN1Object).getName()));
            }
        }
    }

    public int hashCode() {
        PKIXNameConstraintValidator pKIXNameConstraintValidator = this;
        PKIXNameConstraintValidator pKIXNameConstraintValidator2 = this;
        PKIXNameConstraintValidator pKIXNameConstraintValidator3 = this;
        PKIXNameConstraintValidator pKIXNameConstraintValidator4 = this;
        PKIXNameConstraintValidator pKIXNameConstraintValidator5 = this;
        PKIXNameConstraintValidator pKIXNameConstraintValidator6 = this;
        PKIXNameConstraintValidator pKIXNameConstraintValidator7 = this;
        PKIXNameConstraintValidator pKIXNameConstraintValidator8 = this;
        PKIXNameConstraintValidator pKIXNameConstraintValidator9 = this;
        PKIXNameConstraintValidator pKIXNameConstraintValidator10 = this;
        PKIXNameConstraintValidator pKIXNameConstraintValidator11 = this;
        PKIXNameConstraintValidator pKIXNameConstraintValidator12 = this;
        return pKIXNameConstraintValidator.hashCollection(pKIXNameConstraintValidator.excludedSubtreesDN) + pKIXNameConstraintValidator2.hashCollection(pKIXNameConstraintValidator2.excludedSubtreesDNS) + pKIXNameConstraintValidator3.hashCollection(pKIXNameConstraintValidator3.excludedSubtreesEmail) + pKIXNameConstraintValidator4.hashCollection(pKIXNameConstraintValidator4.excludedSubtreesIP) + pKIXNameConstraintValidator5.hashCollection(pKIXNameConstraintValidator5.excludedSubtreesURI) + pKIXNameConstraintValidator6.hashCollection(pKIXNameConstraintValidator6.excludedSubtreesOtherName) + pKIXNameConstraintValidator7.hashCollection(pKIXNameConstraintValidator7.permittedSubtreesDN) + pKIXNameConstraintValidator8.hashCollection(pKIXNameConstraintValidator8.permittedSubtreesDNS) + pKIXNameConstraintValidator9.hashCollection(pKIXNameConstraintValidator9.permittedSubtreesEmail) + pKIXNameConstraintValidator10.hashCollection(pKIXNameConstraintValidator10.permittedSubtreesIP) + pKIXNameConstraintValidator11.hashCollection(pKIXNameConstraintValidator11.permittedSubtreesURI) + pKIXNameConstraintValidator12.hashCollection(pKIXNameConstraintValidator12.permittedSubtreesOtherName);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object object) {
        if (!(object instanceof PKIXNameConstraintValidator)) {
            return false;
        }
        PKIXNameConstraintValidator pKIXNameConstraintValidator = set2;
        object = (PKIXNameConstraintValidator)object;
        Set set = ((PKIXNameConstraintValidator)object).excludedSubtreesDN;
        if (!pKIXNameConstraintValidator.collectionsAreEqual(set, pKIXNameConstraintValidator.excludedSubtreesDN)) return false;
        PKIXNameConstraintValidator pKIXNameConstraintValidator2 = set2;
        set = ((PKIXNameConstraintValidator)object).excludedSubtreesDNS;
        if (!pKIXNameConstraintValidator2.collectionsAreEqual(set, pKIXNameConstraintValidator2.excludedSubtreesDNS)) return false;
        PKIXNameConstraintValidator pKIXNameConstraintValidator3 = set2;
        set = ((PKIXNameConstraintValidator)object).excludedSubtreesEmail;
        if (!pKIXNameConstraintValidator3.collectionsAreEqual(set, pKIXNameConstraintValidator3.excludedSubtreesEmail)) return false;
        PKIXNameConstraintValidator pKIXNameConstraintValidator4 = set2;
        set = ((PKIXNameConstraintValidator)object).excludedSubtreesIP;
        if (!pKIXNameConstraintValidator4.collectionsAreEqual(set, pKIXNameConstraintValidator4.excludedSubtreesIP)) return false;
        PKIXNameConstraintValidator pKIXNameConstraintValidator5 = set2;
        set = ((PKIXNameConstraintValidator)object).excludedSubtreesURI;
        if (!pKIXNameConstraintValidator5.collectionsAreEqual(set, pKIXNameConstraintValidator5.excludedSubtreesURI)) return false;
        PKIXNameConstraintValidator pKIXNameConstraintValidator6 = set2;
        set = ((PKIXNameConstraintValidator)object).excludedSubtreesOtherName;
        if (!pKIXNameConstraintValidator6.collectionsAreEqual(set, pKIXNameConstraintValidator6.excludedSubtreesOtherName)) return false;
        PKIXNameConstraintValidator pKIXNameConstraintValidator7 = set2;
        set = ((PKIXNameConstraintValidator)object).permittedSubtreesDN;
        if (!pKIXNameConstraintValidator7.collectionsAreEqual(set, pKIXNameConstraintValidator7.permittedSubtreesDN)) return false;
        PKIXNameConstraintValidator pKIXNameConstraintValidator8 = set2;
        set = ((PKIXNameConstraintValidator)object).permittedSubtreesDNS;
        if (!pKIXNameConstraintValidator8.collectionsAreEqual(set, pKIXNameConstraintValidator8.permittedSubtreesDNS)) return false;
        PKIXNameConstraintValidator pKIXNameConstraintValidator9 = set2;
        set = ((PKIXNameConstraintValidator)object).permittedSubtreesEmail;
        if (!pKIXNameConstraintValidator9.collectionsAreEqual(set, pKIXNameConstraintValidator9.permittedSubtreesEmail)) return false;
        PKIXNameConstraintValidator pKIXNameConstraintValidator10 = set2;
        set = ((PKIXNameConstraintValidator)object).permittedSubtreesIP;
        if (!pKIXNameConstraintValidator10.collectionsAreEqual(set, pKIXNameConstraintValidator10.permittedSubtreesIP)) return false;
        PKIXNameConstraintValidator pKIXNameConstraintValidator11 = set2;
        set = ((PKIXNameConstraintValidator)object).permittedSubtreesURI;
        if (!pKIXNameConstraintValidator11.collectionsAreEqual(set, pKIXNameConstraintValidator11.permittedSubtreesURI)) return false;
        PKIXNameConstraintValidator pKIXNameConstraintValidator12 = set2;
        Set set2 = ((PKIXNameConstraintValidator)object).permittedSubtreesOtherName;
        if (!pKIXNameConstraintValidator12.collectionsAreEqual(set2, pKIXNameConstraintValidator12.permittedSubtreesOtherName)) return false;
        return true;
    }

    public void checkPermittedDN(X500Name x500Name) {
        PKIXNameConstraintValidator pKIXNameConstraintValidator = this;
        pKIXNameConstraintValidator.checkPermittedDN(pKIXNameConstraintValidator.permittedSubtreesDN, ASN1Sequence.getInstance(x500Name.toASN1Primitive()));
    }

    public void checkExcludedDN(X500Name x500Name) {
        PKIXNameConstraintValidator pKIXNameConstraintValidator = set;
        Set set = ((PKIXNameConstraintValidator)((Object)set)).excludedSubtreesDN;
        pKIXNameConstraintValidator.checkExcludedDN(set, ASN1Sequence.getInstance(x500Name));
    }

    public String toString() {
        StringBuilder stringBuilder;
        PKIXNameConstraintValidator pKIXNameConstraintValidator = this;
        StringBuilder stringBuilder2 = stringBuilder;
        pKIXNameConstraintValidator.addLine(new StringBuilder(), "permitted:");
        if (pKIXNameConstraintValidator.permittedSubtreesDN != null) {
            PKIXNameConstraintValidator pKIXNameConstraintValidator2 = this;
            pKIXNameConstraintValidator2.addLine(stringBuilder2, "DN:");
            this.addLine(stringBuilder2, pKIXNameConstraintValidator2.permittedSubtreesDN.toString());
        }
        if (this.permittedSubtreesDNS != null) {
            PKIXNameConstraintValidator pKIXNameConstraintValidator3 = this;
            pKIXNameConstraintValidator3.addLine(stringBuilder2, "DNS:");
            this.addLine(stringBuilder2, pKIXNameConstraintValidator3.permittedSubtreesDNS.toString());
        }
        if (this.permittedSubtreesEmail != null) {
            PKIXNameConstraintValidator pKIXNameConstraintValidator4 = this;
            pKIXNameConstraintValidator4.addLine(stringBuilder2, "Email:");
            this.addLine(stringBuilder2, pKIXNameConstraintValidator4.permittedSubtreesEmail.toString());
        }
        if (this.permittedSubtreesURI != null) {
            PKIXNameConstraintValidator pKIXNameConstraintValidator5 = this;
            pKIXNameConstraintValidator5.addLine(stringBuilder2, "URI:");
            this.addLine(stringBuilder2, pKIXNameConstraintValidator5.permittedSubtreesURI.toString());
        }
        if (this.permittedSubtreesIP != null) {
            PKIXNameConstraintValidator pKIXNameConstraintValidator6 = this;
            pKIXNameConstraintValidator6.addLine(stringBuilder2, "IP:");
            this.addLine(stringBuilder2, pKIXNameConstraintValidator6.stringifyIPCollection(pKIXNameConstraintValidator6.permittedSubtreesIP));
        }
        if (this.permittedSubtreesOtherName != null) {
            PKIXNameConstraintValidator pKIXNameConstraintValidator7 = this;
            pKIXNameConstraintValidator7.addLine(stringBuilder2, "OtherName:");
            this.addLine(stringBuilder2, pKIXNameConstraintValidator7.stringifyOtherNameCollection(pKIXNameConstraintValidator7.permittedSubtreesOtherName));
        }
        PKIXNameConstraintValidator pKIXNameConstraintValidator8 = this;
        pKIXNameConstraintValidator8.addLine(stringBuilder2, "excluded:");
        if (!pKIXNameConstraintValidator8.excludedSubtreesDN.isEmpty()) {
            PKIXNameConstraintValidator pKIXNameConstraintValidator9 = this;
            pKIXNameConstraintValidator9.addLine(stringBuilder2, "DN:");
            this.addLine(stringBuilder2, pKIXNameConstraintValidator9.excludedSubtreesDN.toString());
        }
        if (!this.excludedSubtreesDNS.isEmpty()) {
            PKIXNameConstraintValidator pKIXNameConstraintValidator10 = this;
            pKIXNameConstraintValidator10.addLine(stringBuilder2, "DNS:");
            this.addLine(stringBuilder2, pKIXNameConstraintValidator10.excludedSubtreesDNS.toString());
        }
        if (!this.excludedSubtreesEmail.isEmpty()) {
            PKIXNameConstraintValidator pKIXNameConstraintValidator11 = this;
            pKIXNameConstraintValidator11.addLine(stringBuilder2, "Email:");
            this.addLine(stringBuilder2, pKIXNameConstraintValidator11.excludedSubtreesEmail.toString());
        }
        if (!this.excludedSubtreesURI.isEmpty()) {
            PKIXNameConstraintValidator pKIXNameConstraintValidator12 = this;
            pKIXNameConstraintValidator12.addLine(stringBuilder2, "URI:");
            this.addLine(stringBuilder2, pKIXNameConstraintValidator12.excludedSubtreesURI.toString());
        }
        if (!this.excludedSubtreesIP.isEmpty()) {
            PKIXNameConstraintValidator pKIXNameConstraintValidator13 = this;
            pKIXNameConstraintValidator13.addLine(stringBuilder2, "IP:");
            this.addLine(stringBuilder2, pKIXNameConstraintValidator13.stringifyIPCollection(pKIXNameConstraintValidator13.excludedSubtreesIP));
        }
        if (!this.excludedSubtreesOtherName.isEmpty()) {
            PKIXNameConstraintValidator pKIXNameConstraintValidator14 = this;
            pKIXNameConstraintValidator14.addLine(stringBuilder2, "OtherName:");
            this.addLine(stringBuilder2, pKIXNameConstraintValidator14.stringifyOtherNameCollection(pKIXNameConstraintValidator14.excludedSubtreesOtherName));
        }
        return stringBuilder2.toString();
    }
}

