/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.asn1.x509;

import c.b;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1EncodableVector;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1GeneralizedTime;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Integer;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Object;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Primitive;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Sequence;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1TaggedObject;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1UTCTime;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.DERSequence;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.DERTaggedObject;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.x500.X500Name;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.x509.AlgorithmIdentifier;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.x509.Extensions;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.x509.Time;
import java.util.Enumeration;
import java.util.NoSuchElementException;

public class TBSCertList
extends ASN1Object {
    public ASN1Integer version;
    public AlgorithmIdentifier signature;
    public X500Name issuer;
    public Time thisUpdate;
    public Time nextUpdate;
    public ASN1Sequence revokedCertificates;
    public Extensions crlExtensions;

    public static TBSCertList getInstance(ASN1TaggedObject aSN1TaggedObject, boolean bl) {
        return TBSCertList.getInstance(ASN1Sequence.getInstance(aSN1TaggedObject, bl));
    }

    public static TBSCertList getInstance(Object object) {
        if (object instanceof TBSCertList) {
            return (TBSCertList)object;
        }
        if (object != null) {
            return new TBSCertList(ASN1Sequence.getInstance(object));
        }
        return null;
    }

    public TBSCertList(ASN1Sequence aSN1Sequence) {
        if (aSN1Sequence.size() >= 3 && aSN1Sequence.size() <= 7) {
            int n3 = 0;
            if (aSN1Sequence.getObjectAt(0) instanceof ASN1Integer) {
                int n4 = n3;
                n3 = 1;
                this.version = ASN1Integer.getInstance(aSN1Sequence.getObjectAt(n4));
            } else {
                this.version = null;
            }
            this.signature = AlgorithmIdentifier.getInstance(aSN1Sequence.getObjectAt(n3++));
            this.issuer = X500Name.getInstance(aSN1Sequence.getObjectAt(n3++));
            int n5 = n3 + 1;
            this.thisUpdate = Time.getInstance(aSN1Sequence.getObjectAt(n3));
            if (n5 < aSN1Sequence.size() && (aSN1Sequence.getObjectAt(n5) instanceof ASN1UTCTime || aSN1Sequence.getObjectAt(n5) instanceof ASN1GeneralizedTime || aSN1Sequence.getObjectAt(n5) instanceof Time)) {
                this.nextUpdate = Time.getInstance(aSN1Sequence.getObjectAt(n5++));
            }
            if (n5 < aSN1Sequence.size() && !(aSN1Sequence.getObjectAt(n5) instanceof ASN1TaggedObject)) {
                this.revokedCertificates = ASN1Sequence.getInstance(aSN1Sequence.getObjectAt(n5++));
            }
            if (n5 < aSN1Sequence.size() && aSN1Sequence.getObjectAt(n5) instanceof ASN1TaggedObject) {
                this.crlExtensions = Extensions.getInstance(ASN1Sequence.getInstance((ASN1TaggedObject)aSN1Sequence.getObjectAt(n5), true));
            }
            return;
        }
        throw new IllegalArgumentException(b.a(aSN1Sequence, b.b.a("Bad sequence size: ")));
    }

    public int getVersionNumber() {
        ASN1Object aSN1Object = ((TBSCertList)aSN1Object).version;
        if (aSN1Object == null) {
            return 1;
        }
        return ((ASN1Integer)aSN1Object).intValueExact() + 1;
    }

    public ASN1Integer getVersion() {
        return this.version;
    }

    public AlgorithmIdentifier getSignature() {
        return this.signature;
    }

    public X500Name getIssuer() {
        return this.issuer;
    }

    public Time getThisUpdate() {
        return this.thisUpdate;
    }

    public Time getNextUpdate() {
        return this.nextUpdate;
    }

    public CRLEntry[] getRevokedCertificates() {
        ASN1Sequence aSN1Sequence = this.revokedCertificates;
        if (aSN1Sequence == null) {
            return new CRLEntry[0];
        }
        int n3 = aSN1Sequence.size();
        CRLEntry[] cRLEntryArray = new CRLEntry[n3];
        for (int i3 = 0; i3 < n3; ++i3) {
            cRLEntryArray[i3] = CRLEntry.getInstance(this.revokedCertificates.getObjectAt(i3));
        }
        return cRLEntryArray;
    }

    public Enumeration getRevokedCertificateEnumeration() {
        ASN1Sequence aSN1Sequence = this.revokedCertificates;
        if (aSN1Sequence == null) {
            return new EmptyEnumeration(null);
        }
        return new RevokedCertificatesEnumeration(aSN1Sequence.getObjects());
    }

    public Extensions getExtensions() {
        return this.crlExtensions;
    }

    @Override
    public ASN1Primitive toASN1Primitive() {
        Extensions extensions;
        ASN1EncodableVector aSN1EncodableVector;
        ASN1EncodableVector aSN1EncodableVector2 = aSN1EncodableVector;
        aSN1EncodableVector = new ASN1EncodableVector(7);
        ASN1Object aSN1Object = this.version;
        if (aSN1Object != null) {
            aSN1EncodableVector2.add(aSN1Object);
        }
        aSN1EncodableVector2.add(this.signature);
        aSN1EncodableVector2.add(this.issuer);
        aSN1EncodableVector2.add(this.thisUpdate);
        aSN1Object = this.nextUpdate;
        if (aSN1Object != null) {
            aSN1EncodableVector2.add(aSN1Object);
        }
        if ((aSN1Object = this.revokedCertificates) != null) {
            aSN1EncodableVector2.add(aSN1Object);
        }
        if ((extensions = this.crlExtensions) != null) {
            DERTaggedObject dERTaggedObject;
            aSN1Object = dERTaggedObject;
            dERTaggedObject = new DERTaggedObject(0, extensions);
            aSN1EncodableVector2.add(aSN1Object);
        }
        return new DERSequence(aSN1EncodableVector2);
    }

    public class EmptyEnumeration
    implements Enumeration {
        private EmptyEnumeration() {
        }

        public /* synthetic */ EmptyEnumeration(1 var2_2) {
            this();
        }

        @Override
        public boolean hasMoreElements() {
            return false;
        }

        public Object nextElement() {
            throw new NoSuchElementException("Empty Enumeration");
        }
    }

    public class RevokedCertificatesEnumeration
    implements Enumeration {
        private final Enumeration en;

        public RevokedCertificatesEnumeration(Enumeration enumeration) {
            this.en = enumeration;
        }

        @Override
        public boolean hasMoreElements() {
            return this.en.hasMoreElements();
        }

        public Object nextElement() {
            return CRLEntry.getInstance(this.en.nextElement());
        }
    }

    public static class CRLEntry
    extends ASN1Object {
        public ASN1Sequence seq;
        public Extensions crlEntryExtensions;

        private CRLEntry(ASN1Sequence aSN1Sequence) {
            if (aSN1Sequence.size() >= 2 && aSN1Sequence.size() <= 3) {
                this.seq = aSN1Sequence;
                return;
            }
            throw new IllegalArgumentException(b.a(aSN1Sequence, b.b.a("Bad sequence size: ")));
        }

        public static CRLEntry getInstance(Object object) {
            if (object instanceof CRLEntry) {
                return (CRLEntry)object;
            }
            if (object != null) {
                return new CRLEntry(ASN1Sequence.getInstance(object));
            }
            return null;
        }

        public ASN1Integer getUserCertificate() {
            return ASN1Integer.getInstance(this.seq.getObjectAt(0));
        }

        public Time getRevocationDate() {
            return Time.getInstance(this.seq.getObjectAt(1));
        }

        public Extensions getExtensions() {
            if (this.crlEntryExtensions == null && this.seq.size() == 3) {
                this.crlEntryExtensions = Extensions.getInstance(this.seq.getObjectAt(2));
            }
            return this.crlEntryExtensions;
        }

        @Override
        public ASN1Primitive toASN1Primitive() {
            return this.seq;
        }

        public boolean hasExtensions() {
            return this.seq.size() == 3;
        }
    }
}

