/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.asn1.x509;

import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Integer;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Object;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Primitive;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Sequence;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1TaggedObject;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.DERBitString;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.x500.X500Name;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.x509.AlgorithmIdentifier;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.x509.Time;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.x509.X509Extensions;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.x509.X509ObjectIdentifiers;

public class TBSCertificateStructure
extends ASN1Object
implements X509ObjectIdentifiers,
PKCSObjectIdentifiers {
    public ASN1Sequence seq;
    public ASN1Integer version;
    public ASN1Integer serialNumber;
    public AlgorithmIdentifier signature;
    public X500Name issuer;
    public Time startDate;
    public Time endDate;
    public X500Name subject;
    public SubjectPublicKeyInfo subjectPublicKeyInfo;
    public DERBitString issuerUniqueId;
    public DERBitString subjectUniqueId;
    public X509Extensions extensions;

    public static TBSCertificateStructure getInstance(ASN1TaggedObject aSN1TaggedObject, boolean bl) {
        return TBSCertificateStructure.getInstance(ASN1Sequence.getInstance(aSN1TaggedObject, bl));
    }

    public static TBSCertificateStructure getInstance(Object object) {
        if (object instanceof TBSCertificateStructure) {
            return (TBSCertificateStructure)object;
        }
        if (object != null) {
            return new TBSCertificateStructure(ASN1Sequence.getInstance(object));
        }
        return null;
    }

    public TBSCertificateStructure(ASN1Sequence aSN1Sequence) {
        int n3 = 0;
        this.seq = aSN1Sequence;
        if (aSN1Sequence.getObjectAt(0) instanceof ASN1TaggedObject) {
            this.version = ASN1Integer.getInstance((ASN1TaggedObject)aSN1Sequence.getObjectAt(0), true);
        } else {
            ASN1Integer aSN1Integer;
            n3 = -1;
            ASN1Integer aSN1Integer2 = aSN1Integer;
            aSN1Integer = new ASN1Integer(0L);
            this.version = aSN1Integer2;
        }
        this.serialNumber = ASN1Integer.getInstance(aSN1Sequence.getObjectAt(n3 + 1));
        this.signature = AlgorithmIdentifier.getInstance(aSN1Sequence.getObjectAt(n3 + 2));
        this.issuer = X500Name.getInstance(aSN1Sequence.getObjectAt(n3 + 3));
        ASN1Sequence aSN1Sequence2 = (ASN1Sequence)aSN1Sequence.getObjectAt(n3 + 4);
        this.startDate = Time.getInstance(aSN1Sequence2.getObjectAt(0));
        this.endDate = Time.getInstance(aSN1Sequence2.getObjectAt(1));
        this.subject = X500Name.getInstance(aSN1Sequence.getObjectAt(n3 + 5));
        this.subjectPublicKeyInfo = SubjectPublicKeyInfo.getInstance(aSN1Sequence.getObjectAt(n3 += 6));
        for (int i3 = aSN1Sequence.size() - n3 - 1; i3 > 0; --i3) {
            ASN1TaggedObject aSN1TaggedObject = ASN1TaggedObject.getInstance(aSN1Sequence.getObjectAt(n3 + i3));
            int n4 = aSN1TaggedObject.getTagNo();
            if (n4 != 1) {
                if (n4 != 2) {
                    if (n4 != 3) continue;
                    this.extensions = X509Extensions.getInstance(aSN1TaggedObject);
                    continue;
                }
                this.subjectUniqueId = DERBitString.getInstance(aSN1TaggedObject, false);
                continue;
            }
            this.issuerUniqueId = DERBitString.getInstance(aSN1TaggedObject, false);
        }
    }

    public int getVersion() {
        return this.version.intValueExact() + 1;
    }

    public ASN1Integer getVersionNumber() {
        return this.version;
    }

    public ASN1Integer getSerialNumber() {
        return this.serialNumber;
    }

    public AlgorithmIdentifier getSignature() {
        return this.signature;
    }

    public X500Name getIssuer() {
        return this.issuer;
    }

    public Time getStartDate() {
        return this.startDate;
    }

    public Time getEndDate() {
        return this.endDate;
    }

    public X500Name getSubject() {
        return this.subject;
    }

    public SubjectPublicKeyInfo getSubjectPublicKeyInfo() {
        return this.subjectPublicKeyInfo;
    }

    public DERBitString getIssuerUniqueId() {
        return this.issuerUniqueId;
    }

    public DERBitString getSubjectUniqueId() {
        return this.subjectUniqueId;
    }

    public X509Extensions getExtensions() {
        return this.extensions;
    }

    @Override
    public ASN1Primitive toASN1Primitive() {
        return this.seq;
    }
}

