/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.asn1.x509.qualified;

import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Encodable;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1EncodableVector;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Object;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1ObjectIdentifier;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Primitive;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Sequence;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.DERSequence;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.x509.GeneralName;

public class SemanticsInformation
extends ASN1Object {
    private ASN1ObjectIdentifier semanticsIdentifier;
    private GeneralName[] nameRegistrationAuthorities;

    public static SemanticsInformation getInstance(Object object) {
        if (object instanceof SemanticsInformation) {
            return (SemanticsInformation)object;
        }
        if (object != null) {
            return new SemanticsInformation(ASN1Sequence.getInstance(object));
        }
        return null;
    }

    private SemanticsInformation(ASN1Sequence object) {
        ASN1Sequence aSN1Sequence = object;
        object = aSN1Sequence.getObjects();
        if (aSN1Sequence.size() >= 1) {
            Object object2 = object.nextElement();
            if (object2 instanceof ASN1ObjectIdentifier) {
                this.semanticsIdentifier = ASN1ObjectIdentifier.getInstance(object2);
                object2 = object.hasMoreElements() ? object.nextElement() : null;
            }
            if (object2 != null) {
                object = ASN1Sequence.getInstance(object2);
                this.nameRegistrationAuthorities = new GeneralName[((ASN1Sequence)object).size()];
                for (int i3 = 0; i3 < ((ASN1Sequence)object).size(); ++i3) {
                    this.nameRegistrationAuthorities[i3] = GeneralName.getInstance(((ASN1Sequence)object).getObjectAt(i3));
                }
            }
            return;
        }
        throw new IllegalArgumentException("no objects in SemanticsInformation");
    }

    public SemanticsInformation(ASN1ObjectIdentifier aSN1ObjectIdentifier, GeneralName[] generalNameArray) {
        this.semanticsIdentifier = aSN1ObjectIdentifier;
        this.nameRegistrationAuthorities = SemanticsInformation.cloneNames(generalNameArray);
    }

    public SemanticsInformation(ASN1ObjectIdentifier aSN1ObjectIdentifier) {
        this.semanticsIdentifier = aSN1ObjectIdentifier;
        this.nameRegistrationAuthorities = null;
    }

    public SemanticsInformation(GeneralName[] generalNameArray) {
        this.semanticsIdentifier = null;
        this.nameRegistrationAuthorities = SemanticsInformation.cloneNames(generalNameArray);
    }

    private static GeneralName[] cloneNames(GeneralName[] generalNameArray) {
        if (generalNameArray != null) {
            GeneralName[] generalNameArray2 = new GeneralName[generalNameArray.length];
            int n3 = generalNameArray.length;
            System.arraycopy(generalNameArray, 0, generalNameArray2, 0, n3);
            return generalNameArray2;
        }
        return null;
    }

    public ASN1ObjectIdentifier getSemanticsIdentifier() {
        return this.semanticsIdentifier;
    }

    public GeneralName[] getNameRegistrationAuthorities() {
        return SemanticsInformation.cloneNames(this.nameRegistrationAuthorities);
    }

    @Override
    public ASN1Primitive toASN1Primitive() {
        ASN1EncodableVector aSN1EncodableVector;
        ASN1EncodableVector aSN1EncodableVector2 = aSN1EncodableVector;
        aSN1EncodableVector = new ASN1EncodableVector(2);
        ASN1Primitive aSN1Primitive = aSN1EncodableArray.semanticsIdentifier;
        if (aSN1Primitive != null) {
            aSN1EncodableVector2.add(aSN1Primitive);
        }
        ASN1Encodable[] aSN1EncodableArray = aSN1EncodableArray.nameRegistrationAuthorities;
        if (aSN1EncodableArray.nameRegistrationAuthorities != null) {
            DERSequence dERSequence;
            aSN1Primitive = dERSequence;
            dERSequence = new DERSequence(aSN1EncodableArray);
            aSN1EncodableVector2.add(aSN1Primitive);
        }
        return new DERSequence(aSN1EncodableVector2);
    }
}

