/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.crypto;

import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.AsymmetricBlockCipher;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.CipherParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.DataLengthException;

public class BufferedAsymmetricBlockCipher {
    public byte[] buf;
    public int bufOff;
    private final AsymmetricBlockCipher cipher;

    public BufferedAsymmetricBlockCipher(AsymmetricBlockCipher asymmetricBlockCipher) {
        this.cipher = asymmetricBlockCipher;
    }

    public AsymmetricBlockCipher getUnderlyingCipher() {
        return this.cipher;
    }

    public int getBufferPosition() {
        return this.bufOff;
    }

    public void init(boolean bl, CipherParameters cipherParameters) {
        BufferedAsymmetricBlockCipher bufferedAsymmetricBlockCipher = this;
        bufferedAsymmetricBlockCipher.reset();
        bufferedAsymmetricBlockCipher.cipher.init(bl, cipherParameters);
        bufferedAsymmetricBlockCipher.buf = new byte[bufferedAsymmetricBlockCipher.cipher.getInputBlockSize() + bl];
        bufferedAsymmetricBlockCipher.bufOff = 0;
    }

    public int getInputBlockSize() {
        return this.cipher.getInputBlockSize();
    }

    public int getOutputBlockSize() {
        return this.cipher.getOutputBlockSize();
    }

    public void processByte(byte by) {
        int n3 = this.bufOff;
        byte[] byArray = this.buf;
        if (n3 < this.buf.length) {
            this.bufOff = n3 + 1;
            byArray[n3] = by;
            return;
        }
        throw new DataLengthException("attempt to process message too long for cipher");
    }

    public void processBytes(byte[] byArray, int n3, int n4) {
        if (n4 == 0) {
            return;
        }
        if (n4 >= 0) {
            int n5 = this.bufOff;
            byte[] byArray2 = this.buf;
            if (n5 + n4 <= this.buf.length) {
                System.arraycopy(byArray, n3, byArray2, n5, n4);
                this.bufOff += n4;
                return;
            }
            throw new DataLengthException("attempt to process message too long for cipher");
        }
        throw new IllegalArgumentException("Can't have a negative input length!");
    }

    public byte[] doFinal() {
        BufferedAsymmetricBlockCipher bufferedAsymmetricBlockCipher = this;
        byte[] byArray = bufferedAsymmetricBlockCipher.buf;
        int n3 = bufferedAsymmetricBlockCipher.bufOff;
        byte[] byArray2 = this.cipher.processBlock(byArray, 0, n3);
        this.reset();
        return byArray2;
    }

    public void reset() {
        if (this.buf != null) {
            int n3 = 0;
            while (true) {
                byte[] byArray = this.buf;
                if (n3 >= this.buf.length) break;
                byArray[n3] = 0;
                ++n3;
            }
        }
        this.bufOff = 0;
    }
}

