/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.crypto;

import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.BlockCipher;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.CipherParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.DataLengthException;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.OutputLengthException;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.StreamCipher;

public class BufferedBlockCipher {
    public byte[] buf;
    public int bufOff;
    public boolean forEncryption;
    public BlockCipher cipher;
    public boolean partialBlockOkay;
    public boolean pgpCFB;

    public BufferedBlockCipher() {
    }

    public BufferedBlockCipher(BlockCipher blockCipher) {
        BufferedBlockCipher bufferedBlockCipher = this;
        this.cipher = blockCipher;
        bufferedBlockCipher.buf = new byte[blockCipher.getBlockSize()];
        bufferedBlockCipher.bufOff = 0;
        String string2 = blockCipher.getAlgorithmName();
        int n3 = string2.indexOf(47) + 1;
        boolean bl = n3 > 0 && string2.startsWith("PGP", n3);
        this.pgpCFB = bl;
        if (!bl && !(blockCipher instanceof StreamCipher)) {
            boolean bl2 = n3 > 0 && string2.startsWith("OpenPGP", n3);
            this.partialBlockOkay = bl2;
        } else {
            this.partialBlockOkay = true;
        }
    }

    public BlockCipher getUnderlyingCipher() {
        return this.cipher;
    }

    public void init(boolean bl, CipherParameters cipherParameters) {
        BufferedBlockCipher bufferedBlockCipher = this;
        bufferedBlockCipher.forEncryption = bl;
        bufferedBlockCipher.reset();
        bufferedBlockCipher.cipher.init(bl, cipherParameters);
    }

    public int getBlockSize() {
        return this.cipher.getBlockSize();
    }

    public int getUpdateOutputSize(int n3) {
        int n4 = this.pgpCFB ? (this.forEncryption ? n3 % this.buf.length - (this.cipher.getBlockSize() + 2) : n3 % this.buf.length) : (n3 += this.bufOff) % this.buf.length;
        return n3 - n4;
    }

    public int getOutputSize(int n3) {
        return n3 + this.bufOff;
    }

    public int processByte(byte by, byte[] byArray, int n3) {
        int n4;
        BufferedBlockCipher bufferedBlockCipher = this;
        int n5 = 0;
        byte[] byArray2 = bufferedBlockCipher.buf;
        int n6 = bufferedBlockCipher.bufOff;
        this.bufOff = n4 = n6 + 1;
        byArray2[n6] = by;
        if (n4 == byArray2.length) {
            n5 = this.cipher.processBlock(byArray2, 0, byArray, n3);
            this.bufOff = 0;
        }
        return n5;
    }

    public int processBytes(byte[] byArray, int n3, int n4, byte[] byArray2, int n5) {
        if (n4 >= 0) {
            BufferedBlockCipher bufferedBlockCipher = this;
            int n6 = bufferedBlockCipher.getBlockSize();
            int n7 = bufferedBlockCipher.getUpdateOutputSize(n4);
            if (n7 > 0 && n5 + n7 > byArray2.length) {
                throw new OutputLengthException("output buffer too short");
            }
            n7 = 0;
            byte[] byArray3 = this.buf;
            int n8 = this.bufOff;
            int n9 = this.buf.length - n8;
            if (n4 > n9) {
                int n10 = n3;
                System.arraycopy(byArray, n3, byArray3, n8, n9);
                n3 = this.cipher.processBlock(this.buf, 0, byArray2, n5) + n7;
                this.bufOff = 0;
                n4 -= n9;
                int n11 = n7 = n10 + n9;
                n7 = n3;
                n3 = n11;
                while (n4 > this.buf.length) {
                    int n12 = n3;
                    int n13 = n4;
                    n4 = n5 + n7;
                    n3 = this.cipher.processBlock(byArray, n3, byArray2, n4) + n7;
                    n4 = n13 - n6;
                    int n14 = n7 = n12 + n6;
                    n7 = n3;
                    n3 = n14;
                }
            }
            byte[] byArray4 = byArray;
            BufferedBlockCipher bufferedBlockCipher2 = this;
            byArray = bufferedBlockCipher2.buf;
            System.arraycopy(byArray4, n3, byArray, bufferedBlockCipher2.bufOff, n4);
            int n15 = this.bufOff + n4;
            BufferedBlockCipher bufferedBlockCipher3 = this;
            bufferedBlockCipher3.bufOff = n15;
            byte[] byArray5 = bufferedBlockCipher3.buf;
            if (n15 == bufferedBlockCipher3.buf.length) {
                int n16 = n5 + n7;
                n7 = this.cipher.processBlock(byArray5, 0, byArray2, n16) + n7;
                this.bufOff = 0;
            }
            return n7;
        }
        throw new IllegalArgumentException("Can't have a negative input length!");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int doFinal(byte[] byArray, int n3) {
        block9: {
            int n4;
            block10: {
                int n5;
                n4 = 0;
                try {
                    n5 = this.bufOff;
                }
                catch (Throwable throwable) {
                    this.reset();
                    throw throwable;
                }
                if (n3 + n5 > byArray.length) break block9;
                if (n5 == 0) break block10;
                if (!this.partialBlockOkay) throw new DataLengthException("data not block size aligned");
                BufferedBlockCipher bufferedBlockCipher = this;
                BufferedBlockCipher bufferedBlockCipher2 = bufferedBlockCipher;
                BufferedBlockCipher bufferedBlockCipher3 = bufferedBlockCipher;
                BufferedBlockCipher bufferedBlockCipher4 = bufferedBlockCipher;
                BlockCipher blockCipher = bufferedBlockCipher.cipher;
                byte[] byArray2 = this.buf;
                blockCipher.processBlock(this.buf, 0, byArray2, 0);
                n4 = bufferedBlockCipher2.bufOff;
                bufferedBlockCipher3.bufOff = 0;
                System.arraycopy(bufferedBlockCipher4.buf, 0, byArray, n3, n4);
            }
            this.reset();
            return n4;
        }
        throw new OutputLengthException("output buffer too short for doFinal()");
    }

    public void reset() {
        int n3 = 0;
        while (true) {
            byte[] byArray = this.buf;
            if (n3 >= this.buf.length) break;
            byArray[n3] = 0;
            ++n3;
        }
        this.bufOff = 0;
        this.cipher.reset();
    }
}

