/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.crypto;

import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.CipherParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.util.Strings;

public abstract class PBEParametersGenerator {
    public byte[] password;
    public byte[] salt;
    public int iterationCount;

    public static byte[] PKCS5PasswordToBytes(char[] cArray) {
        if (cArray != null) {
            int n3 = cArray.length;
            byte[] byArray = new byte[n3];
            for (int i3 = 0; i3 != n3; ++i3) {
                byArray[i3] = (byte)cArray[i3];
            }
            return byArray;
        }
        return new byte[0];
    }

    public static byte[] PKCS5PasswordToUTF8Bytes(char[] cArray) {
        if (cArray != null) {
            return Strings.toUTF8ByteArray(cArray);
        }
        return new byte[0];
    }

    public static byte[] PKCS12PasswordToBytes(char[] cArray) {
        if (cArray != null && cArray.length > 0) {
            byte[] byArray = new byte[(cArray.length + 1) * 2];
            int n3 = 0;
            while (n3 != cArray.length) {
                int n4 = n3++;
                int n5 = n4 * 2;
                char c3 = cArray[n4];
                byArray[n5] = (byte)(c3 >>> 8);
                byArray[++n5] = (byte)c3;
            }
            return byArray;
        }
        return new byte[0];
    }

    public void init(byte[] byArray, byte[] byArray2, int n3) {
        PBEParametersGenerator pBEParametersGenerator = this;
        pBEParametersGenerator.password = byArray;
        pBEParametersGenerator.salt = byArray2;
        pBEParametersGenerator.iterationCount = n3;
    }

    public byte[] getPassword() {
        return this.password;
    }

    public byte[] getSalt() {
        return this.salt;
    }

    public int getIterationCount() {
        return this.iterationCount;
    }

    public abstract CipherParameters generateDerivedParameters(int var1);

    public abstract CipherParameters generateDerivedParameters(int var1, int var2);

    public abstract CipherParameters generateDerivedMacParameters(int var1);
}

