/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.crypto.agreement;

import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.CipherParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.Digest;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.params.ECDomainParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.params.ECKeyParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.params.ECPrivateKeyParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.params.ECPublicKeyParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.params.ParametersWithUKM;
import com.fis.ekyc.nfc.build_in.bouncycastle.math.ec.ECAlgorithms;
import com.fis.ekyc.nfc.build_in.bouncycastle.math.ec.ECPoint;
import com.fis.ekyc.nfc.build_in.bouncycastle.util.BigIntegers;
import java.math.BigInteger;

public class ECVKOAgreement {
    private final Digest digest;
    private ECPrivateKeyParameters key;
    private BigInteger ukm;

    public ECVKOAgreement(Digest digest) {
        this.digest = digest;
    }

    private static BigInteger toInteger(byte[] byArray) {
        int n3 = byArray.length;
        byte[] byArray2 = new byte[n3];
        for (int i3 = 0; i3 != n3; ++i3) {
            byArray2[i3] = byArray[byArray.length - i3 - 1];
        }
        return new BigInteger(1, byArray2);
    }

    private byte[] fromPoint(ECPoint object) {
        int n3;
        Object object2 = ((ECPoint)object).getAffineXCoord().toBigInteger();
        object = ((ECPoint)object).getAffineYCoord().toBigInteger();
        int n4 = ((BigInteger)object2).toByteArray().length > 33 ? 64 : 32;
        int n5 = n4;
        int n6 = n5 * 2;
        byte[] byArray = new byte[n6];
        object2 = BigIntegers.asUnsignedByteArray(n5, (BigInteger)object2);
        object = BigIntegers.asUnsignedByteArray(n5, (BigInteger)object);
        for (n3 = 0; n3 != n4; ++n3) {
            byArray[n3] = (byte)object2[n4 - n3 - 1];
        }
        for (int i3 = 0; i3 != n4; ++i3) {
            n3 = n4 + i3;
            byArray[n3] = (byte)object[n4 - i3 - 1];
        }
        ECVKOAgreement eCVKOAgreement = this;
        eCVKOAgreement.digest.update(byArray, 0, n6);
        byte[] byArray2 = new byte[eCVKOAgreement.digest.getDigestSize()];
        this.digest.doFinal(byArray2, 0);
        return byArray2;
    }

    public void init(CipherParameters cipherParameters) {
        ECVKOAgreement eCVKOAgreement = parametersWithUKM;
        ParametersWithUKM parametersWithUKM = (ParametersWithUKM)cipherParameters;
        eCVKOAgreement.key = (ECPrivateKeyParameters)parametersWithUKM.getParameters();
        eCVKOAgreement.ukm = ECVKOAgreement.toInteger(parametersWithUKM.getUKM());
    }

    public int getFieldSize() {
        return (this.key.getParameters().getCurve().getFieldSize() + 7) / 8;
    }

    public byte[] calculateAgreement(CipherParameters object) {
        object = (ECPublicKeyParameters)object;
        Object object2 = this.key.getParameters();
        if (((ECDomainParameters)object2).equals(((ECKeyParameters)object).getParameters())) {
            ECDomainParameters eCDomainParameters = object2;
            object2 = eCDomainParameters.getH().multiply(this.ukm).multiply(this.key.getD()).mod(((ECDomainParameters)object2).getN());
            object = ECAlgorithms.cleanPoint(eCDomainParameters.getCurve(), ((ECPublicKeyParameters)object).getQ());
            if (!((ECPoint)object).isInfinity()) {
                if (!((ECPoint)(object = ((ECPoint)object).multiply((BigInteger)object2).normalize())).isInfinity()) {
                    return this.fromPoint((ECPoint)object);
                }
                throw new IllegalStateException("Infinity is not a valid agreement value for ECVKO");
            }
            throw new IllegalStateException("Infinity is not a valid public key for ECDHC");
        }
        throw new IllegalStateException("ECVKO public key has wrong domain parameters");
    }
}

