/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.crypto.agreement.jpake;

import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.agreement.jpake.JPAKEUtil;
import com.fis.ekyc.nfc.build_in.bouncycastle.util.Arrays;
import java.math.BigInteger;

public class JPAKERound1Payload {
    private final String participantId;
    private final BigInteger gx1;
    private final BigInteger gx2;
    private final BigInteger[] knowledgeProofForX1;
    private final BigInteger[] knowledgeProofForX2;

    public JPAKERound1Payload(String string2, BigInteger bigInteger, BigInteger bigInteger2, BigInteger[] bigIntegerArray, BigInteger[] bigIntegerArray2) {
        JPAKEUtil.validateNotNull(string2, "participantId");
        JPAKEUtil.validateNotNull(bigInteger, "gx1");
        JPAKEUtil.validateNotNull(bigInteger2, "gx2");
        JPAKEUtil.validateNotNull(bigIntegerArray, "knowledgeProofForX1");
        JPAKEUtil.validateNotNull(bigIntegerArray2, "knowledgeProofForX2");
        this.participantId = string2;
        this.gx1 = bigInteger;
        this.gx2 = bigInteger2;
        this.knowledgeProofForX1 = Arrays.copyOf(bigIntegerArray, bigIntegerArray.length);
        this.knowledgeProofForX2 = Arrays.copyOf(bigIntegerArray2, bigIntegerArray2.length);
    }

    public String getParticipantId() {
        return this.participantId;
    }

    public BigInteger getGx1() {
        return this.gx1;
    }

    public BigInteger getGx2() {
        return this.gx2;
    }

    public BigInteger[] getKnowledgeProofForX1() {
        return Arrays.copyOf(this.knowledgeProofForX1, this.knowledgeProofForX1.length);
    }

    public BigInteger[] getKnowledgeProofForX2() {
        return Arrays.copyOf(this.knowledgeProofForX2, this.knowledgeProofForX2.length);
    }
}

