/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.crypto.agreement.kdf;

import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.DerivationFunction;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.DerivationParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.Digest;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.OutputLengthException;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.params.KDFParameters;

public class ConcatenationKDFGenerator
implements DerivationFunction {
    private Digest digest;
    private byte[] shared;
    private byte[] otherInfo;
    private int hLen;

    public ConcatenationKDFGenerator(Digest digest) {
        this.digest = digest;
        this.hLen = digest.getDigestSize();
    }

    private void ItoOSP(int n3, byte[] byArray) {
        byArray[0] = (byte)(n3 >>> 24);
        byArray[1] = (byte)(n3 >>> 16);
        byArray[2] = (byte)(n3 >>> 8);
        byArray[3] = (byte)(n3 >>> 0);
    }

    @Override
    public void init(DerivationParameters derivationParameters) {
        if (derivationParameters instanceof KDFParameters) {
            ConcatenationKDFGenerator concatenationKDFGenerator = kDFParameters;
            KDFParameters kDFParameters = (KDFParameters)derivationParameters;
            concatenationKDFGenerator.shared = kDFParameters.getSharedSecret();
            concatenationKDFGenerator.otherInfo = kDFParameters.getIV();
            return;
        }
        throw new IllegalArgumentException("KDF parameters required for generator");
    }

    public Digest getDigest() {
        return this.digest;
    }

    @Override
    public int generateBytes(byte[] byArray, int n3, int n4) {
        if (byArray.length - n4 >= n3) {
            ConcatenationKDFGenerator concatenationKDFGenerator = this;
            byte[] byArray2 = new byte[concatenationKDFGenerator.hLen];
            int n5 = 4;
            byte[] byArray3 = new byte[4];
            int n6 = 1;
            int n7 = 0;
            concatenationKDFGenerator.digest.reset();
            if (n4 > concatenationKDFGenerator.hLen) {
                while (true) {
                    int n8 = n6;
                    int n9 = n7;
                    ConcatenationKDFGenerator concatenationKDFGenerator2 = this;
                    concatenationKDFGenerator2.ItoOSP(n6, byArray3);
                    concatenationKDFGenerator2.digest.update(byArray3, 0, n5);
                    concatenationKDFGenerator2.digest.update(this.shared, 0, this.shared.length);
                    concatenationKDFGenerator2.digest.update(this.otherInfo, 0, this.otherInfo.length);
                    concatenationKDFGenerator2.digest.doFinal(byArray2, 0);
                    n7 = n3 + n7;
                    int n10 = this.hLen;
                    System.arraycopy(byArray2, 0, byArray, n7, n10);
                    n7 = this.hLen;
                    n10 = n9 + n7;
                    ++n6;
                    if (n8 >= n4 / n7) {
                        n7 = n10;
                        break;
                    }
                    n7 = n10;
                }
            }
            if (n7 < n4) {
                ConcatenationKDFGenerator concatenationKDFGenerator3 = this;
                concatenationKDFGenerator3.ItoOSP(n6, byArray3);
                concatenationKDFGenerator3.digest.update(byArray3, 0, n5);
                concatenationKDFGenerator3.digest.update(this.shared, 0, this.shared.length);
                concatenationKDFGenerator3.digest.update(this.otherInfo, 0, this.otherInfo.length);
                concatenationKDFGenerator3.digest.doFinal(byArray2, 0);
                int n11 = n3 + n7;
                n3 = n4 - n7;
                System.arraycopy(byArray2, 0, byArray, n11, n3);
            }
            return n4;
        }
        throw new OutputLengthException("output buffer too small");
    }
}

