/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.crypto.agreement.kdf;

import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Encodable;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1EncodableVector;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1ObjectIdentifier;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.DEROctetString;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.DERSequence;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.DERTaggedObject;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.b;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.DerivationFunction;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.DerivationParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.Digest;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.OutputLengthException;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.agreement.kdf.DHKDFParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.util.Pack;
import java.io.IOException;

public class DHKEKGenerator
implements DerivationFunction {
    private final Digest digest;
    private ASN1ObjectIdentifier algorithm;
    private int keySize;
    private byte[] z;
    private byte[] partyAInfo;

    public DHKEKGenerator(Digest digest) {
        this.digest = digest;
    }

    @Override
    public void init(DerivationParameters derivationParameters) {
        DHKEKGenerator dHKEKGenerator = dHKDFParameters;
        DHKDFParameters dHKDFParameters = (DHKDFParameters)derivationParameters;
        dHKEKGenerator.algorithm = dHKDFParameters.getAlgorithm();
        dHKEKGenerator.keySize = dHKDFParameters.getKeySize();
        dHKEKGenerator.z = dHKDFParameters.getZ();
        dHKEKGenerator.partyAInfo = dHKDFParameters.getExtraInfo();
    }

    public Digest getDigest() {
        return this.digest;
    }

    @Override
    public int generateBytes(byte[] byArray, int n3, int n4) {
        if (byArray.length - n4 >= n3) {
            long l3 = n4;
            int n5 = this.digest.getDigestSize();
            if (l3 <= 0x1FFFFFFFFL) {
                long l4 = n5;
                int n6 = (int)((l3 + l4 - 1L) / l4);
                byte[] byArray2 = new byte[this.digest.getDigestSize()];
                int n7 = 1;
                for (int i3 = 0; i3 < n6; ++i3) {
                    DEROctetString dEROctetString;
                    ASN1EncodableVector aSN1EncodableVector;
                    ASN1EncodableVector aSN1EncodableVector2;
                    DHKEKGenerator dHKEKGenerator = this;
                    dHKEKGenerator.digest.update(this.z, 0, this.z.length);
                    Object object = aSN1EncodableVector2;
                    aSN1EncodableVector2 = new ASN1EncodableVector();
                    Object object2 = aSN1EncodableVector;
                    ((ASN1EncodableVector)object2)();
                    aSN1EncodableVector.add(this.algorithm);
                    aSN1EncodableVector.add(new DEROctetString(Pack.intToBigEndian(n7)));
                    aSN1EncodableVector2.add(new DERSequence((ASN1EncodableVector)object2));
                    object2 = dHKEKGenerator.partyAInfo;
                    if (dHKEKGenerator.partyAInfo != null) {
                        DEROctetString dEROctetString2;
                        DERTaggedObject dERTaggedObject;
                        DERTaggedObject dERTaggedObject2 = dERTaggedObject;
                        DEROctetString dEROctetString3 = dEROctetString2;
                        dEROctetString2 = new DEROctetString((byte[])object2);
                        dERTaggedObject = new DERTaggedObject(true, 0, dEROctetString3);
                        ((ASN1EncodableVector)object).add(dERTaggedObject2);
                    }
                    DHKEKGenerator dHKEKGenerator2 = this;
                    object2 = dEROctetString;
                    dEROctetString = new DEROctetString(Pack.intToBigEndian(this.keySize));
                    ((ASN1EncodableVector)object).add(new DERTaggedObject(true, 2, (ASN1Encodable)object2));
                    try {
                        object = new DERSequence((ASN1EncodableVector)object).getEncoded("DER");
                    }
                    catch (IOException iOException) {
                        throw new IllegalArgumentException(b.a(iOException, b.b.a("unable to encode parameter info: ")));
                    }
                    Digest digest = dHKEKGenerator2.digest;
                    Object object3 = object;
                    int n8 = 0;
                    digest.update((byte[])object3, n8, ((Object)object3).length);
                    dHKEKGenerator2.digest.doFinal(byArray2, 0);
                    if (n4 > n5) {
                        System.arraycopy(byArray2, 0, byArray, n3, n5);
                        n3 += n5;
                        n4 -= n5;
                    } else {
                        System.arraycopy(byArray2, 0, byArray, n3, n4);
                    }
                    ++n7;
                }
                this.digest.reset();
                return (int)l3;
            }
            throw new IllegalArgumentException("Output length too large");
        }
        throw new OutputLengthException("output buffer too small");
    }
}

