/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.crypto.agreement.kdf;

import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.DataLengthException;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.DerivationParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.Digest;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.DigestDerivationFunction;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.agreement.kdf.GSKKDFParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.util.Arrays;
import com.fis.ekyc.nfc.build_in.bouncycastle.util.Pack;

public class GSKKFDGenerator
implements DigestDerivationFunction {
    private final Digest digest;
    private byte[] z;
    private int counter;
    private byte[] r;
    private byte[] buf;

    public GSKKFDGenerator(Digest digest) {
        this.digest = digest;
        this.buf = new byte[digest.getDigestSize()];
    }

    @Override
    public Digest getDigest() {
        return this.digest;
    }

    @Override
    public void init(DerivationParameters derivationParameters) {
        if (derivationParameters instanceof GSKKDFParameters) {
            GSKKFDGenerator gSKKFDGenerator = gSKKDFParameters;
            GSKKDFParameters gSKKDFParameters = (GSKKDFParameters)derivationParameters;
            gSKKFDGenerator.z = gSKKDFParameters.getZ();
            gSKKFDGenerator.counter = gSKKDFParameters.getStartCounter();
            gSKKFDGenerator.r = gSKKDFParameters.getNonce();
            return;
        }
        throw new IllegalArgumentException("unkown parameters type");
    }

    @Override
    public int generateBytes(byte[] byArray, int n3, int n4) {
        if (n3 + n4 <= byArray.length) {
            GSKKFDGenerator gSKKFDGenerator = this;
            gSKKFDGenerator.digest.update(this.z, 0, this.z.length);
            int n5 = gSKKFDGenerator.counter;
            this.counter = n5 + 1;
            byte[] byArray2 = Pack.intToBigEndian(n5);
            gSKKFDGenerator.digest.update(byArray2, 0, byArray2.length);
            byArray2 = gSKKFDGenerator.r;
            if (gSKKFDGenerator.r != null) {
                this.digest.update(byArray2, 0, byArray2.length);
            }
            GSKKFDGenerator gSKKFDGenerator2 = this;
            gSKKFDGenerator2.digest.doFinal(this.buf, 0);
            System.arraycopy(gSKKFDGenerator2.buf, 0, byArray, n3, n4);
            Arrays.clear(gSKKFDGenerator2.buf);
            return n4;
        }
        throw new DataLengthException("output buffer too small");
    }
}

