/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.crypto.agreement.srp;

import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.CryptoException;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.Digest;
import com.fis.ekyc.nfc.build_in.bouncycastle.util.BigIntegers;
import java.math.BigInteger;
import java.security.SecureRandom;

public class SRP6Util {
    private static BigInteger ZERO = BigInteger.valueOf(0L);
    private static BigInteger ONE = BigInteger.valueOf(1L);

    public static BigInteger calculateK(Digest digest, BigInteger bigInteger, BigInteger bigInteger2) {
        BigInteger bigInteger3 = bigInteger;
        return SRP6Util.hashPaddedPair(digest, bigInteger3, bigInteger3, bigInteger2);
    }

    public static BigInteger calculateU(Digest digest, BigInteger bigInteger, BigInteger bigInteger2, BigInteger bigInteger3) {
        return SRP6Util.hashPaddedPair(digest, bigInteger, bigInteger2, bigInteger3);
    }

    public static BigInteger calculateX(Digest digest, BigInteger object, byte[] byArray, byte[] byArray2, byte[] byArray3) {
        Digest digest2 = digest;
        Digest digest3 = digest;
        Digest digest4 = digest;
        int n3 = digest.getDigestSize();
        object = new byte[n3];
        int n4 = byArray2.length;
        digest4.update(byArray2, 0, n4);
        digest4.update((byte)58);
        int n5 = byArray3.length;
        digest3.update(byArray3, 0, n5);
        digest3.doFinal((byte[])object, 0);
        n5 = byArray.length;
        digest2.update(byArray, 0, n5);
        digest2.update((byte[])object, 0, n3);
        digest2.doFinal((byte[])object, 0);
        return new BigInteger(1, (byte[])object);
    }

    public static BigInteger generatePrivateValue(Digest digest, BigInteger bigInteger, BigInteger bigInteger2, SecureRandom secureRandom) {
        return BigIntegers.createRandomInRange(ONE.shiftLeft(Math.min(256, bigInteger.bitLength() / 2) - 1), bigInteger.subtract(ONE), secureRandom);
    }

    public static BigInteger validatePublicValue(BigInteger bigInteger, BigInteger bigInteger2) {
        if (!(bigInteger = bigInteger2.mod(bigInteger)).equals(ZERO)) {
            return bigInteger;
        }
        throw new CryptoException("Invalid public value: 0");
    }

    public static BigInteger calculateM1(Digest digest, BigInteger bigInteger, BigInteger bigInteger2, BigInteger bigInteger3, BigInteger bigInteger4) {
        return SRP6Util.hashPaddedTriplet(digest, bigInteger, bigInteger2, bigInteger3, bigInteger4);
    }

    public static BigInteger calculateM2(Digest digest, BigInteger bigInteger, BigInteger bigInteger2, BigInteger bigInteger3, BigInteger bigInteger4) {
        return SRP6Util.hashPaddedTriplet(digest, bigInteger, bigInteger2, bigInteger3, bigInteger4);
    }

    public static BigInteger calculateKey(Digest object, BigInteger bigInteger, BigInteger bigInteger2) {
        Digest digest = object;
        byte[] byArray = SRP6Util.getPadded(bigInteger2, (bigInteger.bitLength() + 7) / 8);
        digest.update(byArray, 0, byArray.length);
        byte[] byArray2 = new byte[digest.getDigestSize()];
        object = byArray2;
        digest.doFinal(byArray2, 0);
        return new BigInteger(1, (byte[])object);
    }

    private static BigInteger hashPaddedTriplet(Digest object, BigInteger bigInteger, BigInteger object2, BigInteger object3, BigInteger bigInteger2) {
        Digest digest = object;
        int n3 = (bigInteger.bitLength() + 7) / 8;
        object2 = SRP6Util.getPadded((BigInteger)object2, n3);
        object3 = SRP6Util.getPadded((BigInteger)object3, n3);
        byte[] byArray = SRP6Util.getPadded(bigInteger2, n3);
        Object object4 = object3;
        Object object5 = object2;
        object.update((byte[])object5, 0, ((Object)object5).length);
        object.update((byte[])object4, 0, ((Object)object4).length);
        digest.update(byArray, 0, byArray.length);
        byte[] byArray2 = new byte[digest.getDigestSize()];
        object = byArray2;
        digest.doFinal(byArray2, 0);
        return new BigInteger(1, (byte[])object);
    }

    private static BigInteger hashPaddedPair(Digest object, BigInteger bigInteger, BigInteger object2, BigInteger bigInteger2) {
        Digest digest = object;
        int n3 = (bigInteger.bitLength() + 7) / 8;
        object2 = SRP6Util.getPadded((BigInteger)object2, n3);
        byte[] byArray = SRP6Util.getPadded(bigInteger2, n3);
        Object object3 = object2;
        object.update((byte[])object3, 0, ((Object)object3).length);
        digest.update(byArray, 0, byArray.length);
        byte[] byArray2 = new byte[digest.getDigestSize()];
        object = byArray2;
        digest.doFinal(byArray2, 0);
        return new BigInteger(1, (byte[])object);
    }

    private static byte[] getPadded(BigInteger object, int n3) {
        byte[] byArray = BigIntegers.asUnsignedByteArray((BigInteger)object);
        object = byArray;
        if (byArray.length < n3) {
            Object object2 = object;
            Object object3 = object;
            object = new byte[n3];
            int n4 = ((Object)object2).length;
            System.arraycopy(object2, 0, object, n3 -= ((Object)object3).length, n4);
        }
        return object;
    }
}

