/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.crypto.digests;

import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.ExtendedDigest;
import com.fis.ekyc.nfc.build_in.bouncycastle.util.Arrays;
import com.fis.ekyc.nfc.build_in.bouncycastle.util.Longs;
import com.fis.ekyc.nfc.build_in.bouncycastle.util.Pack;

public class Blake2bDigest
implements ExtendedDigest {
    private static final long[] blake2b_IV = new long[]{7640891576956012808L, -4942790177534073029L, 4354685564936845355L, -6534734903238641935L, 5840696475078001361L, -7276294671716946913L, 2270897969802886507L, 6620516959819538809L};
    private static final byte[][] blake2b_sigma;
    private static int ROUNDS = 12;
    private static final int BLOCK_LENGTH_BYTES = 128;
    private int digestLength = 64;
    private int keyLength = 0;
    private byte[] salt = null;
    private byte[] personalization = null;
    private byte[] key = null;
    private byte[] buffer;
    private int bufferPos;
    private long[] internalState;
    private long[] chainValue;
    private long t0;
    private long t1;
    private long f0;

    public Blake2bDigest() {
        this(512);
    }

    public Blake2bDigest(Blake2bDigest blake2bDigest) {
        this.buffer = null;
        this.bufferPos = 0;
        this.internalState = new long[16];
        this.chainValue = null;
        this.t0 = 0L;
        this.t1 = 0L;
        this.f0 = 0L;
        this.bufferPos = blake2bDigest.bufferPos;
        this.buffer = Arrays.clone(blake2bDigest.buffer);
        this.keyLength = blake2bDigest.keyLength;
        this.key = Arrays.clone(blake2bDigest.key);
        this.digestLength = blake2bDigest.digestLength;
        this.chainValue = Arrays.clone(blake2bDigest.chainValue);
        this.personalization = Arrays.clone(blake2bDigest.personalization);
        this.salt = Arrays.clone(blake2bDigest.salt);
        this.t0 = blake2bDigest.t0;
        this.t1 = blake2bDigest.t1;
        this.f0 = blake2bDigest.f0;
    }

    public Blake2bDigest(int n3) {
        this.buffer = null;
        this.bufferPos = 0;
        this.internalState = new long[16];
        this.chainValue = null;
        this.t0 = 0L;
        this.t1 = 0L;
        this.f0 = 0L;
        if (n3 >= 8 && n3 <= 512 && n3 % 8 == 0) {
            Blake2bDigest blake2bDigest = this;
            blake2bDigest.buffer = new byte[128];
            blake2bDigest.keyLength = 0;
            this.digestLength = n3 / 8;
            this.init();
            return;
        }
        throw new IllegalArgumentException("BLAKE2b digest bit length must be a multiple of 8 and not greater than 512");
    }

    public Blake2bDigest(byte[] byArray) {
        this.bufferPos = 0;
        this.internalState = new long[16];
        this.chainValue = null;
        this.t0 = 0L;
        this.t1 = 0L;
        this.f0 = 0L;
        this.buffer = new byte[128];
        if (byArray != null) {
            byte[] byArray2 = new byte[byArray.length];
            this.key = byArray2;
            int n3 = byArray.length;
            System.arraycopy(byArray, 0, byArray2, 0, n3);
            if (byArray.length <= 64) {
                this.keyLength = byArray.length;
                byArray = this.buffer;
                int n4 = byArray.length;
                System.arraycopy(byArray, 0, byArray, 0, n4);
                this.bufferPos = 128;
            } else {
                throw new IllegalArgumentException("Keys > 64 are not supported");
            }
        }
        this.digestLength = 64;
        this.init();
    }

    public Blake2bDigest(byte[] byArray, int n3, byte[] byArray2, byte[] byArray3) {
        this.bufferPos = 0;
        this.internalState = new long[16];
        this.chainValue = null;
        this.t0 = 0L;
        this.t1 = 0L;
        this.f0 = 0L;
        this.buffer = new byte[128];
        if (n3 >= 1 && n3 <= 64) {
            this.digestLength = n3;
            if (byArray2 != null) {
                if (byArray2.length == 16) {
                    byte[] byArray4 = new byte[16];
                    this.salt = byArray4;
                    int n4 = byArray2.length;
                    System.arraycopy(byArray2, 0, byArray4, 0, n4);
                } else {
                    throw new IllegalArgumentException("salt length must be exactly 16 bytes");
                }
            }
            if (byArray3 != null) {
                if (byArray3.length == 16) {
                    byte[] byArray5 = new byte[16];
                    this.personalization = byArray5;
                    int n5 = byArray3.length;
                    System.arraycopy(byArray3, 0, byArray5, 0, n5);
                } else {
                    throw new IllegalArgumentException("personalization length must be exactly 16 bytes");
                }
            }
            if (byArray != null) {
                byte[] byArray6 = new byte[byArray.length];
                this.key = byArray6;
                int n6 = byArray.length;
                System.arraycopy(byArray, 0, byArray6, 0, n6);
                if (byArray.length <= 64) {
                    this.keyLength = byArray.length;
                    byArray = this.buffer;
                    int n7 = byArray.length;
                    System.arraycopy(byArray, 0, byArray, 0, n7);
                    this.bufferPos = 128;
                } else {
                    throw new IllegalArgumentException("Keys > 64 are not supported");
                }
            }
            this.init();
            return;
        }
        throw new IllegalArgumentException("Invalid digest length (required: 1 - 64)");
    }

    private void init() {
        if (this.chainValue == null) {
            long l3;
            long l4;
            long l5;
            long l6;
            long[] lArray = new long[8];
            long[] lArray2 = lArray;
            this.chainValue = lArray2;
            long[] lArray3 = blake2b_IV;
            lArray2[0] = l6 = lArray3[0] ^ (long)(this.digestLength | this.keyLength << 8 | 0x1010000);
            lArray2[1] = l6 = lArray3[1];
            lArray2[2] = l6 = lArray3[2];
            lArray2[3] = l6 = lArray3[3];
            lArray2[4] = l6 = lArray3[4];
            lArray[5] = l5 = blake2b_IV[5];
            byte[] byArray = this.salt;
            if (this.salt != null) {
                lArray2[4] = l6 ^= Pack.littleEndianToLong(byArray, 0);
                this.chainValue[5] = l6 = this.chainValue[5] ^ Pack.littleEndianToLong(this.salt, 8);
            }
            Blake2bDigest blake2bDigest = this;
            lArray2 = blake2bDigest.chainValue;
            lArray2[6] = l4 = lArray3[6];
            blake2bDigest.chainValue[7] = l3 = lArray3[7];
            byte[] byArray2 = blake2bDigest.personalization;
            if (blake2bDigest.personalization != null) {
                long l7;
                lArray2[6] = l7 = l4 ^ Pack.littleEndianToLong(byArray2, 0);
                this.chainValue[7] = l7 = this.chainValue[7] ^ Pack.littleEndianToLong(this.personalization, 8);
            }
        }
    }

    private void initializeInternalState() {
        long l3;
        long l4;
        Blake2bDigest blake2bDigest = this;
        long[] lArray = this.internalState;
        int n3 = blake2bDigest.chainValue.length;
        System.arraycopy(blake2bDigest.chainValue, 0, lArray, 0, n3);
        lArray = blake2b_IV;
        Blake2bDigest blake2bDigest2 = this;
        long[] lArray2 = blake2bDigest2.internalState;
        int n4 = blake2bDigest2.chainValue.length;
        System.arraycopy(blake2b_IV, 0, lArray2, n4, 4);
        lArray2 = blake2bDigest.internalState;
        lArray2[12] = l4 = this.t0 ^ lArray[4];
        lArray2[13] = l4 = this.t1 ^ lArray[5];
        lArray2[14] = l3 = this.f0 ^ lArray[6];
        blake2bDigest.internalState[15] = l3 = lArray[7];
    }

    private void compress(byte[] byArray, int n3) {
        int n4;
        this.initializeInternalState();
        long[] lArray = new long[16];
        for (int i3 = 0; i3 < 16; ++i3) {
            lArray[i3] = Pack.littleEndianToLong(byArray, i3 * 8 + n3);
        }
        for (n4 = 0; n4 < ROUNDS; ++n4) {
            byte[][] byArray2 = blake2b_sigma;
            byte[] byArray3 = byArray2[n4];
            long l3 = lArray[byArray3[0]];
            long l4 = lArray[byArray3[1]];
            this.G(l3, l4, 0, 4, 8, 12);
            byte[] byArray4 = byArray2[n4];
            l3 = lArray[byArray4[2]];
            l4 = lArray[byArray4[3]];
            this.G(l3, l4, 1, 5, 9, 13);
            byte[] byArray5 = byArray2[n4];
            l3 = lArray[byArray5[4]];
            l4 = lArray[byArray5[5]];
            this.G(l3, l4, 2, 6, 10, 14);
            byte[] byArray6 = byArray2[n4];
            l3 = lArray[byArray6[6]];
            l4 = lArray[byArray6[7]];
            this.G(l3, l4, 3, 7, 11, 15);
            byte[] byArray7 = byArray2[n4];
            l3 = lArray[byArray7[8]];
            l4 = lArray[byArray7[9]];
            this.G(l3, l4, 0, 5, 10, 15);
            byte[] byArray8 = byArray2[n4];
            l3 = lArray[byArray8[10]];
            l4 = lArray[byArray8[11]];
            this.G(l3, l4, 1, 6, 11, 12);
            byte[] byArray9 = byArray2[n4];
            l3 = lArray[byArray9[12]];
            l4 = lArray[byArray9[13]];
            this.G(l3, l4, 2, 7, 8, 13);
            byte[] byArray10 = blake2b_sigma[n4];
            l3 = lArray[byArray10[14]];
            l4 = lArray[byArray10[15]];
            this.G(l3, l4, 3, 4, 9, 14);
        }
        n4 = 0;
        while (true) {
            long[] lArray2 = this.chainValue;
            if (n4 >= this.chainValue.length) break;
            long[] lArray3 = lArray2;
            long l5 = lArray2[n4];
            lArray2 = this.internalState;
            lArray3[n4] = l5 ^ this.internalState[n4] ^ lArray2[n4 + 8];
            ++n4;
        }
    }

    /*
     * WARNING - void declaration
     */
    private void G(long l3, long l4, int n3, int n4, int n5, int n6) {
        long l5;
        void var3_10;
        long lArray3;
        void var7_13;
        long lArray2;
        void var8_14;
        void var1_9;
        void var6_12;
        void var5_11;
        long lArray;
        Blake2bDigest object;
        Blake2bDigest blake2bDigest = object;
        long[] lArray4 = blake2bDigest.internalState;
        lArray4[var5_11] = lArray = lArray4[var5_11] + lArray4[var6_12] + var1_9;
        blake2bDigest.internalState[var8_14] = Longs.rotateRight(lArray4[var8_14] ^ lArray, 32);
        long[] l7 = blake2bDigest.internalState;
        l7[var7_13] = lArray2 = l7[var7_13] + l7[var8_14];
        blake2bDigest.internalState[var6_12] = Longs.rotateRight(l7[var6_12] ^ lArray2, 24);
        long[] l6 = blake2bDigest.internalState;
        l6[var5_11] = lArray3 = l6[var5_11] + l6[var6_12] + var3_10;
        blake2bDigest.internalState[var8_14] = Longs.rotateRight(l6[var8_14] ^ lArray3, 16);
        long[] l52 = blake2bDigest.internalState;
        l52[var7_13] = l5 = l52[var7_13] + l52[var8_14];
        blake2bDigest.internalState[var6_12] = Longs.rotateRight(l52[var6_12] ^ l5, 63);
    }

    static {
        byte[][] byArrayArray = new byte[12][];
        byte[] byArray = new byte[16];
        byte[] byArray2 = byArray;
        byArray[0] = 0;
        byArray[1] = 1;
        byArray[2] = 2;
        byArray[3] = 3;
        byArray[4] = 4;
        byArray[5] = 5;
        byArray[6] = 6;
        byArray[7] = 7;
        byArray[8] = 8;
        byArray[9] = 9;
        byArray[10] = 10;
        byArray[11] = 11;
        byArray[12] = 12;
        byArray[13] = 13;
        byArray[14] = 14;
        byArray[15] = 15;
        byArrayArray[0] = byArray2;
        byte[] byArray3 = new byte[16];
        byArray2 = byArray3;
        byArray3[0] = 14;
        byArray3[1] = 10;
        byArray3[2] = 4;
        byArray3[3] = 8;
        byArray3[4] = 9;
        byArray3[5] = 15;
        byArray3[6] = 13;
        byArray3[7] = 6;
        byArray3[8] = 1;
        byArray3[9] = 12;
        byArray3[10] = 0;
        byArray3[11] = 2;
        byArray3[12] = 11;
        byArray3[13] = 7;
        byArray3[14] = 5;
        byArray3[15] = 3;
        byArrayArray[1] = byArray2;
        byte[] byArray4 = new byte[16];
        byArray2 = byArray4;
        byArray4[0] = 11;
        byArray4[1] = 8;
        byArray4[2] = 12;
        byArray4[3] = 0;
        byArray4[4] = 5;
        byArray4[5] = 2;
        byArray4[6] = 15;
        byArray4[7] = 13;
        byArray4[8] = 10;
        byArray4[9] = 14;
        byArray4[10] = 3;
        byArray4[11] = 6;
        byArray4[12] = 7;
        byArray4[13] = 1;
        byArray4[14] = 9;
        byArray4[15] = 4;
        byArrayArray[2] = byArray2;
        byte[] byArray5 = new byte[16];
        byArray2 = byArray5;
        byArray5[0] = 7;
        byArray5[1] = 9;
        byArray5[2] = 3;
        byArray5[3] = 1;
        byArray5[4] = 13;
        byArray5[5] = 12;
        byArray5[6] = 11;
        byArray5[7] = 14;
        byArray5[8] = 2;
        byArray5[9] = 6;
        byArray5[10] = 5;
        byArray5[11] = 10;
        byArray5[12] = 4;
        byArray5[13] = 0;
        byArray5[14] = 15;
        byArray5[15] = 8;
        byArrayArray[3] = byArray2;
        byte[] byArray6 = new byte[16];
        byArray2 = byArray6;
        byArray6[0] = 9;
        byArray6[1] = 0;
        byArray6[2] = 5;
        byArray6[3] = 7;
        byArray6[4] = 2;
        byArray6[5] = 4;
        byArray6[6] = 10;
        byArray6[7] = 15;
        byArray6[8] = 14;
        byArray6[9] = 1;
        byArray6[10] = 11;
        byArray6[11] = 12;
        byArray6[12] = 6;
        byArray6[13] = 8;
        byArray6[14] = 3;
        byArray6[15] = 13;
        byArrayArray[4] = byArray2;
        byte[] byArray7 = new byte[16];
        byArray2 = byArray7;
        byArray7[0] = 2;
        byArray7[1] = 12;
        byArray7[2] = 6;
        byArray7[3] = 10;
        byArray7[4] = 0;
        byArray7[5] = 11;
        byArray7[6] = 8;
        byArray7[7] = 3;
        byArray7[8] = 4;
        byArray7[9] = 13;
        byArray7[10] = 7;
        byArray7[11] = 5;
        byArray7[12] = 15;
        byArray7[13] = 14;
        byArray7[14] = 1;
        byArray7[15] = 9;
        byArrayArray[5] = byArray2;
        byte[] byArray8 = new byte[16];
        byArray2 = byArray8;
        byArray8[0] = 12;
        byArray8[1] = 5;
        byArray8[2] = 1;
        byArray8[3] = 15;
        byArray8[4] = 14;
        byArray8[5] = 13;
        byArray8[6] = 4;
        byArray8[7] = 10;
        byArray8[8] = 0;
        byArray8[9] = 7;
        byArray8[10] = 6;
        byArray8[11] = 3;
        byArray8[12] = 9;
        byArray8[13] = 2;
        byArray8[14] = 8;
        byArray8[15] = 11;
        byArrayArray[6] = byArray2;
        byte[] byArray9 = new byte[16];
        byArray2 = byArray9;
        byArray9[0] = 13;
        byArray9[1] = 11;
        byArray9[2] = 7;
        byArray9[3] = 14;
        byArray9[4] = 12;
        byArray9[5] = 1;
        byArray9[6] = 3;
        byArray9[7] = 9;
        byArray9[8] = 5;
        byArray9[9] = 0;
        byArray9[10] = 15;
        byArray9[11] = 4;
        byArray9[12] = 8;
        byArray9[13] = 6;
        byArray9[14] = 2;
        byArray9[15] = 10;
        byArrayArray[7] = byArray2;
        byte[] byArray10 = new byte[16];
        byArray2 = byArray10;
        byArray10[0] = 6;
        byArray10[1] = 15;
        byArray10[2] = 14;
        byArray10[3] = 9;
        byArray10[4] = 11;
        byArray10[5] = 3;
        byArray10[6] = 0;
        byArray10[7] = 8;
        byArray10[8] = 12;
        byArray10[9] = 2;
        byArray10[10] = 13;
        byArray10[11] = 7;
        byArray10[12] = 1;
        byArray10[13] = 4;
        byArray10[14] = 10;
        byArray10[15] = 5;
        byArrayArray[8] = byArray2;
        byte[] byArray11 = new byte[16];
        byArray2 = byArray11;
        byArray11[0] = 10;
        byArray11[1] = 2;
        byArray11[2] = 8;
        byArray11[3] = 4;
        byArray11[4] = 7;
        byArray11[5] = 6;
        byArray11[6] = 1;
        byArray11[7] = 5;
        byArray11[8] = 15;
        byArray11[9] = 11;
        byArray11[10] = 9;
        byArray11[11] = 14;
        byArray11[12] = 3;
        byArray11[13] = 12;
        byArray11[14] = 13;
        byArray11[15] = 0;
        byArrayArray[9] = byArray2;
        byte[] byArray12 = new byte[16];
        byArray2 = byArray12;
        byArray12[0] = 0;
        byArray12[1] = 1;
        byArray12[2] = 2;
        byArray12[3] = 3;
        byArray12[4] = 4;
        byArray12[5] = 5;
        byArray12[6] = 6;
        byArray12[7] = 7;
        byArray12[8] = 8;
        byArray12[9] = 9;
        byArray12[10] = 10;
        byArray12[11] = 11;
        byArray12[12] = 12;
        byArray12[13] = 13;
        byArray12[14] = 14;
        byArray12[15] = 15;
        byArrayArray[10] = byArray2;
        byte[] byArray13 = new byte[16];
        byArray2 = byArray13;
        byArray13[0] = 14;
        byArray13[1] = 10;
        byArray13[2] = 4;
        byArray13[3] = 8;
        byArray13[4] = 9;
        byArray13[5] = 15;
        byArray13[6] = 13;
        byArray13[7] = 6;
        byArray13[8] = 1;
        byArray13[9] = 12;
        byArray13[10] = 0;
        byArray13[11] = 2;
        byArray13[12] = 11;
        byArray13[13] = 7;
        byArray13[14] = 5;
        byArray13[15] = 3;
        byArrayArray[11] = byArray2;
        blake2b_sigma = byArrayArray;
    }

    @Override
    public void update(byte by) {
        int n3 = this.bufferPos;
        if (128 - n3 == 0) {
            long l3;
            this.t0 = l3 = this.t0 + 128L;
            if (l3 == 0L) {
                ++this.t1;
            }
            Blake2bDigest blake2bDigest = this;
            blake2bDigest.compress(blake2bDigest.buffer, 0);
            Arrays.fill(blake2bDigest.buffer, (byte)0);
            blake2bDigest.buffer[0] = by;
            blake2bDigest.bufferPos = 1;
            return;
        }
        this.buffer[n3] = by;
        this.bufferPos = n3 + 1;
    }

    @Override
    public void update(byte[] byArray, int n3, int n4) {
        if (byArray != null && n4 != 0) {
            int n5 = 0;
            int n6 = ((Blake2bDigest)object).bufferPos;
            if (n6 != 0) {
                n5 = 128 - n6;
                if (n5 < n4) {
                    long l3;
                    System.arraycopy(byArray, n3, ((Blake2bDigest)object).buffer, n6, n5);
                    ((Blake2bDigest)object).t0 = l3 = ((Blake2bDigest)object).t0 + 128L;
                    if (l3 == 0L) {
                        ++((Blake2bDigest)object).t1;
                    }
                    Object object = object;
                    super.compress(((Blake2bDigest)object).buffer, 0);
                    ((Blake2bDigest)object).bufferPos = 0;
                    Arrays.fill(((Blake2bDigest)object).buffer, (byte)0);
                } else {
                    System.arraycopy(byArray, n3, ((Blake2bDigest)object).buffer, n6, n4);
                    ((Blake2bDigest)object).bufferPos += n4;
                    return;
                }
            }
            n3 = n3 + n4;
            n4 = n3 - 128;
            for (n5 = (v578564) + n5; n5 < n4; n5 += 128) {
                long l4;
                ((Blake2bDigest)object).t0 = l4 = ((Blake2bDigest)object).t0 + 128L;
                if (l4 == 0L) {
                    ++((Blake2bDigest)object).t1;
                }
                super.compress(byArray, n5);
            }
            Blake2bDigest blake2bDigest = object;
            Object object = ((Blake2bDigest)object).buffer;
            int n7 = n3 - n5;
            System.arraycopy(byArray, n5, object, 0, n7);
            blake2bDigest.bufferPos += n7;
            return;
        }
    }

    @Override
    public int doFinal(byte[] byArray, int n3) {
        Object[] objectArray;
        Blake2bDigest blake2bDigest = this;
        blake2bDigest.f0 = -1L;
        long l3 = blake2bDigest.t0;
        int n4 = blake2bDigest.bufferPos;
        this.t0 = l3 += (long)n4;
        if (n4 > 0 && l3 == 0L) {
            ++this.t1;
        }
        Blake2bDigest blake2bDigest2 = this;
        blake2bDigest2.compress(blake2bDigest2.buffer, 0);
        Arrays.fill(blake2bDigest2.buffer, (byte)0);
        Arrays.fill(blake2bDigest2.internalState, 0L);
        int n5 = 0;
        while (true) {
            int n6;
            objectArray = this.chainValue;
            if (n5 >= this.chainValue.length || (n4 = n5 * 8) >= this.digestLength) break;
            objectArray = Pack.longToLittleEndian(objectArray[n5]);
            int n7 = this.digestLength;
            if (n4 < n7 - 8) {
                n6 = n3 + n4;
                System.arraycopy(objectArray, 0, byArray, n6, 8);
            } else {
                n6 = n3 + n4;
                n4 = n7 - n4;
                System.arraycopy(objectArray, 0, byArray, n6, n4);
            }
            ++n5;
        }
        Blake2bDigest blake2bDigest3 = this;
        Arrays.fill(objectArray, 0L);
        blake2bDigest3.reset();
        return blake2bDigest3.digestLength;
    }

    @Override
    public void reset() {
        Blake2bDigest blake2bDigest = this;
        blake2bDigest.bufferPos = 0;
        blake2bDigest.f0 = 0L;
        blake2bDigest.t0 = 0L;
        blake2bDigest.t1 = 0L;
        blake2bDigest.chainValue = null;
        Arrays.fill(blake2bDigest.buffer, (byte)0);
        byte[] byArray = blake2bDigest.key;
        if (blake2bDigest.key != null) {
            byArray = this.buffer;
            int n3 = byArray.length;
            System.arraycopy(byArray, 0, byArray, 0, n3);
            this.bufferPos = 128;
        }
        this.init();
    }

    @Override
    public String getAlgorithmName() {
        return "BLAKE2b";
    }

    @Override
    public int getDigestSize() {
        return this.digestLength;
    }

    @Override
    public int getByteLength() {
        return 128;
    }

    public void clearKey() {
        byte[] byArray = this.key;
        if (this.key != null) {
            Arrays.fill(byArray, (byte)0);
            Arrays.fill(this.buffer, (byte)0);
        }
    }

    public void clearSalt() {
        Object object = ((Blake2bDigest)object).salt;
        if (((Blake2bDigest)object).salt != null) {
            Arrays.fill((byte[])object, (byte)0);
        }
    }
}

