/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.crypto.digests;

import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.ExtendedDigest;
import com.fis.ekyc.nfc.build_in.bouncycastle.util.Arrays;
import com.fis.ekyc.nfc.build_in.bouncycastle.util.Pack;

public class Blake2sDigest
implements ExtendedDigest {
    private static final int[] blake2s_IV = new int[]{1779033703, -1150833019, 1013904242, -1521486534, 1359893119, -1694144372, 528734635, 1541459225};
    private static final byte[][] blake2s_sigma;
    private static final int ROUNDS = 10;
    private static final int BLOCK_LENGTH_BYTES = 64;
    private int digestLength;
    private int keyLength;
    private byte[] salt;
    private byte[] personalization;
    private byte[] key;
    private int fanout;
    private int depth;
    private int leafLength;
    private long nodeOffset;
    private int nodeDepth;
    private int innerHashLength;
    private byte[] buffer;
    private int bufferPos;
    private int[] internalState;
    private int[] chainValue;
    private int t0;
    private int t1;
    private int f0;

    public Blake2sDigest() {
        this(256);
    }

    public Blake2sDigest(Blake2sDigest blake2sDigest) {
        this.digestLength = 32;
        this.keyLength = 0;
        this.salt = null;
        this.personalization = null;
        this.key = null;
        this.fanout = 1;
        this.depth = 1;
        this.leafLength = 0;
        this.nodeOffset = 0L;
        this.nodeDepth = 0;
        this.innerHashLength = 0;
        this.buffer = null;
        this.bufferPos = 0;
        this.internalState = new int[16];
        this.chainValue = null;
        this.t0 = 0;
        this.t1 = 0;
        this.f0 = 0;
        this.bufferPos = blake2sDigest.bufferPos;
        this.buffer = Arrays.clone(blake2sDigest.buffer);
        this.keyLength = blake2sDigest.keyLength;
        this.key = Arrays.clone(blake2sDigest.key);
        this.digestLength = blake2sDigest.digestLength;
        this.internalState = Arrays.clone(this.internalState);
        this.chainValue = Arrays.clone(blake2sDigest.chainValue);
        this.t0 = blake2sDigest.t0;
        this.t1 = blake2sDigest.t1;
        this.f0 = blake2sDigest.f0;
        this.salt = Arrays.clone(blake2sDigest.salt);
        this.personalization = Arrays.clone(blake2sDigest.personalization);
        this.fanout = blake2sDigest.fanout;
        this.depth = blake2sDigest.depth;
        this.leafLength = blake2sDigest.leafLength;
        this.nodeOffset = blake2sDigest.nodeOffset;
        this.nodeDepth = blake2sDigest.nodeDepth;
        this.innerHashLength = blake2sDigest.innerHashLength;
    }

    public Blake2sDigest(int n3) {
        this.digestLength = 32;
        this.keyLength = 0;
        this.salt = null;
        this.personalization = null;
        this.key = null;
        this.fanout = 1;
        this.depth = 1;
        this.leafLength = 0;
        this.nodeOffset = 0L;
        this.nodeDepth = 0;
        this.innerHashLength = 0;
        this.buffer = null;
        this.bufferPos = 0;
        this.internalState = new int[16];
        this.chainValue = null;
        this.t0 = 0;
        this.t1 = 0;
        this.f0 = 0;
        if (n3 >= 8 && n3 <= 256 && n3 % 8 == 0) {
            this.digestLength = n3 / 8;
            this.init(null, null, null);
            return;
        }
        throw new IllegalArgumentException("BLAKE2s digest bit length must be a multiple of 8 and not greater than 256");
    }

    public Blake2sDigest(byte[] byArray) {
        Blake2sDigest blake2sDigest = this;
        blake2sDigest.digestLength = 32;
        blake2sDigest.keyLength = 0;
        blake2sDigest.salt = null;
        blake2sDigest.personalization = null;
        blake2sDigest.key = null;
        blake2sDigest.fanout = 1;
        blake2sDigest.depth = 1;
        blake2sDigest.leafLength = 0;
        blake2sDigest.nodeOffset = 0L;
        blake2sDigest.nodeDepth = 0;
        blake2sDigest.innerHashLength = 0;
        blake2sDigest.buffer = null;
        blake2sDigest.bufferPos = 0;
        blake2sDigest.internalState = new int[16];
        blake2sDigest.chainValue = null;
        blake2sDigest.t0 = 0;
        blake2sDigest.t1 = 0;
        blake2sDigest.f0 = 0;
        blake2sDigest.init(null, null, byArray);
    }

    public Blake2sDigest(byte[] byArray, int n3, byte[] byArray2, byte[] byArray3) {
        this.digestLength = 32;
        this.keyLength = 0;
        this.salt = null;
        this.personalization = null;
        this.key = null;
        this.fanout = 1;
        this.depth = 1;
        this.leafLength = 0;
        this.nodeOffset = 0L;
        this.nodeDepth = 0;
        this.innerHashLength = 0;
        this.buffer = null;
        this.bufferPos = 0;
        this.internalState = new int[16];
        this.chainValue = null;
        this.t0 = 0;
        this.t1 = 0;
        this.f0 = 0;
        if (n3 >= 1 && n3 <= 32) {
            this.digestLength = n3;
            this.init(byArray2, byArray3, byArray);
            return;
        }
        throw new IllegalArgumentException("Invalid digest length (required: 1 - 32)");
    }

    public Blake2sDigest(int n3, byte[] byArray, byte[] byArray2, byte[] byArray3, long l3) {
        this.keyLength = 0;
        this.salt = null;
        this.personalization = null;
        this.key = null;
        this.fanout = 1;
        this.depth = 1;
        this.leafLength = 0;
        this.nodeDepth = 0;
        this.innerHashLength = 0;
        this.buffer = null;
        this.bufferPos = 0;
        this.internalState = new int[16];
        this.chainValue = null;
        this.t0 = 0;
        this.t1 = 0;
        this.f0 = 0;
        this.digestLength = n3;
        this.nodeOffset = l3;
        this.init(byArray2, byArray3, byArray);
    }

    public Blake2sDigest(int n3, int n4, long l3) {
        Blake2sDigest blake2sDigest = this;
        this.keyLength = 0;
        this.salt = null;
        this.personalization = null;
        this.key = null;
        this.buffer = null;
        this.bufferPos = 0;
        this.internalState = new int[16];
        this.chainValue = null;
        this.t0 = 0;
        this.t1 = 0;
        this.f0 = 0;
        this.digestLength = n3;
        blake2sDigest.nodeOffset = l3;
        blake2sDigest.fanout = 0;
        blake2sDigest.depth = 0;
        this.leafLength = n4;
        this.innerHashLength = n4;
        this.nodeDepth = 0;
        this.init(null, null, null);
    }

    private void init(byte[] byArray, byte[] byArray2, byte[] objectArray) {
        ((Blake2sDigest)object).buffer = new byte[64];
        if (objectArray != null && objectArray.length > 0) {
            if (objectArray.length <= 32) {
                Object[] objectArray2 = objectArray;
                objectArray = new byte[objectArray.length];
                ((Blake2sDigest)object).key = objectArray;
                int n3 = objectArray2.length;
                System.arraycopy(objectArray2, 0, objectArray, 0, n3);
                ((Blake2sDigest)object).keyLength = objectArray.length;
                objectArray = ((Blake2sDigest)object).buffer;
                n3 = objectArray.length;
                System.arraycopy(objectArray, 0, objectArray, 0, n3);
                ((Blake2sDigest)object).bufferPos = 64;
            } else {
                throw new IllegalArgumentException("Keys > 32 bytes are not supported");
            }
        }
        if (((Blake2sDigest)object).chainValue == null) {
            int[] nArray = new int[8];
            objectArray = nArray;
            ((Blake2sDigest)object).chainValue = objectArray;
            int[] nArray2 = blake2s_IV;
            objectArray[0] = nArray2[0] ^ (((Blake2sDigest)object).digestLength | ((Blake2sDigest)object).keyLength << 8 | (((Blake2sDigest)object).fanout << 16 | ((Blake2sDigest)object).depth << 24));
            objectArray[1] = nArray2[1] ^ ((Blake2sDigest)object).leafLength;
            long l3 = ((Blake2sDigest)object).nodeOffset;
            int n4 = (int)(l3 >> 32);
            int n5 = (int)l3;
            objectArray[2] = nArray2[2] ^ n5;
            objectArray[3] = nArray2[3] ^ (n4 | ((Blake2sDigest)object).nodeDepth << 16 | ((Blake2sDigest)object).innerHashLength << 24);
            objectArray[4] = nArray2[4];
            nArray[5] = blake2s_IV[5];
            if (byArray != null) {
                if (byArray.length == 8) {
                    Blake2sDigest blake2sDigest = object;
                    byte[] byArray3 = new byte[8];
                    ((Blake2sDigest)object).salt = byArray3;
                    n5 = byArray.length;
                    System.arraycopy(byArray, 0, byArray3, 0, n5);
                    blake2sDigest.chainValue[4] = blake2sDigest.chainValue[4] ^ Pack.littleEndianToInt(byArray, 0);
                    blake2sDigest.chainValue[5] = blake2sDigest.chainValue[5] ^ Pack.littleEndianToInt(byArray, 4);
                } else {
                    throw new IllegalArgumentException("Salt length must be exactly 8 bytes");
                }
            }
            ((Blake2sDigest)object).chainValue[6] = nArray2[6];
            ((Blake2sDigest)object).chainValue[7] = nArray2[7];
            if (byArray2 != null) {
                if (byArray2.length == 8) {
                    Blake2sDigest blake2sDigest = object;
                    Blake2sDigest blake2sDigest2 = object;
                    byte[] byArray4 = new byte[8];
                    Object object = byArray4;
                    blake2sDigest2.personalization = byArray4;
                    int n6 = byArray2.length;
                    System.arraycopy(byArray2, 0, object, 0, n6);
                    blake2sDigest.chainValue[6] = blake2sDigest.chainValue[6] ^ Pack.littleEndianToInt(byArray2, 0);
                    blake2sDigest.chainValue[7] = blake2sDigest.chainValue[7] ^ Pack.littleEndianToInt(byArray2, 4);
                } else {
                    throw new IllegalArgumentException("Personalization length must be exactly 8 bytes");
                }
            }
        }
    }

    private void initializeInternalState() {
        Blake2sDigest blake2sDigest = this;
        int[] nArray = this.internalState;
        int n3 = blake2sDigest.chainValue.length;
        System.arraycopy(blake2sDigest.chainValue, 0, nArray, 0, n3);
        nArray = blake2s_IV;
        Blake2sDigest blake2sDigest2 = this;
        int[] nArray2 = blake2sDigest2.internalState;
        int n4 = blake2sDigest2.chainValue.length;
        System.arraycopy(blake2s_IV, 0, nArray2, n4, 4);
        nArray2 = blake2sDigest.internalState;
        nArray2[12] = this.t0 ^ nArray[4];
        nArray2[13] = this.t1 ^ nArray[5];
        nArray2[14] = this.f0 ^ nArray[6];
        blake2sDigest.internalState[15] = nArray[7];
    }

    private void compress(byte[] byArray, int n3) {
        int n4;
        this.initializeInternalState();
        int[] nArray = new int[16];
        for (int i3 = 0; i3 < 16; ++i3) {
            nArray[i3] = Pack.littleEndianToInt(byArray, i3 * 4 + n3);
        }
        for (n4 = 0; n4 < 10; ++n4) {
            byte[][] byArray2 = blake2s_sigma;
            byte[] byArray3 = byArray2[n4];
            n3 = nArray[byArray3[0]];
            this.G(n3, nArray[byArray3[1]], 0, 4, 8, 12);
            byte[] byArray4 = byArray2[n4];
            n3 = nArray[byArray4[2]];
            this.G(n3, nArray[byArray4[3]], 1, 5, 9, 13);
            byte[] byArray5 = byArray2[n4];
            n3 = nArray[byArray5[4]];
            this.G(n3, nArray[byArray5[5]], 2, 6, 10, 14);
            byte[] byArray6 = byArray2[n4];
            n3 = nArray[byArray6[6]];
            this.G(n3, nArray[byArray6[7]], 3, 7, 11, 15);
            byte[] byArray7 = byArray2[n4];
            n3 = nArray[byArray7[8]];
            this.G(n3, nArray[byArray7[9]], 0, 5, 10, 15);
            byte[] byArray8 = byArray2[n4];
            n3 = nArray[byArray8[10]];
            this.G(n3, nArray[byArray8[11]], 1, 6, 11, 12);
            byte[] byArray9 = byArray2[n4];
            n3 = nArray[byArray9[12]];
            this.G(n3, nArray[byArray9[13]], 2, 7, 8, 13);
            byte[] byArray10 = blake2s_sigma[n4];
            n3 = nArray[byArray10[14]];
            this.G(n3, nArray[byArray10[15]], 3, 4, 9, 14);
        }
        n4 = 0;
        while (true) {
            int[] nArray2 = this.chainValue;
            if (n4 >= this.chainValue.length) break;
            int[] nArray3 = nArray2;
            int n5 = nArray2[n4];
            nArray2 = this.internalState;
            nArray3[n4] = n5 ^ this.internalState[n4] ^ nArray2[n4 + 8];
            ++n4;
        }
    }

    private void G(int n3, int n4, int n5, int n6, int n7, int n8) {
        int n9;
        int n10;
        int n11;
        Blake2sDigest blake2sDigest = this;
        int[] nArray = blake2sDigest.internalState;
        nArray[n5] = n3 = nArray[n5] + nArray[n6] + n3;
        blake2sDigest.internalState[n8] = this.rotr32(nArray[n8] ^ n3, 16);
        int[] nArray2 = blake2sDigest.internalState;
        nArray2[n7] = n11 = nArray2[n7] + nArray2[n8];
        blake2sDigest.internalState[n6] = this.rotr32(nArray2[n6] ^ n11, 12);
        int[] nArray3 = blake2sDigest.internalState;
        nArray3[n5] = n10 = nArray3[n5] + nArray3[n6] + n4;
        blake2sDigest.internalState[n8] = this.rotr32(nArray3[n8] ^ n10, 8);
        int[] nArray4 = blake2sDigest.internalState;
        nArray4[n7] = n9 = nArray4[n7] + nArray4[n8];
        blake2sDigest.internalState[n6] = this.rotr32(nArray4[n6] ^ n9, 7);
    }

    private int rotr32(int n3, int n4) {
        return n3 >>> n4 | n3 << 32 - n4;
    }

    static {
        byte[][] byArrayArray = new byte[10][];
        byte[] byArray = new byte[16];
        byte[] byArray2 = byArray;
        byArray[0] = 0;
        byArray[1] = 1;
        byArray[2] = 2;
        byArray[3] = 3;
        byArray[4] = 4;
        byArray[5] = 5;
        byArray[6] = 6;
        byArray[7] = 7;
        byArray[8] = 8;
        byArray[9] = 9;
        byArray[10] = 10;
        byArray[11] = 11;
        byArray[12] = 12;
        byArray[13] = 13;
        byArray[14] = 14;
        byArray[15] = 15;
        byArrayArray[0] = byArray2;
        byte[] byArray3 = new byte[16];
        byArray2 = byArray3;
        byArray3[0] = 14;
        byArray3[1] = 10;
        byArray3[2] = 4;
        byArray3[3] = 8;
        byArray3[4] = 9;
        byArray3[5] = 15;
        byArray3[6] = 13;
        byArray3[7] = 6;
        byArray3[8] = 1;
        byArray3[9] = 12;
        byArray3[10] = 0;
        byArray3[11] = 2;
        byArray3[12] = 11;
        byArray3[13] = 7;
        byArray3[14] = 5;
        byArray3[15] = 3;
        byArrayArray[1] = byArray2;
        byte[] byArray4 = new byte[16];
        byArray2 = byArray4;
        byArray4[0] = 11;
        byArray4[1] = 8;
        byArray4[2] = 12;
        byArray4[3] = 0;
        byArray4[4] = 5;
        byArray4[5] = 2;
        byArray4[6] = 15;
        byArray4[7] = 13;
        byArray4[8] = 10;
        byArray4[9] = 14;
        byArray4[10] = 3;
        byArray4[11] = 6;
        byArray4[12] = 7;
        byArray4[13] = 1;
        byArray4[14] = 9;
        byArray4[15] = 4;
        byArrayArray[2] = byArray2;
        byte[] byArray5 = new byte[16];
        byArray2 = byArray5;
        byArray5[0] = 7;
        byArray5[1] = 9;
        byArray5[2] = 3;
        byArray5[3] = 1;
        byArray5[4] = 13;
        byArray5[5] = 12;
        byArray5[6] = 11;
        byArray5[7] = 14;
        byArray5[8] = 2;
        byArray5[9] = 6;
        byArray5[10] = 5;
        byArray5[11] = 10;
        byArray5[12] = 4;
        byArray5[13] = 0;
        byArray5[14] = 15;
        byArray5[15] = 8;
        byArrayArray[3] = byArray2;
        byte[] byArray6 = new byte[16];
        byArray2 = byArray6;
        byArray6[0] = 9;
        byArray6[1] = 0;
        byArray6[2] = 5;
        byArray6[3] = 7;
        byArray6[4] = 2;
        byArray6[5] = 4;
        byArray6[6] = 10;
        byArray6[7] = 15;
        byArray6[8] = 14;
        byArray6[9] = 1;
        byArray6[10] = 11;
        byArray6[11] = 12;
        byArray6[12] = 6;
        byArray6[13] = 8;
        byArray6[14] = 3;
        byArray6[15] = 13;
        byArrayArray[4] = byArray2;
        byte[] byArray7 = new byte[16];
        byArray2 = byArray7;
        byArray7[0] = 2;
        byArray7[1] = 12;
        byArray7[2] = 6;
        byArray7[3] = 10;
        byArray7[4] = 0;
        byArray7[5] = 11;
        byArray7[6] = 8;
        byArray7[7] = 3;
        byArray7[8] = 4;
        byArray7[9] = 13;
        byArray7[10] = 7;
        byArray7[11] = 5;
        byArray7[12] = 15;
        byArray7[13] = 14;
        byArray7[14] = 1;
        byArray7[15] = 9;
        byArrayArray[5] = byArray2;
        byte[] byArray8 = new byte[16];
        byArray2 = byArray8;
        byArray8[0] = 12;
        byArray8[1] = 5;
        byArray8[2] = 1;
        byArray8[3] = 15;
        byArray8[4] = 14;
        byArray8[5] = 13;
        byArray8[6] = 4;
        byArray8[7] = 10;
        byArray8[8] = 0;
        byArray8[9] = 7;
        byArray8[10] = 6;
        byArray8[11] = 3;
        byArray8[12] = 9;
        byArray8[13] = 2;
        byArray8[14] = 8;
        byArray8[15] = 11;
        byArrayArray[6] = byArray2;
        byte[] byArray9 = new byte[16];
        byArray2 = byArray9;
        byArray9[0] = 13;
        byArray9[1] = 11;
        byArray9[2] = 7;
        byArray9[3] = 14;
        byArray9[4] = 12;
        byArray9[5] = 1;
        byArray9[6] = 3;
        byArray9[7] = 9;
        byArray9[8] = 5;
        byArray9[9] = 0;
        byArray9[10] = 15;
        byArray9[11] = 4;
        byArray9[12] = 8;
        byArray9[13] = 6;
        byArray9[14] = 2;
        byArray9[15] = 10;
        byArrayArray[7] = byArray2;
        byte[] byArray10 = new byte[16];
        byArray2 = byArray10;
        byArray10[0] = 6;
        byArray10[1] = 15;
        byArray10[2] = 14;
        byArray10[3] = 9;
        byArray10[4] = 11;
        byArray10[5] = 3;
        byArray10[6] = 0;
        byArray10[7] = 8;
        byArray10[8] = 12;
        byArray10[9] = 2;
        byArray10[10] = 13;
        byArray10[11] = 7;
        byArray10[12] = 1;
        byArray10[13] = 4;
        byArray10[14] = 10;
        byArray10[15] = 5;
        byArrayArray[8] = byArray2;
        byte[] byArray11 = new byte[16];
        byArray2 = byArray11;
        byArray11[0] = 10;
        byArray11[1] = 2;
        byArray11[2] = 8;
        byArray11[3] = 4;
        byArray11[4] = 7;
        byArray11[5] = 6;
        byArray11[6] = 1;
        byArray11[7] = 5;
        byArray11[8] = 15;
        byArray11[9] = 11;
        byArray11[10] = 9;
        byArray11[11] = 14;
        byArray11[12] = 3;
        byArray11[13] = 12;
        byArray11[14] = 13;
        byArray11[15] = 0;
        byArrayArray[9] = byArray2;
        blake2s_sigma = byArrayArray;
    }

    @Override
    public void update(byte by) {
        int n3 = this.bufferPos;
        if (64 - n3 == 0) {
            if ((this.t0 += 64) == 0) {
                ++this.t1;
            }
            Blake2sDigest blake2sDigest = this;
            blake2sDigest.compress(blake2sDigest.buffer, 0);
            Arrays.fill(blake2sDigest.buffer, (byte)0);
            blake2sDigest.buffer[0] = by;
            blake2sDigest.bufferPos = 1;
        } else {
            this.buffer[n3] = by;
            this.bufferPos = n3 + 1;
        }
    }

    @Override
    public void update(byte[] byArray, int n3, int n4) {
        if (byArray != null && n4 != 0) {
            int n5 = 0;
            int n6 = ((Blake2sDigest)object).bufferPos;
            if (n6 != 0) {
                n5 = 64 - n6;
                if (n5 < n4) {
                    System.arraycopy(byArray, n3, ((Blake2sDigest)object).buffer, n6, n5);
                    if ((((Blake2sDigest)object).t0 += 64) == 0) {
                        ++((Blake2sDigest)object).t1;
                    }
                    Blake2sDigest blake2sDigest = object;
                    blake2sDigest.compress(blake2sDigest.buffer, 0);
                    blake2sDigest.bufferPos = 0;
                    Arrays.fill(blake2sDigest.buffer, (byte)0);
                } else {
                    System.arraycopy(byArray, n3, ((Blake2sDigest)object).buffer, n6, n4);
                    ((Blake2sDigest)object).bufferPos += n4;
                    return;
                }
            }
            n3 = n3 + n4;
            n4 = n3 - 64;
            for (n5 = (v580723) + n5; n5 < n4; n5 += 64) {
                if ((((Blake2sDigest)object).t0 += 64) == 0) {
                    ++((Blake2sDigest)object).t1;
                }
                super.compress(byArray, n5);
            }
            Blake2sDigest blake2sDigest = object;
            Object object = ((Blake2sDigest)object).buffer;
            int n7 = n3 - n5;
            System.arraycopy(byArray, n5, object, 0, n7);
            blake2sDigest.bufferPos += n7;
            return;
        }
    }

    @Override
    public int doFinal(byte[] byArray, int n3) {
        Object[] objectArray;
        int n4;
        this.f0 = -1;
        int n5 = this.bufferPos;
        this.t0 = n4 = this.t0 + n5;
        if (n4 < 0 && n5 > -n4) {
            ++this.t1;
        }
        Blake2sDigest blake2sDigest = this;
        blake2sDigest.compress(blake2sDigest.buffer, 0);
        Arrays.fill(blake2sDigest.buffer, (byte)0);
        Arrays.fill(blake2sDigest.internalState, 0);
        n5 = 0;
        while (true) {
            int n6;
            objectArray = this.chainValue;
            if (n5 >= this.chainValue.length || (n6 = n5 * 4) >= this.digestLength) break;
            objectArray = Pack.intToLittleEndian(objectArray[n5]);
            int n7 = this.digestLength;
            if (n6 < n7 - 4) {
                n4 = n3 + n6;
                System.arraycopy(objectArray, 0, byArray, n4, 4);
            } else {
                n4 = n3 + n6;
                n6 = n7 - n6;
                System.arraycopy(objectArray, 0, byArray, n4, n6);
            }
            ++n5;
        }
        Blake2sDigest blake2sDigest2 = this;
        Arrays.fill(objectArray, 0);
        blake2sDigest2.reset();
        return blake2sDigest2.digestLength;
    }

    @Override
    public void reset() {
        Blake2sDigest blake2sDigest = object;
        blake2sDigest.bufferPos = 0;
        blake2sDigest.f0 = 0;
        blake2sDigest.t0 = 0;
        blake2sDigest.t1 = 0;
        blake2sDigest.chainValue = null;
        Arrays.fill(blake2sDigest.buffer, (byte)0);
        byte[] byArray = blake2sDigest.key;
        if (blake2sDigest.key != null) {
            byArray = ((Blake2sDigest)object).buffer;
            int n3 = byArray.length;
            System.arraycopy(byArray, 0, byArray, 0, n3);
            ((Blake2sDigest)object).bufferPos = 64;
        }
        Blake2sDigest blake2sDigest2 = object;
        Object object = blake2sDigest2.salt;
        byArray = blake2sDigest2.personalization;
        byte[] byArray2 = blake2sDigest2.key;
        blake2sDigest2.init((byte[])object, byArray, byArray2);
    }

    @Override
    public String getAlgorithmName() {
        return "BLAKE2s";
    }

    @Override
    public int getDigestSize() {
        return this.digestLength;
    }

    @Override
    public int getByteLength() {
        return 64;
    }

    public void clearKey() {
        byte[] byArray = this.key;
        if (this.key != null) {
            Arrays.fill(byArray, (byte)0);
            Arrays.fill(this.buffer, (byte)0);
        }
    }

    public void clearSalt() {
        Object object = ((Blake2sDigest)object).salt;
        if (((Blake2sDigest)object).salt != null) {
            Arrays.fill((byte[])object, (byte)0);
        }
    }
}

