/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.crypto.digests;

import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.Xof;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.digests.Blake2sDigest;
import com.fis.ekyc.nfc.build_in.bouncycastle.util.Arrays;

public class Blake2xsDigest
implements Xof {
    public static final int UNKNOWN_DIGEST_LENGTH = 65535;
    private static final int DIGEST_LENGTH = 32;
    private static final long MAX_NUMBER_BLOCKS = 0x100000000L;
    private int digestLength;
    private Blake2sDigest hash;
    private byte[] h0;
    private byte[] buf;
    private int bufPos;
    private int digestPos;
    private long blockPos;
    private long nodeOffset;

    public Blake2xsDigest() {
        this(65535);
    }

    public Blake2xsDigest(int n3) {
        this(n3, null, null, null);
    }

    public Blake2xsDigest(int n3, byte[] byArray) {
        this(n3, byArray, null, null);
    }

    public Blake2xsDigest(int n3, byte[] byArray, byte[] byArray2, byte[] byArray3) {
        this.h0 = null;
        this.buf = new byte[32];
        this.bufPos = 32;
        this.digestPos = 0;
        this.blockPos = 0L;
        if (n3 >= 1 && n3 <= 65535) {
            Blake2sDigest blake2sDigest;
            long l3;
            this.digestLength = n3;
            this.nodeOffset = l3 = this.computeNodeOffset();
            Blake2sDigest blake2sDigest2 = blake2sDigest;
            blake2sDigest = new Blake2sDigest(32, byArray, byArray2, byArray3, l3);
            this.hash = blake2sDigest2;
            return;
        }
        throw new IllegalArgumentException("BLAKE2xs digest length must be between 1 and 2^16-1");
    }

    public Blake2xsDigest(Blake2xsDigest blake2xsDigest) {
        Blake2xsDigest blake2xsDigest2 = this;
        this.h0 = null;
        this.buf = new byte[32];
        this.bufPos = 32;
        this.digestPos = 0;
        this.blockPos = 0L;
        blake2xsDigest2.digestLength = blake2xsDigest.digestLength;
        blake2xsDigest2.hash = new Blake2sDigest(blake2xsDigest.hash);
        this.h0 = Arrays.clone(blake2xsDigest.h0);
        this.buf = Arrays.clone(blake2xsDigest.buf);
        this.bufPos = blake2xsDigest.bufPos;
        this.digestPos = blake2xsDigest.digestPos;
        this.blockPos = blake2xsDigest.blockPos;
        this.nodeOffset = blake2xsDigest.nodeOffset;
    }

    private int computeStepLength() {
        int n3 = this.digestLength;
        if (n3 == 65535) {
            return 32;
        }
        return Math.min(32, n3 - this.digestPos);
    }

    private long computeNodeOffset() {
        return (long)this.digestLength * 0x100000000L;
    }

    @Override
    public String getAlgorithmName() {
        return "BLAKE2xs";
    }

    @Override
    public int getDigestSize() {
        return this.digestLength;
    }

    @Override
    public int getByteLength() {
        return this.hash.getByteLength();
    }

    public long getUnknownMaxLength() {
        return 0x2000000000L;
    }

    @Override
    public void update(byte by) {
        this.hash.update(by);
    }

    @Override
    public void update(byte[] byArray, int n3, int n4) {
        this.hash.update(byArray, n3, n4);
    }

    @Override
    public void reset() {
        Blake2xsDigest blake2xsDigest = this;
        blake2xsDigest.hash.reset();
        blake2xsDigest.h0 = null;
        blake2xsDigest.bufPos = 32;
        blake2xsDigest.digestPos = 0;
        blake2xsDigest.blockPos = 0L;
        blake2xsDigest.nodeOffset = blake2xsDigest.computeNodeOffset();
    }

    @Override
    public int doFinal(byte[] byArray, int n3) {
        return this.doFinal(byArray, n3, byArray.length);
    }

    @Override
    public int doFinal(byte[] byArray, int n3, int n4) {
        int n5 = this.doOutput(byArray, n3, n4);
        this.reset();
        return n5;
    }

    @Override
    public int doOutput(byte[] byArray, int n3, int n4) {
        block10: {
            block9: {
                block8: {
                    if (this.h0 == null) {
                        Blake2xsDigest blake2xsDigest = this;
                        byte[] byArray2 = new byte[blake2xsDigest.hash.getDigestSize()];
                        blake2xsDigest.h0 = byArray2;
                        blake2xsDigest.hash.doFinal(byArray2, 0);
                    }
                    if ((n3 = this.digestLength) == 65535) break block8;
                    if (this.digestPos + n4 > n3) {
                        throw new IllegalArgumentException("Output length is above the digest length");
                    }
                    break block9;
                }
                if (this.blockPos << 5 >= this.getUnknownMaxLength()) break block10;
            }
            for (n3 = 0; n3 < n4; ++n3) {
                Object object;
                if (this.bufPos >= 32) {
                    Blake2sDigest blake2sDigest;
                    Blake2xsDigest blake2xsDigest = this;
                    object = blake2sDigest;
                    Blake2xsDigest blake2xsDigest2 = this;
                    Blake2xsDigest blake2xsDigest3 = this;
                    int n5 = blake2xsDigest3.computeStepLength();
                    long l3 = blake2xsDigest3.nodeOffset;
                    ((Blake2sDigest)object)(n5, 32, l3);
                    ((Blake2sDigest)object).update(this.h0, 0, this.h0.length);
                    Arrays.fill(blake2xsDigest2.buf, (byte)0);
                    blake2sDigest.doFinal(blake2xsDigest2.buf, 0);
                    blake2xsDigest.bufPos = 0;
                    ++blake2xsDigest.nodeOffset;
                    ++blake2xsDigest.blockPos;
                }
                Blake2xsDigest blake2xsDigest = this;
                object = blake2xsDigest.buf;
                int n6 = blake2xsDigest.bufPos;
                byArray[n3] = object[n6];
                blake2xsDigest.bufPos = n6 + 1;
                ++blake2xsDigest.digestPos;
            }
            return n4;
        }
        throw new IllegalArgumentException("Maximum length is 2^32 blocks of 32 bytes");
    }
}

