/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.crypto.digests;

import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.ExtendedDigest;
import com.fis.ekyc.nfc.build_in.bouncycastle.util.Arrays;
import com.fis.ekyc.nfc.build_in.bouncycastle.util.Memoable;
import com.fis.ekyc.nfc.build_in.bouncycastle.util.Pack;

public class DSTU7564Digest
implements ExtendedDigest,
Memoable {
    private static final int NB_512 = 8;
    private static final int NB_1024 = 16;
    private static final int NR_512 = 10;
    private static final int NR_1024 = 14;
    private static final byte[] S0 = new byte[]{-88, 67, 95, 6, 107, 117, 108, 89, 113, -33, -121, -107, 23, -16, -40, 9, 109, -13, 29, -53, -55, 77, 44, -81, 121, -32, -105, -3, 111, 75, 69, 57, 62, -35, -93, 79, -76, -74, -102, 14, 31, -65, 21, -31, 73, -46, -109, -58, -110, 114, -98, 97, -47, 99, -6, -18, -12, 25, -43, -83, 88, -92, -69, -95, -36, -14, -125, 55, 66, -28, 122, 50, -100, -52, -85, 74, -113, 110, 4, 39, 46, -25, -30, 90, -106, 22, 35, 43, -62, 101, 102, 15, -68, -87, 71, 65, 52, 72, -4, -73, 106, -120, -91, 83, -122, -7, 91, -37, 56, 123, -61, 30, 34, 51, 36, 40, 54, -57, -78, 59, -114, 119, -70, -11, 20, -97, 8, 85, -101, 76, -2, 96, 92, -38, 24, 70, -51, 125, 33, -80, 63, 27, -119, -1, -21, -124, 105, 58, -99, -41, -45, 112, 103, 64, -75, -34, 93, 48, -111, -79, 120, 17, 1, -27, 0, 104, -104, -96, -59, 2, -90, 116, 45, 11, -94, 118, -77, -66, -50, -67, -82, -23, -118, 49, 28, -20, -15, -103, -108, -86, -10, 38, 47, -17, -24, -116, 53, 3, -44, 127, -5, 5, -63, 94, -112, 32, 61, -126, -9, -22, 10, 13, 126, -8, 80, 26, -60, 7, 87, -72, 60, 98, -29, -56, -84, 82, 100, 16, -48, -39, 19, 12, 18, 41, 81, -71, -49, -42, 115, -115, -127, 84, -64, -19, 78, 68, -89, 42, -123, 37, -26, -54, 124, -117, 86, -128};
    private static final byte[] S1 = new byte[]{-50, -69, -21, -110, -22, -53, 19, -63, -23, 58, -42, -78, -46, -112, 23, -8, 66, 21, 86, -76, 101, 28, -120, 67, -59, 92, 54, -70, -11, 87, 103, -115, 49, -10, 100, 88, -98, -12, 34, -86, 117, 15, 2, -79, -33, 109, 115, 77, 124, 38, 46, -9, 8, 93, 68, 62, -97, 20, -56, -82, 84, 16, -40, -68, 26, 107, 105, -13, -67, 51, -85, -6, -47, -101, 104, 78, 22, -107, -111, -18, 76, 99, -114, 91, -52, 60, 25, -95, -127, 73, 123, -39, 111, 55, 96, -54, -25, 43, 72, -3, -106, 69, -4, 65, 18, 13, 121, -27, -119, -116, -29, 32, 48, -36, -73, 108, 74, -75, 63, -105, -44, 98, 45, 6, -92, -91, -125, 95, 42, -38, -55, 0, 126, -94, 85, -65, 17, -43, -100, -49, 14, 10, 61, 81, 125, -109, 27, -2, -60, 71, 9, -122, 11, -113, -99, 106, 7, -71, -80, -104, 24, 50, 113, 75, -17, 59, 112, -96, -28, 64, -1, -61, -87, -26, 120, -7, -117, 70, -128, 30, 56, -31, -72, -88, -32, 12, 35, 118, 29, 37, 36, 5, -15, 110, -108, 40, -102, -124, -24, -93, 79, 119, -45, -123, -30, 82, -14, -126, 80, 122, 47, 116, 83, -77, 97, -81, 57, 53, -34, -51, 31, -103, -84, -83, 114, 44, -35, -48, -121, -66, 94, -90, -20, 4, -58, 3, 52, -5, -37, 89, -74, -62, 1, -16, 90, -19, -89, 102, 33, 127, -118, 39, -57, -64, 41, -41};
    private static final byte[] S2 = new byte[]{-109, -39, -102, -75, -104, 34, 69, -4, -70, 106, -33, 2, -97, -36, 81, 89, 74, 23, 43, -62, -108, -12, -69, -93, 98, -28, 113, -44, -51, 112, 22, -31, 73, 60, -64, -40, 92, -101, -83, -123, 83, -95, 122, -56, 45, -32, -47, 114, -90, 44, -60, -29, 118, 120, -73, -76, 9, 59, 14, 65, 76, -34, -78, -112, 37, -91, -41, 3, 17, 0, -61, 46, -110, -17, 78, 18, -99, 125, -53, 53, 16, -43, 79, -98, 77, -87, 85, -58, -48, 123, 24, -105, -45, 54, -26, 72, 86, -127, -113, 119, -52, -100, -71, -30, -84, -72, 47, 21, -92, 124, -38, 56, 30, 11, 5, -42, 20, 110, 108, 126, 102, -3, -79, -27, 96, -81, 94, 51, -121, -55, -16, 93, 109, 63, -120, -115, -57, -9, 29, -23, -20, -19, -128, 41, 39, -49, -103, -88, 80, 15, 55, 36, 40, 48, -107, -46, 62, 91, 64, -125, -77, 105, 87, 31, 7, 28, -118, -68, 32, -21, -50, -114, -85, -18, 49, -94, 115, -7, -54, 58, 26, -5, 13, -63, -2, -6, -14, 111, -67, -106, -35, 67, 82, -74, 8, -13, -82, -66, 25, -119, 50, 38, -80, -22, 75, 100, -124, -126, 107, -11, 121, -65, 1, 95, 117, 99, 27, 35, 61, 104, 42, 101, -24, -111, -10, -1, 19, 88, -15, 71, 10, 127, -59, -89, -25, 97, 90, 6, 70, 68, 66, 4, -96, -37, 57, -122, 84, -86, -116, 52, 33, -117, -8, 12, 116, 103};
    private static final byte[] S3 = new byte[]{104, -115, -54, 77, 115, 75, 78, 42, -44, 82, 38, -77, 84, 30, 25, 31, 34, 3, 70, 61, 45, 74, 83, -125, 19, -118, -73, -43, 37, 121, -11, -67, 88, 47, 13, 2, -19, 81, -98, 17, -14, 62, 85, 94, -47, 22, 60, 102, 112, 93, -13, 69, 64, -52, -24, -108, 86, 8, -50, 26, 58, -46, -31, -33, -75, 56, 110, 14, -27, -12, -7, -122, -23, 79, -42, -123, 35, -49, 50, -103, 49, 20, -82, -18, -56, 72, -45, 48, -95, -110, 65, -79, 24, -60, 44, 113, 114, 68, 21, -3, 55, -66, 95, -86, -101, -120, -40, -85, -119, -100, -6, 96, -22, -68, 98, 12, 36, -90, -88, -20, 103, 32, -37, 124, 40, -35, -84, 91, 52, 126, 16, -15, 123, -113, 99, -96, 5, -102, 67, 119, 33, -65, 39, 9, -61, -97, -74, -41, 41, -62, -21, -64, -92, -117, -116, 29, -5, -1, -63, -78, -105, 46, -8, 101, -10, 117, 7, 4, 73, 51, -28, -39, -71, -48, 66, -57, 108, -112, 0, -114, 111, 80, 1, -59, -38, 71, 63, -51, 105, -94, -30, 122, -89, -58, -109, 15, 10, 6, -26, 43, -106, -93, 28, -81, 106, 18, -124, 57, -25, -80, -126, -9, -2, -99, -121, 92, -127, 53, -34, -76, -91, -4, -128, -17, -53, -69, 107, 118, -70, 90, 125, 120, 11, -107, -29, -83, 116, -104, 59, 54, 100, 109, -36, -16, 89, -87, 76, 23, 127, -111, -72, -55, 87, 27, -32, 97};
    private int hashSize;
    private int blockSize;
    private int columns;
    private int rounds;
    private long[] state;
    private long[] tempState1;
    private long[] tempState2;
    private long inputBlocks;
    private int bufOff;
    private byte[] buf;

    public DSTU7564Digest(DSTU7564Digest dSTU7564Digest) {
        DSTU7564Digest dSTU7564Digest2 = this;
        dSTU7564Digest2.copyIn(dSTU7564Digest);
    }

    private void copyIn(DSTU7564Digest dSTU7564Digest) {
        this.hashSize = dSTU7564Digest.hashSize;
        this.blockSize = dSTU7564Digest.blockSize;
        this.rounds = dSTU7564Digest.rounds;
        int n3 = this.columns;
        if (n3 > 0 && n3 == dSTU7564Digest.columns) {
            DSTU7564Digest dSTU7564Digest2 = dSTU7564Digest;
            System.arraycopy(dSTU7564Digest2.state, 0, this.state, 0, n3);
            DSTU7564Digest dSTU7564Digest3 = this;
            byte[] byArray = dSTU7564Digest3.buf;
            int n4 = dSTU7564Digest3.blockSize;
            System.arraycopy(dSTU7564Digest2.buf, 0, byArray, 0, n4);
        } else {
            this.columns = dSTU7564Digest.columns;
            this.state = Arrays.clone(dSTU7564Digest.state);
            n3 = this.columns;
            this.tempState1 = new long[n3];
            this.tempState2 = new long[n3];
            this.buf = Arrays.clone(dSTU7564Digest.buf);
        }
        this.inputBlocks = dSTU7564Digest.inputBlocks;
        this.bufOff = dSTU7564Digest.bufOff;
    }

    public DSTU7564Digest(int n3) {
        long l3;
        int n4;
        if (n3 != 256 && n3 != 384 && n3 != 512) {
            throw new IllegalArgumentException("Hash size is not recommended. Use 256/384/512 instead");
        }
        this.hashSize = n3 >>> 3;
        if (n3 > 256) {
            DSTU7564Digest dSTU7564Digest = this;
            dSTU7564Digest.columns = 16;
            dSTU7564Digest.rounds = 14;
        } else {
            DSTU7564Digest dSTU7564Digest = this;
            dSTU7564Digest.columns = 8;
            dSTU7564Digest.rounds = 10;
        }
        n3 = this.columns;
        this.blockSize = n4 = n3 << 3;
        long[] lArray = new long[n3];
        long[] lArray2 = lArray;
        this.state = lArray2;
        lArray[0] = l3 = (long)n4;
        this.tempState1 = new long[n3];
        this.tempState2 = new long[n3];
        this.buf = new byte[n4];
    }

    private void processBlock(byte[] byArray, int n3) {
        for (int i3 = 0; i3 < this.columns; ++i3) {
            DSTU7564Digest dSTU7564Digest = this;
            long l3 = Pack.littleEndianToLong(byArray, n3);
            n3 += 8;
            dSTU7564Digest.tempState1[i3] = this.state[i3] ^ l3;
            dSTU7564Digest.tempState2[i3] = l3;
        }
        DSTU7564Digest dSTU7564Digest = this;
        dSTU7564Digest.P(dSTU7564Digest.tempState1);
        dSTU7564Digest.Q(dSTU7564Digest.tempState2);
        for (int i4 = 0; i4 < this.columns; ++i4) {
            this.state[i4] = this.state[i4] ^ (this.tempState1[i4] ^ this.tempState2[i4]);
        }
    }

    private void P(long[] lArray) {
        for (int i3 = 0; i3 < this.rounds; ++i3) {
            long l3 = i3;
            for (int i4 = 0; i4 < this.columns; ++i4) {
                lArray[i4] = lArray[i4] ^ l3;
                l3 += 16L;
            }
            DSTU7564Digest dSTU7564Digest = this;
            dSTU7564Digest.shiftRows(lArray);
            dSTU7564Digest.subBytes(lArray);
            dSTU7564Digest.mixColumns(lArray);
        }
    }

    private void Q(long[] lArray) {
        for (int i3 = 0; i3 < this.rounds; ++i3) {
            long l3 = (long)(this.columns - 1 << 4 ^ i3) << 56 | 0xF0F0F0F0F0F0F3L;
            for (int i4 = 0; i4 < this.columns; ++i4) {
                lArray[i4] = lArray[i4] + l3;
                l3 -= 0x1000000000000000L;
            }
            DSTU7564Digest dSTU7564Digest = this;
            dSTU7564Digest.shiftRows(lArray);
            dSTU7564Digest.subBytes(lArray);
            dSTU7564Digest.mixColumns(lArray);
        }
    }

    private static long mixColumn(long l3) {
        long l4 = (l3 & 0x7F7F7F7F7F7F7F7FL) << 1 ^ ((l3 & 0x8080808080808080L) >>> 7) * 29L;
        long l5 = DSTU7564Digest.rotate(8, l3) ^ l3;
        long l6 = l5 ^ DSTU7564Digest.rotate(16, l5) ^ DSTU7564Digest.rotate(48, l3);
        l3 = l6 ^ l3 ^ l4;
        l3 = (l3 & 0x3F3F3F3F3F3F3F3FL) << 2 ^ ((l3 & 0x8080808080808080L) >>> 6) * 29L ^ ((l3 & 0x4040404040404040L) >>> 6) * 29L;
        return l6 ^ DSTU7564Digest.rotate(32, l3) ^ DSTU7564Digest.rotate(40, l4) ^ DSTU7564Digest.rotate(48, l4);
    }

    private void mixColumns(long[] lArray) {
        for (int i3 = 0; i3 < this.columns; ++i3) {
            lArray[i3] = DSTU7564Digest.mixColumn(lArray[i3]);
        }
    }

    private static long rotate(int n3, long l3) {
        return l3 >>> n3 | l3 << -n3;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void shiftRows(long[] lArray) {
        int n3 = this.columns;
        if (n3 != 8) {
            if (n3 != 16) throw new IllegalStateException("unsupported state size: only 512/1024 are allowed");
            long[] lArray2 = lArray;
            long[] lArray3 = lArray;
            long l3 = lArray2[0];
            long l4 = lArray3[1];
            long l5 = lArray2[2];
            long l6 = lArray3[3];
            long l7 = lArray2[4];
            long l8 = lArray3[5];
            long l9 = lArray2[6];
            long l10 = lArray3[7];
            long l11 = lArray2[8];
            long l12 = lArray3[9];
            long l13 = lArray2[10];
            long l14 = lArray3[11];
            long l15 = lArray2[12];
            long l16 = lArray3[13];
            long l17 = lArray2[14];
            long l18 = lArray3[15];
            long l19 = l18;
            long l20 = l10;
            long l21 = l9;
            long l22 = l8;
            long l23 = l7;
            long l24 = l6;
            long l25 = l5;
            long l26 = l4;
            long l27 = l3;
            l3 = (l27 ^ l11) & 0xFF00000000000000L;
            l4 = l27 ^ l3;
            l3 = l11 ^ l3;
            l5 = (l26 ^ l12) & 0xFF00000000000000L;
            l6 = l26 ^ l5;
            l5 = l12 ^ l5;
            l7 = (l25 ^ l13) & 0xFFFF000000000000L;
            l8 = l25 ^ l7;
            l7 = l13 ^ l7;
            l9 = (l24 ^ l14) & 0xFFFFFF0000000000L;
            l10 = l24 ^ l9;
            l9 = l14 ^ l9;
            l11 = (l23 ^ l15) & 0xFFFFFFFF00000000L;
            l12 = l23 ^ l11;
            l11 = l15 ^ l11;
            l13 = (l22 ^ l16) & 0xFFFFFFFF000000L;
            l14 = l22 ^ l13;
            l13 = l16 ^ l13;
            l15 = (l21 ^ l17) & 0xFFFFFFFFFF0000L;
            l16 = l21 ^ l15;
            l15 = l17 ^ l15;
            l17 = (l20 ^ l19) & 0xFFFFFFFFFFFF00L;
            l19 = l20 ^ l17;
            long l28 = l18 ^ l17;
            l17 = l28;
            long l29 = l9;
            long l30 = l15;
            long l31 = l7;
            long l32 = l13;
            long l33 = l5;
            long l34 = l11;
            long l35 = l3;
            long l36 = l10;
            long l37 = l8;
            long l38 = l6;
            long l39 = l4;
            l3 = (l39 ^ l12) & 0xFFFFFF00000000L;
            l4 = l39 ^ l3;
            l3 = l12 ^ l3;
            l5 = (l38 ^ l14) & 0xFFFFFFFFFF000000L;
            l6 = l38 ^ l5;
            l5 = l14 ^ l5;
            l7 = (l37 ^ l16) & 0xFF00FFFFFFFF0000L;
            l8 = l37 ^ l7;
            l7 = l16 ^ l7;
            l9 = (l36 ^ l19) & 0xFF0000FFFFFFFF00L;
            l10 = l36 ^ l9;
            l9 = l19 ^ l9;
            l11 = (l35 ^ l11) & 0xFFFFFF00000000L;
            l12 = l35 ^ l11;
            l11 = l34 ^ l11;
            l13 = (l33 ^ l13) & 0xFFFFFFFFFF000000L;
            l14 = l33 ^ l13;
            l13 = l32 ^ l13;
            l15 = (l31 ^ l15) & 0xFF00FFFFFFFF0000L;
            l16 = l31 ^ l15;
            l15 = l30 ^ l15;
            l17 = (l29 ^ l17) & 0xFF0000FFFFFFFF00L;
            l19 = l29 ^ l17;
            long l40 = l28 ^ l17;
            l17 = l40;
            long l41 = l13;
            long l42 = l15;
            long l43 = l11;
            long l44 = l14;
            long l45 = l12;
            long l46 = l9;
            long l47 = l5;
            long l48 = l7;
            long l49 = l3;
            long l50 = l6;
            long l51 = l4;
            l3 = (l51 ^ l8) & 0xFFFF0000FFFF0000L;
            l4 = l51 ^ l3;
            l3 = l8 ^ l3;
            l5 = (l50 ^ l10) & 0xFFFF0000FFFF00L;
            l6 = l50 ^ l5;
            l5 = l10 ^ l5;
            l7 = (l49 ^ l7) & 0xFFFF0000FFFF0000L;
            l8 = l49 ^ l7;
            l7 = l48 ^ l7;
            l9 = (l47 ^ l9) & 0xFFFF0000FFFF00L;
            l10 = l47 ^ l9;
            l9 = l46 ^ l9;
            l11 = (l45 ^ l16) & 0xFFFF0000FFFF0000L;
            l12 = l45 ^ l11;
            l11 = l16 ^ l11;
            l13 = (l44 ^ l19) & 0xFFFF0000FFFF00L;
            l14 = l44 ^ l13;
            l13 = l19 ^ l13;
            l15 = (l43 ^ l15) & 0xFFFF0000FFFF0000L;
            l16 = l43 ^ l15;
            l15 = l42 ^ l15;
            l17 = (l41 ^ l17) & 0xFFFF0000FFFF00L;
            l19 = l41 ^ l17;
            long l52 = l40 ^ l17;
            l17 = l52;
            long l53 = l15;
            long l54 = l16;
            long l55 = l13;
            long l56 = l11;
            long l57 = l12;
            long l58 = l9;
            long l59 = l7;
            long l60 = l8;
            long l61 = l5;
            long l62 = l3;
            long l63 = l4;
            l3 = (l63 ^ l6) & 0xFF00FF00FF00FF00L;
            l4 = l63 ^ l3;
            l3 = l6 ^ l3;
            l5 = (l62 ^ l5) & 0xFF00FF00FF00FF00L;
            l6 = l62 ^ l5;
            l5 = l61 ^ l5;
            l7 = (l60 ^ l10) & 0xFF00FF00FF00FF00L;
            l8 = l60 ^ l7;
            l7 = l10 ^ l7;
            l9 = (l59 ^ l9) & 0xFF00FF00FF00FF00L;
            l10 = l59 ^ l9;
            l9 = l58 ^ l9;
            l11 = (l57 ^ l14) & 0xFF00FF00FF00FF00L;
            l12 = l57 ^ l11;
            l11 = l14 ^ l11;
            l13 = (l56 ^ l13) & 0xFF00FF00FF00FF00L;
            l14 = l56 ^ l13;
            l13 = l55 ^ l13;
            l15 = (l54 ^ l19) & 0xFF00FF00FF00FF00L;
            l16 = l54 ^ l15;
            l15 = l19 ^ l15;
            l17 = (l53 ^ l17) & 0xFF00FF00FF00FF00L;
            l19 = l53 ^ l17;
            l17 = l52 ^ l17;
            lArray2[0] = l4;
            lArray3[1] = l3;
            lArray2[2] = l6;
            lArray3[3] = l5;
            lArray2[4] = l8;
            lArray3[5] = l7;
            lArray2[6] = l10;
            lArray3[7] = l9;
            lArray2[8] = l12;
            lArray3[9] = l11;
            lArray2[10] = l14;
            lArray3[11] = l13;
            lArray2[12] = l16;
            lArray3[13] = l15;
            lArray2[14] = l19;
            lArray3[15] = l17;
            return;
        } else {
            long[] lArray4 = lArray;
            long[] lArray5 = lArray;
            long l64 = lArray4[0];
            long l65 = lArray5[1];
            long l66 = lArray4[2];
            long l67 = lArray5[3];
            long l68 = lArray4[4];
            long l69 = lArray5[5];
            long l70 = lArray4[6];
            long l71 = lArray5[7];
            long l72 = l71;
            long l73 = l67;
            long l74 = l66;
            long l75 = l65;
            long l76 = l64;
            l64 = (l76 ^ l68) & 0xFFFFFFFF00000000L;
            l65 = l76 ^ l64;
            l64 = l68 ^ l64;
            l66 = (l75 ^ l69) & 0xFFFFFFFF000000L;
            l67 = l75 ^ l66;
            l66 = l69 ^ l66;
            l68 = (l74 ^ l70) & 0xFFFFFFFF0000L;
            l69 = l74 ^ l68;
            l68 = l70 ^ l68;
            l70 = (l73 ^ l72) & 0xFFFFFFFF00L;
            l72 = l73 ^ l70;
            long l77 = l71 ^ l70;
            l70 = l77;
            long l78 = l66;
            long l79 = l68;
            long l80 = l64;
            long l81 = l67;
            long l82 = l65;
            l64 = (l82 ^ l69) & 0xFFFF0000FFFF0000L;
            l65 = l82 ^ l64;
            l64 = l69 ^ l64;
            l66 = (l81 ^ l72) & 0xFFFF0000FFFF00L;
            l67 = l81 ^ l66;
            l66 = l72 ^ l66;
            l68 = (l80 ^ l68) & 0xFFFF0000FFFF0000L;
            l69 = l80 ^ l68;
            l68 = l79 ^ l68;
            l70 = (l78 ^ l70) & 0xFFFF0000FFFF00L;
            l72 = l78 ^ l70;
            long l83 = l77 ^ l70;
            l70 = l83;
            long l84 = l68;
            long l85 = l69;
            long l86 = l66;
            long l87 = l64;
            long l88 = l65;
            l64 = (l88 ^ l67) & 0xFF00FF00FF00FF00L;
            l65 = l88 ^ l64;
            l64 = l67 ^ l64;
            l66 = (l87 ^ l66) & 0xFF00FF00FF00FF00L;
            l67 = l87 ^ l66;
            l66 = l86 ^ l66;
            l68 = (l85 ^ l72) & 0xFF00FF00FF00FF00L;
            l69 = l85 ^ l68;
            l68 = l72 ^ l68;
            l70 = (l84 ^ l70) & 0xFF00FF00FF00FF00L;
            l72 = l84 ^ l70;
            l70 = l83 ^ l70;
            lArray4[0] = l65;
            lArray5[1] = l64;
            lArray4[2] = l67;
            lArray5[3] = l66;
            lArray4[4] = l69;
            lArray5[5] = l68;
            lArray4[6] = l72;
            lArray5[7] = l70;
        }
    }

    private void subBytes(long[] lArray) {
        for (int i3 = 0; i3 < this.columns; ++i3) {
            long l3 = lArray[i3];
            int n3 = (int)l3;
            int n4 = (int)(l3 >>> 32);
            byte by = S0[n3 & 0xFF];
            byte[] byArray = S1;
            byte by2 = S1[n3 >>> 8 & 0xFF];
            byte[] byArray2 = S2;
            byte by3 = S2[n3 >>> 16 & 0xFF];
            byte[] byArray3 = S3;
            n3 = S3[n3 >>> 24];
            n3 = by & 0xFF | (by2 & 0xFF) << 8 | (by3 & 0xFF) << 16 | n3 << 24;
            byte by4 = S0[n4 & 0xFF];
            int n5 = n4;
            int n6 = n4;
            n4 = byArray[n4 >>> 8 & 0xFF];
            byte by5 = byArray2[n6 >>> 16 & 0xFF];
            by2 = byArray3[n5 >>> 24];
            n4 = by4 & 0xFF | (n4 & 0xFF) << 8 | (by5 & 0xFF) << 16 | by2 << 24;
            lArray[i3] = (long)n3 & 0xFFFFFFFFL | (long)n4 << 32;
        }
    }

    @Override
    public String getAlgorithmName() {
        return "DSTU7564";
    }

    @Override
    public int getDigestSize() {
        return this.hashSize;
    }

    @Override
    public int getByteLength() {
        return this.blockSize;
    }

    @Override
    public void update(byte by) {
        int n3;
        DSTU7564Digest dSTU7564Digest = this;
        byte[] byArray = dSTU7564Digest.buf;
        int n4 = dSTU7564Digest.bufOff;
        this.bufOff = n3 = n4 + 1;
        byArray[n4] = by;
        if (n3 == this.blockSize) {
            DSTU7564Digest dSTU7564Digest2 = this;
            dSTU7564Digest2.processBlock(byArray, 0);
            dSTU7564Digest2.bufOff = 0;
            ++dSTU7564Digest2.inputBlocks;
        }
    }

    @Override
    public void update(byte[] byArray, int n3, int n4) {
        while (this.bufOff != 0 && n4 > 0) {
            this.update(byArray[n3++]);
            --n4;
        }
        if (n4 > 0) {
            while (n4 >= this.blockSize) {
                int n5 = n4;
                int n6 = n3;
                DSTU7564Digest dSTU7564Digest = this;
                dSTU7564Digest.processBlock(byArray, n3);
                n3 = dSTU7564Digest.blockSize;
                n4 = n6 + n3;
                n3 = n5 - n3;
                ++this.inputBlocks;
                int n7 = n3;
                n3 = n4;
                n4 = n7;
            }
            while (n4 > 0) {
                this.update(byArray[n3++]);
                --n4;
            }
        }
    }

    @Override
    public int doFinal(byte[] byArray, int n3) {
        int n4;
        int n5;
        int n6;
        DSTU7564Digest dSTU7564Digest = this;
        int n7 = dSTU7564Digest.bufOff;
        byte[] byArray2 = dSTU7564Digest.buf;
        this.bufOff = n6 = n7 + 1;
        byArray2[n7] = -128;
        int n8 = this.blockSize - 12;
        if (n6 > n8) {
            while ((n6 = this.bufOff) < this.blockSize) {
                this.bufOff = n6 + 1;
                this.buf[n6] = 0;
            }
            DSTU7564Digest dSTU7564Digest2 = this;
            dSTU7564Digest2.bufOff = 0;
            dSTU7564Digest2.processBlock(dSTU7564Digest2.buf, 0);
        }
        while ((n6 = this.bufOff) < n8) {
            this.bufOff = n6 + 1;
            this.buf[n6] = 0;
        }
        DSTU7564Digest dSTU7564Digest3 = this;
        long l3 = (dSTU7564Digest3.inputBlocks & 0xFFFFFFFFL) * (long)this.blockSize + (long)n7 << 3;
        Pack.intToLittleEndian((int)l3, this.buf, n6);
        this.bufOff = n5 = this.bufOff + 4;
        Pack.longToLittleEndian((l3 >>> 32) + ((this.inputBlocks >>> 32) * (long)this.blockSize << 3), this.buf, n5);
        dSTU7564Digest3.processBlock(dSTU7564Digest3.buf, 0);
        DSTU7564Digest dSTU7564Digest4 = this;
        long[] lArray = dSTU7564Digest4.tempState1;
        n8 = dSTU7564Digest4.columns;
        System.arraycopy(dSTU7564Digest3.state, 0, lArray, 0, n8);
        dSTU7564Digest3.P(dSTU7564Digest3.tempState1);
        for (n4 = 0; n4 < (n8 = this.columns); ++n4) {
            this.state[n4] = this.state[n4] ^ this.tempState1[n4];
        }
        for (n4 = n8 - (this.hashSize >>> 3); n4 < this.columns; ++n4) {
            Pack.longToLittleEndian(this.state[n4], byArray, n3);
            n3 += 8;
        }
        DSTU7564Digest dSTU7564Digest5 = this;
        dSTU7564Digest5.reset();
        return dSTU7564Digest5.hashSize;
    }

    @Override
    public void reset() {
        long l3;
        DSTU7564Digest dSTU7564Digest = this;
        Arrays.fill(dSTU7564Digest.state, 0L);
        dSTU7564Digest.state[0] = l3 = (long)this.blockSize;
        dSTU7564Digest.inputBlocks = 0L;
        dSTU7564Digest.bufOff = 0;
    }

    @Override
    public Memoable copy() {
        return new DSTU7564Digest(this);
    }

    @Override
    public void reset(Memoable memoable) {
        this.copyIn((DSTU7564Digest)memoable);
    }
}

