/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.crypto.digests;

import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.BlockCipher;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.CipherParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.ExtendedDigest;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.engines.GOST28147Engine;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.params.KeyParameter;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.params.ParametersWithSBox;
import com.fis.ekyc.nfc.build_in.bouncycastle.util.Arrays;
import com.fis.ekyc.nfc.build_in.bouncycastle.util.Memoable;
import com.fis.ekyc.nfc.build_in.bouncycastle.util.Pack;

public class GOST3411Digest
implements ExtendedDigest,
Memoable {
    private static final int DIGEST_LENGTH = 32;
    private static final byte[] C2 = new byte[]{0, -1, 0, -1, 0, -1, 0, -1, -1, 0, -1, 0, -1, 0, -1, 0, 0, -1, -1, 0, -1, 0, 0, -1, -1, 0, 0, 0, -1, -1, 0, -1};
    private byte[] H;
    private byte[] L;
    private byte[] M;
    private byte[] Sum;
    private byte[][] C;
    private byte[] xBuf;
    private int xBufOff;
    private long byteCount;
    private BlockCipher cipher;
    private byte[] sBox;
    private byte[] K;
    public byte[] a;
    public short[] wS;
    public short[] w_S;
    public byte[] S;
    public byte[] U;
    public byte[] V;
    public byte[] W;

    public GOST3411Digest() {
        ParametersWithSBox parametersWithSBox;
        GOST3411Digest gOST3411Digest = object;
        gOST3411Digest.H = new byte[32];
        gOST3411Digest.L = new byte[32];
        gOST3411Digest.M = new byte[32];
        gOST3411Digest.Sum = new byte[32];
        gOST3411Digest.C = new byte[4][32];
        gOST3411Digest.xBuf = new byte[32];
        gOST3411Digest.cipher = new GOST28147Engine();
        gOST3411Digest.K = new byte[32];
        gOST3411Digest.a = new byte[8];
        gOST3411Digest.wS = new short[16];
        gOST3411Digest.w_S = new short[16];
        gOST3411Digest.S = new byte[32];
        gOST3411Digest.U = new byte[32];
        gOST3411Digest.V = new byte[32];
        gOST3411Digest.W = new byte[32];
        byte[] byArray = GOST28147Engine.getSBox("D-A");
        Object object = byArray;
        gOST3411Digest.sBox = byArray;
        ParametersWithSBox parametersWithSBox2 = parametersWithSBox;
        parametersWithSBox = new ParametersWithSBox(null, (byte[])object);
        gOST3411Digest.cipher.init(true, parametersWithSBox2);
        gOST3411Digest.reset();
    }

    public GOST3411Digest(byte[] object) {
        ParametersWithSBox parametersWithSBox;
        GOST3411Digest gOST3411Digest = object2;
        ((GOST3411Digest)object2).H = new byte[32];
        ((GOST3411Digest)object2).L = new byte[32];
        ((GOST3411Digest)object2).M = new byte[32];
        ((GOST3411Digest)object2).Sum = new byte[32];
        ((GOST3411Digest)object2).C = new byte[4][32];
        ((GOST3411Digest)object2).xBuf = new byte[32];
        ((GOST3411Digest)object2).cipher = new GOST28147Engine();
        ((GOST3411Digest)object2).K = new byte[32];
        ((GOST3411Digest)object2).a = new byte[8];
        ((GOST3411Digest)object2).wS = new short[16];
        ((GOST3411Digest)object2).w_S = new short[16];
        ((GOST3411Digest)object2).S = new byte[32];
        ((GOST3411Digest)object2).U = new byte[32];
        ((GOST3411Digest)object2).V = new byte[32];
        ((GOST3411Digest)object2).W = new byte[32];
        byte[] byArray = Arrays.clone(object);
        Object object2 = byArray;
        gOST3411Digest.sBox = byArray;
        object = parametersWithSBox;
        parametersWithSBox = new ParametersWithSBox(null, (byte[])object2);
        gOST3411Digest.cipher.init(true, (CipherParameters)object);
        gOST3411Digest.reset();
    }

    public GOST3411Digest(GOST3411Digest gOST3411Digest) {
        this.H = new byte[32];
        this.L = new byte[32];
        this.M = new byte[32];
        this.Sum = new byte[32];
        this.C = new byte[4][32];
        this.xBuf = new byte[32];
        this.cipher = new GOST28147Engine();
        this.K = new byte[32];
        this.a = new byte[8];
        this.wS = new short[16];
        this.w_S = new short[16];
        this.S = new byte[32];
        this.U = new byte[32];
        this.V = new byte[32];
        this.W = new byte[32];
        this.reset(gOST3411Digest);
    }

    private byte[] P(byte[] byArray) {
        for (int i3 = 0; i3 < 8; ++i3) {
            byte[] byArray2 = this.K;
            int n3 = i3;
            int n4 = n3 * 4;
            byArray2[n4] = byArray[n3];
            int n5 = n4 + 1;
            byArray2[n5] = byArray[i3 + 8];
            n5 = n4 + 2;
            byArray2[n5] = byArray[i3 + 16];
            this.K[n4 += 3] = byArray[i3 + 24];
        }
        return this.K;
    }

    private byte[] A(byte[] byArray) {
        for (int i3 = 0; i3 < 8; ++i3) {
            this.a[i3] = (byte)(byArray[i3] ^ byArray[i3 + 8]);
        }
        System.arraycopy(byArray, 8, byArray, 0, 24);
        System.arraycopy(this.a, 0, byArray, 24, 8);
        return byArray;
    }

    private void E(byte[] byArray, byte[] byArray2, int n3, byte[] byArray3, int n4) {
        KeyParameter keyParameter;
        GOST3411Digest gOST3411Digest = keyParameter2;
        KeyParameter keyParameter2 = keyParameter;
        keyParameter = new KeyParameter(byArray);
        gOST3411Digest.cipher.init(true, keyParameter2);
        gOST3411Digest.cipher.processBlock(byArray3, n4, byArray2, n3);
    }

    private void fw(byte[] byArray) {
        GOST3411Digest gOST3411Digest = object;
        gOST3411Digest.cpyBytesToShort(byArray, ((GOST3411Digest)object).wS);
        Object object = gOST3411Digest.w_S;
        short[] sArray = gOST3411Digest.wS;
        object[15] = (short)(sArray[0] ^ sArray[1] ^ sArray[2] ^ sArray[3] ^ sArray[12] ^ sArray[15]);
        System.arraycopy(gOST3411Digest.wS, 1, object, 0, 15);
        gOST3411Digest.cpyShortToBytes(gOST3411Digest.w_S, byArray);
    }

    private void finish() {
        Pack.longToLittleEndian(this.byteCount * 8L, this.L, 0);
        while (this.xBufOff != 0) {
            this.update((byte)0);
        }
        GOST3411Digest gOST3411Digest = this;
        gOST3411Digest.processBlock(gOST3411Digest.L, 0);
        gOST3411Digest.processBlock(gOST3411Digest.Sum, 0);
    }

    private void sumByteArray(byte[] byArray) {
        int n3 = 0;
        int n4 = 0;
        while (true) {
            byte[] byArray2 = this.Sum;
            if (n4 == this.Sum.length) break;
            n3 = (byArray2[n4] & 0xFF) + (byArray[n4] & 0xFF) + n3;
            byArray2[n4] = (byte)n3;
            n3 >>>= 8;
            ++n4;
        }
    }

    private void cpyBytesToShort(byte[] byArray, short[] sArray) {
        for (int i3 = 0; i3 < byArray.length / 2; ++i3) {
            int n3 = i3 * 2;
            sArray[i3] = (short)(byArray[n3 + 1] << 8 & 0xFF00 | byArray[n3] & 0xFF);
        }
    }

    private void cpyShortToBytes(short[] sArray, byte[] byArray) {
        int n3 = 0;
        while (n3 < byArray.length / 2) {
            int n4 = n3++;
            int n5 = n4 * 2;
            int n6 = n5 + 1;
            short s2 = sArray[n4];
            byArray[n6] = (byte)(s2 >> 8);
            byArray[n5] = (byte)s2;
        }
    }

    @Override
    public String getAlgorithmName() {
        return "GOST3411";
    }

    @Override
    public int getDigestSize() {
        return 32;
    }

    @Override
    public void update(byte by) {
        int n3;
        GOST3411Digest gOST3411Digest = this;
        byte[] byArray = gOST3411Digest.xBuf;
        int n4 = gOST3411Digest.xBufOff;
        this.xBufOff = n3 = n4 + 1;
        byArray[n4] = by;
        if (n3 == byArray.length) {
            GOST3411Digest gOST3411Digest2 = this;
            gOST3411Digest2.sumByteArray(byArray);
            gOST3411Digest2.processBlock(gOST3411Digest2.xBuf, 0);
            gOST3411Digest2.xBufOff = 0;
        }
        ++this.byteCount;
    }

    @Override
    public void update(byte[] byArray, int n3, int n4) {
        while (this.xBufOff != 0 && n4 > 0) {
            this.update(byArray[n3]);
            ++n3;
            --n4;
        }
        while (true) {
            byte[] byArray2 = this.xBuf;
            if (n4 <= this.xBuf.length) break;
            int n5 = n4;
            int n6 = n3;
            GOST3411Digest gOST3411Digest = this;
            int n7 = n3;
            n3 = byArray2.length;
            System.arraycopy(byArray, n7, byArray2, 0, n3);
            gOST3411Digest.sumByteArray(gOST3411Digest.xBuf);
            gOST3411Digest.processBlock(gOST3411Digest.xBuf, 0);
            byte[] byArray3 = gOST3411Digest.xBuf;
            n4 = n6 + gOST3411Digest.xBuf.length;
            int n8 = n5 - byArray3.length;
            this.byteCount += (long)byArray3.length;
            n3 = n4;
            n4 = n8;
        }
        while (n4 > 0) {
            this.update(byArray[n3]);
            ++n3;
            --n4;
        }
    }

    public void processBlock(byte[] byArray, int n3) {
        int n4;
        GOST3411Digest gOST3411Digest = object;
        System.arraycopy(byArray, n3, ((GOST3411Digest)object).M, 0, 32);
        System.arraycopy(gOST3411Digest.H, 0, ((GOST3411Digest)object).U, 0, 32);
        System.arraycopy(gOST3411Digest.M, 0, ((GOST3411Digest)object).V, 0, 32);
        for (int i3 = 0; i3 < 32; ++i3) {
            ((GOST3411Digest)object).W[i3] = (byte)(((GOST3411Digest)object).U[i3] ^ ((GOST3411Digest)object).V[i3]);
        }
        GOST3411Digest gOST3411Digest2 = object;
        byte[] byArray2 = gOST3411Digest2.P(gOST3411Digest2.W);
        byte[] byArray3 = gOST3411Digest2.S;
        byte[] byArray4 = gOST3411Digest2.H;
        gOST3411Digest2.E(byArray2, byArray3, 0, byArray4, 0);
        for (n4 = 1; n4 < 4; ++n4) {
            GOST3411Digest gOST3411Digest3 = object;
            byArray3 = gOST3411Digest3.A(gOST3411Digest3.U);
            for (int i4 = 0; i4 < 32; ++i4) {
                ((GOST3411Digest)object).U[i4] = (byte)(byArray3[i4] ^ ((GOST3411Digest)object).C[n4][i4]);
            }
            GOST3411Digest gOST3411Digest4 = object;
            gOST3411Digest4.V = gOST3411Digest4.A(gOST3411Digest4.A(gOST3411Digest4.V));
            for (int i5 = 0; i5 < 32; ++i5) {
                ((GOST3411Digest)object).W[i5] = (byte)(((GOST3411Digest)object).U[i5] ^ ((GOST3411Digest)object).V[i5]);
            }
            GOST3411Digest gOST3411Digest5 = object;
            GOST3411Digest gOST3411Digest6 = object;
            byArray3 = gOST3411Digest6.P(gOST3411Digest6.W);
            byArray4 = gOST3411Digest6.S;
            int n5 = n4 * 8;
            byte[] byArray5 = gOST3411Digest5.H;
            gOST3411Digest5.E(byArray3, byArray4, n5, byArray5, n5);
        }
        for (n4 = 0; n4 < 12; ++n4) {
            GOST3411Digest gOST3411Digest7 = object;
            gOST3411Digest7.fw(gOST3411Digest7.S);
        }
        for (n4 = 0; n4 < 32; ++n4) {
            ((GOST3411Digest)object).S[n4] = (byte)(((GOST3411Digest)object).S[n4] ^ ((GOST3411Digest)object).M[n4]);
        }
        GOST3411Digest gOST3411Digest8 = object;
        gOST3411Digest8.fw(gOST3411Digest8.S);
        for (n4 = 0; n4 < 32; ++n4) {
            byArray3 = ((GOST3411Digest)object).S;
            ((GOST3411Digest)object).S[n4] = (byte)(((GOST3411Digest)object).H[n4] ^ byArray3[n4]);
        }
        for (n4 = 0; n4 < 61; ++n4) {
            GOST3411Digest gOST3411Digest9 = object;
            gOST3411Digest9.fw(gOST3411Digest9.S);
        }
        Object object = ((GOST3411Digest)object).H;
        n4 = ((GOST3411Digest)object).H.length;
        System.arraycopy(((GOST3411Digest)object).S, 0, object, 0, n4);
    }

    @Override
    public int doFinal(byte[] byArray, int n3) {
        GOST3411Digest gOST3411Digest = this;
        gOST3411Digest.finish();
        int n4 = gOST3411Digest.H.length;
        System.arraycopy(gOST3411Digest.H, 0, byArray, n3, n4);
        gOST3411Digest.reset();
        return 32;
    }

    @Override
    public void reset() {
        byte[] byArray;
        GOST3411Digest gOST3411Digest = object;
        gOST3411Digest.byteCount = 0L;
        gOST3411Digest.xBufOff = 0;
        int n3 = 0;
        while (true) {
            byArray = ((GOST3411Digest)object).H;
            if (n3 >= ((GOST3411Digest)object).H.length) break;
            byArray[n3] = 0;
            ++n3;
        }
        n3 = 0;
        while (true) {
            byArray = ((GOST3411Digest)object).L;
            if (n3 >= ((GOST3411Digest)object).L.length) break;
            byArray[n3] = 0;
            ++n3;
        }
        n3 = 0;
        while (true) {
            byArray = ((GOST3411Digest)object).M;
            if (n3 >= ((GOST3411Digest)object).M.length) break;
            byArray[n3] = 0;
            ++n3;
        }
        for (n3 = 0; n3 < (byArray = ((GOST3411Digest)object).C[1]).length; ++n3) {
            byArray[n3] = 0;
        }
        for (n3 = 0; n3 < (byArray = ((GOST3411Digest)object).C[3]).length; ++n3) {
            byArray[n3] = 0;
        }
        n3 = 0;
        while (true) {
            byArray = ((GOST3411Digest)object).Sum;
            if (n3 >= ((GOST3411Digest)object).Sum.length) break;
            byArray[n3] = 0;
            ++n3;
        }
        n3 = 0;
        while (true) {
            byArray = ((GOST3411Digest)object).xBuf;
            if (n3 >= ((GOST3411Digest)object).xBuf.length) break;
            byArray[n3] = 0;
            ++n3;
        }
        Object object = ((GOST3411Digest)object).C[2];
        n3 = C2.length;
        System.arraycopy(C2, 0, object, 0, n3);
    }

    @Override
    public int getByteLength() {
        return 32;
    }

    @Override
    public Memoable copy() {
        return new GOST3411Digest(this);
    }

    @Override
    public void reset(Memoable memoable) {
        ParametersWithSBox parametersWithSBox;
        GOST3411Digest gOST3411Digest = object;
        memoable = (GOST3411Digest)memoable;
        GOST3411Digest gOST3411Digest2 = object;
        byte[] byArray = ((GOST3411Digest)memoable).sBox;
        gOST3411Digest2.sBox = ((GOST3411Digest)memoable).sBox;
        ParametersWithSBox parametersWithSBox2 = parametersWithSBox;
        parametersWithSBox = new ParametersWithSBox(null, byArray);
        gOST3411Digest2.cipher.init(true, parametersWithSBox2);
        gOST3411Digest2.reset();
        byArray = ((GOST3411Digest)object).H;
        int n3 = ((GOST3411Digest)memoable).H.length;
        System.arraycopy(((GOST3411Digest)memoable).H, 0, byArray, 0, n3);
        byArray = ((GOST3411Digest)object).L;
        n3 = ((GOST3411Digest)memoable).L.length;
        System.arraycopy(((GOST3411Digest)memoable).L, 0, byArray, 0, n3);
        byArray = ((GOST3411Digest)object).M;
        n3 = ((GOST3411Digest)memoable).M.length;
        System.arraycopy(((GOST3411Digest)memoable).M, 0, byArray, 0, n3);
        byArray = ((GOST3411Digest)object).Sum;
        n3 = ((GOST3411Digest)memoable).Sum.length;
        System.arraycopy(((GOST3411Digest)memoable).Sum, 0, byArray, 0, n3);
        byte[] byArray2 = ((GOST3411Digest)memoable).C[1];
        byArray = ((GOST3411Digest)object).C[1];
        n3 = byArray2.length;
        System.arraycopy(byArray2, 0, byArray, 0, n3);
        byte[] byArray3 = ((GOST3411Digest)memoable).C[2];
        byArray = ((GOST3411Digest)object).C[2];
        n3 = byArray3.length;
        System.arraycopy(byArray3, 0, byArray, 0, n3);
        byte[] byArray4 = ((GOST3411Digest)memoable).C[3];
        byArray = ((GOST3411Digest)object).C[3];
        n3 = byArray4.length;
        System.arraycopy(byArray4, 0, byArray, 0, n3);
        Object object = ((GOST3411Digest)object).xBuf;
        int n4 = ((GOST3411Digest)memoable).xBuf.length;
        System.arraycopy(((GOST3411Digest)memoable).xBuf, 0, object, 0, n4);
        gOST3411Digest.xBufOff = ((GOST3411Digest)memoable).xBufOff;
        gOST3411Digest.byteCount = ((GOST3411Digest)memoable).byteCount;
    }
}

