/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.crypto.digests;

import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.ExtendedDigest;
import com.fis.ekyc.nfc.build_in.bouncycastle.util.Memoable;
import com.fis.ekyc.nfc.build_in.bouncycastle.util.Pack;

public abstract class GeneralDigest
implements ExtendedDigest,
Memoable {
    private static final int BYTE_LENGTH = 64;
    private final byte[] xBuf;
    private int xBufOff;
    private long byteCount;

    public GeneralDigest() {
        this.xBuf = new byte[4];
        this.xBufOff = 0;
    }

    public GeneralDigest(GeneralDigest generalDigest) {
        this.xBuf = new byte[4];
        this.copyIn(generalDigest);
    }

    public GeneralDigest(byte[] byArray) {
        byte[] byArray2 = byArray;
        byArray = new byte[4];
        this.xBuf = byArray;
        int n3 = byArray.length;
        System.arraycopy(byArray, 0, byArray, 0, n3);
        this.xBufOff = Pack.bigEndianToInt(byArray, 4);
        this.byteCount = Pack.bigEndianToLong(byArray2, 8);
    }

    public void copyIn(GeneralDigest generalDigest) {
        GeneralDigest generalDigest2 = object;
        GeneralDigest generalDigest3 = object;
        GeneralDigest generalDigest4 = generalDigest;
        Object object = ((GeneralDigest)object).xBuf;
        int n3 = generalDigest4.xBuf.length;
        System.arraycopy(generalDigest4.xBuf, 0, object, 0, n3);
        generalDigest3.xBufOff = generalDigest4.xBufOff;
        generalDigest2.byteCount = generalDigest.byteCount;
    }

    @Override
    public void update(byte by) {
        int n3;
        GeneralDigest generalDigest = this;
        byte[] byArray = generalDigest.xBuf;
        int n4 = generalDigest.xBufOff;
        this.xBufOff = n3 = n4 + 1;
        byArray[n4] = by;
        if (n3 == byArray.length) {
            this.processWord(byArray, 0);
            this.xBufOff = 0;
        }
        ++this.byteCount;
    }

    @Override
    public void update(byte[] byArray, int n3, int n4) {
        n4 = Math.max(0, n4);
        int n5 = 0;
        if (this.xBufOff != 0) {
            while (n5 < n4) {
                GeneralDigest generalDigest = this;
                byte[] byArray2 = generalDigest.xBuf;
                int n6 = generalDigest.xBufOff;
                int n7 = n6 + 1;
                this.xBufOff = n7;
                byArray2[n6] = byArray[n3 + n5++];
                if (n7 != 4) continue;
                this.processWord(byArray2, 0);
                this.xBufOff = 0;
                break;
            }
        }
        int n8 = (n4 - n5 & 0xFFFFFFFC) + n5;
        while (n5 < n8) {
            this.processWord(byArray, n3 + n5);
            n5 += 4;
        }
        while (n5 < n4) {
            n8 = this.xBufOff;
            this.xBufOff = n8 + 1;
            this.xBuf[n8] = byArray[n3 + n5++];
        }
        this.byteCount += (long)n4;
    }

    public void finish() {
        GeneralDigest generalDigest = this;
        long l3 = generalDigest.byteCount << 3;
        generalDigest.update((byte)-128);
        while (this.xBufOff != 0) {
            this.update((byte)0);
        }
        GeneralDigest generalDigest2 = this;
        generalDigest2.processLength(l3);
        generalDigest2.processBlock();
    }

    @Override
    public void reset() {
        GeneralDigest generalDigest = this;
        generalDigest.byteCount = 0L;
        generalDigest.xBufOff = 0;
        int n3 = 0;
        while (true) {
            byte[] byArray = this.xBuf;
            if (n3 >= this.xBuf.length) break;
            byArray[n3] = 0;
            ++n3;
        }
    }

    public void populateState(byte[] byArray) {
        GeneralDigest generalDigest = this;
        int n3 = this.xBufOff;
        System.arraycopy(generalDigest.xBuf, 0, byArray, 0, n3);
        Pack.intToBigEndian(generalDigest.xBufOff, byArray, 4);
        Pack.longToBigEndian(generalDigest.byteCount, byArray, 8);
    }

    @Override
    public int getByteLength() {
        return 64;
    }

    public abstract void processWord(byte[] var1, int var2);

    public abstract void processLength(long var1);

    public abstract void processBlock();
}

