/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.crypto.digests;

import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.digests.HarakaBase;
import com.fis.ekyc.nfc.build_in.bouncycastle.util.Arrays;

public class Haraka512Digest
extends HarakaBase {
    private static byte[][] RC;
    private final byte[] buffer;
    private int off;

    public Haraka512Digest() {
        this.buffer = new byte[64];
    }

    public Haraka512Digest(Haraka512Digest haraka512Digest) {
        this.buffer = Arrays.clone(haraka512Digest.buffer);
        this.off = haraka512Digest.off;
    }

    private void mix512(byte[][] byArray, byte[][] byArray2) {
        byte[][] byArray3 = byArray;
        byte[][] byArray4 = byArray;
        System.arraycopy(byArray3[0], 12, byArray2[0], 0, 4);
        System.arraycopy(byArray4[2], 12, byArray2[0], 4, 4);
        System.arraycopy(byArray3[1], 12, byArray2[0], 8, 4);
        System.arraycopy(byArray4[3], 12, byArray2[0], 12, 4);
        System.arraycopy(byArray3[2], 0, byArray2[1], 0, 4);
        System.arraycopy(byArray4[0], 0, byArray2[1], 4, 4);
        System.arraycopy(byArray3[3], 0, byArray2[1], 8, 4);
        System.arraycopy(byArray4[1], 0, byArray2[1], 12, 4);
        System.arraycopy(byArray3[2], 4, byArray2[2], 0, 4);
        System.arraycopy(byArray4[0], 4, byArray2[2], 4, 4);
        System.arraycopy(byArray3[3], 4, byArray2[2], 8, 4);
        System.arraycopy(byArray4[1], 4, byArray2[2], 12, 4);
        System.arraycopy(byArray3[0], 8, byArray2[3], 0, 4);
        System.arraycopy(byArray4[2], 8, byArray2[3], 4, 4);
        System.arraycopy(byArray3[1], 8, byArray2[3], 8, 4);
        System.arraycopy(byArray4[3], 8, byArray2[3], 12, 4);
    }

    private int haraka512256(byte[] byArray, byte[] byArray2, int n3) {
        byte[][] byArray3 = new byte[4][16];
        byte[][] byArray4 = byArray3;
        byte[][] byArray5 = new byte[4][16];
        byte[][] byArray6 = byArray4;
        byte[][] byArray7 = byArray4;
        byte[][] byArray8 = byArray4;
        byte[][] byArray9 = byArray4;
        byte[][] byArray10 = byArray4;
        System.arraycopy(byArray, 0, byArray4[0], 0, 16);
        System.arraycopy(byArray, 16, byArray4[1], 0, 16);
        System.arraycopy(byArray, 32, byArray4[2], 0, 16);
        System.arraycopy(byArray, 48, byArray4[3], 0, 16);
        byArray10[0] = HarakaBase.aesEnc(byArray10[0], RC[0]);
        byArray10[1] = HarakaBase.aesEnc(byArray10[1], RC[1]);
        byArray10[2] = HarakaBase.aesEnc(byArray10[2], RC[2]);
        byArray10[3] = HarakaBase.aesEnc(byArray10[3], RC[3]);
        byArray10[0] = HarakaBase.aesEnc(byArray10[0], RC[4]);
        byArray10[1] = HarakaBase.aesEnc(byArray10[1], RC[5]);
        byArray10[2] = HarakaBase.aesEnc(byArray10[2], RC[6]);
        byArray10[3] = HarakaBase.aesEnc(byArray10[3], RC[7]);
        this.mix512(byArray4, byArray5);
        byArray4[0] = HarakaBase.aesEnc(byArray5[0], RC[8]);
        byArray4[1] = HarakaBase.aesEnc(byArray5[1], RC[9]);
        byArray4[2] = HarakaBase.aesEnc(byArray5[2], RC[10]);
        byArray9[3] = HarakaBase.aesEnc(byArray5[3], RC[11]);
        byArray9[0] = HarakaBase.aesEnc(byArray4[0], RC[12]);
        byArray9[1] = HarakaBase.aesEnc(byArray4[1], RC[13]);
        byArray9[2] = HarakaBase.aesEnc(byArray4[2], RC[14]);
        byArray9[3] = HarakaBase.aesEnc(byArray4[3], RC[15]);
        this.mix512(byArray4, byArray5);
        byArray4[0] = HarakaBase.aesEnc(byArray5[0], RC[16]);
        byArray4[1] = HarakaBase.aesEnc(byArray5[1], RC[17]);
        byArray4[2] = HarakaBase.aesEnc(byArray5[2], RC[18]);
        byArray8[3] = HarakaBase.aesEnc(byArray5[3], RC[19]);
        byArray8[0] = HarakaBase.aesEnc(byArray4[0], RC[20]);
        byArray8[1] = HarakaBase.aesEnc(byArray4[1], RC[21]);
        byArray8[2] = HarakaBase.aesEnc(byArray4[2], RC[22]);
        byArray8[3] = HarakaBase.aesEnc(byArray4[3], RC[23]);
        this.mix512(byArray4, byArray5);
        byArray4[0] = HarakaBase.aesEnc(byArray5[0], RC[24]);
        byArray4[1] = HarakaBase.aesEnc(byArray5[1], RC[25]);
        byArray4[2] = HarakaBase.aesEnc(byArray5[2], RC[26]);
        byArray7[3] = HarakaBase.aesEnc(byArray5[3], RC[27]);
        byArray7[0] = HarakaBase.aesEnc(byArray4[0], RC[28]);
        byArray7[1] = HarakaBase.aesEnc(byArray4[1], RC[29]);
        byArray7[2] = HarakaBase.aesEnc(byArray4[2], RC[30]);
        byArray7[3] = HarakaBase.aesEnc(byArray4[3], RC[31]);
        this.mix512(byArray4, byArray5);
        byArray4[0] = HarakaBase.aesEnc(byArray5[0], RC[32]);
        byArray4[1] = HarakaBase.aesEnc(byArray5[1], RC[33]);
        byArray4[2] = HarakaBase.aesEnc(byArray5[2], RC[34]);
        byArray6[3] = HarakaBase.aesEnc(byArray5[3], RC[35]);
        byArray6[0] = HarakaBase.aesEnc(byArray4[0], RC[36]);
        byArray6[1] = HarakaBase.aesEnc(byArray4[1], RC[37]);
        byArray6[2] = HarakaBase.aesEnc(byArray4[2], RC[38]);
        byArray6[3] = HarakaBase.aesEnc(byArray4[3], RC[39]);
        this.mix512(byArray4, byArray5);
        byArray4[0] = HarakaBase.xor(byArray5[0], byArray, 0);
        byArray4[1] = HarakaBase.xor(byArray5[1], byArray, 16);
        byArray4[2] = HarakaBase.xor(byArray5[2], byArray, 32);
        byArray3[3] = HarakaBase.xor(byArray5[3], byArray, 48);
        System.arraycopy(byArray3[0], 8, byArray2, n3, 8);
        int n4 = n3 + 8;
        System.arraycopy(byArray3[1], 8, byArray2, n4, 8);
        n4 = n3 + 16;
        System.arraycopy(byArray3[2], 0, byArray2, n4, 8);
        n4 = n3 + 24;
        System.arraycopy(byArray3[3], 0, byArray2, n4, 8);
        return 32;
    }

    static {
        byte[][] byArrayArray = new byte[40][];
        byte[] byArray = new byte[16];
        byte[] byArray2 = byArray;
        byArray[0] = 6;
        byArray[1] = -124;
        byArray[2] = 112;
        byArray[3] = 76;
        byArray[4] = -26;
        byArray[5] = 32;
        byArray[6] = -64;
        byArray[7] = 10;
        byArray[8] = -78;
        byArray[9] = -59;
        byArray[10] = -2;
        byArray[11] = -16;
        byArray[12] = 117;
        byArray[13] = -127;
        byArray[14] = 123;
        byArray[15] = -99;
        byArrayArray[0] = byArray2;
        byte[] byArray3 = new byte[16];
        byArray2 = byArray3;
        byArray3[0] = -117;
        byArray3[1] = 102;
        byArray3[2] = -76;
        byArray3[3] = -31;
        byArray3[4] = -120;
        byArray3[5] = -13;
        byArray3[6] = -96;
        byArray3[7] = 107;
        byArray3[8] = 100;
        byArray3[9] = 15;
        byArray3[10] = 107;
        byArray3[11] = -92;
        byArray3[12] = 47;
        byArray3[13] = 8;
        byArray3[14] = -9;
        byArray3[15] = 23;
        byArrayArray[1] = byArray2;
        byte[] byArray4 = new byte[16];
        byArray2 = byArray4;
        byArray4[0] = 52;
        byArray4[1] = 2;
        byArray4[2] = -34;
        byArray4[3] = 45;
        byArray4[4] = 83;
        byArray4[5] = -14;
        byArray4[6] = -124;
        byArray4[7] = -104;
        byArray4[8] = -49;
        byArray4[9] = 2;
        byArray4[10] = -99;
        byArray4[11] = 96;
        byArray4[12] = -97;
        byArray4[13] = 2;
        byArray4[14] = -111;
        byArray4[15] = 20;
        byArrayArray[2] = byArray2;
        byte[] byArray5 = new byte[16];
        byArray2 = byArray5;
        byArray5[0] = 14;
        byArray5[1] = -42;
        byArray5[2] = -22;
        byArray5[3] = -26;
        byArray5[4] = 46;
        byArray5[5] = 123;
        byArray5[6] = 79;
        byArray5[7] = 8;
        byArray5[8] = -69;
        byArray5[9] = -13;
        byArray5[10] = -68;
        byArray5[11] = -81;
        byArray5[12] = -3;
        byArray5[13] = 91;
        byArray5[14] = 79;
        byArray5[15] = 121;
        byArrayArray[3] = byArray2;
        byte[] byArray6 = new byte[16];
        byArray2 = byArray6;
        byArray6[0] = -53;
        byArray6[1] = -49;
        byArray6[2] = -80;
        byArray6[3] = -53;
        byArray6[4] = 72;
        byArray6[5] = 114;
        byArray6[6] = 68;
        byArray6[7] = -117;
        byArray6[8] = 121;
        byArray6[9] = -18;
        byArray6[10] = -51;
        byArray6[11] = 28;
        byArray6[12] = -66;
        byArray6[13] = 57;
        byArray6[14] = 112;
        byArray6[15] = 68;
        byArrayArray[4] = byArray2;
        byte[] byArray7 = new byte[16];
        byArray2 = byArray7;
        byArray7[0] = 126;
        byArray7[1] = -22;
        byArray7[2] = -51;
        byArray7[3] = -18;
        byArray7[4] = 110;
        byArray7[5] = -112;
        byArray7[6] = 50;
        byArray7[7] = -73;
        byArray7[8] = -115;
        byArray7[9] = 83;
        byArray7[10] = 53;
        byArray7[11] = -19;
        byArray7[12] = 43;
        byArray7[13] = -118;
        byArray7[14] = 5;
        byArray7[15] = 123;
        byArrayArray[5] = byArray2;
        byte[] byArray8 = new byte[16];
        byArray2 = byArray8;
        byArray8[0] = 103;
        byArray8[1] = -62;
        byArray8[2] = -113;
        byArray8[3] = 67;
        byArray8[4] = 94;
        byArray8[5] = 46;
        byArray8[6] = 124;
        byArray8[7] = -48;
        byArray8[8] = -30;
        byArray8[9] = 65;
        byArray8[10] = 39;
        byArray8[11] = 97;
        byArray8[12] = -38;
        byArray8[13] = 79;
        byArray8[14] = -17;
        byArray8[15] = 27;
        byArrayArray[6] = byArray2;
        byte[] byArray9 = new byte[16];
        byArray2 = byArray9;
        byArray9[0] = 41;
        byArray9[1] = 36;
        byArray9[2] = -39;
        byArray9[3] = -80;
        byArray9[4] = -81;
        byArray9[5] = -54;
        byArray9[6] = -52;
        byArray9[7] = 7;
        byArray9[8] = 103;
        byArray9[9] = 95;
        byArray9[10] = -3;
        byArray9[11] = -30;
        byArray9[12] = 31;
        byArray9[13] = -57;
        byArray9[14] = 11;
        byArray9[15] = 59;
        byArrayArray[7] = byArray2;
        byte[] byArray10 = new byte[16];
        byArray2 = byArray10;
        byArray10[0] = -85;
        byArray10[1] = 77;
        byArray10[2] = 99;
        byArray10[3] = -15;
        byArray10[4] = -26;
        byArray10[5] = -122;
        byArray10[6] = 127;
        byArray10[7] = -23;
        byArray10[8] = -20;
        byArray10[9] = -37;
        byArray10[10] = -113;
        byArray10[11] = -54;
        byArray10[12] = -71;
        byArray10[13] = -44;
        byArray10[14] = 101;
        byArray10[15] = -18;
        byArrayArray[8] = byArray2;
        byte[] byArray11 = new byte[16];
        byArray2 = byArray11;
        byArray11[0] = 28;
        byArray11[1] = 48;
        byArray11[2] = -65;
        byArray11[3] = -124;
        byArray11[4] = -44;
        byArray11[5] = -73;
        byArray11[6] = -51;
        byArray11[7] = 100;
        byArray11[8] = 91;
        byArray11[9] = 42;
        byArray11[10] = 64;
        byArray11[11] = 79;
        byArray11[12] = -83;
        byArray11[13] = 3;
        byArray11[14] = 126;
        byArray11[15] = 51;
        byArrayArray[9] = byArray2;
        byte[] byArray12 = new byte[16];
        byArray2 = byArray12;
        byArray12[0] = -78;
        byArray12[1] = -52;
        byArray12[2] = 11;
        byArray12[3] = -71;
        byArray12[4] = -108;
        byArray12[5] = 23;
        byArray12[6] = 35;
        byArray12[7] = -65;
        byArray12[8] = 105;
        byArray12[9] = 2;
        byArray12[10] = -117;
        byArray12[11] = 46;
        byArray12[12] = -115;
        byArray12[13] = -10;
        byArray12[14] = -104;
        byArray12[15] = 0;
        byArrayArray[10] = byArray2;
        byte[] byArray13 = new byte[16];
        byArray2 = byArray13;
        byArray13[0] = -6;
        byArray13[1] = 4;
        byArray13[2] = 120;
        byArray13[3] = -90;
        byArray13[4] = -34;
        byArray13[5] = 111;
        byArray13[6] = 85;
        byArray13[7] = 114;
        byArray13[8] = 74;
        byArray13[9] = -86;
        byArray13[10] = -98;
        byArray13[11] = -56;
        byArray13[12] = 92;
        byArray13[13] = -99;
        byArray13[14] = 45;
        byArray13[15] = -118;
        byArrayArray[11] = byArray2;
        byte[] byArray14 = new byte[16];
        byArray2 = byArray14;
        byArray14[0] = -33;
        byArray14[1] = -76;
        byArray14[2] = -97;
        byArray14[3] = 43;
        byArray14[4] = 107;
        byArray14[5] = 119;
        byArray14[6] = 42;
        byArray14[7] = 18;
        byArray14[8] = 14;
        byArray14[9] = -6;
        byArray14[10] = 79;
        byArray14[11] = 46;
        byArray14[12] = 41;
        byArray14[13] = 18;
        byArray14[14] = -97;
        byArray14[15] = -44;
        byArrayArray[12] = byArray2;
        byte[] byArray15 = new byte[16];
        byArray2 = byArray15;
        byArray15[0] = 30;
        byArray15[1] = -95;
        byArray15[2] = 3;
        byArray15[3] = 68;
        byArray15[4] = -12;
        byArray15[5] = 73;
        byArray15[6] = -94;
        byArray15[7] = 54;
        byArray15[8] = 50;
        byArray15[9] = -42;
        byArray15[10] = 17;
        byArray15[11] = -82;
        byArray15[12] = -69;
        byArray15[13] = 106;
        byArray15[14] = 18;
        byArray15[15] = -18;
        byArrayArray[13] = byArray2;
        byte[] byArray16 = new byte[16];
        byArray2 = byArray16;
        byArray16[0] = -81;
        byArray16[1] = 4;
        byArray16[2] = 73;
        byArray16[3] = -120;
        byArray16[4] = 75;
        byArray16[5] = 5;
        byArray16[6] = 0;
        byArray16[7] = -124;
        byArray16[8] = 95;
        byArray16[9] = -106;
        byArray16[10] = 0;
        byArray16[11] = -55;
        byArray16[12] = -100;
        byArray16[13] = -88;
        byArray16[14] = -20;
        byArray16[15] = -90;
        byArrayArray[14] = byArray2;
        byte[] byArray17 = new byte[16];
        byArray2 = byArray17;
        byArray17[0] = 33;
        byArray17[1] = 2;
        byArray17[2] = 94;
        byArray17[3] = -40;
        byArray17[4] = -99;
        byArray17[5] = 25;
        byArray17[6] = -100;
        byArray17[7] = 79;
        byArray17[8] = 120;
        byArray17[9] = -94;
        byArray17[10] = -57;
        byArray17[11] = -29;
        byArray17[12] = 39;
        byArray17[13] = -27;
        byArray17[14] = -109;
        byArray17[15] = -20;
        byArrayArray[15] = byArray2;
        byte[] byArray18 = new byte[16];
        byArray2 = byArray18;
        byArray18[0] = -65;
        byArray18[1] = 58;
        byArray18[2] = -86;
        byArray18[3] = -8;
        byArray18[4] = -89;
        byArray18[5] = 89;
        byArray18[6] = -55;
        byArray18[7] = -73;
        byArray18[8] = -71;
        byArray18[9] = 40;
        byArray18[10] = 46;
        byArray18[11] = -51;
        byArray18[12] = -126;
        byArray18[13] = -44;
        byArray18[14] = 1;
        byArray18[15] = 115;
        byArrayArray[16] = byArray2;
        byte[] byArray19 = new byte[16];
        byArray2 = byArray19;
        byArray19[0] = 98;
        byArray19[1] = 96;
        byArray19[2] = 112;
        byArray19[3] = 13;
        byArray19[4] = 97;
        byArray19[5] = -122;
        byArray19[6] = -80;
        byArray19[7] = 23;
        byArray19[8] = 55;
        byArray19[9] = -14;
        byArray19[10] = -17;
        byArray19[11] = -39;
        byArray19[12] = 16;
        byArray19[13] = 48;
        byArray19[14] = 125;
        byArray19[15] = 107;
        byArrayArray[17] = byArray2;
        byte[] byArray20 = new byte[16];
        byArray2 = byArray20;
        byArray20[0] = 90;
        byArray20[1] = -54;
        byArray20[2] = 69;
        byArray20[3] = -62;
        byArray20[4] = 33;
        byArray20[5] = 48;
        byArray20[6] = 4;
        byArray20[7] = 67;
        byArray20[8] = -127;
        byArray20[9] = -62;
        byArray20[10] = -111;
        byArray20[11] = 83;
        byArray20[12] = -10;
        byArray20[13] = -4;
        byArray20[14] = -102;
        byArray20[15] = -58;
        byArrayArray[18] = byArray2;
        byte[] byArray21 = new byte[16];
        byArray2 = byArray21;
        byArray21[0] = -110;
        byArray21[1] = 35;
        byArray21[2] = -105;
        byArray21[3] = 60;
        byArray21[4] = 34;
        byArray21[5] = 107;
        byArray21[6] = 104;
        byArray21[7] = -69;
        byArray21[8] = 44;
        byArray21[9] = -81;
        byArray21[10] = -110;
        byArray21[11] = -24;
        byArray21[12] = 54;
        byArray21[13] = -47;
        byArray21[14] = -108;
        byArray21[15] = 58;
        byArrayArray[19] = byArray2;
        byte[] byArray22 = new byte[16];
        byArray2 = byArray22;
        byArray22[0] = -45;
        byArray22[1] = -65;
        byArray22[2] = -110;
        byArray22[3] = 56;
        byArray22[4] = 34;
        byArray22[5] = 88;
        byArray22[6] = -122;
        byArray22[7] = -21;
        byArray22[8] = 108;
        byArray22[9] = -70;
        byArray22[10] = -71;
        byArray22[11] = 88;
        byArray22[12] = -27;
        byArray22[13] = 16;
        byArray22[14] = 113;
        byArray22[15] = -76;
        byArrayArray[20] = byArray2;
        byte[] byArray23 = new byte[16];
        byArray2 = byArray23;
        byArray23[0] = -37;
        byArray23[1] = -122;
        byArray23[2] = 60;
        byArray23[3] = -27;
        byArray23[4] = -82;
        byArray23[5] = -16;
        byArray23[6] = -58;
        byArray23[7] = 119;
        byArray23[8] = -109;
        byArray23[9] = 61;
        byArray23[10] = -3;
        byArray23[11] = -35;
        byArray23[12] = 36;
        byArray23[13] = -31;
        byArray23[14] = 18;
        byArray23[15] = -115;
        byArrayArray[21] = byArray2;
        byte[] byArray24 = new byte[16];
        byArray2 = byArray24;
        byArray24[0] = -69;
        byArray24[1] = 96;
        byArray24[2] = 98;
        byArray24[3] = 104;
        byArray24[4] = -1;
        byArray24[5] = -21;
        byArray24[6] = -96;
        byArray24[7] = -100;
        byArray24[8] = -125;
        byArray24[9] = -28;
        byArray24[10] = -115;
        byArray24[11] = -29;
        byArray24[12] = -53;
        byArray24[13] = 34;
        byArray24[14] = 18;
        byArray24[15] = -79;
        byArrayArray[22] = byArray2;
        byte[] byArray25 = new byte[16];
        byArray2 = byArray25;
        byArray25[0] = 115;
        byArray25[1] = 75;
        byArray25[2] = -45;
        byArray25[3] = -36;
        byArray25[4] = -30;
        byArray25[5] = -28;
        byArray25[6] = -47;
        byArray25[7] = -100;
        byArray25[8] = 45;
        byArray25[9] = -71;
        byArray25[10] = 26;
        byArray25[11] = 78;
        byArray25[12] = -57;
        byArray25[13] = 43;
        byArray25[14] = -9;
        byArray25[15] = 125;
        byArrayArray[23] = byArray2;
        byte[] byArray26 = new byte[16];
        byArray2 = byArray26;
        byArray26[0] = 67;
        byArray26[1] = -69;
        byArray26[2] = 71;
        byArray26[3] = -61;
        byArray26[4] = 97;
        byArray26[5] = 48;
        byArray26[6] = 27;
        byArray26[7] = 67;
        byArray26[8] = 75;
        byArray26[9] = 20;
        byArray26[10] = 21;
        byArray26[11] = -60;
        byArray26[12] = 44;
        byArray26[13] = -77;
        byArray26[14] = -110;
        byArray26[15] = 78;
        byArrayArray[24] = byArray2;
        byte[] byArray27 = new byte[16];
        byArray2 = byArray27;
        byArray27[0] = -37;
        byArray27[1] = -89;
        byArray27[2] = 117;
        byArray27[3] = -88;
        byArray27[4] = -25;
        byArray27[5] = 7;
        byArray27[6] = -17;
        byArray27[7] = -10;
        byArray27[8] = 3;
        byArray27[9] = -78;
        byArray27[10] = 49;
        byArray27[11] = -35;
        byArray27[12] = 22;
        byArray27[13] = -21;
        byArray27[14] = 104;
        byArray27[15] = -103;
        byArrayArray[25] = byArray2;
        byte[] byArray28 = new byte[16];
        byArray2 = byArray28;
        byArray28[0] = 109;
        byArray28[1] = -13;
        byArray28[2] = 97;
        byArray28[3] = 75;
        byArray28[4] = 60;
        byArray28[5] = 117;
        byArray28[6] = 89;
        byArray28[7] = 119;
        byArray28[8] = -114;
        byArray28[9] = 94;
        byArray28[10] = 35;
        byArray28[11] = 2;
        byArray28[12] = 126;
        byArray28[13] = -54;
        byArray28[14] = 71;
        byArray28[15] = 44;
        byArrayArray[26] = byArray2;
        byte[] byArray29 = new byte[16];
        byArray2 = byArray29;
        byArray29[0] = -51;
        byArray29[1] = -89;
        byArray29[2] = 90;
        byArray29[3] = 23;
        byArray29[4] = -42;
        byArray29[5] = -34;
        byArray29[6] = 125;
        byArray29[7] = 119;
        byArray29[8] = 109;
        byArray29[9] = 27;
        byArray29[10] = -27;
        byArray29[11] = -71;
        byArray29[12] = -72;
        byArray29[13] = -122;
        byArray29[14] = 23;
        byArray29[15] = -7;
        byArrayArray[27] = byArray2;
        byte[] byArray30 = new byte[16];
        byArray2 = byArray30;
        byArray30[0] = -20;
        byArray30[1] = 107;
        byArray30[2] = 67;
        byArray30[3] = -16;
        byArray30[4] = 107;
        byArray30[5] = -88;
        byArray30[6] = -23;
        byArray30[7] = -86;
        byArray30[8] = -99;
        byArray30[9] = 108;
        byArray30[10] = 6;
        byArray30[11] = -99;
        byArray30[12] = -87;
        byArray30[13] = 70;
        byArray30[14] = -18;
        byArray30[15] = 93;
        byArrayArray[28] = byArray2;
        byte[] byArray31 = new byte[16];
        byArray2 = byArray31;
        byArray31[0] = -53;
        byArray31[1] = 30;
        byArray31[2] = 105;
        byArray31[3] = 80;
        byArray31[4] = -7;
        byArray31[5] = 87;
        byArray31[6] = 51;
        byArray31[7] = 43;
        byArray31[8] = -94;
        byArray31[9] = 83;
        byArray31[10] = 17;
        byArray31[11] = 89;
        byArray31[12] = 59;
        byArray31[13] = -13;
        byArray31[14] = 39;
        byArray31[15] = -63;
        byArrayArray[29] = byArray2;
        byte[] byArray32 = new byte[16];
        byArray2 = byArray32;
        byArray32[0] = 44;
        byArray32[1] = -18;
        byArray32[2] = 12;
        byArray32[3] = 117;
        byArray32[4] = 0;
        byArray32[5] = -38;
        byArray32[6] = 97;
        byArray32[7] = -100;
        byArray32[8] = -28;
        byArray32[9] = -19;
        byArray32[10] = 3;
        byArray32[11] = 83;
        byArray32[12] = 96;
        byArray32[13] = 14;
        byArray32[14] = -48;
        byArray32[15] = -39;
        byArrayArray[30] = byArray2;
        byte[] byArray33 = new byte[16];
        byArray2 = byArray33;
        byArray33[0] = -16;
        byArray33[1] = -79;
        byArray33[2] = -91;
        byArray33[3] = -95;
        byArray33[4] = -106;
        byArray33[5] = -23;
        byArray33[6] = 12;
        byArray33[7] = -85;
        byArray33[8] = -128;
        byArray33[9] = -69;
        byArray33[10] = -70;
        byArray33[11] = -68;
        byArray33[12] = 99;
        byArray33[13] = -92;
        byArray33[14] = -93;
        byArray33[15] = 80;
        byArrayArray[31] = byArray2;
        byte[] byArray34 = new byte[16];
        byArray2 = byArray34;
        byArray34[0] = -82;
        byArray34[1] = 61;
        byArray34[2] = -79;
        byArray34[3] = 2;
        byArray34[4] = 94;
        byArray34[5] = -106;
        byArray34[6] = 41;
        byArray34[7] = -120;
        byArray34[8] = -85;
        byArray34[9] = 13;
        byArray34[10] = -34;
        byArray34[11] = 48;
        byArray34[12] = -109;
        byArray34[13] = -115;
        byArray34[14] = -54;
        byArray34[15] = 57;
        byArrayArray[32] = byArray2;
        byte[] byArray35 = new byte[16];
        byArray2 = byArray35;
        byArray35[0] = 23;
        byArray35[1] = -69;
        byArray35[2] = -113;
        byArray35[3] = 56;
        byArray35[4] = -43;
        byArray35[5] = 84;
        byArray35[6] = -92;
        byArray35[7] = 11;
        byArray35[8] = -120;
        byArray35[9] = 20;
        byArray35[10] = -13;
        byArray35[11] = -88;
        byArray35[12] = 46;
        byArray35[13] = 117;
        byArray35[14] = -76;
        byArray35[15] = 66;
        byArrayArray[33] = byArray2;
        byte[] byArray36 = new byte[16];
        byArray2 = byArray36;
        byArray36[0] = 52;
        byArray36[1] = -69;
        byArray36[2] = -118;
        byArray36[3] = 91;
        byArray36[4] = 95;
        byArray36[5] = 66;
        byArray36[6] = 127;
        byArray36[7] = -41;
        byArray36[8] = -82;
        byArray36[9] = -74;
        byArray36[10] = -73;
        byArray36[11] = 121;
        byArray36[12] = 54;
        byArray36[13] = 10;
        byArray36[14] = 22;
        byArray36[15] = -10;
        byArrayArray[34] = byArray2;
        byte[] byArray37 = new byte[16];
        byArray2 = byArray37;
        byArray37[0] = 38;
        byArray37[1] = -10;
        byArray37[2] = 82;
        byArray37[3] = 65;
        byArray37[4] = -53;
        byArray37[5] = -27;
        byArray37[6] = 84;
        byArray37[7] = 56;
        byArray37[8] = 67;
        byArray37[9] = -50;
        byArray37[10] = 89;
        byArray37[11] = 24;
        byArray37[12] = -1;
        byArray37[13] = -70;
        byArray37[14] = -81;
        byArray37[15] = -34;
        byArrayArray[35] = byArray2;
        byte[] byArray38 = new byte[16];
        byArray2 = byArray38;
        byArray38[0] = 76;
        byArray38[1] = -23;
        byArray38[2] = -102;
        byArray38[3] = 84;
        byArray38[4] = -71;
        byArray38[5] = -13;
        byArray38[6] = 2;
        byArray38[7] = 106;
        byArray38[8] = -94;
        byArray38[9] = -54;
        byArray38[10] = -100;
        byArray38[11] = -9;
        byArray38[12] = -125;
        byArray38[13] = -98;
        byArray38[14] = -55;
        byArray38[15] = 120;
        byArrayArray[36] = byArray2;
        byte[] byArray39 = new byte[16];
        byArray2 = byArray39;
        byArray39[0] = -82;
        byArray39[1] = 81;
        byArray39[2] = -91;
        byArray39[3] = 26;
        byArray39[4] = 27;
        byArray39[5] = -33;
        byArray39[6] = -9;
        byArray39[7] = -66;
        byArray39[8] = 64;
        byArray39[9] = -64;
        byArray39[10] = 110;
        byArray39[11] = 40;
        byArray39[12] = 34;
        byArray39[13] = -112;
        byArray39[14] = 18;
        byArray39[15] = 53;
        byArrayArray[37] = byArray2;
        byte[] byArray40 = new byte[16];
        byArray2 = byArray40;
        byArray40[0] = -96;
        byArray40[1] = -63;
        byArray40[2] = 97;
        byArray40[3] = 60;
        byArray40[4] = -70;
        byArray40[5] = 126;
        byArray40[6] = -46;
        byArray40[7] = 43;
        byArray40[8] = -63;
        byArray40[9] = 115;
        byArray40[10] = -68;
        byArray40[11] = 15;
        byArray40[12] = 72;
        byArray40[13] = -90;
        byArray40[14] = 89;
        byArray40[15] = -49;
        byArrayArray[38] = byArray2;
        byte[] byArray41 = new byte[16];
        byArray2 = byArray41;
        byArray41[0] = 117;
        byArray41[1] = 106;
        byArray41[2] = -52;
        byArray41[3] = 3;
        byArray41[4] = 2;
        byArray41[5] = 40;
        byArray41[6] = -126;
        byArray41[7] = -120;
        byArray41[8] = 74;
        byArray41[9] = -42;
        byArray41[10] = -67;
        byArray41[11] = -3;
        byArray41[12] = -23;
        byArray41[13] = -59;
        byArray41[14] = -99;
        byArray41[15] = -95;
        byArrayArray[39] = byArray2;
        RC = byArrayArray;
    }

    @Override
    public String getAlgorithmName() {
        return "Haraka-512";
    }

    @Override
    public void update(byte by) {
        int n3 = this.off;
        if (n3 + 1 <= 64) {
            this.off = n3 + 1;
            this.buffer[n3] = by;
            return;
        }
        throw new IllegalArgumentException("total input cannot be more than 64 bytes");
    }

    @Override
    public void update(byte[] byArray, int n3, int n4) {
        int n5 = this.off;
        if (n5 + n4 <= 64) {
            System.arraycopy(byArray, n3, this.buffer, n5, n4);
            this.off += n4;
            return;
        }
        throw new IllegalArgumentException("total input cannot be more than 64 bytes");
    }

    @Override
    public int doFinal(byte[] byArray, int n3) {
        if (this.off == 64) {
            if (byArray.length - n3 >= 32) {
                Haraka512Digest haraka512Digest = this;
                int n4 = haraka512Digest.haraka512256(haraka512Digest.buffer, byArray, n3);
                this.reset();
                return n4;
            }
            throw new IllegalArgumentException("output too short to receive digest");
        }
        throw new IllegalStateException("input must be exactly 64 bytes");
    }

    @Override
    public void reset() {
        this.off = 0;
        Arrays.clear(this.buffer);
    }
}

