/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.crypto.digests;

import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.CipherParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.ExtendedDigest;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.Xof;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.digests.a;
import com.fis.ekyc.nfc.build_in.bouncycastle.util.Arrays;
import com.fis.ekyc.nfc.build_in.bouncycastle.util.Pack;

public final class Kangaroo {
    private static final int DIGESTLEN = 32;

    public static class KangarooSponge {
        private static long[] KeccakRoundConstants = new long[]{1L, 32898L, -9223372036854742902L, -9223372034707259392L, 32907L, 0x80000001L, -9223372034707259263L, -9223372036854743031L, 138L, 136L, 0x80008009L, 0x8000000AL, 0x8000808BL, -9223372036854775669L, -9223372036854742903L, -9223372036854743037L, -9223372036854743038L, -9223372036854775680L, 32778L, -9223372034707292150L, -9223372034707259263L, -9223372036854742912L, 0x80000001L, -9223372034707259384L};
        private final int theRounds;
        private final int theRateBytes;
        private final long[] theState = new long[25];
        private final byte[] theQueue;
        private int bytesInQueue;
        private boolean squeezing;

        public KangarooSponge(int n3, int n4) {
            int n5;
            this.theRateBytes = n5 = 1600 - (n3 << 1) >> 3;
            this.theRounds = n4;
            this.theQueue = new byte[n5];
            this.initSponge();
        }

        private void initSponge() {
            KangarooSponge kangarooSponge = this;
            Arrays.fill(kangarooSponge.theState, 0L);
            Arrays.fill(kangarooSponge.theQueue, (byte)0);
            kangarooSponge.bytesInQueue = 0;
            kangarooSponge.squeezing = false;
        }

        private void absorb(byte[] byArray, int n3, int n4) {
            if (!this.squeezing) {
                int n5 = 0;
                block0: while (n5 < n4) {
                    int n6 = this.bytesInQueue;
                    if (n6 == 0 && n5 <= n4 - this.theRateBytes) {
                        while (true) {
                            int n7 = n5;
                            KangarooSponge kangarooSponge = this;
                            kangarooSponge.KangarooAbsorb(byArray, n3 + n5);
                            n5 = kangarooSponge.theRateBytes;
                            n6 = n7 + n5;
                            if (n6 > n4 - n5) {
                                n5 = n6;
                                continue block0;
                            }
                            n5 = n6;
                        }
                    }
                    KangarooSponge kangarooSponge = this;
                    n6 = Math.min(this.theRateBytes - n6, n4 - n5);
                    int n8 = n3 + n5;
                    byte[] byArray2 = kangarooSponge.theQueue;
                    int n9 = kangarooSponge.bytesInQueue;
                    System.arraycopy(byArray, n8, byArray2, n9, n6);
                    this.bytesInQueue = n8 = this.bytesInQueue + n6;
                    n5 += n6;
                    if (n8 != this.theRateBytes) continue;
                    KangarooSponge kangarooSponge2 = this;
                    kangarooSponge2.KangarooAbsorb(kangarooSponge2.theQueue, 0);
                    kangarooSponge2.bytesInQueue = 0;
                }
                return;
            }
            throw new IllegalStateException("attempt to absorb while squeezing");
        }

        private void padAndSwitchToSqueezingPhase() {
            int n3;
            for (int i3 = this.bytesInQueue; i3 < (n3 = this.theRateBytes); ++i3) {
                this.theQueue[i3] = 0;
            }
            KangarooSponge kangarooSponge = this;
            byte[] byArray = kangarooSponge.theQueue;
            int n4 = n3 - 1;
            byArray[n4] = (byte)(byArray[n4] ^ 0x80);
            kangarooSponge.KangarooAbsorb(kangarooSponge.theQueue, 0);
            kangarooSponge.KangarooExtract();
            kangarooSponge.bytesInQueue = kangarooSponge.theRateBytes;
            kangarooSponge.squeezing = true;
        }

        private void squeeze(byte[] byArray, int n3, int n4) {
            if (!this.squeezing) {
                this.padAndSwitchToSqueezingPhase();
            }
            int n5 = 0;
            while (n5 < n4) {
                if (this.bytesInQueue == 0) {
                    KangarooSponge kangarooSponge = this;
                    kangarooSponge.KangarooPermutation();
                    kangarooSponge.KangarooExtract();
                    kangarooSponge.bytesInQueue = kangarooSponge.theRateBytes;
                }
                int n6 = n5;
                KangarooSponge kangarooSponge = this;
                int n7 = Math.min(kangarooSponge.bytesInQueue, n4 - n5);
                int n8 = n5;
                n5 = this.theRateBytes - this.bytesInQueue;
                int n9 = n3 + n8;
                System.arraycopy(kangarooSponge.theQueue, n5, byArray, n9, n7);
                kangarooSponge.bytesInQueue -= n7;
                n5 = n6 + n7;
            }
        }

        private void KangarooAbsorb(byte[] byArray, int n3) {
            int n4 = this.theRateBytes >> 3;
            for (int i3 = 0; i3 < n4; ++i3) {
                this.theState[i3] = this.theState[i3] ^ Pack.littleEndianToLong(byArray, n3);
                n3 += 8;
            }
            this.KangarooPermutation();
        }

        private void KangarooExtract() {
            KangarooSponge kangarooSponge = this;
            int n3 = kangarooSponge.theRateBytes >> 3;
            byte[] byArray = kangarooSponge.theQueue;
            Pack.longToLittleEndian(this.theState, 0, n3, byArray, 0);
        }

        private void KangarooPermutation() {
            long[] lArray = this.theState;
            long l3 = this.theState[0];
            long l4 = lArray[1];
            long l5 = this.theState[2];
            long l6 = lArray[3];
            long l7 = this.theState[4];
            long l8 = lArray[5];
            long l9 = this.theState[6];
            long l10 = lArray[7];
            long l11 = this.theState[8];
            long l12 = lArray[9];
            long l13 = this.theState[10];
            long l14 = lArray[11];
            long l15 = this.theState[12];
            long l16 = lArray[13];
            long l17 = this.theState[14];
            long l18 = lArray[15];
            long l19 = this.theState[16];
            long l20 = lArray[17];
            long l21 = this.theState[18];
            long l22 = lArray[19];
            long l23 = this.theState[20];
            long l24 = lArray[21];
            long l25 = this.theState[22];
            long l26 = lArray[23];
            long l27 = this.theState[24];
            int n3 = KeccakRoundConstants.length - this.theRounds;
            for (int i3 = 0; i3 < this.theRounds; ++i3) {
                long l28 = l3;
                l3 = l28 ^ l8 ^ l13 ^ l18 ^ l23;
                long l29 = l4 ^ l9 ^ l14 ^ l19 ^ l24;
                long l30 = l5 ^ l10 ^ l15 ^ l20 ^ l25;
                long l31 = l6 ^ l11 ^ l16 ^ l21 ^ l26;
                long l32 = l7 ^ l12 ^ l17 ^ l22 ^ l27;
                long l33 = (l29 << 1 | l29 >>> -1) ^ l32;
                long l34 = (l30 << 1 | l30 >>> -1) ^ l3;
                l29 = (l31 << 1 | l31 >>> -1) ^ l29;
                l30 = (l32 << 1 | l32 >>> -1) ^ l30;
                l3 = (l3 << 1 | l3 >>> -1) ^ l31;
                l31 = l28 ^ l33;
                long l35 = l9;
                long l36 = l4;
                l4 = l8 ^ l33;
                l8 = l13 ^ l33;
                l9 = l18 ^ l33;
                l13 = l23 ^ l33;
                l18 = l36 ^ l34;
                l23 = l35 ^ l34;
                long l37 = l3;
                long l38 = l22;
                long l39 = l3;
                long l40 = l17;
                long l41 = l3;
                long l42 = l12;
                long l43 = l3;
                long l44 = l7;
                long l45 = l3;
                long l46 = l16;
                long l47 = l11;
                long l48 = l6;
                long l49 = l5;
                l3 = l14 ^ l34;
                l5 = l19 ^ l34;
                l6 = l24 ^ l34;
                l7 = l49 ^ l29;
                l10 ^= l29;
                l11 = l15 ^ l29;
                l12 = l20 ^ l29;
                l14 = l25 ^ l29;
                l15 = l48 ^ l30;
                l16 = l47 ^ l30;
                l17 = l46 ^ l30;
                l19 = l21 ^ l30;
                l20 = l26 ^ l30;
                l21 = l44 ^ l45;
                l22 = l42 ^ l43;
                l24 = l40 ^ l41;
                l25 = l38 ^ l39;
                l26 = l27 ^ l37;
                l18 = l18 << 1 | l18 >>> 63;
                l23 = l23 << 44 | l23 >>> 20;
                l22 = l22 << 20 | l22 >>> 44;
                l14 = l14 << 61 | l14 >>> 3;
                l24 = l24 << 39 | l24 >>> 25;
                l13 = l13 << 18 | l13 >>> 46;
                l7 = l7 << 62 | l7 >>> 2;
                l11 = l11 << 43 | l11 >>> 21;
                l17 = l17 << 25 | l17 >>> 39;
                l25 = l25 << 8 | l25 >>> 56;
                l20 = l20 << 56 | l20 >>> 8;
                l9 = l9 << 41 | l9 >>> 23;
                l21 = l21 << 27 | l21 >>> 37;
                l26 = l26 << 14 | l26 >>> 50;
                l6 = l6 << 2 | l6 >>> 62;
                l16 = l16 << 55 | l16 >>> 9;
                l5 = l5 << 45 | l5 >>> 19;
                l4 = l4 << 36 | l4 >>> 28;
                l15 = l15 << 28 | l15 >>> 36;
                l19 = l19 << 21 | l19 >>> 43;
                l12 = l12 << 15 | l12 >>> 49;
                l3 = l3 << 10 | l3 >>> 54;
                l10 = l10 << 6 | l10 >>> 58;
                l8 = l8 << 3 | l8 >>> 61;
                long l50 = l31 ^ (l23 ^ 0xFFFFFFFFFFFFFFFFL) & l11;
                long l51 = l6;
                long l52 = l7;
                long l53 = l9;
                long l54 = l6;
                long l55 = l24;
                long l56 = l9;
                long l57 = l24;
                long l58 = l20;
                long l59 = l21;
                long l60 = l12;
                long l61 = l20;
                long l62 = l3;
                long l63 = l12;
                long l64 = l3;
                long l65 = l13;
                long l66 = l18;
                long l67 = l25;
                long l68 = l13;
                long l69 = l17;
                long l70 = l25;
                long l71 = l17;
                long l72 = l14;
                long l73 = l15;
                long l74 = l5;
                long l75 = l14;
                long l76 = l8;
                long l77 = l5;
                long l78 = l8;
                long l79 = l26;
                long l80 = l19;
                long l81 = l11;
                l11 = l23 ^ (l11 ^ 0xFFFFFFFFFFFFFFFFL) & l19;
                l19 = l81 ^ (l19 ^ 0xFFFFFFFFFFFFFFFFL) & l26;
                l26 = l80 ^ (l26 ^ 0xFFFFFFFFFFFFFFFFL) & l31;
                l23 = l79 ^ (l31 ^ 0xFFFFFFFFFFFFFFFFL) & l23;
                l8 = l15 ^ (l22 ^ 0xFFFFFFFFFFFFFFFFL) & l8;
                l5 = l22 ^ (l78 ^ 0xFFFFFFFFFFFFFFFFL) & l5;
                l14 = l76 ^ (l77 ^ 0xFFFFFFFFFFFFFFFFL) & l14;
                l15 = l74 ^ (l75 ^ 0xFFFFFFFFFFFFFFFFL) & l15;
                l22 = l72 ^ (l73 ^ 0xFFFFFFFFFFFFFFFFL) & l22;
                l17 = l18 ^ (l10 ^ 0xFFFFFFFFFFFFFFFFL) & l17;
                l25 = l10 ^ (l71 ^ 0xFFFFFFFFFFFFFFFFL) & l25;
                l13 = l69 ^ (l70 ^ 0xFFFFFFFFFFFFFFFFL) & l13;
                l18 = l67 ^ (l68 ^ 0xFFFFFFFFFFFFFFFFL) & l18;
                l10 = l65 ^ (l66 ^ 0xFFFFFFFFFFFFFFFFL) & l10;
                l3 = l21 ^ (l4 ^ 0xFFFFFFFFFFFFFFFFL) & l3;
                l12 = l4 ^ (l64 ^ 0xFFFFFFFFFFFFFFFFL) & l12;
                l20 = l62 ^ (l63 ^ 0xFFFFFFFFFFFFFFFFL) & l20;
                l21 = l60 ^ (l61 ^ 0xFFFFFFFFFFFFFFFFL) & l21;
                l4 = l58 ^ (l59 ^ 0xFFFFFFFFFFFFFFFFL) & l4;
                l24 = l7 ^ (l16 ^ 0xFFFFFFFFFFFFFFFFL) & l24;
                l9 = l16 ^ (l57 ^ 0xFFFFFFFFFFFFFFFFL) & l9;
                l6 = l55 ^ (l56 ^ 0xFFFFFFFFFFFFFFFFL) & l6;
                l7 = l53 ^ (l54 ^ 0xFFFFFFFFFFFFFFFFL) & l7;
                l27 = l51 ^ (l52 ^ 0xFFFFFFFFFFFFFFFFL) & l16;
                l16 = l50 ^ KeccakRoundConstants[n3 + i3];
                long l82 = l16;
                long l83 = l11;
                long l84 = l19;
                long l85 = l26;
                long l86 = l23;
                long l87 = l14;
                long l88 = l15;
                long l89 = l22;
                long l90 = l17;
                long l91 = l25;
                long l92 = l18;
                long l93 = l24;
                l26 = l7;
                l25 = l6;
                l24 = l9;
                l23 = l93;
                l22 = l4;
                l19 = l12;
                l18 = l3;
                l17 = l10;
                l16 = l92;
                l15 = l13;
                l14 = l91;
                l13 = l90;
                l12 = l89;
                l11 = l88;
                l10 = l87;
                l9 = l5;
                l7 = l86;
                l6 = l85;
                l5 = l84;
                l4 = l83;
                l3 = l82;
            }
            long[] lArray2 = lArray;
            lArray2[0] = l3;
            lArray2[1] = l4;
            lArray2[2] = l5;
            lArray2[3] = l6;
            lArray2[4] = l7;
            lArray2[5] = l8;
            lArray2[6] = l9;
            lArray2[7] = l10;
            lArray2[8] = l11;
            lArray2[9] = l12;
            lArray2[10] = l13;
            lArray2[11] = l14;
            lArray2[12] = l15;
            lArray2[13] = l16;
            lArray2[14] = l17;
            lArray2[15] = l18;
            lArray2[16] = l19;
            lArray2[17] = l20;
            lArray2[18] = l21;
            lArray2[19] = l22;
            lArray2[20] = l23;
            lArray2[21] = l24;
            lArray2[22] = l25;
            lArray2[23] = l26;
            lArray[24] = l27;
        }
    }

    public static abstract class KangarooBase
    implements ExtendedDigest,
    Xof {
        private static final int BLKSIZE = 8192;
        private static final byte[] SINGLE = new byte[]{7};
        private static final byte[] INTERMEDIATE = new byte[]{11};
        private static final byte[] FINAL = new byte[]{-1, -1, 6};
        private static final byte[] FIRST = new byte[]{3, 0, 0, 0, 0, 0, 0, 0};
        private final byte[] singleByte = new byte[1];
        private final KangarooSponge theTree;
        private final KangarooSponge theLeaf;
        private final int theChainLen;
        private byte[] thePersonal;
        private boolean squeezing;
        private int theCurrNode;
        private int theProcessed;

        public KangarooBase(int n3, int n4, int n5) {
            this.theTree = new KangarooSponge(n3, n4);
            this.theLeaf = new KangarooSponge(n3, n4);
            this.theChainLen = n3 >> 2;
            this.buildPersonal(null);
        }

        private void buildPersonal(byte[] byArray) {
            int n3 = byArray == null ? 0 : byArray.length;
            byte[] byArray2 = KangarooBase.lengthEncode(n3);
            byArray = byArray == null ? new byte[n3 + byArray2.length] : Arrays.copyOf(byArray, n3 + byArray2.length);
            this.thePersonal = byArray;
            int n4 = byArray2.length;
            System.arraycopy(byArray2, 0, byArray, n3, n4);
        }

        private void processData(byte[] byArray, int n3, int n4) {
            if (!this.squeezing) {
                KangarooSponge kangarooSponge = this.theCurrNode == 0 ? this.theTree : this.theLeaf;
                int n5 = 8192 - this.theProcessed;
                if (n5 >= n4) {
                    kangarooSponge.absorb(byArray, n3, n4);
                    this.theProcessed += n4;
                    return;
                }
                if (n5 > 0) {
                    kangarooSponge.absorb(byArray, n3, n5);
                    this.theProcessed += n5;
                }
                while (n5 < n4) {
                    if (this.theProcessed == 8192) {
                        this.switchLeaf(true);
                    }
                    KangarooBase kangarooBase = this;
                    int n6 = Math.min(n4 - n5, 8192);
                    kangarooBase.theLeaf.absorb(byArray, n3 + n5, n6);
                    kangarooBase.theProcessed += n6;
                    n5 += n6;
                }
                return;
            }
            throw new IllegalStateException("attempt to absorb while squeezing");
        }

        private void switchLeaf(boolean bl) {
            if (this.theCurrNode == 0) {
                this.theTree.absorb(KangarooBase.FIRST, 0, KangarooBase.FIRST.length);
            } else {
                KangarooBase kangarooBase = this;
                kangarooBase.theLeaf.absorb(KangarooBase.INTERMEDIATE, 0, KangarooBase.INTERMEDIATE.length);
                int n3 = kangarooBase.theChainLen;
                byte[] byArray = new byte[n3];
                kangarooBase.theLeaf.squeeze(byArray, 0, n3);
                kangarooBase.theTree.absorb(byArray, 0, this.theChainLen);
                kangarooBase.theLeaf.initSponge();
            }
            if (bl) {
                ++this.theCurrNode;
            }
            this.theProcessed = 0;
        }

        private void switchToSqueezing() {
            KangarooBase kangarooBase = this;
            kangarooBase.processData(kangarooBase.thePersonal, 0, kangarooBase.thePersonal.length);
            if (kangarooBase.theCurrNode == 0) {
                this.switchSingle();
            } else {
                this.switchFinal();
            }
        }

        private void switchSingle() {
            KangarooBase kangarooBase = this;
            kangarooBase.theTree.absorb(KangarooBase.SINGLE, 0, 1);
            kangarooBase.theTree.padAndSwitchToSqueezingPhase();
        }

        private void switchFinal() {
            KangarooBase kangarooBase = this;
            kangarooBase.switchLeaf(false);
            Object object = this = (Object)KangarooBase.lengthEncode(kangarooBase.theCurrNode);
            kangarooBase.theTree.absorb((byte[])object, 0, ((Object)object).length);
            kangarooBase.theTree.absorb(KangarooBase.FINAL, 0, KangarooBase.FINAL.length);
            kangarooBase.theTree.padAndSwitchToSqueezingPhase();
        }

        private static byte[] lengthEncode(long l3) {
            int n3 = 0;
            if (l3 != 0L) {
                n3 = 1;
                long l4 = l3;
                while ((l4 >>= 8) != 0L) {
                    n3 = (byte)(n3 + 1);
                }
            }
            byte[] byArray = new byte[n3 + 1];
            byte[] byArray2 = byArray;
            int n4 = n3;
            byArray[n4] = n4;
            for (int i3 = 0; i3 < n3; ++i3) {
                byArray2[i3] = (byte)(l3 >> a.a(n3, i3, 1, 8));
            }
            return byArray2;
        }

        @Override
        public int getByteLength() {
            return this.theTree.theRateBytes;
        }

        @Override
        public int getDigestSize() {
            return this.theChainLen >> 1;
        }

        public void init(KangarooParameters kangarooParameters) {
            KangarooBase kangarooBase = this;
            kangarooBase.buildPersonal(kangarooParameters.getPersonalisation());
            kangarooBase.reset();
        }

        @Override
        public void update(byte by) {
            KangarooBase kangarooBase = object;
            Object object = kangarooBase.singleByte;
            kangarooBase.singleByte[0] = by;
            kangarooBase.update((byte[])object, 0, 1);
        }

        @Override
        public void update(byte[] byArray, int n3, int n4) {
            this.processData(byArray, n3, n4);
        }

        @Override
        public int doFinal(byte[] byArray, int n3) {
            return this.doFinal(byArray, n3, this.getDigestSize());
        }

        @Override
        public int doFinal(byte[] byArray, int n3, int n4) {
            if (!this.squeezing) {
                int n5 = this.doOutput(byArray, n3, n4);
                this.reset();
                return n5;
            }
            throw new IllegalStateException("Already outputting");
        }

        @Override
        public int doOutput(byte[] byArray, int n3, int n4) {
            if (!this.squeezing) {
                this.switchToSqueezing();
            }
            if (n4 >= 0) {
                this.theTree.squeeze(byArray, n3, n4);
                return n4;
            }
            throw new IllegalArgumentException("Invalid output length");
        }

        @Override
        public void reset() {
            KangarooBase kangarooBase = this;
            kangarooBase.theTree.initSponge();
            kangarooBase.theLeaf.initSponge();
            kangarooBase.theCurrNode = 0;
            kangarooBase.theProcessed = 0;
            kangarooBase.squeezing = false;
        }
    }

    public static class KangarooParameters
    implements CipherParameters {
        private byte[] thePersonal;

        public static /* synthetic */ byte[] access$002(KangarooParameters kangarooParameters, byte[] byArray) {
            kangarooParameters.thePersonal = byArray;
            return byArray;
        }

        public byte[] getPersonalisation() {
            return Arrays.clone(this.thePersonal);
        }

        public static class Builder {
            private byte[] thePersonal;

            public Builder setPersonalisation(byte[] byArray) {
                this.thePersonal = Arrays.clone(byArray);
                return this;
            }

            public KangarooParameters build() {
                KangarooParameters kangarooParameters;
                Builder builder = kangarooParameters2;
                KangarooParameters kangarooParameters2 = kangarooParameters;
                kangarooParameters = new KangarooParameters();
                byte[] byArray = builder.thePersonal;
                if (builder.thePersonal != null) {
                    KangarooParameters.access$002(kangarooParameters2, byArray);
                }
                return kangarooParameters2;
            }
        }
    }

    public static class MarsupilamiFourteen
    extends KangarooBase {
        public MarsupilamiFourteen() {
            this(32);
        }

        public MarsupilamiFourteen(int n3) {
            super(256, 14, n3);
        }

        @Override
        public String getAlgorithmName() {
            return "MarsupilamiFourteen";
        }
    }

    public static class KangarooTwelve
    extends KangarooBase {
        public KangarooTwelve() {
            this(32);
        }

        public KangarooTwelve(int n3) {
            super(128, 12, n3);
        }

        @Override
        public String getAlgorithmName() {
            return "KangarooTwelve";
        }
    }
}

