/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.crypto.digests;

import b.b;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.ExtendedDigest;
import com.fis.ekyc.nfc.build_in.bouncycastle.util.Arrays;
import com.fis.ekyc.nfc.build_in.bouncycastle.util.Pack;
import com.fis.ekyc.nfc.build_in.bouncycastle.util.encoders.Hex;

public class KeccakDigest
implements ExtendedDigest {
    private static long[] KeccakRoundConstants = new long[]{1L, 32898L, -9223372036854742902L, -9223372034707259392L, 32907L, 0x80000001L, -9223372034707259263L, -9223372036854743031L, 138L, 136L, 0x80008009L, 0x8000000AL, 0x8000808BL, -9223372036854775669L, -9223372036854742903L, -9223372036854743037L, -9223372036854743038L, -9223372036854775680L, 32778L, -9223372034707292150L, -9223372034707259263L, -9223372036854742912L, 0x80000001L, -9223372034707259384L};
    public long[] state;
    public byte[] dataQueue;
    public int rate;
    public int bitsInQueue;
    public int fixedOutputLength;
    public boolean squeezing;

    public KeccakDigest() {
        this(288);
    }

    public KeccakDigest(int n3) {
        this.state = new long[25];
        this.dataQueue = new byte[192];
        this.init(n3);
    }

    public KeccakDigest(KeccakDigest object) {
        KeccakDigest keccakDigest = object2;
        KeccakDigest keccakDigest2 = object;
        KeccakDigest keccakDigest3 = object2;
        KeccakDigest keccakDigest4 = object;
        KeccakDigest keccakDigest5 = object2;
        KeccakDigest keccakDigest6 = object;
        KeccakDigest keccakDigest7 = object2;
        KeccakDigest keccakDigest8 = object;
        long[] lArray = new long[25];
        object = lArray;
        ((KeccakDigest)object2).state = lArray;
        ((KeccakDigest)object2).dataQueue = new byte[192];
        int n3 = keccakDigest8.state.length;
        System.arraycopy(keccakDigest8.state, 0, object, 0, n3);
        Object object2 = ((KeccakDigest)object2).dataQueue;
        int n4 = keccakDigest8.dataQueue.length;
        System.arraycopy(keccakDigest8.dataQueue, 0, object2, 0, n4);
        keccakDigest7.rate = keccakDigest8.rate;
        keccakDigest5.bitsInQueue = keccakDigest6.bitsInQueue;
        keccakDigest3.fixedOutputLength = keccakDigest4.fixedOutputLength;
        keccakDigest.squeezing = keccakDigest2.squeezing;
    }

    private void init(int n3) {
        switch (n3) {
            default: {
                throw new IllegalArgumentException("bitLength must be one of 128, 224, 256, 288, 384, or 512.");
            }
            case 128: 
            case 224: 
            case 256: 
            case 288: 
            case 384: 
            case 512: 
        }
        this.initSponge(1600 - (n3 << 1));
    }

    private void initSponge(int n3) {
        if (n3 > 0 && n3 < 1600 && n3 % 64 == 0) {
            this.rate = n3;
            int n4 = 0;
            while (true) {
                long[] lArray = this.state;
                if (n4 >= this.state.length) break;
                lArray[n4] = 0L;
                ++n4;
            }
            Arrays.fill(this.dataQueue, (byte)0);
            this.bitsInQueue = 0;
            this.squeezing = false;
            this.fixedOutputLength = (1600 - n3) / 2;
            return;
        }
        throw new IllegalStateException("invalid rate value");
    }

    private void padAndSwitchToSqueezingPhase() {
        long l3;
        byte[] byArray = this.dataQueue;
        int n3 = this.bitsInQueue;
        int n4 = n3 >>> 3;
        this.dataQueue[n4] = (byte)(byArray[n4] | (byte)(1 << (n3 & 7)));
        this.bitsInQueue = ++n3;
        if (n3 == this.rate) {
            this.KeccakAbsorb(byArray, 0);
        } else {
            int n5 = n3;
            int n6 = n5 >>> 6;
            n3 = n5 & 0x3F;
            n4 = 0;
            for (int i3 = 0; i3 < n6; ++i3) {
                this.state[i3] = this.state[i3] ^ Pack.littleEndianToLong(this.dataQueue, n4);
                n4 += 8;
            }
            this.dumpState();
            if (n3 > 0) {
                long l4 = (1L << n3) - 1L;
                this.state[n6] = this.state[n6] ^ Pack.littleEndianToLong(this.dataQueue, n4) & l4;
            }
        }
        KeccakDigest keccakDigest = this;
        int n7 = this.rate - 1 >>> 6;
        keccakDigest.state[n7] = l3 = keccakDigest.state[n7] ^ Long.MIN_VALUE;
        keccakDigest.bitsInQueue = 0;
        keccakDigest.squeezing = true;
    }

    private void KeccakAbsorb(byte[] byArray, int n3) {
        int n4 = this.rate >>> 6;
        for (int i3 = 0; i3 < n4; ++i3) {
            this.state[i3] = this.state[i3] ^ Pack.littleEndianToLong(byArray, n3);
            n3 += 8;
        }
        KeccakDigest keccakDigest = this;
        Hex.toHexString(keccakDigest.dumpState()).toLowerCase();
        keccakDigest.KeccakPermutation();
    }

    private void KeccakExtract() {
        KeccakDigest keccakDigest = this;
        keccakDigest.KeccakPermutation();
        keccakDigest.dumpState();
        KeccakDigest keccakDigest2 = this;
        int n3 = keccakDigest2.rate >>> 6;
        byte[] byArray = keccakDigest2.dataQueue;
        Pack.longToLittleEndian(keccakDigest.state, 0, n3, byArray, 0);
        keccakDigest.bitsInQueue = keccakDigest.rate;
    }

    private void KeccakPermutation() {
        Object object = ((KeccakDigest)object).state;
        long l3 = ((KeccakDigest)object).state[0];
        long l4 = ((KeccakDigest)object).state[1];
        long l5 = ((KeccakDigest)object).state[2];
        long l6 = ((KeccakDigest)object).state[3];
        long l7 = ((KeccakDigest)object).state[4];
        long l8 = ((KeccakDigest)object).state[5];
        long l9 = ((KeccakDigest)object).state[6];
        long l10 = ((KeccakDigest)object).state[7];
        long l11 = ((KeccakDigest)object).state[8];
        long l12 = ((KeccakDigest)object).state[9];
        long l13 = ((KeccakDigest)object).state[10];
        long l14 = ((KeccakDigest)object).state[11];
        long l15 = ((KeccakDigest)object).state[12];
        long l16 = ((KeccakDigest)object).state[13];
        long l17 = ((KeccakDigest)object).state[14];
        long l18 = ((KeccakDigest)object).state[15];
        long l19 = ((KeccakDigest)object).state[16];
        long l20 = ((KeccakDigest)object).state[17];
        long l21 = ((KeccakDigest)object).state[18];
        long l22 = ((KeccakDigest)object).state[19];
        long l23 = ((KeccakDigest)object).state[20];
        long l24 = ((KeccakDigest)object).state[21];
        long l25 = ((KeccakDigest)object).state[22];
        long l26 = ((KeccakDigest)object).state[23];
        long l27 = ((KeccakDigest)object).state[24];
        for (int i3 = 0; i3 < 24; ++i3) {
            long l28 = l3;
            l3 = l28 ^ l8 ^ l13 ^ l18 ^ l23;
            long l29 = l4 ^ l9 ^ l14 ^ l19 ^ l24;
            long l30 = l5 ^ l10 ^ l15 ^ l20 ^ l25;
            long l31 = l6 ^ l11 ^ l16 ^ l21 ^ l26;
            long l32 = l7 ^ l12 ^ l17 ^ l22 ^ l27;
            long l33 = (l29 << 1 | l29 >>> -1) ^ l32;
            long l34 = (l30 << 1 | l30 >>> -1) ^ l3;
            l29 = (l31 << 1 | l31 >>> -1) ^ l29;
            l30 = (l32 << 1 | l32 >>> -1) ^ l30;
            l3 = (l3 << 1 | l3 >>> -1) ^ l31;
            l31 = l28 ^ l33;
            long l35 = l9;
            long l36 = l4;
            l4 = l8 ^ l33;
            l8 = l13 ^ l33;
            l9 = l18 ^ l33;
            l13 = l23 ^ l33;
            l18 = l36 ^ l34;
            l23 = l35 ^ l34;
            long l37 = l3;
            long l38 = l22;
            long l39 = l3;
            long l40 = l17;
            long l41 = l3;
            long l42 = l12;
            long l43 = l3;
            long l44 = l7;
            long l45 = l3;
            long l46 = l16;
            long l47 = l11;
            long l48 = l6;
            long l49 = l5;
            l3 = l14 ^ l34;
            l5 = l19 ^ l34;
            l6 = l24 ^ l34;
            l7 = l49 ^ l29;
            l10 ^= l29;
            l11 = l15 ^ l29;
            l12 = l20 ^ l29;
            l14 = l25 ^ l29;
            l15 = l48 ^ l30;
            l16 = l47 ^ l30;
            l17 = l46 ^ l30;
            l19 = l21 ^ l30;
            l20 = l26 ^ l30;
            l21 = l44 ^ l45;
            l22 = l42 ^ l43;
            l24 = l40 ^ l41;
            l25 = l38 ^ l39;
            l26 = l27 ^ l37;
            l18 = l18 << 1 | l18 >>> 63;
            l23 = l23 << 44 | l23 >>> 20;
            l22 = l22 << 20 | l22 >>> 44;
            l14 = l14 << 61 | l14 >>> 3;
            l24 = l24 << 39 | l24 >>> 25;
            l13 = l13 << 18 | l13 >>> 46;
            l7 = l7 << 62 | l7 >>> 2;
            l11 = l11 << 43 | l11 >>> 21;
            l17 = l17 << 25 | l17 >>> 39;
            l25 = l25 << 8 | l25 >>> 56;
            l20 = l20 << 56 | l20 >>> 8;
            l9 = l9 << 41 | l9 >>> 23;
            l21 = l21 << 27 | l21 >>> 37;
            l26 = l26 << 14 | l26 >>> 50;
            l6 = l6 << 2 | l6 >>> 62;
            l16 = l16 << 55 | l16 >>> 9;
            l5 = l5 << 45 | l5 >>> 19;
            l4 = l4 << 36 | l4 >>> 28;
            l15 = l15 << 28 | l15 >>> 36;
            l19 = l19 << 21 | l19 >>> 43;
            l12 = l12 << 15 | l12 >>> 49;
            l3 = l3 << 10 | l3 >>> 54;
            l10 = l10 << 6 | l10 >>> 58;
            l8 = l8 << 3 | l8 >>> 61;
            long l50 = l31 ^ (l23 ^ 0xFFFFFFFFFFFFFFFFL) & l11;
            long l51 = l6;
            long l52 = l7;
            long l53 = l9;
            long l54 = l6;
            long l55 = l24;
            long l56 = l9;
            long l57 = l24;
            long l58 = l20;
            long l59 = l21;
            long l60 = l12;
            long l61 = l20;
            long l62 = l3;
            long l63 = l12;
            long l64 = l3;
            long l65 = l13;
            long l66 = l18;
            long l67 = l25;
            long l68 = l13;
            long l69 = l17;
            long l70 = l25;
            long l71 = l17;
            long l72 = l14;
            long l73 = l15;
            long l74 = l5;
            long l75 = l14;
            long l76 = l8;
            long l77 = l5;
            long l78 = l8;
            long l79 = l26;
            long l80 = l19;
            long l81 = l11;
            l11 = l23 ^ (l11 ^ 0xFFFFFFFFFFFFFFFFL) & l19;
            l19 = l81 ^ (l19 ^ 0xFFFFFFFFFFFFFFFFL) & l26;
            l26 = l80 ^ (l26 ^ 0xFFFFFFFFFFFFFFFFL) & l31;
            l23 = l79 ^ (l31 ^ 0xFFFFFFFFFFFFFFFFL) & l23;
            l8 = l15 ^ (l22 ^ 0xFFFFFFFFFFFFFFFFL) & l8;
            l5 = l22 ^ (l78 ^ 0xFFFFFFFFFFFFFFFFL) & l5;
            l14 = l76 ^ (l77 ^ 0xFFFFFFFFFFFFFFFFL) & l14;
            l15 = l74 ^ (l75 ^ 0xFFFFFFFFFFFFFFFFL) & l15;
            l22 = l72 ^ (l73 ^ 0xFFFFFFFFFFFFFFFFL) & l22;
            l17 = l18 ^ (l10 ^ 0xFFFFFFFFFFFFFFFFL) & l17;
            l25 = l10 ^ (l71 ^ 0xFFFFFFFFFFFFFFFFL) & l25;
            l13 = l69 ^ (l70 ^ 0xFFFFFFFFFFFFFFFFL) & l13;
            l18 = l67 ^ (l68 ^ 0xFFFFFFFFFFFFFFFFL) & l18;
            l10 = l65 ^ (l66 ^ 0xFFFFFFFFFFFFFFFFL) & l10;
            l3 = l21 ^ (l4 ^ 0xFFFFFFFFFFFFFFFFL) & l3;
            l12 = l4 ^ (l64 ^ 0xFFFFFFFFFFFFFFFFL) & l12;
            l20 = l62 ^ (l63 ^ 0xFFFFFFFFFFFFFFFFL) & l20;
            l21 = l60 ^ (l61 ^ 0xFFFFFFFFFFFFFFFFL) & l21;
            l4 = l58 ^ (l59 ^ 0xFFFFFFFFFFFFFFFFL) & l4;
            l24 = l7 ^ (l16 ^ 0xFFFFFFFFFFFFFFFFL) & l24;
            l9 = l16 ^ (l57 ^ 0xFFFFFFFFFFFFFFFFL) & l9;
            l6 = l55 ^ (l56 ^ 0xFFFFFFFFFFFFFFFFL) & l6;
            l7 = l53 ^ (l54 ^ 0xFFFFFFFFFFFFFFFFL) & l7;
            l27 = l51 ^ (l52 ^ 0xFFFFFFFFFFFFFFFFL) & l16;
            l16 = l50 ^ KeccakRoundConstants[i3];
            long l82 = l16;
            long l83 = l11;
            long l84 = l19;
            long l85 = l26;
            long l86 = l23;
            long l87 = l14;
            long l88 = l15;
            long l89 = l22;
            long l90 = l17;
            long l91 = l25;
            long l92 = l18;
            long l93 = l24;
            l26 = l7;
            l25 = l6;
            l24 = l9;
            l23 = l93;
            l22 = l4;
            l19 = l12;
            l18 = l3;
            l17 = l10;
            l16 = l92;
            l15 = l13;
            l14 = l91;
            l13 = l90;
            l12 = l89;
            l11 = l88;
            l10 = l87;
            l9 = l5;
            l7 = l86;
            l6 = l85;
            l5 = l84;
            l4 = l83;
            l3 = l82;
        }
        Object object2 = object;
        object2[0] = l3;
        object2[1] = l4;
        object2[2] = l5;
        object2[3] = l6;
        object2[4] = l7;
        object2[5] = l8;
        object2[6] = l9;
        object2[7] = l10;
        object2[8] = l11;
        object2[9] = l12;
        object2[10] = l13;
        object2[11] = l14;
        object2[12] = l15;
        object2[13] = l16;
        object2[14] = l17;
        object2[15] = l18;
        object2[16] = l19;
        object2[17] = l20;
        object2[18] = l21;
        object2[19] = l22;
        object2[20] = l23;
        object2[21] = l24;
        object2[22] = l25;
        object2[23] = l26;
        object2[24] = l27;
    }

    @Override
    public String getAlgorithmName() {
        return b.a("Keccak-").append(this.fixedOutputLength).toString();
    }

    @Override
    public int getDigestSize() {
        return this.fixedOutputLength / 8;
    }

    @Override
    public void update(byte by) {
        this.absorb(by);
    }

    @Override
    public void update(byte[] byArray, int n3, int n4) {
        this.absorb(byArray, n3, n4);
    }

    @Override
    public int doFinal(byte[] byArray, int n3) {
        KeccakDigest keccakDigest = this;
        long l3 = this.fixedOutputLength;
        keccakDigest.squeeze(byArray, n3, l3);
        keccakDigest.reset();
        return keccakDigest.getDigestSize();
    }

    public int doFinal(byte[] byArray, int n3, byte by, int n4) {
        if (n4 > 0) {
            this.absorbBits(by, n4);
        }
        KeccakDigest keccakDigest = this;
        long l3 = this.fixedOutputLength;
        keccakDigest.squeeze(byArray, n3, l3);
        keccakDigest.reset();
        return keccakDigest.getDigestSize();
    }

    @Override
    public void reset() {
        KeccakDigest keccakDigest = this;
        keccakDigest.init(keccakDigest.fixedOutputLength);
    }

    @Override
    public int getByteLength() {
        return this.rate / 8;
    }

    public void absorb(byte by) {
        int n3 = this.bitsInQueue;
        if (n3 % 8 == 0) {
            if (!this.squeezing) {
                byte[] byArray = this.dataQueue;
                this.dataQueue[n3 >>> 3] = by;
                int n4 = n3 + 8;
                by = (byte)n4;
                this.bitsInQueue = by;
                if (n4 == this.rate) {
                    this.KeccakAbsorb(byArray, 0);
                    this.bitsInQueue = 0;
                }
                return;
            }
            throw new IllegalStateException("attempt to absorb while squeezing");
        }
        throw new IllegalStateException("attempt to absorb with odd length queue");
    }

    public void absorb(byte[] byArray, int n3, int n4) {
        int n5 = this.bitsInQueue;
        if (n5 % 8 == 0) {
            if (!this.squeezing) {
                int n6 = this.rate >>> 3;
                int n7 = n6 - (n5 >>>= 3);
                if (n4 < n7) {
                    System.arraycopy(byArray, n3, this.dataQueue, n5, n4);
                    this.bitsInQueue += n4 << 3;
                    return;
                }
                int n8 = 0;
                if (n5 > 0) {
                    KeccakDigest keccakDigest = this;
                    System.arraycopy(byArray, n3, this.dataQueue, n5, n7);
                    n8 = n7 + n8;
                    keccakDigest.KeccakAbsorb(keccakDigest.dataQueue, 0);
                }
                while ((n5 = n4 - n8) >= n6) {
                    this.KeccakAbsorb(byArray, n3 + n8);
                    n8 += n6;
                }
                int n9 = n3 + n8;
                System.arraycopy(byArray, n9, this.dataQueue, 0, n5);
                this.bitsInQueue = n5 << 3;
                return;
            }
            throw new IllegalStateException("attempt to absorb while squeezing");
        }
        throw new IllegalStateException("attempt to absorb with odd length queue");
    }

    public void absorbBits(int n3, int n4) {
        if (n4 >= 1 && n4 <= 7) {
            int n5 = this.bitsInQueue;
            if (n5 % 8 == 0) {
                if (!this.squeezing) {
                    int n6;
                    int n7 = n6 = (1 << n4) - 1;
                    n6 = n5 >>> 3;
                    this.dataQueue[n6] = (byte)(n3 & n7);
                    this.bitsInQueue = n5 + n4;
                    return;
                }
                throw new IllegalStateException("attempt to absorb while squeezing");
            }
            throw new IllegalStateException("attempt to absorb with odd length queue");
        }
        throw new IllegalArgumentException("'bits' must be in the range 1 to 7");
    }

    public byte[] dumpState() {
        byte[] byArray = new byte[this.state.length * 8];
        int n3 = 0;
        int n4 = 0;
        while (true) {
            long[] lArray = this.state;
            if (n4 == this.state.length) break;
            Pack.longToLittleEndian(lArray[n4], byArray, n3);
            n3 += 8;
            ++n4;
        }
        return byArray;
    }

    public void squeeze(byte[] byArray, int n3, long l3) {
        if (!this.squeezing) {
            this.padAndSwitchToSqueezingPhase();
        }
        this.dumpState();
        if (l3 % 8L == 0L) {
            int n4;
            for (long i3 = 0L; i3 < l3; i3 += (long)n4) {
                if (this.bitsInQueue == 0) {
                    this.KeccakExtract();
                }
                KeccakDigest keccakDigest = this;
                n4 = (int)Math.min((long)keccakDigest.bitsInQueue, l3 - i3);
                int n5 = (this.rate - this.bitsInQueue) / 8;
                int n6 = n3 + (int)(i3 / 8L);
                int n7 = n4 / 8;
                System.arraycopy(keccakDigest.dataQueue, n5, byArray, n6, n7);
                keccakDigest.bitsInQueue -= n4;
            }
            this.dumpState();
            return;
        }
        throw new IllegalStateException("outputLength not a multiple of 8");
    }
}

