/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.crypto.digests;

import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.ExtendedDigest;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.digests.EncodableDigest;
import com.fis.ekyc.nfc.build_in.bouncycastle.util.Memoable;
import com.fis.ekyc.nfc.build_in.bouncycastle.util.Pack;

public abstract class LongDigest
implements ExtendedDigest,
Memoable,
EncodableDigest {
    private static final int BYTE_LENGTH = 128;
    public static final long[] K = new long[]{4794697086780616226L, 8158064640168781261L, -5349999486874862801L, -1606136188198331460L, 4131703408338449720L, 6480981068601479193L, -7908458776815382629L, -6116909921290321640L, -2880145864133508542L, 1334009975649890238L, 2608012711638119052L, 6128411473006802146L, 8268148722764581231L, -9160688886553864527L, -7215885187991268811L, -4495734319001033068L, -1973867731355612462L, -1171420211273849373L, 1135362057144423861L, 2597628984639134821L, 3308224258029322869L, 5365058923640841347L, 6679025012923562964L, 8573033837759648693L, -7476448914759557205L, -6327057829258317296L, -5763719355590565569L, -4658551843659510044L, -4116276920077217854L, -3051310485924567259L, 489312712824947311L, 1452737877330783856L, 2861767655752347644L, 3322285676063803686L, 5560940570517711597L, 5996557281743188959L, 7280758554555802590L, 8532644243296465576L, -9096487096722542874L, -7894198246740708037L, -6719396339535248540L, -6333637450476146687L, -4446306890439682159L, -4076793802049405392L, -3345356375505022440L, -2983346525034927856L, -860691631967231958L, 1182934255886127544L, 1847814050463011016L, 2177327727835720531L, 2830643537854262169L, 3796741975233480872L, 4115178125766777443L, 5681478168544905931L, 6601373596472566643L, 7507060721942968483L, 8399075790359081724L, 8693463985226723168L, -8878714635349349518L, -8302665154208450068L, -8016688836872298968L, -6606660893046293015L, -4685533653050689259L, -4147400797238176981L, -3880063495543823972L, -3348786107499101689L, -1523767162380948706L, -757361751448694408L, 500013540394364858L, 748580250866718886L, 1242879168328830382L, 1977374033974150939L, 2944078676154940804L, 3659926193048069267L, 4368137639120453308L, 4836135668995329356L, 5532061633213252278L, 6448918945643986474L, 6902733635092675308L, 7801388544844847127L};
    private byte[] xBuf;
    private int xBufOff;
    private long byteCount1;
    private long byteCount2;
    public long H1;
    public long H2;
    public long H3;
    public long H4;
    public long H5;
    public long H6;
    public long H7;
    public long H8;
    private long[] W;
    private int wOff;

    public LongDigest() {
        LongDigest longDigest = this;
        longDigest.xBuf = new byte[8];
        longDigest.W = new long[80];
        longDigest.xBufOff = 0;
        longDigest.reset();
    }

    public LongDigest(LongDigest longDigest) {
        this.xBuf = new byte[8];
        this.W = new long[80];
        this.copyIn(longDigest);
    }

    private void adjustByteCounts() {
        long l3 = this.byteCount1;
        if (l3 > 0x1FFFFFFFFFFFFFFFL) {
            this.byteCount2 += l3 >>> 61;
            this.byteCount1 = l3 & 0x1FFFFFFFFFFFFFFFL;
        }
    }

    private long Ch(long l3, long l4, long l5) {
        return l3 & l4 ^ (l3 ^ 0xFFFFFFFFFFFFFFFFL) & l5;
    }

    private long Maj(long l3, long l4, long l5) {
        return l3 & l4 ^ l3 & l5 ^ l4 & l5;
    }

    private long Sum0(long l3) {
        return (l3 << 36 | l3 >>> 28) ^ (l3 << 30 | l3 >>> 34) ^ (l3 << 25 | l3 >>> 39);
    }

    private long Sum1(long l3) {
        return (l3 << 50 | l3 >>> 14) ^ (l3 << 46 | l3 >>> 18) ^ (l3 << 23 | l3 >>> 41);
    }

    private long Sigma0(long l3) {
        return (l3 << 63 | l3 >>> 1) ^ (l3 << 56 | l3 >>> 8) ^ l3 >>> 7;
    }

    private long Sigma1(long l3) {
        return (l3 << 45 | l3 >>> 19) ^ (l3 << 3 | l3 >>> 61) ^ l3 >>> 6;
    }

    public void copyIn(LongDigest object) {
        LongDigest longDigest = object2;
        LongDigest longDigest2 = object;
        LongDigest longDigest3 = object;
        LongDigest longDigest4 = object;
        LongDigest longDigest5 = object;
        LongDigest longDigest6 = object;
        LongDigest longDigest7 = object;
        LongDigest longDigest8 = object;
        LongDigest longDigest9 = object;
        LongDigest longDigest10 = object;
        LongDigest longDigest11 = object;
        LongDigest longDigest12 = object;
        LongDigest longDigest13 = object;
        object = ((LongDigest)object2).xBuf;
        int n3 = longDigest13.xBuf.length;
        System.arraycopy(longDigest13.xBuf, 0, object, 0, n3);
        ((LongDigest)object2).xBufOff = longDigest13.xBufOff;
        ((LongDigest)object2).byteCount1 = longDigest12.byteCount1;
        ((LongDigest)object2).byteCount2 = longDigest11.byteCount2;
        ((LongDigest)object2).H1 = longDigest10.H1;
        ((LongDigest)object2).H2 = longDigest9.H2;
        ((LongDigest)object2).H3 = longDigest8.H3;
        ((LongDigest)object2).H4 = longDigest7.H4;
        ((LongDigest)object2).H5 = longDigest6.H5;
        ((LongDigest)object2).H6 = longDigest5.H6;
        ((LongDigest)object2).H7 = longDigest4.H7;
        ((LongDigest)object2).H8 = longDigest3.H8;
        Object object2 = ((LongDigest)object2).W;
        int n4 = longDigest2.W.length;
        System.arraycopy(longDigest2.W, 0, object2, 0, n4);
        longDigest.wOff = longDigest2.wOff;
    }

    public void populateState(byte[] byArray) {
        LongDigest longDigest = this;
        int n3 = this.xBufOff;
        System.arraycopy(longDigest.xBuf, 0, byArray, 0, n3);
        Pack.intToBigEndian(longDigest.xBufOff, byArray, 8);
        Pack.longToBigEndian(longDigest.byteCount1, byArray, 12);
        Pack.longToBigEndian(longDigest.byteCount2, byArray, 20);
        Pack.longToBigEndian(longDigest.H1, byArray, 28);
        Pack.longToBigEndian(longDigest.H2, byArray, 36);
        Pack.longToBigEndian(longDigest.H3, byArray, 44);
        Pack.longToBigEndian(longDigest.H4, byArray, 52);
        Pack.longToBigEndian(longDigest.H5, byArray, 60);
        Pack.longToBigEndian(longDigest.H6, byArray, 68);
        Pack.longToBigEndian(longDigest.H7, byArray, 76);
        Pack.longToBigEndian(longDigest.H8, byArray, 84);
        Pack.intToBigEndian(longDigest.wOff, byArray, 92);
        for (n3 = 0; n3 < this.wOff; ++n3) {
            Pack.longToBigEndian(this.W[n3], byArray, n3 * 8 + 96);
        }
    }

    public void restoreState(byte[] byArray) {
        int n3;
        this.xBufOff = n3 = Pack.bigEndianToInt(byArray, 8);
        System.arraycopy(byArray, 0, this.xBuf, 0, n3);
        this.byteCount1 = Pack.bigEndianToLong(byArray, 12);
        this.byteCount2 = Pack.bigEndianToLong(byArray, 20);
        this.H1 = Pack.bigEndianToLong(byArray, 28);
        this.H2 = Pack.bigEndianToLong(byArray, 36);
        this.H3 = Pack.bigEndianToLong(byArray, 44);
        this.H4 = Pack.bigEndianToLong(byArray, 52);
        this.H5 = Pack.bigEndianToLong(byArray, 60);
        this.H6 = Pack.bigEndianToLong(byArray, 68);
        this.H7 = Pack.bigEndianToLong(byArray, 76);
        this.H8 = Pack.bigEndianToLong(byArray, 84);
        this.wOff = Pack.bigEndianToInt(byArray, 92);
        for (n3 = 0; n3 < this.wOff; ++n3) {
            this.W[n3] = Pack.bigEndianToLong(byArray, n3 * 8 + 96);
        }
    }

    public int getEncodedStateSize() {
        return this.wOff * 8 + 96;
    }

    @Override
    public void update(byte by) {
        int n3;
        LongDigest longDigest = this;
        byte[] byArray = longDigest.xBuf;
        int n4 = longDigest.xBufOff;
        this.xBufOff = n3 = n4 + 1;
        byArray[n4] = by;
        if (n3 == byArray.length) {
            this.processWord(byArray, 0);
            this.xBufOff = 0;
        }
        ++this.byteCount1;
    }

    @Override
    public void update(byte[] byArray, int n3, int n4) {
        while (this.xBufOff != 0 && n4 > 0) {
            this.update(byArray[n3]);
            ++n3;
            --n4;
        }
        while (n4 > this.xBuf.length) {
            int n5 = n4;
            LongDigest longDigest = this;
            longDigest.processWord(byArray, n3);
            byte[] byArray2 = longDigest.xBuf;
            n4 = n3 + longDigest.xBuf.length;
            int n6 = n5 - byArray2.length;
            this.byteCount1 += (long)byArray2.length;
            n3 = n4;
            n4 = n6;
        }
        while (n4 > 0) {
            this.update(byArray[n3]);
            ++n3;
            --n4;
        }
    }

    public void finish() {
        LongDigest longDigest = this;
        longDigest.adjustByteCounts();
        long l3 = longDigest.byteCount1 << 3;
        long l4 = longDigest.byteCount2;
        longDigest.update((byte)-128);
        while (this.xBufOff != 0) {
            this.update((byte)0);
        }
        LongDigest longDigest2 = this;
        longDigest2.processLength(l3, l4);
        longDigest2.processBlock();
    }

    @Override
    public void reset() {
        Object[] objectArray;
        LongDigest longDigest = this;
        longDigest.byteCount1 = 0L;
        longDigest.byteCount2 = 0L;
        longDigest.xBufOff = 0;
        int n3 = 0;
        while (true) {
            objectArray = this.xBuf;
            if (n3 >= this.xBuf.length) break;
            objectArray[n3] = 0;
            ++n3;
        }
        this.wOff = 0;
        n3 = 0;
        while (true) {
            objectArray = this.W;
            if (n3 == this.W.length) break;
            objectArray[n3] = (byte)0L;
            ++n3;
        }
    }

    @Override
    public int getByteLength() {
        return 128;
    }

    public void processWord(byte[] byArray, int n3) {
        long l3;
        LongDigest longDigest = this;
        int n4 = this.wOff;
        longDigest.W[n4] = l3 = Pack.bigEndianToLong(byArray, n3);
        this.wOff = longDigest.wOff + 1;
        if (this.wOff == 16) {
            this.processBlock();
        }
    }

    public void processLength(long l3, long l4) {
        if (this.wOff > 14) {
            this.processBlock();
        }
        this.W[14] = l4;
        this.W[15] = l3;
    }

    public void processBlock() {
        this.adjustByteCounts();
        for (int i3 = 16; i3 <= 79; ++i3) {
            long[] lArray = this.W;
            long l3 = this.Sigma1(lArray[i3 - 2]);
            lArray = this.W;
            this.W[i3] = l3 + this.W[i3 - 7] + this.Sigma0(lArray[i3 - 15]) + this.W[i3 - 16];
        }
        LongDigest longDigest = this;
        long l4 = longDigest.H1;
        long l5 = longDigest.H2;
        long l6 = longDigest.H3;
        long l7 = longDigest.H4;
        long l8 = longDigest.H5;
        long l9 = longDigest.H6;
        long l10 = longDigest.H7;
        long l11 = longDigest.H8;
        int n3 = 0;
        for (int i4 = 0; i4 < 10; ++i4) {
            LongDigest longDigest2 = this;
            long l12 = l4;
            LongDigest longDigest3 = this;
            long l13 = l5;
            LongDigest longDigest4 = this;
            long l14 = l6;
            LongDigest longDigest5 = this;
            long[] lArray = K;
            int n4 = n3;
            int n5 = n4 + 1;
            l11 = this.Sum1(l8) + this.Ch(l8, l9, l10) + K[n3] + this.W[n4] + l11;
            long l15 = l7 + l11;
            l6 = longDigest5.Sum0(l4) + this.Maj(l4, l5, l6) + l11;
            l10 = longDigest5.Sum1(l15) + this.Ch(l15, l8, l9) + lArray[n5] + this.W[n5++] + l10;
            l11 = l14 + l10;
            l5 = longDigest4.Sum0(l6) + this.Maj(l6, l4, l5) + l10;
            l9 = longDigest4.Sum1(l11) + this.Ch(l11, l15, l8) + lArray[n5] + this.W[n5++] + l9;
            l10 = l13 + l9;
            l4 = longDigest3.Sum0(l5) + this.Maj(l5, l6, l4) + l9;
            l8 = longDigest3.Sum1(l10) + this.Ch(l10, l11, l15) + lArray[n5] + this.W[n5++] + l8;
            l9 = l12 + l8;
            l8 = longDigest2.Sum0(l4) + this.Maj(l4, l5, l6) + l8;
            LongDigest longDigest6 = this;
            long l16 = l4;
            LongDigest longDigest7 = this;
            long l17 = l5;
            LongDigest longDigest8 = this;
            int n6 = n5;
            int n7 = n6 + 1;
            l15 = this.Sum1(l9) + this.Ch(l9, l10, l11) + lArray[n5] + this.W[n6] + l15;
            long l18 = l6 + l15;
            l5 = longDigest8.Sum0(l8) + this.Maj(l8, l4, l5) + l15;
            l11 = longDigest8.Sum1(l18) + this.Ch(l18, l9, l10) + lArray[n7] + this.W[n7++] + l11;
            l15 = l17 + l11;
            l4 = longDigest7.Sum0(l5) + this.Maj(l5, l8, l4) + l11;
            l10 = longDigest7.Sum1(l15) + this.Ch(l15, l18, l9) + lArray[n7] + this.W[n7++] + l10;
            l11 = l16 + l10;
            long l19 = longDigest6.Sum0(l4) + this.Maj(l4, l5, l8) + l10;
            int n8 = n7;
            n3 = n8 + 1;
            l6 = longDigest6.Sum1(l11) + this.Ch(l11, l15, l18) + lArray[n7] + this.W[n8] + l9;
            long l20 = l8 + l6;
            l6 = longDigest2.Sum0(l19) + this.Maj(l19, l4, l5) + l6;
            long l21 = l6;
            long l22 = l11;
            l11 = l18;
            l10 = l15;
            l9 = l22;
            l8 = l20;
            l7 = l5;
            l6 = l4;
            l5 = l19;
            l4 = l21;
        }
        LongDigest longDigest9 = this;
        longDigest9.H1 += l4;
        longDigest9.H2 += l5;
        longDigest9.H3 += l6;
        longDigest9.H4 += l7;
        longDigest9.H5 += l8;
        longDigest9.H6 += l9;
        longDigest9.H7 += l10;
        longDigest9.H8 += l11;
        longDigest9.wOff = 0;
        for (int i5 = 0; i5 < 16; ++i5) {
            this.W[i5] = 0L;
        }
    }
}

